/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.info;

import com.tencent.tinker.build.apkparser.AndroidParser;
import com.tencent.tinker.build.patch.Configuration;
import com.tencent.tinker.build.util.TinkerPatchException;
import com.tencent.tinker.commons.util.IOHelper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.Properties;
import tinker.net.dongliu.apk.parser.utils.Utils;

public class PatchInfoGen {
    private final Configuration config;
    private final File packageInfoFile;

    public PatchInfoGen(Configuration config) {
        this.config = config;
        this.packageInfoFile = new File(config.mTempResultDir + File.separator + "assets" + File.separator + "package_meta.txt");
    }

    private void addTinkerID() throws IOException, ParseException {
        String tinkerID;
        if (!this.config.mPackageFields.containsKey("TINKER_ID")) {
            AndroidParser oldAndroidManifest = AndroidParser.getAndroidManifest(this.config.mOldApkFile);
            tinkerID = oldAndroidManifest.metaDatas.get("TINKER_ID");
            if (tinkerID == null) {
                throw new TinkerPatchException("can't find TINKER_ID from the old apk manifest file, it must be set!");
            }
            this.config.mPackageFields.put("TINKER_ID", tinkerID);
        }
        if (!this.config.mPackageFields.containsKey("NEW_TINKER_ID")) {
            AndroidParser newAndroidManifest = AndroidParser.getAndroidManifest(this.config.mNewApkFile);
            tinkerID = newAndroidManifest.metaDatas.get("TINKER_ID");
            if (tinkerID == null) {
                throw new TinkerPatchException("can't find TINKER_ID from the new apk manifest file, it must be set!");
            }
            this.config.mPackageFields.put("NEW_TINKER_ID", tinkerID);
        }
    }

    private void addProtectedAppFlag() {
        this.config.mPackageFields.put("is_protected_app", this.config.mIsProtectedApp ? "1" : "0");
    }

    private void addFilePatchFlag() {
        this.config.mPackageFields.put("use_custom_file_patch", Utils.isEmpty((CharSequence)this.config.mCustomDiffPath) ? "0" : "1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gen() throws Exception {
        this.addTinkerID();
        this.addProtectedAppFlag();
        this.addFilePatchFlag();
        Properties newProperties = new Properties();
        for (String key : this.config.mPackageFields.keySet()) {
            newProperties.put(key, this.config.mPackageFields.get(key));
        }
        String comment = "base package config field";
        BufferedOutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(this.packageInfoFile, false));
            newProperties.store(os, comment);
        }
        catch (Throwable throwable) {
            IOHelper.closeQuietly(os);
            throw throwable;
        }
        IOHelper.closeQuietly((Object)os);
    }
}

