/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.aapt;

import com.google.common.base.Joiner;
import com.tencent.tinker.build.aapt.FakeRDotTxtEntry;
import com.tencent.tinker.build.aapt.RDotTxtEntry;
import com.tencent.tinker.build.aapt.ResourceDirectory;
import com.tencent.tinker.build.aapt.ResourceEntry;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AaptResourceCollector {
    private final Map<RDotTxtEntry.RType, Map<String, Set<ResourceDirectory>>> rTypeResourceDirectoryMap = new HashMap<RDotTxtEntry.RType, Map<String, Set<ResourceDirectory>>>();
    private final Map<RDotTxtEntry.RType, ResourceIdEnumerator> rTypeEnumeratorMap = new HashMap<RDotTxtEntry.RType, ResourceIdEnumerator>();
    private final Map<RDotTxtEntry, RDotTxtEntry> originalResourceMap;
    private final Map<RDotTxtEntry.RType, Set<RDotTxtEntry>> rTypeResourceMap = new HashMap<RDotTxtEntry.RType, Set<RDotTxtEntry>>();
    private final Map<RDotTxtEntry.RType, Set<RDotTxtEntry>> rTypeIncreaseResourceMap = new HashMap<RDotTxtEntry.RType, Set<RDotTxtEntry>>();
    private final Map<String, Set<String>> duplicateResourceMap = new HashMap<String, Set<String>>();
    private final Map<RDotTxtEntry.RType, HashMap<String, String>> sanitizeTypeMap = new HashMap<RDotTxtEntry.RType, HashMap<String, String>>();
    private final Set<String> ignoreIdSet;
    private int currentTypeId = 2;

    public AaptResourceCollector() {
        this.originalResourceMap = new HashMap<RDotTxtEntry, RDotTxtEntry>();
        this.ignoreIdSet = new HashSet<String>();
    }

    public AaptResourceCollector(Map<RDotTxtEntry.RType, Set<RDotTxtEntry>> rTypeResourceMap) {
        this();
        if (rTypeResourceMap != null) {
            for (Map.Entry<RDotTxtEntry.RType, Set<RDotTxtEntry>> entry : rTypeResourceMap.entrySet()) {
                RDotTxtEntry.RType rType = entry.getKey();
                Set<RDotTxtEntry> set = entry.getValue();
                for (RDotTxtEntry rDotTxtEntry : set) {
                    this.originalResourceMap.put(rDotTxtEntry, rDotTxtEntry);
                    ResourceIdEnumerator resourceIdEnumerator = null;
                    if (rDotTxtEntry.idType.equals((Object)RDotTxtEntry.IdType.INT_ARRAY)) continue;
                    int resourceId = Integer.decode(rDotTxtEntry.idValue.trim());
                    int typeId = (resourceId & 0xFF0000) / 65536;
                    if (typeId >= this.currentTypeId) {
                        this.currentTypeId = typeId + 1;
                    }
                    if (this.rTypeEnumeratorMap.containsKey((Object)rType)) {
                        resourceIdEnumerator = this.rTypeEnumeratorMap.get((Object)rType);
                        if (resourceIdEnumerator.currentId >= resourceId) continue;
                        resourceIdEnumerator.currentId = resourceId;
                        continue;
                    }
                    resourceIdEnumerator = new ResourceIdEnumerator();
                    resourceIdEnumerator.currentId = resourceId;
                    this.rTypeEnumeratorMap.put(rType, resourceIdEnumerator);
                }
            }
        }
    }

    public void addIntResourceIfNotPresent(RDotTxtEntry.RType rType, String name) {
        if (!this.rTypeEnumeratorMap.containsKey((Object)rType)) {
            if (rType.equals((Object)RDotTxtEntry.RType.ATTR)) {
                this.rTypeEnumeratorMap.put(rType, new ResourceIdEnumerator(1));
            } else {
                this.rTypeEnumeratorMap.put(rType, new ResourceIdEnumerator(this.currentTypeId++));
            }
        }
        FakeRDotTxtEntry entry = new FakeRDotTxtEntry(RDotTxtEntry.IdType.INT, rType, name);
        Set<Object> resourceSet = null;
        if (this.rTypeResourceMap.containsKey((Object)rType)) {
            resourceSet = this.rTypeResourceMap.get((Object)rType);
        } else {
            resourceSet = new HashSet();
            this.rTypeResourceMap.put(rType, resourceSet);
        }
        if (!resourceSet.contains(entry)) {
            String idValue = String.format("0x%08x", this.rTypeEnumeratorMap.get((Object)rType).next());
            this.addResource(rType, RDotTxtEntry.IdType.INT, name, idValue);
        }
    }

    public void addIntArrayResourceIfNotPresent(RDotTxtEntry.RType rType, String name, int numValues) {
        String idValue = String.format("{ %s }", Joiner.on((String)",").join(Collections.nCopies(numValues, "0x7f000000")));
        this.addResource(rType, RDotTxtEntry.IdType.INT_ARRAY, name, idValue);
    }

    public void addResource(RDotTxtEntry.RType rType, RDotTxtEntry.IdType idType, String name, String idValue) {
        Set<Object> resourceSet = null;
        if (this.rTypeResourceMap.containsKey((Object)rType)) {
            resourceSet = this.rTypeResourceMap.get((Object)rType);
        } else {
            resourceSet = new HashSet();
            this.rTypeResourceMap.put(rType, resourceSet);
        }
        RDotTxtEntry rDotTxtEntry = new RDotTxtEntry(idType, rType, name, idValue);
        boolean increaseResource = false;
        if (!resourceSet.contains(rDotTxtEntry)) {
            if (this.originalResourceMap.containsKey(rDotTxtEntry)) {
                this.rTypeEnumeratorMap.get((Object)rType).previous();
                rDotTxtEntry = this.originalResourceMap.get(rDotTxtEntry);
            } else {
                increaseResource = true;
            }
            resourceSet.add(rDotTxtEntry);
        }
        Set<Object> increaseResourceSet = null;
        if (this.rTypeIncreaseResourceMap.containsKey((Object)rType)) {
            increaseResourceSet = this.rTypeIncreaseResourceMap.get((Object)rType);
        } else {
            increaseResourceSet = new HashSet();
            this.rTypeIncreaseResourceMap.put(rType, increaseResourceSet);
        }
        if (increaseResource) {
            increaseResourceSet.add(rDotTxtEntry);
        }
    }

    public boolean isContainResource(RDotTxtEntry.RType rType, RDotTxtEntry.IdType idType, String name) {
        Set<RDotTxtEntry> resourceSet;
        boolean result = false;
        if (this.rTypeResourceMap.containsKey((Object)rType) && (resourceSet = this.rTypeResourceMap.get((Object)rType)).contains(new RDotTxtEntry(idType, rType, name, "0x7f000000"))) {
            result = true;
        }
        return result;
    }

    void addRTypeResourceName(RDotTxtEntry.RType rType, String resourceName, String resourceValue, ResourceDirectory resourceDirectory) {
        Map<Object, Object> directoryResourceDirectoryMap = null;
        if (this.rTypeResourceDirectoryMap.containsKey((Object)rType)) {
            directoryResourceDirectoryMap = this.rTypeResourceDirectoryMap.get((Object)rType);
        } else {
            directoryResourceDirectoryMap = new HashMap();
            this.rTypeResourceDirectoryMap.put(rType, directoryResourceDirectoryMap);
        }
        Set<ResourceDirectory> resourceDirectorySet = null;
        if (directoryResourceDirectoryMap.containsKey(resourceDirectory.directoryName)) {
            resourceDirectorySet = (Set)directoryResourceDirectoryMap.get(resourceDirectory.directoryName);
        } else {
            resourceDirectorySet = new HashSet();
            directoryResourceDirectoryMap.put(resourceDirectory.directoryName, resourceDirectorySet);
        }
        boolean find = false;
        ResourceDirectory newResourceDirectory = new ResourceDirectory(resourceDirectory.directoryName, resourceDirectory.resourceFullFilename);
        if (!resourceDirectorySet.contains(newResourceDirectory)) {
            resourceDirectorySet.add(newResourceDirectory);
        }
        for (ResourceDirectory oldResourceDirectory : resourceDirectorySet) {
            if (!oldResourceDirectory.resourceEntrySet.contains(new ResourceEntry(resourceName, resourceValue))) continue;
            find = true;
            String resourceKey = (Object)((Object)rType) + "/" + resourceDirectory.directoryName + "/" + resourceName;
            Set<Object> fullFilenameSet = null;
            if (!this.duplicateResourceMap.containsKey(resourceKey)) {
                fullFilenameSet = new HashSet<String>();
                fullFilenameSet.add(oldResourceDirectory.resourceFullFilename);
                this.duplicateResourceMap.put(resourceKey, fullFilenameSet);
            } else {
                fullFilenameSet = this.duplicateResourceMap.get(resourceKey);
            }
            fullFilenameSet.add(resourceDirectory.resourceFullFilename);
        }
        if (!find) {
            for (ResourceDirectory oldResourceDirectory : resourceDirectorySet) {
                if (!oldResourceDirectory.equals(newResourceDirectory) || oldResourceDirectory.resourceEntrySet.contains(new ResourceEntry(resourceName, resourceValue))) continue;
                oldResourceDirectory.resourceEntrySet.add(new ResourceEntry(resourceName, resourceValue));
            }
        }
    }

    void putSanitizeName(RDotTxtEntry.RType rType, String sanitizeName, String rawName) {
        HashMap<Object, Object> sanitizeNameMap;
        if (!this.sanitizeTypeMap.containsKey((Object)rType)) {
            sanitizeNameMap = new HashMap();
            this.sanitizeTypeMap.put(rType, sanitizeNameMap);
        } else {
            sanitizeNameMap = this.sanitizeTypeMap.get((Object)rType);
        }
        if (!sanitizeNameMap.containsKey(sanitizeName)) {
            sanitizeNameMap.put(sanitizeName, rawName);
        }
    }

    public String getRawName(RDotTxtEntry.RType rType, String sanitizeName) {
        if (!this.sanitizeTypeMap.containsKey((Object)rType)) {
            return null;
        }
        return this.sanitizeTypeMap.get((Object)rType).get(sanitizeName);
    }

    public Map<RDotTxtEntry.RType, Set<RDotTxtEntry>> getRTypeResourceMap() {
        return this.rTypeResourceMap;
    }

    public Map<String, Set<String>> getDuplicateResourceMap() {
        return this.duplicateResourceMap;
    }

    public Map<RDotTxtEntry.RType, Set<RDotTxtEntry>> getRTypeIncreaseResourceMap() {
        return this.rTypeIncreaseResourceMap;
    }

    public Map<RDotTxtEntry.RType, Map<String, Set<ResourceDirectory>>> getRTypeResourceDirectoryMap() {
        return this.rTypeResourceDirectoryMap;
    }

    void addIgnoreId(String name) {
        this.ignoreIdSet.add(name);
    }

    public Set<String> getIgnoreIdSet() {
        return this.ignoreIdSet;
    }

    private static class ResourceIdEnumerator {
        private int currentId = 0;

        ResourceIdEnumerator() {
        }

        ResourceIdEnumerator(int typeId) {
            this.currentId = 0x7F000000 + 65536 * typeId + -1;
        }

        int previous() {
            return --this.currentId;
        }

        int next() {
            return ++this.currentId;
        }
    }
}

