/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.util;

import com.tencent.tinker.commons.util.StreamUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;

public final class MD5 {
    private MD5() {
    }

    public static String getMessageDigest(byte[] buffer) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest mdTemp = MessageDigest.getInstance("MD5");
            mdTemp.update(buffer);
            byte[] md = mdTemp.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            return new String(str);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] getRawDigest(byte[] buffer) {
        try {
            MessageDigest mdTemp = MessageDigest.getInstance("MD5");
            mdTemp.update(buffer);
            return mdTemp.digest();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getMD5(InputStream is, int bufLen, int offset, int length) {
        return MD5.getMD5ExtendBytes(is, bufLen, offset, length, null);
    }

    public static String getMD5ExtendBytes(InputStream is, int bufLen, int offset, int length, byte[] extendBytes) {
        if (is == null || bufLen <= 0 || offset < 0 || length <= 0) {
            return null;
        }
        try {
            long skipLen = is.skip(offset);
            if (skipLen < (long)offset) {
                return null;
            }
            MessageDigest md = MessageDigest.getInstance("MD5");
            StringBuilder md5Str = new StringBuilder(32);
            byte[] buf = new byte[bufLen];
            int readCount = 0;
            int totalRead = 0;
            while ((readCount = is.read(buf)) != -1 && totalRead < length) {
                if (totalRead + readCount <= length) {
                    md.update(buf, 0, readCount);
                    totalRead += readCount;
                    continue;
                }
                md.update(buf, 0, length - totalRead);
                totalRead = length;
            }
            if (extendBytes != null && extendBytes.length > 0) {
                md.update(extendBytes);
            }
            byte[] hashValue = md.digest();
            for (int i = 0; i < hashValue.length; ++i) {
                md5Str.append(Integer.toString((hashValue[i] & 0xFF) + 256, 16).substring(1));
            }
            return md5Str.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getMD5(InputStream is, int bufLen) {
        if (is == null || bufLen <= 0) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            StringBuilder md5Str = new StringBuilder(32);
            byte[] buf = new byte[bufLen];
            int readCount = 0;
            while ((readCount = is.read(buf)) != -1) {
                md.update(buf, 0, readCount);
            }
            byte[] hashValue = md.digest();
            for (int i = 0; i < hashValue.length; ++i) {
                md5Str.append(Integer.toString((hashValue[i] & 0xFF) + 256, 16).substring(1));
            }
            return md5Str.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getMD5(String file) {
        if (file == null) {
            return null;
        }
        File f = new File(file);
        if (f.exists()) {
            return MD5.getMD5(f, 102400);
        }
        return null;
    }

    public static String getMD5(File file) {
        return MD5.getMD5(file, 102400);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMD5(File file, int bufLen) {
        String string;
        if (file == null || bufLen <= 0 || !file.exists()) {
            return null;
        }
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            String md5 = MD5.getMD5(fin, (int)((long)bufLen <= file.length() ? (long)bufLen : file.length()));
            fin.close();
            string = md5;
        }
        catch (Exception e) {
            String string2;
            try {
                string2 = null;
            }
            catch (Throwable throwable) {
                StreamUtil.closeQuietly(fin);
                throw throwable;
            }
            StreamUtil.closeQuietly((Object)fin);
            return string2;
        }
        StreamUtil.closeQuietly((Object)fin);
        return string;
    }

    public static String getMD5(String file, int offset, int length) {
        if (file == null) {
            return null;
        }
        File f = new File(file);
        if (f.exists()) {
            return MD5.getMD5(f, offset, length);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMD5(File file, int offset, int length) {
        String string;
        if (file == null || !file.exists() || offset < 0 || length <= 0) {
            return null;
        }
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            String md5 = MD5.getMD5(fin, 102400, offset, length);
            fin.close();
            string = md5;
        }
        catch (Exception e) {
            String string2;
            try {
                string2 = null;
            }
            catch (Throwable throwable) {
                StreamUtil.closeQuietly(fin);
                throw throwable;
            }
            StreamUtil.closeQuietly((Object)fin);
            return string2;
        }
        StreamUtil.closeQuietly((Object)fin);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMD5ExtendBytes(File file, int offset, int length, byte[] extend) {
        String string;
        if (file == null || !file.exists() || offset < 0 || length <= 0) {
            return null;
        }
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            String md5 = MD5.getMD5ExtendBytes(fin, 102400, offset, length, extend);
            fin.close();
            string = md5;
        }
        catch (Exception e) {
            String string2;
            try {
                string2 = null;
            }
            catch (Throwable throwable) {
                StreamUtil.closeQuietly(fin);
                throw throwable;
            }
            StreamUtil.closeQuietly((Object)fin);
            return string2;
        }
        StreamUtil.closeQuietly((Object)fin);
        return string;
    }
}

