/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.aapt;

import com.tencent.tinker.build.aapt.DefaultFileCopyProcessor;
import com.tencent.tinker.build.aapt.Generator;
import com.tencent.tinker.build.aapt.StringUtil;
import com.tencent.tinker.commons.util.StreamUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public final class FileUtil {
    private static final FileCopyProcessor DEFAULT_FILE_COPY_PROCESSOR = new DefaultFileCopyProcessor();

    private FileUtil() {
    }

    public static boolean isExist(String path) {
        File file = new File(path);
        return file.exists();
    }

    public static boolean isHasFile(String directory, String fileSuffix) {
        boolean result = false;
        File directoryFile = new File(directory);
        ConcurrentLinkedQueue<File> queue = new ConcurrentLinkedQueue<File>();
        queue.add(directoryFile);
        while (!queue.isEmpty()) {
            File file = (File)queue.poll();
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                if (fileArray == null) continue;
                queue.addAll(Arrays.asList(fileArray));
                continue;
            }
            if (!file.isFile() || !file.getName().toLowerCase().endsWith(fileSuffix.toLowerCase())) continue;
            result = true;
            break;
        }
        return result;
    }

    public static void createDirectory(String directoryPath) {
        File file = new File(directoryPath);
        if (!file.exists()) {
            file.setReadable(true, false);
            file.setWritable(true, true);
            file.mkdirs();
        }
    }

    public static boolean createFile(String fullFilename) {
        boolean result = false;
        File file = new File(fullFilename);
        FileUtil.createDirectory(file.getParent());
        try {
            file.setReadable(true, false);
            file.setWritable(true, true);
            result = file.createNewFile();
        }
        catch (Exception e) {
            throw new FileUtilException(e);
        }
        return result;
    }

    public static void deleteAllFile(String directory) {
        ArrayList<File> fileList = new ArrayList<File>();
        File directoryFile = new File(directory);
        ConcurrentLinkedQueue<File> queue = new ConcurrentLinkedQueue<File>();
        queue.add(directoryFile);
        while (!queue.isEmpty()) {
            File[] fileArray;
            File file = (File)queue.poll();
            if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
                queue.addAll(Arrays.asList(fileArray));
            }
            fileList.add(file);
        }
        for (int i = fileList.size() - 1; i >= 0; --i) {
            ((File)fileList.get(i)).delete();
        }
    }

    public static void copyFile(String from, String to) {
        FileUtil.copyFile(from, to, FileCopyType.PATH_TO_PATH, DEFAULT_FILE_COPY_PROCESSOR);
    }

    public static void copyFile(String from, String to, FileCopyType fileCopyType) {
        FileUtil.copyFile(from, to, fileCopyType, DEFAULT_FILE_COPY_PROCESSOR);
    }

    public static void copyFile(String from, String to, FileCopyType fileCopyType, FileCopyProcessor fileCopyProcessor) {
        switch (fileCopyType) {
            case FILE_TO_PATH: {
                FileUtil.copyFileToPath(from, to, fileCopyProcessor);
                break;
            }
            case FILE_TO_FILE: {
                FileUtil.copyFileToFile(from, to, fileCopyProcessor);
                break;
            }
            default: {
                FileUtil.copyPathToPath(from, to, fileCopyProcessor);
            }
        }
    }

    public static void copyPathToPath(String fromPath, String toPath, FileCopyProcessor fileCopyProcessor) {
        String toDirectoryPath;
        File fromDirectoryFile = new File(fromPath);
        File toDirectoryFile = new File(toPath);
        String fromDirectoryPath = fromDirectoryFile.getAbsolutePath();
        if (fromDirectoryPath.equals(toDirectoryPath = toDirectoryFile.getAbsolutePath())) {
            toDirectoryPath = toDirectoryPath + "_copy";
        }
        ConcurrentLinkedQueue<File> queue = new ConcurrentLinkedQueue<File>();
        queue.add(fromDirectoryFile);
        while (!queue.isEmpty()) {
            File file = (File)queue.poll();
            String fromFilePath = file.getAbsolutePath();
            String toFilePath = toDirectoryPath + fromFilePath.substring(fromDirectoryPath.length());
            if (file.isDirectory()) {
                File[] fileArray;
                boolean result = true;
                if (fileCopyProcessor != null) {
                    result = fileCopyProcessor.copyFileToFileProcess(fromFilePath, toFilePath, false);
                }
                if (!result || (fileArray = file.listFiles()) == null) continue;
                queue.addAll(Arrays.asList(fileArray));
                continue;
            }
            if (!file.isFile() || fileCopyProcessor == null) continue;
            fileCopyProcessor.copyFileToFileProcess(fromFilePath, toFilePath, true);
        }
    }

    private static void copyFileToPath(String fromFile, String toPath, FileCopyProcessor fileCopyProcessor) {
        File from = new File(fromFile);
        File to = new File(toPath);
        if (from.exists() && from.isFile()) {
            FileUtil.createDirectory(toPath);
            String tempFromFile = from.getAbsolutePath();
            String tempToFile = to.getAbsolutePath() + File.separator + from.getName();
            FileUtil.copyFileToFile(tempFromFile, tempToFile, fileCopyProcessor);
        }
    }

    public static List<String> unzip(String zipFullFilename, String outputDirectory) {
        return FileUtil.unzip(zipFullFilename, outputDirectory, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> unzip(String zipFullFilename, String outputDirectory, List<String> zipEntryNameList) {
        if (outputDirectory == null) {
            throw new NullPointerException("out put directory can not be null.");
        }
        ArrayList<String> storeFileList = null;
        ZipFile zipFile = null;
        try {
            storeFileList = new ArrayList<String>();
            zipFile = new ZipFile(zipFullFilename);
            String outputDirectoryAbsolutePath = new File(outputDirectory).getAbsolutePath();
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String zipEntryName = zipEntry.getName();
                boolean contains = false;
                if (zipEntryNameList == null || zipEntryNameList.isEmpty()) {
                    contains = true;
                } else if (zipEntryNameList.contains(zipEntryName)) {
                    contains = true;
                }
                if (!contains) continue;
                String outputFullFilename = outputDirectoryAbsolutePath + "/" + zipEntryName;
                if (zipEntry.isDirectory()) {
                    FileUtil.createDirectory(outputFullFilename);
                    continue;
                }
                InputStream inputStream = null;
                FileUtil.createFile(outputFullFilename);
                FileOutputStream outputStream = null;
                try {
                    inputStream = zipFile.getInputStream(zipEntry);
                    outputStream = new FileOutputStream(outputFullFilename);
                    byte[] buffer = new byte[1024];
                    int length = -1;
                    while ((length = inputStream.read(buffer, 0, buffer.length)) != -1) {
                        ((OutputStream)outputStream).write(buffer, 0, length);
                        outputStream.flush();
                    }
                }
                catch (Throwable throwable) {
                    StreamUtil.closeQuietly(outputStream);
                    StreamUtil.closeQuietly((Object)inputStream);
                    throw throwable;
                }
                StreamUtil.closeQuietly((Object)outputStream);
                StreamUtil.closeQuietly((Object)inputStream);
                storeFileList.add(outputFullFilename);
            }
        }
        catch (Exception e) {
            try {
                throw new FileUtilException(e);
            }
            catch (Throwable throwable) {
                StreamUtil.closeQuietly(zipFile);
                throw throwable;
            }
        }
        StreamUtil.closeQuietly((Object)zipFile);
        return storeFileList;
    }

    public static void zip(String outputZipFullFilename, String directory) {
        FileUtil.zip(outputZipFullFilename, directory, "");
    }

    public static void zip(String outputZipFullFilename, String directory, String fileSuffix) {
        List<String> classFileList = FileUtil.findMatchFile(directory, fileSuffix);
        if (classFileList != null && !classFileList.isEmpty()) {
            ArrayList<ZipEntryPath> zipEntryPathList = new ArrayList<ZipEntryPath>();
            int classOutputFullFilenameLength = new File(directory).getAbsolutePath().length() + 1;
            for (String classFile : classFileList) {
                String zipEntryName = classFile.substring(classOutputFullFilenameLength, classFile.length());
                zipEntryName = zipEntryName.replace("\\", "/");
                zipEntryPathList.add(new ZipEntryPath(classFile, new ZipEntry(zipEntryName), true));
            }
            FileUtil.zip(outputZipFullFilename, zipEntryPathList);
        }
    }

    public static void zip(String outputZipFullFilename, List<ZipEntryPath> zipEntryPathList) {
        FileUtil.zip(outputZipFullFilename, null, zipEntryPathList);
    }

    public static void zip(String outputZipFullFilename, String inputZipFullFilename, List<ZipEntryPath> zipEntryPathList) {
        FileUtil.zip(outputZipFullFilename, inputZipFullFilename, zipEntryPathList, null);
    }

    public static void zip(String outputZipFullFilename, String inputZipFullFilename, ZipProcessor zipProcessor) {
        FileUtil.zip(outputZipFullFilename, inputZipFullFilename, null, zipProcessor);
    }

    public static void zip(String outputZipFullFilename, String inputZipFullFilename, List<ZipEntryPath> zipEntryPathList, ZipProcessor zipProcessor) {
        ZipOutputStream zipOutputStream = null;
        ZipFile zipFile = null;
        HashMap<String, ZipEntryPath> zipEntryPathMap = new HashMap<String, ZipEntryPath>();
        CopyOnWriteArrayList<String> needToAddEntryNameList = new CopyOnWriteArrayList<String>();
        if (zipEntryPathList != null) {
            for (ZipEntryPath zipEntryPath : zipEntryPathList) {
                zipEntryPathMap.put(zipEntryPath.zipEntry.getName(), zipEntryPath);
                needToAddEntryNameList.add(zipEntryPath.zipEntry.getName());
            }
        }
        try {
            FileUtil.createFile(outputZipFullFilename);
            zipOutputStream = new ZipOutputStream(new FileOutputStream(outputZipFullFilename));
            if (inputZipFullFilename != null) {
                zipFile = new ZipFile(inputZipFullFilename);
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                    String zipEntryName = zipEntry.getName();
                    InputStream inputStream = null;
                    if (zipEntryPathMap.containsKey(zipEntryName)) {
                        ZipEntryPath zipEntryPath = (ZipEntryPath)zipEntryPathMap.get(zipEntryName);
                        needToAddEntryNameList.remove(zipEntryName);
                        if (zipEntryPath.replace) {
                            zipEntry = zipEntryPath.zipEntry;
                            inputStream = new FileInputStream(zipEntryPath.fullFilename);
                        }
                    }
                    if (inputStream == null) {
                        inputStream = zipFile.getInputStream(zipEntry);
                        if (zipProcessor != null) {
                            inputStream = zipProcessor.zipEntryProcess(zipEntryName, inputStream);
                        }
                    }
                    ZipEntry newZipEntry = new ZipEntry(zipEntryName);
                    FileUtil.addZipEntry(zipOutputStream, newZipEntry, inputStream);
                }
            }
            for (String zipEntryName : needToAddEntryNameList) {
                ZipEntryPath zipEntryPath = (ZipEntryPath)zipEntryPathMap.get(zipEntryName);
                ZipEntry zipEntry = zipEntryPath.zipEntry;
                InputStream inputStream = new FileInputStream(zipEntryPath.fullFilename);
                if (zipProcessor != null) {
                    inputStream = zipProcessor.zipEntryProcess(zipEntry.getName(), inputStream);
                }
                FileUtil.addZipEntry(zipOutputStream, zipEntry, inputStream);
            }
        }
        catch (Exception e) {
            try {
                throw new FileUtilException(e);
            }
            catch (Throwable throwable) {
                StreamUtil.closeQuietly(zipOutputStream);
                StreamUtil.closeQuietly(zipFile);
                throw throwable;
            }
        }
        StreamUtil.closeQuietly((Object)zipOutputStream);
        StreamUtil.closeQuietly((Object)zipFile);
    }

    public static void mergeZip(String zipOutputFullFilename, List<String> mergeZipFullFilenameList) {
        FileUtil.createFile(zipOutputFullFilename);
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(new FileOutputStream(zipOutputFullFilename));
            if (mergeZipFullFilenameList != null) {
                for (String zipFullFilename : mergeZipFullFilenameList) {
                    if (!FileUtil.isExist(zipFullFilename)) continue;
                    ZipFile zipFile = new ZipFile(zipFullFilename);
                    Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                    while (enumeration.hasMoreElements()) {
                        ZipEntry zipEntry = enumeration.nextElement();
                        InputStream inputStream = zipFile.getInputStream(zipEntry);
                        FileUtil.addZipEntry(zipOutputStream, zipEntry, inputStream);
                    }
                    zipFile.close();
                }
            }
        }
        catch (Exception e) {
            try {
                throw new FileUtilException(e);
            }
            catch (Throwable throwable) {
                StreamUtil.closeQuietly(zipOutputStream);
                throw throwable;
            }
        }
        StreamUtil.closeQuietly((Object)zipOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addZipEntry(ZipOutputStream zipOutputStream, ZipEntry zipEntry, InputStream inputStream) throws Exception {
        try {
            zipOutputStream.putNextEntry(zipEntry);
            byte[] buffer = new byte[1024];
            int length = -1;
            while ((length = inputStream.read(buffer, 0, buffer.length)) != -1) {
                zipOutputStream.write(buffer, 0, length);
                zipOutputStream.flush();
            }
        }
        catch (ZipException zipException) {
        }
        finally {
            StreamUtil.closeQuietly((Object)inputStream);
            zipOutputStream.closeEntry();
        }
    }

    public static byte[] readFile(String fullFilename) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(fullFilename);
            FileUtil.copyStream(inputStream, byteArrayOutputStream);
        }
        catch (FileNotFoundException e) {
            throw new FileUtilException(e);
        }
        finally {
            StreamUtil.closeQuietly((Object)byteArrayOutputStream);
            StreamUtil.closeQuietly((Object)inputStream);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void writeFile(String outputFullFilename, byte[] byteArray) {
        ByteArrayInputStream inputStream = null;
        FileUtil.createFile(outputFullFilename);
        FileOutputStream outputStream = null;
        try {
            inputStream = new ByteArrayInputStream(byteArray);
            outputStream = new FileOutputStream(outputFullFilename);
            FileUtil.copyStream(inputStream, outputStream);
        }
        catch (FileNotFoundException e) {
            try {
                throw new FileUtilException(e);
            }
            catch (Throwable throwable) {
                StreamUtil.closeQuietly(outputStream);
                StreamUtil.closeQuietly((Object)inputStream);
                throw throwable;
            }
        }
        StreamUtil.closeQuietly((Object)outputStream);
        StreamUtil.closeQuietly((Object)inputStream);
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) {
        if (inputStream != null && outputStream != null) {
            try {
                int length = -1;
                byte[] buffer = new byte[0x100000];
                while ((length = inputStream.read(buffer, 0, buffer.length)) != -1) {
                    outputStream.write(buffer, 0, length);
                    outputStream.flush();
                }
            }
            catch (Exception e) {
                throw new FileUtilException(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void mergeFile(String outputFullFilename, List<String> fullFilenameList) {
        if (fullFilenameList == null) return;
        if (outputFullFilename == null) return;
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(outputFullFilename);
            for (String fullFilename : fullFilenameList) {
                FileInputStream inputStream = null;
                try {
                    inputStream = new FileInputStream(fullFilename);
                    FileUtil.copyStream(inputStream, outputStream);
                }
                catch (Exception e) {
                    try {
                        throw new FileUtilException(e);
                    }
                    catch (Throwable throwable) {
                        StreamUtil.closeQuietly(inputStream);
                        throw throwable;
                    }
                }
                StreamUtil.closeQuietly((Object)inputStream);
            }
        }
        catch (Exception e) {
            try {
                throw new FileUtilException(e);
            }
            catch (Throwable throwable) {
                StreamUtil.closeQuietly(outputStream);
                throw throwable;
            }
        }
        StreamUtil.closeQuietly((Object)outputStream);
    }

    public static List<String> findMatchFileDirectory(String sourceDirectory, String fileSuffix) {
        return FileUtil.findMatchFileOrMatchFileDirectory(sourceDirectory, fileSuffix, null, false, true);
    }

    public static List<String> findMatchFileDirectory(String sourceDirectory, String fileSuffix, boolean includeHidden) {
        return FileUtil.findMatchFileOrMatchFileDirectory(sourceDirectory, fileSuffix, null, false, includeHidden);
    }

    public static List<String> findMatchFileDirectory(String sourceDirectory, String fileSuffix, String somethingAppendToRear) {
        return FileUtil.findMatchFileOrMatchFileDirectory(sourceDirectory, fileSuffix, somethingAppendToRear, false, true);
    }

    public static List<String> findMatchFileDirectory(String sourceDirectory, String fileSuffix, String somethingAppendToRear, boolean includeHidden) {
        return FileUtil.findMatchFileOrMatchFileDirectory(sourceDirectory, fileSuffix, somethingAppendToRear, false, includeHidden);
    }

    public static List<String> findMatchFile(String sourceDirectory, String fileSuffix) {
        return FileUtil.findMatchFileOrMatchFileDirectory(sourceDirectory, fileSuffix, null, true, true);
    }

    public static List<String> findMatchFile(String sourceDirectory, String fileSuffix, boolean includeHidden) {
        return FileUtil.findMatchFileOrMatchFileDirectory(sourceDirectory, fileSuffix, null, true, includeHidden);
    }

    public static List<String> findMatchFile(String sourceDirectory, String fileSuffix, String somethingAppendToRear) {
        return FileUtil.findMatchFileOrMatchFileDirectory(sourceDirectory, fileSuffix, somethingAppendToRear, true, false);
    }

    public static List<String> findMatchFile(String sourceDirectory, String fileSuffix, String somethingAppendToRear, boolean includeHidden) {
        return FileUtil.findMatchFileOrMatchFileDirectory(sourceDirectory, fileSuffix, somethingAppendToRear, true, includeHidden);
    }

    private static List<String> findMatchFileOrMatchFileDirectory(String sourceDirectory, String fileSuffix, String somethingAppendToRear, boolean isFindMatchFile, boolean includeHidden) {
        fileSuffix = StringUtil.nullToBlank(fileSuffix);
        somethingAppendToRear = StringUtil.nullToBlank(somethingAppendToRear);
        ArrayList<String> list = new ArrayList<String>();
        File sourceDirectoryFile = new File(sourceDirectory);
        ConcurrentLinkedQueue<File> queue = new ConcurrentLinkedQueue<File>();
        queue.add(sourceDirectoryFile);
        while (!queue.isEmpty()) {
            File file = (File)queue.poll();
            boolean result = false;
            if (!file.isHidden() || includeHidden) {
                result = true;
            }
            if (!result) continue;
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                if (fileArray == null) continue;
                queue.addAll(Arrays.asList(fileArray));
                continue;
            }
            if (!file.isFile() || !file.getName().toLowerCase().endsWith(fileSuffix.toLowerCase())) continue;
            if (isFindMatchFile) {
                list.add(file.getAbsolutePath() + somethingAppendToRear);
                continue;
            }
            String parentPath = file.getParent();
            if (list.contains(parentPath = parentPath + somethingAppendToRear)) continue;
            list.add(parentPath);
        }
        return list;
    }

    private static Map<String, String> getZipEntryHashMap(String zipFullFilename) {
        ZipFile zipFile = null;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            zipFile = new ZipFile(zipFullFilename);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                if (zipEntry.isDirectory()) continue;
                String key = zipEntry.getName();
                String value = zipEntry.getCrc() + "." + zipEntry.getSize();
                map.put(key, value);
            }
        }
        catch (Exception e) {
            throw new FileUtilException(e);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    throw new FileUtilException(e);
                }
            }
        }
        return map;
    }

    public static void differZip(String differentOutputFullFilename, String oldZipFullFilename, String newZipFullFilename) {
        Map<String, String> map = FileUtil.getZipEntryHashMap(oldZipFullFilename);
        ZipFile newZipFile = null;
        ZipOutputStream zipOutputStream = null;
        try {
            newZipFile = new ZipFile(newZipFullFilename);
            Enumeration<? extends ZipEntry> entries = newZipFile.entries();
            FileUtil.createFile(differentOutputFullFilename);
            zipOutputStream = new ZipOutputStream(new FileOutputStream(differentOutputFullFilename));
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                if (zipEntry.isDirectory()) continue;
                String zipEntryName = zipEntry.getName();
                String oldZipEntryHash = map.get(zipEntryName);
                String newZipEntryHash = zipEntry.getCrc() + "." + zipEntry.getSize();
                if (oldZipEntryHash != null && newZipEntryHash.equals(oldZipEntryHash)) continue;
                System.out.println(String.format("found modified entry, key=%s(%s/%s)", zipEntryName, oldZipEntryHash, newZipEntryHash));
                FileUtil.addZipEntry(zipOutputStream, zipEntry, newZipFile.getInputStream(zipEntry));
            }
        }
        catch (Exception e) {
            try {
                throw new FileUtilException(e);
            }
            catch (Throwable throwable) {
                StreamUtil.closeQuietly(zipOutputStream);
                StreamUtil.closeQuietly((Object)newZipFile);
                throw throwable;
            }
        }
        StreamUtil.closeQuietly((Object)zipOutputStream);
        StreamUtil.closeQuietly((Object)newZipFile);
    }

    public static void generateSimpleFile(String templateFullFilename, String outputFullFilename, Map<String, String> valueMap) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(templateFullFilename);
            FileUtil.generateSimpleFile(inputStream, outputFullFilename, valueMap);
        }
        catch (Exception e) {
            try {
                throw new FileUtilException(e);
            }
            catch (Throwable throwable) {
                StreamUtil.closeQuietly(inputStream);
                throw throwable;
            }
        }
        StreamUtil.closeQuietly((Object)inputStream);
    }

    public static void generateSimpleFile(InputStream templateInputStream, String outputFullFilename, Map<String, String> valueMap) {
        BufferedReader bufferedReader = null;
        FileOutputStream outputStream = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(templateInputStream, "UTF-8"));
            StringBuilder content = new StringBuilder();
            String line = null;
            Set<Map.Entry<String, String>> entrySet = valueMap.entrySet();
            while ((line = bufferedReader.readLine()) != null) {
                for (Map.Entry<String, String> entry : entrySet) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    line = line.replace(key, value);
                }
                content.append(line);
                content.append("\r\n");
            }
            FileUtil.createFile(outputFullFilename);
            outputStream = new FileOutputStream(outputFullFilename);
            ((OutputStream)outputStream).write(content.toString().getBytes("UTF-8"));
            outputStream.flush();
        }
        catch (Exception e) {
            try {
                throw new FileUtilException(e);
            }
            catch (Throwable throwable) {
                StreamUtil.closeQuietly(outputStream);
                StreamUtil.closeQuietly(bufferedReader);
                throw throwable;
            }
        }
        StreamUtil.closeQuietly((Object)outputStream);
        StreamUtil.closeQuietly((Object)bufferedReader);
    }

    public static List<String> findFileListWithCache(List<String> sourceDirectoryList, Properties cacheProperties, String fileSuffix, String somethingAppendToRear, boolean isFile) {
        return FileUtil.findFileListWithCache(sourceDirectoryList, cacheProperties, fileSuffix, somethingAppendToRear, isFile, null);
    }

    public static List<String> findFileListWithCache(List<String> sourceDirectoryList, Properties cacheProperties, String fileSuffix, String somethingAppendToRear, boolean isFile, CacheProcessor cacheProcessor) {
        return FileUtil.findFileListWithCache(sourceDirectoryList, cacheProperties, fileSuffix, somethingAppendToRear, isFile, false, cacheProcessor);
    }

    public static List<String> findFileListWithCache(List<String> sourceDirectoryList, Properties cacheProperties, String fileSuffix, String somethingAppendToRear, boolean isFile, boolean includeHidden, CacheProcessor cacheProcessor) {
        ArrayList<String> sourceList;
        block13: {
            block14: {
                block15: {
                    block12: {
                        sourceList = new ArrayList<String>();
                        if (cacheProperties != null) break block12;
                        if (sourceDirectoryList == null || sourceDirectoryList.isEmpty()) break block13;
                        for (String sourceDirectory : sourceDirectoryList) {
                            if (isFile) {
                                sourceList.addAll(FileUtil.findMatchFile(sourceDirectory, fileSuffix, includeHidden));
                                continue;
                            }
                            sourceList.addAll(FileUtil.findMatchFileDirectory(sourceDirectory, fileSuffix, somethingAppendToRear, includeHidden));
                        }
                        break block13;
                    }
                    if (!cacheProperties.isEmpty()) break block14;
                    ArrayList<String> fileList = new ArrayList<String>();
                    if (sourceDirectoryList != null && !sourceDirectoryList.isEmpty()) {
                        for (String sourceDirectory : sourceDirectoryList) {
                            fileList.addAll(FileUtil.findMatchFile(sourceDirectory, fileSuffix, includeHidden));
                        }
                    }
                    Iterator<Object> iterator = fileList.iterator();
                    while (iterator.hasNext()) {
                        String fullFilename;
                        String cacheKey = fullFilename = (String)iterator.next();
                        if (cacheProcessor != null) {
                            cacheKey = cacheProcessor.keyProcess(cacheKey);
                        }
                        cacheProperties.setProperty(cacheKey, Generator.md5File(fullFilename));
                    }
                    if (!isFile) break block15;
                    sourceList.addAll(fileList);
                    break block13;
                }
                if (sourceDirectoryList == null || sourceDirectoryList.isEmpty()) break block13;
                for (String sourceDirectory : sourceDirectoryList) {
                    sourceList.addAll(FileUtil.findMatchFileDirectory(sourceDirectory, fileSuffix, somethingAppendToRear, includeHidden));
                }
                break block13;
            }
            ArrayList<String> fileList = new ArrayList<String>();
            if (sourceDirectoryList != null && !sourceDirectoryList.isEmpty()) {
                for (String sourceDirectory : sourceDirectoryList) {
                    fileList.addAll(FileUtil.findMatchFile(sourceDirectory, fileSuffix, includeHidden));
                }
            }
            Iterator<Object> iterator = fileList.iterator();
            while (iterator.hasNext()) {
                String fullFilename;
                String cacheKey = fullFilename = (String)iterator.next();
                if (cacheProcessor != null) {
                    cacheKey = cacheProcessor.keyProcess(cacheKey);
                }
                String sourceFileMd5 = Generator.md5File(fullFilename);
                if (cacheProperties.containsKey(cacheKey)) {
                    String md5 = cacheProperties.getProperty(cacheKey);
                    if (sourceFileMd5.equals(md5)) continue;
                    sourceList.add(fullFilename);
                    cacheProperties.setProperty(cacheKey, sourceFileMd5);
                    continue;
                }
                sourceList.add(fullFilename);
                cacheProperties.setProperty(cacheKey, sourceFileMd5);
            }
        }
        return sourceList;
    }

    public static List<String> dealWithFileCache(String propertiesFileMappingFullFilename, NoCacheFileFinder noCacheFileFinder, NoCacheFileProcessor noCacheFileProcessor) {
        Properties propertiesFileMapping = FileUtil.getPropertiesAutoCreate(propertiesFileMappingFullFilename);
        List<String> noCacheFileList = null;
        if (noCacheFileFinder == null) {
            throw new NullPointerException("noCacheFileFinder can not be null.");
        }
        noCacheFileList = noCacheFileFinder.findNoCacheFileList(propertiesFileMapping);
        boolean saveCache = false;
        if (noCacheFileProcessor != null) {
            saveCache = noCacheFileProcessor.process(noCacheFileList);
        }
        if (saveCache) {
            FileUtil.saveProperties(propertiesFileMapping, propertiesFileMappingFullFilename);
        }
        return noCacheFileList;
    }

    public static Properties getPropertiesAutoCreate(String propertiesFullFilename) {
        if (!FileUtil.isExist(propertiesFullFilename)) {
            FileUtil.createFile(propertiesFullFilename);
        }
        return FileUtil.getProperties(propertiesFullFilename);
    }

    public static Properties getProperties(String propertiesFullFilename) {
        Properties properties = null;
        if (propertiesFullFilename != null) {
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(propertiesFullFilename);
                properties = new Properties();
                properties.load(inputStream);
            }
            catch (Exception e) {
                try {
                    throw new FileUtilException(e);
                }
                catch (Throwable throwable) {
                    StreamUtil.closeQuietly(inputStream);
                    throw throwable;
                }
            }
            StreamUtil.closeQuietly((Object)inputStream);
        }
        return properties;
    }

    public static Properties getProperties(File file) {
        Properties properties = null;
        if (file != null) {
            properties = FileUtil.getProperties(file.getAbsolutePath());
        }
        return properties;
    }

    public static void saveProperties(Properties properties, String outputFullFilename) {
        if (properties != null && outputFullFilename != null) {
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(outputFullFilename);
                properties.store(outputStream, null);
            }
            catch (Exception e) {
                try {
                    throw new FileUtilException(e);
                }
                catch (Throwable throwable) {
                    StreamUtil.closeQuietly(outputStream);
                    throw throwable;
                }
            }
            StreamUtil.closeQuietly((Object)outputStream);
        }
    }

    private static void copyFileToFile(String fromFile, String toFile, FileCopyProcessor fileCopyProcessor) {
        if (fileCopyProcessor != null) {
            FileUtil.createFile(toFile);
            fileCopyProcessor.copyFileToFileProcess(fromFile, toFile, true);
        }
    }

    public static void main(String[] args) {
        String outputZipFullFilename = "/D:/a/b.zip";
        FileUtil.mergeZip(outputZipFullFilename, Arrays.asList("/D:/a.zip", "/D:/b.zip"));
    }

    public static class FileUtilException
    extends RuntimeException {
        private static final long serialVersionUID = 3884649425767533205L;

        public FileUtilException(Throwable cause) {
            super(cause);
        }
    }

    public static class ZipEntryPath {
        private String fullFilename = null;
        private ZipEntry zipEntry = null;
        private boolean replace = false;

        public ZipEntryPath(String fullFilename, ZipEntry zipEntry) {
            this(fullFilename, zipEntry, false);
        }

        public ZipEntryPath(String fullFilename, ZipEntry zipEntry, boolean replace) {
            this.fullFilename = fullFilename;
            this.zipEntry = zipEntry;
            this.replace = replace;
        }
    }

    public static interface NoCacheFileFinder {
        public List<String> findNoCacheFileList(Properties var1);
    }

    public static interface NoCacheFileProcessor {
        public boolean process(List<String> var1);
    }

    public static interface CacheProcessor {
        public String keyProcess(String var1);
    }

    public static interface ZipProcessor {
        public InputStream zipEntryProcess(String var1, InputStream var2);
    }

    public static interface FileCopyProcessor {
        public boolean copyFileToFileProcess(String var1, String var2, boolean var3);
    }

    public static enum FileCopyType {
        PATH_TO_PATH,
        FILE_TO_PATH,
        FILE_TO_FILE;

    }
}

