/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.ziputils.ziputil;

import com.tencent.tinker.ziputils.ziputil.TinkerZipEntry;
import com.tencent.tinker.ziputils.ziputil.TinkerZipFile;
import com.tencent.tinker.ziputils.ziputil.TinkerZipOutputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TinkerZipUtil {
    private static final int BUFFER_SIZE = 16384;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractTinkerEntry(TinkerZipFile apk, TinkerZipEntry zipEntry, TinkerZipOutputStream outputStream) throws IOException {
        try (InputStream in = null;){
            in = apk.getInputStream(zipEntry);
            outputStream.putNextEntry(new TinkerZipEntry(zipEntry));
            byte[] buffer = new byte[16384];
            int length = in.read(buffer);
            while (length != -1) {
                outputStream.write(buffer, 0, length);
                length = in.read(buffer);
            }
            outputStream.closeEntry();
        }
    }

    public static void extractTinkerEntry(TinkerZipEntry zipEntry, InputStream inputStream, TinkerZipOutputStream outputStream) throws IOException {
        outputStream.putNextEntry(zipEntry);
        byte[] buffer = new byte[16384];
        int length = inputStream.read(buffer);
        while (length != -1) {
            outputStream.write(buffer, 0, length);
            length = inputStream.read(buffer);
        }
        outputStream.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractLargeModifyFile(TinkerZipEntry sourceArscEntry, File newFile, long newFileCrc, TinkerZipOutputStream outputStream) throws IOException {
        TinkerZipEntry newArscZipEntry = new TinkerZipEntry(sourceArscEntry);
        newArscZipEntry.setMethod(0);
        newArscZipEntry.setSize(newFile.length());
        newArscZipEntry.setCompressedSize(newFile.length());
        newArscZipEntry.setCrc(newFileCrc);
        try (BufferedInputStream in = null;){
            in = new BufferedInputStream(new FileInputStream(newFile));
            outputStream.putNextEntry(new TinkerZipEntry(newArscZipEntry));
            byte[] buffer = new byte[16384];
            int length = in.read(buffer);
            while (length != -1) {
                outputStream.write(buffer, 0, length);
                length = in.read(buffer);
            }
            outputStream.closeEntry();
        }
    }

    public static boolean validateZipEntryName(File destDir, String entryName) {
        if (entryName == null || entryName.isEmpty()) {
            return false;
        }
        try {
            String canonicalDestinationDir = destDir.getCanonicalPath();
            File destEntryFile = destDir.toPath().resolve(entryName).toFile();
            return destEntryFile.getCanonicalPath().startsWith(canonicalDestinationDir + File.separator);
        }
        catch (Throwable ignored) {
            return false;
        }
    }
}

