/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.android.fcm;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.tencent.android.tpush.XGLocalMessage;
import com.tencent.android.tpush.XGPushManager;
import com.tencent.android.tpush.logging.TLogger;
import com.tencent.android.tpush.otherpush.OtherPushClient;
import com.tencent.android.tpush.otherpush.fcm.impl.OtherPushImpl;
import com.tencent.android.tpush.stat.ServiceStat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class XGFcmListenerService
extends FirebaseMessagingService {
    private static final String TAG = "XGFcmListenerService";

    public void onNewToken(String string) {
        try {
            TLogger.d((String)TAG, (String)("Refreshed token: " + string));
            OtherPushImpl.setToken(this.getApplicationContext(), string);
            OtherPushClient.updateToken((Context)this.getApplicationContext());
        }
        catch (Throwable throwable) {
            TLogger.e((String)TAG, (String)("onNewToken error: " + throwable.toString()));
        }
    }

    public void onMessageReceived(RemoteMessage remoteMessage) {
        Intent intent;
        long l;
        long l2;
        long l3;
        if (remoteMessage == null) {
            return;
        }
        Map map = remoteMessage.getData();
        if (map == null) {
            return;
        }
        String string = remoteMessage.getFrom();
        XGPushManager.startPushService((Context)this);
        String string2 = (String)map.get("title");
        long l4 = -1L;
        try {
            l4 = Integer.parseInt((String)map.get("type"));
        }
        catch (NumberFormatException numberFormatException) {
            TLogger.e((String)TAG, (String)("type from Srv format Error: " + numberFormatException.getMessage()));
        }
        String string3 = (String)map.get("pushChannel");
        String string4 = (String)map.get("content");
        String string5 = (String)map.get("msgId");
        String string6 = (String)map.get("busiMsgId");
        String string7 = (String)map.get("pushTime");
        String string8 = (String)map.get("groupId");
        String string9 = (String)map.get("templateId");
        String string10 = (String)map.get("traceId");
        long l5 = 0L;
        long l6 = 0L;
        String string11 = (String)map.get("targetType");
        String string12 = (String)map.get("source");
        if (string11 != null) {
            try {
                l5 = Long.parseLong(string11);
            }
            catch (NumberFormatException numberFormatException) {
                TLogger.e((String)TAG, (String)("targetType from Srv format Error: " + numberFormatException.getMessage()));
            }
        }
        if (string12 != null) {
            try {
                l6 = Long.parseLong(string12);
            }
            catch (NumberFormatException numberFormatException) {
                TLogger.e((String)TAG, (String)("source from Srv format Error: " + numberFormatException.getMessage()));
            }
        }
        TLogger.d((String)TAG, (String)("[FCM Notification] From: " + string + ", title: " + string2 + ", type: " + l4 + ", content: " + string4 + ", strMsgid: " + string5 + ", strBusiMsgId: " + string6 + " , groupId : " + string8 + ", strTargetType: " + string11 + ", strSource: " + string12 + " , pushChannel = " + string3));
        boolean bl = true;
        if (string5 != null) {
            try {
                l3 = Long.parseLong(string5);
            }
            catch (NumberFormatException numberFormatException) {
                l3 = System.currentTimeMillis();
                bl = false;
            }
        } else {
            l3 = System.currentTimeMillis();
            bl = false;
        }
        if (string6 != null) {
            try {
                l2 = Long.parseLong(string6);
            }
            catch (NumberFormatException numberFormatException) {
                l2 = 0L;
            }
        } else {
            l2 = 0L;
        }
        if (string7 != null) {
            try {
                l = Long.parseLong(string7);
                l = 1000L * l;
            }
            catch (NumberFormatException numberFormatException) {
                l = 0L;
            }
        } else {
            l = 0L;
        }
        try {
            intent = new Intent();
            intent.putExtra("msgId", l3);
            intent.putExtra("busiMsgId", l2);
            intent.putExtra("type", l4);
            intent.putExtra("pushChannel", 101);
            intent.putExtra("pushTime", l);
            intent.putExtra("groupId", string8);
            intent.putExtra("targetType", l5);
            intent.putExtra("source", l6);
            intent.putExtra("templateId", string9);
            intent.putExtra("traceId", string10);
            if (bl) {
                ServiceStat.appReportServiceReceived((Context)this.getApplication(), (Intent)intent);
            }
        }
        catch (Throwable throwable) {
            TLogger.e((String)TAG, (String)("report service receive error: " + throwable));
        }
        intent = new XGLocalMessage();
        intent.setType((int)l4);
        intent.setMsgId(l3);
        intent.setBusiMsgId(l2);
        intent.nGroupId = string8;
        intent.pushTime = l;
        intent.targetType = l5;
        intent.source = l6;
        intent.templateId = string9;
        intent.traceId = string10;
        intent.pushChannel = 101;
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd-HH-mm");
        String[] stringArray = simpleDateFormat.format(date).split("-");
        if (stringArray.length >= 3) {
            intent.setDate(stringArray[0]);
            intent.setHour(stringArray[1]);
            intent.setMin(stringArray[2]);
        }
        try {
            Object object;
            String string13;
            if (string4 == null) {
                return;
            }
            JSONObject jSONObject = new JSONObject(string4);
            if (jSONObject == null) {
                return;
            }
            if (!jSONObject.isNull("title")) {
                intent.setTitle(jSONObject.getString("title"));
            }
            if (!jSONObject.isNull("content")) {
                intent.setContent(jSONObject.getString("content"));
            }
            if (!jSONObject.isNull("custom_content") && (string13 = jSONObject.getString("custom_content")) != null && !string13.trim().equals("{}") && (object = XGFcmListenerService.strToHashMap(string13)) != null) {
                intent.setCustomContent(object);
            }
            intent.setBuilderId((long)jSONObject.optInt("builder_id"));
            intent.setRing(jSONObject.optInt("ring", 1));
            intent.setRing_raw(jSONObject.optString("ring_raw"));
            intent.setIcon_res(jSONObject.optString("icon_res"));
            intent.setSmall_icon(jSONObject.optString("small_icon"));
            intent.setLights(jSONObject.optInt("lights", 1));
            intent.setVibrate(jSONObject.optInt("vibrate", 1));
            intent.setIcon_type(jSONObject.optInt("icon_type", 0));
            intent.setNotificationId(jSONObject.optInt("n_id"));
            intent.setStyle_id(jSONObject.optInt("style_id", 0));
            intent.setNsModel(jSONObject.optInt("is_show_type", 2));
            intent.setChannelId(jSONObject.optString("n_ch_id"));
            intent.setTpns_media_resources(jSONObject.optString("xg_media_resources"));
            intent.setColor(jSONObject.optInt("color", 0));
            intent.setBadgeType(jSONObject.optInt("badge_type", -1));
            intent.setThreadId(jSONObject.optString("thread_id"));
            intent.setThreadSumText(jSONObject.optString("thread_sumtext"));
            int n = intent.pushChannel = string3 != null && !TextUtils.isEmpty((CharSequence)string3) ? Integer.valueOf(string3) : 101;
            if (!jSONObject.isNull("action")) {
                JSONObject jSONObject2;
                string13 = new JSONObject(jSONObject.getString("action"));
                if (!string13.isNull("action_type")) {
                    intent.setAction_type(string13.getInt("action_type"));
                }
                if (!string13.isNull("activity")) {
                    intent.setActivity(string13.getString("activity"));
                }
                if (!string13.isNull("intent")) {
                    intent.setIntent(string13.getString("intent"));
                }
                if (!string13.isNull("browser") && !(jSONObject2 = new JSONObject((String)(object = string13.getString("browser")))).isNull("url")) {
                    intent.setUrl(jSONObject2.getString("url"));
                }
                if (!string13.isNull("package_name")) {
                    object = string13.getString("package_name");
                    jSONObject2 = new JSONObject((String)object);
                    if (!jSONObject2.isNull("packageDownloadUrl")) {
                        intent.setPackageDownloadUrl(jSONObject2.getString("packageDownloadUrl"));
                    }
                    if (!jSONObject2.isNull("packageName")) {
                        intent.setPackageName(jSONObject2.getString("packageName"));
                    }
                }
            }
        }
        catch (Throwable throwable) {
            TLogger.e((String)TAG, (String)("get local msg from json error: " + throwable));
        }
        XGPushManager.addLocalNotification((Context)this.getApplicationContext(), (XGLocalMessage)intent);
    }

    private static HashMap<String, Object> strToHashMap(String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            JSONObject jSONObject = new JSONObject(string);
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string2 = String.valueOf(iterator.next());
                Object object = jSONObject.get(string2);
                hashMap.put(string2, object);
            }
        }
        catch (JSONException jSONException) {
            return null;
        }
        return hashMap;
    }
}

