/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.android.tpush.otherpush.fcm.impl;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.support.annotation.NonNull;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;
import com.google.firebase.messaging.FirebaseMessaging;
import com.tencent.android.fcm.Util;
import com.tencent.android.tpush.encrypt.Rijndael;
import com.tencent.android.tpush.logging.TLogger;
import java.lang.reflect.Method;

public class OtherPushImpl {
    public static final String TPUSH_FCM_TOKEN = "XG_V2_FCM_APP_TOKEN";
    public static String fcmToken = "";
    private static int isAvailable = -1;
    private static final String SP_FILE = "xg.otherpush.xml";
    private static final int FCM_API_VERSION_22 = 22;
    private static final int FCM_API_VERSION_LOWER_22 = 17;
    private static final int FCM_API_VERSION_ERROR = -1;
    private static int fcmApiVersion = 0;

    public static String getPushInfo() {
        return "fcm";
    }

    private static int getFCMVersion() {
        if (fcmApiVersion == 0) {
            try {
                Class<?> clazz = Class.forName("com.google.firebase.messaging.FirebaseMessaging");
                Method method = clazz.getDeclaredMethod("getToken", new Class[0]);
                TLogger.i((String)"XG_fcm", (String)"get FCM version over 22");
                fcmApiVersion = 22;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                TLogger.i((String)"XG_fcm", (String)"get FCM version lower 22");
                fcmApiVersion = 17;
            }
            catch (Throwable throwable) {
                TLogger.w((String)"XG_fcm", (String)"Missing FCM SDK");
                fcmApiVersion = -1;
            }
        }
        return fcmApiVersion;
    }

    public static void registerPush(final Context context) {
        try {
            if (OtherPushImpl.getFCMVersion() == -1) {
                return;
            }
            if (OtherPushImpl.getFCMVersion() == 22) {
                FirebaseMessaging.getInstance().getToken().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<String>(){

                    public void onComplete(@NonNull Task<String> task) {
                        if (!task.isSuccessful()) {
                            TLogger.w((String)"XG_fcm", (String)"getToken failed", (Throwable)task.getException());
                            return;
                        }
                        fcmToken = (String)task.getResult();
                        TLogger.d((String)"XG_fcm", (String)(" OtherPushImpl registerFcmPush getToken= " + fcmToken));
                        SharedPreferences sharedPreferences = OtherPushImpl.getOtherPushSharedPreferences(context);
                        if (sharedPreferences != null) {
                            SharedPreferences.Editor editor = sharedPreferences.edit();
                            editor.putString("XG_V2_FCM_APP_TOKEN," + context.getPackageName(), Rijndael.encrypt((String)fcmToken));
                            editor.commit();
                        }
                    }
                });
            } else {
                FirebaseInstanceId.getInstance().getInstanceId().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<InstanceIdResult>(){

                    public void onComplete(@NonNull Task<InstanceIdResult> task) {
                        if (!task.isSuccessful()) {
                            TLogger.w((String)"XG_fcm", (String)"getInstanceId failed", (Throwable)task.getException());
                            return;
                        }
                        fcmToken = ((InstanceIdResult)task.getResult()).getToken();
                        TLogger.d((String)"XG_fcm", (String)(" OtherPushImpl registerFcmPush getToken= " + fcmToken));
                        SharedPreferences sharedPreferences = OtherPushImpl.getOtherPushSharedPreferences(context);
                        if (sharedPreferences != null) {
                            SharedPreferences.Editor editor = sharedPreferences.edit();
                            editor.putString("XG_V2_FCM_APP_TOKEN," + context.getPackageName(), Rijndael.encrypt((String)fcmToken));
                            editor.commit();
                        }
                    }
                });
            }
        }
        catch (Throwable throwable) {
            TLogger.e((String)"XG_fcm", (String)("FCM Register error! " + throwable));
            fcmToken = null;
        }
    }

    public static void unregisterPush(Context context) {
        try {
            if (OtherPushImpl.getFCMVersion() == -1) {
                return;
            }
            Context context2 = context;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (FirebaseApp.getInstance() != null) {
                            if (FirebaseApp.getInstance().getOptions() != null) {
                                if (OtherPushImpl.getFCMVersion() == 22) {
                                    FirebaseMessaging.getInstance().deleteToken();
                                } else {
                                    FirebaseInstanceId.getInstance().deleteToken(FirebaseApp.getInstance().getOptions().getGcmSenderId(), "FCM");
                                    TLogger.i((String)"XG_fcm", (String)"FCM unregisterPush success !");
                                }
                            } else {
                                TLogger.i((String)"XG_fcm", (String)"FCM unregisterPush fail !");
                            }
                        } else {
                            TLogger.i((String)"XG_fcm", (String)"FCM unregisterPush fail !");
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                    }
                    catch (Throwable throwable) {
                        TLogger.e((String)"XG_fcm", (String)("FCM deleteInstanceId error! " + throwable));
                    }
                }
            }).start();
        }
        catch (Throwable throwable) {
            TLogger.e((String)"XG_fcm", (String)("FCM unregister error! " + throwable));
        }
    }

    public static void setToken(Context context, String string) {
        SharedPreferences sharedPreferences;
        fcmToken = string;
        if (fcmToken == null) {
            fcmToken = "";
        }
        if ((sharedPreferences = OtherPushImpl.getOtherPushSharedPreferences(context)) != null) {
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString("XG_V2_FCM_APP_TOKEN," + context.getPackageName(), Rijndael.encrypt((String)fcmToken));
            editor.commit();
        }
    }

    public static String getToken(final Context context) {
        try {
            String string;
            if (!Util.isNullOrEmptyString(fcmToken)) {
                return fcmToken;
            }
            SharedPreferences sharedPreferences = OtherPushImpl.getOtherPushSharedPreferences(context);
            if (sharedPreferences != null && !Util.isNullOrEmptyString(string = sharedPreferences.getString("XG_V2_FCM_APP_TOKEN," + context.getPackageName(), null)) && !Util.isNullOrEmptyString(fcmToken = Rijndael.decrypt((String)string))) {
                return fcmToken;
            }
            if (OtherPushImpl.getFCMVersion() == -1) {
                return fcmToken;
            }
            if (OtherPushImpl.getFCMVersion() == 22) {
                FirebaseMessaging.getInstance().getToken().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<String>(){

                    public void onComplete(@NonNull Task<String> task) {
                        if (!task.isSuccessful()) {
                            TLogger.w((String)"XG_fcm", (String)"getToken failed", (Throwable)task.getException());
                            return;
                        }
                        fcmToken = (String)task.getResult();
                        SharedPreferences sharedPreferences = OtherPushImpl.getOtherPushSharedPreferences(context);
                        if (sharedPreferences != null) {
                            SharedPreferences.Editor editor = sharedPreferences.edit();
                            editor.putString("XG_V2_FCM_APP_TOKEN," + context.getPackageName(), Rijndael.encrypt((String)fcmToken));
                            editor.commit();
                        }
                    }
                });
            } else {
                FirebaseInstanceId.getInstance().getInstanceId().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<InstanceIdResult>(){

                    public void onComplete(@NonNull Task<InstanceIdResult> task) {
                        if (!task.isSuccessful()) {
                            TLogger.w((String)"OTHER_PUSH_TAG", (String)"getInstanceId failed", (Throwable)task.getException());
                            return;
                        }
                        fcmToken = ((InstanceIdResult)task.getResult()).getToken();
                        SharedPreferences sharedPreferences = OtherPushImpl.getOtherPushSharedPreferences(context);
                        if (sharedPreferences != null) {
                            SharedPreferences.Editor editor = sharedPreferences.edit();
                            editor.putString("XG_V2_FCM_APP_TOKEN," + context.getPackageName(), Rijndael.encrypt((String)fcmToken));
                            editor.commit();
                        }
                    }
                });
            }
            return fcmToken;
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static boolean checkDevice(Context context) {
        int n;
        if (isAvailable == -1) {
            n = -1;
            try {
                GoogleApiAvailability googleApiAvailability = GoogleApiAvailability.getInstance();
                n = googleApiAvailability.isGooglePlayServicesAvailable(context);
            }
            catch (Throwable throwable) {
                GoogleApiAvailabilityLight googleApiAvailabilityLight = GoogleApiAvailabilityLight.getInstance();
                n = googleApiAvailabilityLight.isGooglePlayServicesAvailable(context);
            }
            TLogger.d((String)"XG_fcm", (String)(" GooglePlayServices service resultCode = " + n));
            if (n == 0 || n == 2 || n == 21) {
                TLogger.d((String)"XG_fcm", (String)"This device is supported, GooglePlayServices service is running");
                isAvailable = 1;
            } else {
                TLogger.d((String)"XG_fcm", (String)" GooglePlayServices is not supported");
                isAvailable = 0;
            }
        }
        n = isAvailable == 1 ? 1 : 0;
        return n != 0;
    }

    private static SharedPreferences getOtherPushSharedPreferences(Context context) {
        SharedPreferences sharedPreferences = null;
        sharedPreferences = Build.VERSION.SDK_INT >= 11 ? context.getSharedPreferences(SP_FILE, 4) : context.getSharedPreferences(SP_FILE, 0);
        return sharedPreferences;
    }
}

