/*
 * Decompiled with CFR 0.152.
 */
package com.hihonor.push.framework.aidl;

import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import com.hihonor.push.framework.aidl.IMessageEntity;
import com.hihonor.push.framework.aidl.annotation.Packed;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class MessageCodec {
    private static final String TAG = "MessageCodec";
    private static final String BUNDLE_NEXT = "_next_item_";
    private static final String BUNDLE_VALUE = "_value_";
    public static final String PACKED_TYPE = "_packed_type_";
    public static final int VAL_NULL = -1;
    public static final int VAL_ENTITY = 0;
    public static final int VAL_LIST = 1;

    private MessageCodec() {
    }

    public static IMessageEntity parseMessageEntity(Bundle bundle, IMessageEntity iMessageEntity) {
        if (bundle != null && iMessageEntity != null) {
            bundle.setClassLoader(iMessageEntity.getClass().getClassLoader());
            for (Class<?> clazz = iMessageEntity.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                for (Field field : clazz.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(Packed.class)) continue;
                    try {
                        MessageCodec.parseMessageField(iMessageEntity, field, bundle);
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                    Log.e((String)TAG, (String)("decode, set value of the field exception, field name:" + field.getName()));
                }
            }
            return iMessageEntity;
        }
        return iMessageEntity;
    }

    private static void parseMessageField(IMessageEntity iMessageEntity, Field field, Bundle object) {
        if ((object = MessageCodec.newInstance(field, object)) != null) {
            Field field2 = field;
            boolean bl = field2.isAccessible();
            field2.setAccessible(true);
            field2.set(iMessageEntity, object);
            field2.setAccessible(bl);
        }
    }

    private static Object newInstance(Field field, Bundle object) {
        Object object2;
        block6: {
            int n2;
            block5: {
                Bundle bundle;
                object2 = object.get((String)(object = field.getName()));
                if (!(object2 instanceof Bundle)) break block6;
                try {
                    bundle = (Bundle)object2;
                }
                catch (Exception exception) {
                    Log.e((String)TAG, (String)"decode, read value of the field exception, field name: ".concat(String.valueOf(object)));
                    return null;
                }
                n2 = bundle.getInt(PACKED_TYPE, -1);
                if (n2 != 1) break block5;
                return MessageCodec.parseGenericType(field.getGenericType(), bundle);
            }
            if (n2 != 0) break block6;
            return MessageCodec.parseMessageEntity((Bundle)object2, (IMessageEntity)field.getType().newInstance());
        }
        return object2;
    }

    private static List<Object> parseGenericType(Type type, Bundle object) {
        ArrayList arrayList;
        Bundle bundle = object;
        object = arrayList;
        arrayList = new ArrayList();
        for (Bundle bundle2 = (v12014).getBundle(BUNDLE_NEXT); bundle2 != null; bundle2 = bundle2.getBundle(BUNDLE_NEXT)) {
            Object object2 = bundle2.get(BUNDLE_VALUE);
            if (!object2.getClass().isPrimitive() && !(object2 instanceof Serializable)) {
                if (!(object2 instanceof Bundle)) continue;
                int n2 = (object2 = (Bundle)object2).getInt(PACKED_TYPE, -1);
                if (n2 != 1) {
                    if (n2 == 0) {
                        ((ArrayList)object).add(MessageCodec.parseMessageEntity((Bundle)object2, (IMessageEntity)((Class)((ParameterizedType)type).getActualTypeArguments()[0]).newInstance()));
                        continue;
                    }
                    throw new InstantiationException("Unknown type can not be supported");
                }
                throw new InstantiationException("Nested List can not be supported");
            }
            ((ArrayList)object).add(object2);
        }
        return object;
    }

    public static Bundle formMessageEntity(IMessageEntity iMessageEntity, Bundle bundle) {
        if (iMessageEntity != null && bundle != null) {
            for (Class<?> clazz = iMessageEntity.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                for (Field field : clazz.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(Packed.class)) continue;
                    try {
                        MessageCodec.formMessageField(iMessageEntity, field, bundle);
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                    Log.e((String)TAG, (String)("encode, get value of the field exception, field name: " + field.getName()));
                }
            }
            return bundle;
        }
        return bundle;
    }

    private static void formMessageField(IMessageEntity iMessageEntity, Field field, Bundle bundle) {
        Field field2 = field;
        boolean bl = field2.isAccessible();
        field2.setAccessible(true);
        MessageCodec.put(field.getName(), field.get(iMessageEntity), bundle);
        field2.setAccessible(bl);
    }

    private static void put(String string, Object object, Bundle bundle) {
        if (object != null && !MessageCodec.putGenericType(string, object, bundle)) {
            if (object instanceof CharSequence) {
                bundle.putCharSequence(string, (CharSequence)object);
                return;
            }
            if (object instanceof Parcelable) {
                bundle.putParcelable(string, (Parcelable)object);
                return;
            }
            if (object instanceof byte[]) {
                bundle.putByteArray(string, (byte[])object);
                return;
            }
            if (object instanceof List) {
                MessageCodec.putList(string, (List)object, bundle);
                return;
            }
            if (object instanceof Serializable) {
                bundle.putSerializable(string, (Serializable)object);
                return;
            }
            if (object instanceof IMessageEntity) {
                String string2 = string;
                string = MessageCodec.formMessageEntity((IMessageEntity)object, new Bundle());
                string.putInt(PACKED_TYPE, 0);
                bundle.putBundle(string2, (Bundle)string);
                return;
            }
            Log.e((String)TAG, (String)"cannot support type, ".concat(String.valueOf(string)));
            return;
        }
    }

    private static void putList(String string, List list, Bundle bundle) {
        List list2 = list;
        list = null;
        for (Object e2 : list2) {
            if (list == null) {
                Bundle bundle2;
                list = bundle2;
                list();
                bundle.putBundle(string, (Bundle)list);
                bundle2.putInt(PACKED_TYPE, 1);
            }
            list = MessageCodec.putNext(BUNDLE_VALUE, (Bundle)list, e2);
        }
    }

    private static Bundle putNext(String string, Bundle bundle, Object object) {
        Bundle bundle2;
        Bundle bundle3 = bundle2;
        bundle3();
        MessageCodec.put(string, object, bundle3);
        bundle.putBundle(BUNDLE_NEXT, bundle3);
        return bundle2;
    }

    private static boolean putGenericType(String string, Object object, Bundle bundle) {
        if (object instanceof String) {
            bundle.putString(string, (String)object);
            return true;
        }
        if (object instanceof Integer) {
            bundle.putInt(string, ((Integer)object).intValue());
            return true;
        }
        if (object instanceof Short) {
            bundle.putShort(string, ((Short)object).shortValue());
            return true;
        }
        if (object instanceof Long) {
            bundle.putLong(string, ((Long)object).longValue());
            return true;
        }
        if (object instanceof Float) {
            bundle.putFloat(string, ((Float)object).floatValue());
            return true;
        }
        if (object instanceof Double) {
            bundle.putDouble(string, ((Double)object).doubleValue());
            return true;
        }
        if (!(object instanceof Boolean)) {
            return false;
        }
        bundle.putBoolean(string, ((Boolean)object).booleanValue());
        return true;
    }
}

