/*
 * Decompiled with CFR 0.152.
 */
package com.hihonor.push.sdk.ipc;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.text.TextUtils;
import com.hihonor.push.sdk.bean.RemoteServiceBean;
import com.hihonor.push.sdk.common.data.ErrorEnum;
import com.hihonor.push.sdk.common.logger.Logger;
import com.hihonor.push.sdk.utils.ConfigUtils;
import com.hihonor.push.sdk.utils.Preconditions;

public class HonorApiAvailability {
    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int isHonorMobileServicesAvailable(Context object) {
        void var0_4;
        Object object2 = object;
        Preconditions.checkNotNull(object2, "context must not be null.");
        RemoteServiceBean remoteServiceBean = HonorApiAvailability.a(object2);
        String string = remoteServiceBean.getPackageName();
        Logger.d("HonorApiAvailability", "service package name is ".concat(String.valueOf(string)));
        if (TextUtils.isEmpty((CharSequence)string)) {
            PackageStates packageStates = PackageStates.NOT_INSTALLED;
        } else {
            try {
                PackageStates packageStates = object.getPackageManager().getApplicationInfo((String)string, (int)0).enabled ? PackageStates.ENABLED : PackageStates.DISABLED;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                PackageStates packageStates = PackageStates.NOT_INSTALLED;
            }
        }
        if (PackageStates.NOT_INSTALLED.equals(var0_4)) {
            Logger.i("HonorApiAvailability", "push service is not installed");
            return 8002008;
        }
        if (PackageStates.DISABLED.equals(var0_4)) {
            Logger.i("HonorApiAvailability", "push service is disabled");
            return 8002007;
        }
        if (TextUtils.equals((CharSequence)string, (CharSequence)"android") && !TextUtils.isEmpty((CharSequence)remoteServiceBean.getPackageSignature())) {
            return ErrorEnum.SUCCESS.statusCode;
        }
        return 8002006;
    }

    public static RemoteServiceBean a(Context context) {
        Intent intent;
        RemoteServiceBean remoteServiceBean;
        RemoteServiceBean remoteServiceBean2 = remoteServiceBean;
        remoteServiceBean = new RemoteServiceBean();
        Object object = intent;
        new Intent().setComponent(new ComponentName("android", "com.hihonor.android.pushagentproxy.HiPushService"));
        object = context.getPackageManager().queryIntentServices((Intent)object, 128);
        if (object.size() > 0 && (object = object.iterator()).hasNext()) {
            RemoteServiceBean remoteServiceBean3 = remoteServiceBean2;
            Context context2 = context;
            context = (ResolveInfo)object.next();
            object = context.serviceInfo.applicationInfo.packageName;
            String string = ConfigUtils.getCertFingerprint(context2, (String)object);
            remoteServiceBean3.setPackageName((String)object);
            remoteServiceBean3.setPackageServiceName(context.serviceInfo.name);
            remoteServiceBean3.setPackageSignature(string);
        }
        return remoteServiceBean2;
    }

    public static final class PackageStates
    extends Enum<PackageStates> {
        public static final /* enum */ PackageStates ENABLED;
        public static final /* enum */ PackageStates DISABLED;
        public static final /* enum */ PackageStates NOT_INSTALLED;
        public static final /* synthetic */ PackageStates[] a;

        public static PackageStates[] values() {
            return (PackageStates[])a.clone();
        }

        public static PackageStates valueOf(String string) {
            return Enum.valueOf(PackageStates.class, string);
        }

        static {
            PackageStates packageStates;
            PackageStates packageStates2;
            PackageStates packageStates3;
            PackageStates packageStates4 = packageStates3;
            ENABLED = new PackageStates();
            PackageStates packageStates5 = packageStates2;
            DISABLED = new PackageStates();
            PackageStates packageStates6 = packageStates;
            NOT_INSTALLED = new PackageStates();
            a = new PackageStates[]{packageStates4, packageStates5, packageStates6};
        }
    }
}

