/*
 * Decompiled with CFR 0.152.
 */
package com.hihonor.push.sdk.tasks.task;

import android.content.Context;
import com.hihonor.push.framework.aidl.IMessageEntity;
import com.hihonor.push.framework.aidl.entity.RequestHeader;
import com.hihonor.push.sdk.common.data.ApiException;
import com.hihonor.push.sdk.tasks.task.DeletePushTokenTask;
import com.hihonor.push.sdk.tasks.task.GetPushTokenTask;
import com.hihonor.push.sdk.utils.HonorChecker;
import com.hihonor.push.sdk.utils.HonorIdUtils;

public class HonorTaskHelper {
    public static GetPushTokenTask buildPushTokenTask(Context context, IMessageEntity iMessageEntity) throws ApiException {
        GetPushTokenTask getPushTokenTask = new GetPushTokenTask(context, "up_msg_request_push_token", iMessageEntity);
        getPushTokenTask.setRequestHeader(HonorTaskHelper.buildRequestHeader(context, false));
        return getPushTokenTask;
    }

    public static DeletePushTokenTask getDeletePushToken(Context context, IMessageEntity iMessageEntity) throws ApiException {
        DeletePushTokenTask deletePushTokenTask = new DeletePushTokenTask(context, "up_msg_unregister_push_token", iMessageEntity);
        deletePushTokenTask.setRequestHeader(HonorTaskHelper.buildRequestHeader(context, true));
        return deletePushTokenTask;
    }

    public static RequestHeader buildRequestHeader(Context context, boolean bl) throws ApiException {
        RequestHeader requestHeader;
        Context context2 = context;
        String string = HonorChecker.checkPushAppId(context2);
        String string2 = HonorChecker.checkPushCertFingerprint(context2);
        String string3 = "";
        if (bl) {
            string3 = HonorChecker.checkPushToken(context);
        }
        RequestHeader requestHeader2 = requestHeader;
        requestHeader2();
        requestHeader2.setPackageName(context.getPackageName());
        requestHeader2.setAppId(string);
        requestHeader2.setCertificateFingerprint(string2);
        requestHeader2.setPushToken(string3);
        requestHeader.setAAID(HonorIdUtils.getAAID(context));
        requestHeader.setSdkVersion(60003102);
        return requestHeader;
    }

    public static ApiException toCastBaseException(Exception exception) {
        ApiException apiException;
        if (exception.getCause() instanceof ApiException) {
            apiException = (ApiException)exception.getCause();
        } else if (exception instanceof ApiException) {
            apiException = (ApiException)exception;
        } else {
            ApiException apiException2;
            apiException = apiException2;
            apiException2 = new ApiException(-1, exception.getMessage());
        }
        return apiException;
    }
}

