/*
 * Decompiled with CFR 0.152.
 */
package com.hihonor.push.sdk.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import com.hihonor.push.sdk.common.logger.Logger;
import java.security.MessageDigest;
import java.util.Locale;
import java.util.UUID;

public class ConfigUtils {
    private static final String PUSH_KEY = "com.hihonor.push.api_key";
    private static final String PUSH_ID = "com.hihonor.push.app_id";
    private static final String PUSH_VERSION = "com.hihonor.push.sdk_version";
    private static final String PUSH_AUTO_INIT = "com.hihonor.push.init_enabled";

    public static String getRandomUUID() {
        String string = UUID.randomUUID().toString().replace("-", "");
        Logger.d("getRandomUUID UUID =" + string);
        return string;
    }

    public static String getPushAppId(Context object) {
        block3: {
            object = object.getPackageManager().getApplicationInfo((String)object.getPackageName(), (int)128).metaData.get(PUSH_ID);
            if (object == null) break block3;
            try {
                object = String.valueOf(object);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                nameNotFoundException.printStackTrace();
                object = null;
            }
        }
        object = null;
        return object;
    }

    public static String getPushApiKey(Context object) {
        block3: {
            object = object.getPackageManager().getApplicationInfo((String)object.getPackageName(), (int)128).metaData.get(PUSH_KEY);
            if (object == null) break block3;
            try {
                object = String.valueOf(object);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                nameNotFoundException.printStackTrace();
                object = null;
            }
        }
        object = null;
        return object;
    }

    public static boolean getPushAutoInitEnabled(Context context) {
        boolean bl = false;
        try {
            bl = context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)128).metaData.getBoolean(PUSH_AUTO_INIT);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
        }
        return bl;
    }

    public static String getPushSDKVersion(Context object) {
        block3: {
            object = object.getPackageManager().getApplicationInfo((String)object.getPackageName(), (int)128).metaData.get(PUSH_VERSION);
            if (object == null) break block3;
            try {
                object = String.valueOf(object);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                nameNotFoundException.printStackTrace();
                object = null;
            }
        }
        object = null;
        return object;
    }

    public static String getCertFingerprint(Context context) {
        Context context2 = context;
        return ConfigUtils.getCertFingerprint(context2, context2.getPackageName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"PackageManagerGetSignatures"})
    public static String getCertFingerprint(Context object, String charSequence) {
        String string;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        byte[] byArray = Build.VERSION.SDK_INT >= 28 ? MessageDigest.getInstance("SHA256").digest(object.getPackageManager().getPackageInfo((String)((Object)stringBuilder2), (int)0x8000000).signingInfo.getApkContentsSigners()[0].toByteArray()) : MessageDigest.getInstance("SHA256").digest(object.getPackageManager().getPackageInfo((String)((Object)stringBuilder2), (int)64).signatures[0].toByteArray());
        byte[] byArray2 = byArray;
        stringBuilder2 = stringBuilder;
        try {
            stringBuilder = new StringBuilder();
            int n2 = byArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                string = Integer.toHexString(byArray[i2] & 0xFF).toUpperCase(Locale.US);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        {
            if (string.length() == 1) {
                stringBuilder2.append("0");
            }
            stringBuilder2.append(string);
            continue;
        }
        return stringBuilder2.toString();
    }
}

