/*
 * Decompiled with CFR 0.152.
 */
package com.hihonor.push.sdk.utils;

import android.content.Context;
import android.os.Looper;
import android.text.TextUtils;
import com.hihonor.push.sdk.common.data.ApiException;
import com.hihonor.push.sdk.common.data.ErrorEnum;
import com.hihonor.push.sdk.common.logger.Logger;
import com.hihonor.push.sdk.utils.ConfigUtils;
import com.hihonor.push.sdk.utils.HonorIdUtils;

public class HonorChecker {
    public static void checkNotRunInMainThread() throws ApiException {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            return;
        }
        throw ErrorEnum.ERROR_MAIN_THREAD.toApiException();
    }

    public static String checkPushAppId(Context object) throws ApiException {
        if (!TextUtils.isEmpty((CharSequence)(object = ConfigUtils.getPushAppId(object)))) {
            Logger.d("checkPushAppId Parameter is ".concat(String.valueOf(object)));
            return object;
        }
        Logger.e("checkPushConfig Parameter is missing");
        throw ErrorEnum.ERROR_NO_APPID.toApiException();
    }

    public static String checkPushCertFingerprint(Context object) throws ApiException {
        if (!TextUtils.isEmpty((CharSequence)(object = ConfigUtils.getCertFingerprint(object)))) {
            Logger.d("checkPushCertFingerprint Parameter is ".concat(String.valueOf(object)));
            return object;
        }
        Logger.e("checkPushConfig Parameter is missing.");
        throw ErrorEnum.ERROR_CERT_FINGERPRINT_EMPTY.toApiException();
    }

    public static String checkPushToken(Context object) throws ApiException {
        if (!TextUtils.isEmpty((CharSequence)(object = HonorIdUtils.getPushToken(object)))) {
            Logger.d("checkPushToken Parameter is ".concat(String.valueOf(object)));
            return object;
        }
        Logger.e("checkPushToken Parameter is missing.");
        throw ErrorEnum.ERROR_NO_TOKEN.toApiException();
    }
}

