/*
 * Decompiled with CFR 0.152.
 */
package com.hihonor.push.sdk.utils;

import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import java.util.HashMap;
import java.util.Map;

public class PushPreferences {
    public SharedPreferences mSharePreferences;

    public PushPreferences(Context context, String string) {
        if (context != null) {
            Context context2;
            if (Build.VERSION.SDK_INT >= 24) {
                context2 = context.createDeviceProtectedStorageContext();
                SharedPreferences sharedPreferences = context2.getSharedPreferences("move_to_de_records", 0);
                if (!sharedPreferences.getBoolean(string, false) && context2.moveSharedPreferencesFrom(context, string)) {
                    SharedPreferences.Editor editor = sharedPreferences.edit();
                    editor.putBoolean(string, true);
                    editor.apply();
                }
            } else {
                context2 = context;
            }
            this.mSharePreferences = context2.getSharedPreferences(string, 0);
            return;
        }
        throw new NullPointerException("context is null!");
    }

    public boolean clear() {
        PushPreferences pushPreferences = pushPreferences.mSharePreferences;
        if (pushPreferences != null) {
            return pushPreferences.edit().clear().commit();
        }
        return false;
    }

    public boolean containsKey(String string) {
        PushPreferences pushPreferences = pushPreferences.mSharePreferences;
        return pushPreferences != null && pushPreferences.contains(string);
    }

    public Map<String, ?> getAll() {
        PushPreferences pushPreferences = pushPreferences.mSharePreferences;
        if (pushPreferences != null) {
            return pushPreferences.getAll();
        }
        return new HashMap();
    }

    public boolean getBoolean(String string) {
        PushPreferences pushPreferences = pushPreferences.mSharePreferences;
        return pushPreferences != null && pushPreferences.getBoolean(string, false);
    }

    public int getInt(String string) {
        PushPreferences pushPreferences = pushPreferences.mSharePreferences;
        if (pushPreferences != null) {
            return pushPreferences.getInt(string, 0);
        }
        return 0;
    }

    public long getLong(String string) {
        PushPreferences pushPreferences = pushPreferences.mSharePreferences;
        if (pushPreferences != null) {
            return pushPreferences.getLong(string, 0L);
        }
        return 0L;
    }

    public String getString(String string) {
        PushPreferences pushPreferences = pushPreferences.mSharePreferences;
        if (pushPreferences != null) {
            return pushPreferences.getString(string, "");
        }
        return "";
    }

    public ContentValues read() {
        Object object = ((PushPreferences)object).mSharePreferences;
        if (object != null && (object = object.getAll()) != null) {
            ContentValues contentValues;
            Object object2 = object;
            object = contentValues;
            contentValues = new ContentValues();
            for (Map.Entry entry : object2.entrySet()) {
                String string = (String)entry.getKey();
                Object v2 = entry.getValue();
                if (v2 instanceof String) {
                    object.put(string, String.valueOf(v2));
                    continue;
                }
                if (!(v2 instanceof Integer || v2 instanceof Short || v2 instanceof Byte)) {
                    if (v2 instanceof Long) {
                        object.put(string, (Long)v2);
                        continue;
                    }
                    if (v2 instanceof Float) {
                        object.put(string, (Float)v2);
                        continue;
                    }
                    if (v2 instanceof Double) {
                        object.put(string, (Double)v2);
                        continue;
                    }
                    if (!(v2 instanceof Boolean)) continue;
                    object.put(string, (Boolean)v2);
                    continue;
                }
                object.put(string, (Integer)v2);
            }
            return object;
        }
        return null;
    }

    public boolean removeKey(String string) {
        SharedPreferences sharedPreferences = this.mSharePreferences;
        if (sharedPreferences != null && sharedPreferences.contains(string) && (this = this.mSharePreferences.edit()) != null) {
            return this.remove(string).commit();
        }
        return false;
    }

    public boolean save(String string, Object object) {
        PushPreferences pushPreferences = pushPreferences.mSharePreferences.edit();
        if (object instanceof String) {
            pushPreferences.putString(string, String.valueOf(object));
        } else if (object instanceof Integer) {
            pushPreferences.putInt(string, (Integer)object);
        } else if (object instanceof Short) {
            pushPreferences.putInt(string, ((Short)object).shortValue());
        } else if (object instanceof Byte) {
            pushPreferences.putInt(string, ((Byte)object).byteValue());
        } else if (object instanceof Long) {
            pushPreferences.putLong(string, (Long)object);
        } else if (object instanceof Float) {
            pushPreferences.putFloat(string, ((Float)object).floatValue());
        } else if (object instanceof Double) {
            pushPreferences.putFloat(string, ((Float)object).floatValue());
        } else if (object instanceof Boolean) {
            pushPreferences.putBoolean(string, (Boolean)object);
        }
        return pushPreferences.commit();
    }

    public boolean saveBoolean(String string, boolean bl) {
        PushPreferences pushPreferences = pushPreferences.mSharePreferences;
        if (pushPreferences != null && (pushPreferences = pushPreferences.edit()) != null) {
            return pushPreferences.putBoolean(string, bl).commit();
        }
        return false;
    }

    public boolean saveInt(String string, Integer n2) {
        PushPreferences pushPreferences = pushPreferences.mSharePreferences;
        if (pushPreferences != null && (pushPreferences = pushPreferences.edit()) != null) {
            return pushPreferences.putInt(string, n2).commit();
        }
        return false;
    }

    public boolean saveLong(String string, Long l2) {
        PushPreferences pushPreferences = pushPreferences.mSharePreferences;
        if (pushPreferences != null && (pushPreferences = pushPreferences.edit()) != null) {
            return pushPreferences.putLong(string, l2).commit();
        }
        return false;
    }

    public void saveMap(Map<String, Object> object) {
        for (Map.Entry entry : object.entrySet()) {
            String string = (String)entry.getKey();
            this.save(string, entry.getValue());
        }
    }

    public boolean saveString(String string, String string2) {
        PushPreferences pushPreferences = pushPreferences.mSharePreferences;
        if (pushPreferences != null && (pushPreferences = pushPreferences.edit()) != null) {
            return pushPreferences.putString(string, string2).commit();
        }
        return false;
    }

    public boolean write(ContentValues contentValues) {
        if (this.mSharePreferences != null && contentValues != null) {
            boolean bl = true;
            for (Map.Entry entry : contentValues.valueSet()) {
                String string = (String)entry.getKey();
                if (this.save(string, entry.getValue())) continue;
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public boolean removeKey(String[] stringArray) {
        if (this.mSharePreferences == null) {
            return false;
        }
        for (String string : stringArray) {
            if (!this.mSharePreferences.contains(string)) continue;
            return this.mSharePreferences.edit().remove(string).commit();
        }
        return true;
    }
}

