/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.android.hms.tpns;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;

public class CommonWorkingThread {
    private static final String TAG = "CommonWorkingThread";
    private static HandlerThread thread = null;
    private static Handler handler = null;

    private CommonWorkingThread() {
    }

    public static CommonWorkingThread getInstance() {
        CommonWorkingThread.initHandler();
        return CommonWorkingThreadHolder.instance;
    }

    public boolean execute(Runnable r) {
        if (handler != null) {
            return handler.post(r);
        }
        return false;
    }

    private static void initHandler() {
        try {
            if (thread == null || !thread.isAlive() || thread.isInterrupted() || thread.getState() == Thread.State.TERMINATED) {
                thread = new HandlerThread("tpns.baseapi.thread");
                thread.start();
                Looper looper = thread.getLooper();
                if (looper != null) {
                    handler = new Handler(looper);
                } else {
                    Log.e((String)TAG, (String)">>> Create new working thread false, cause thread.getLooper()==null");
                }
            }
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)"unexpected for initHandler", (Throwable)e);
        }
    }

    public static class CommonWorkingThreadHolder {
        public static CommonWorkingThread instance = new CommonWorkingThread();
    }
}

