/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.android.hms.tpns;

import android.content.Intent;
import android.content.SharedPreferences;
import android.util.Log;
import com.huawei.android.hms.tpns.CommonWorkingThread;
import com.huawei.hms.push.HmsMessageService;
import com.huawei.hms.push.RemoteMessage;
import java.io.Serializable;
import java.security.MessageDigest;

public class HWHmsMessageService
extends HmsMessageService {
    private static String token;

    public void onNewToken(final String s) {
        super.onNewToken(s);
        Log.i((String)"TPush", (String)("[XG_HWPUSH_V3] otherpush huawei register onNewToken: " + s));
        CommonWorkingThread.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                if (s != null && s.length() != 0) {
                    try {
                        SharedPreferences sp = HWHmsMessageService.this.getApplicationContext().getSharedPreferences("tpush.vip.shareprefs", 0);
                        if (null == token || token.length() <= 0) {
                            token = sp.getString(HWHmsMessageService.md5("huawei_token"), "");
                        }
                        if (!s.equals(token)) {
                            token = s;
                            SharedPreferences.Editor editor = sp.edit();
                            editor.putString(HWHmsMessageService.md5("huawei_token"), s);
                            editor.apply();
                        }
                    }
                    catch (Throwable e) {
                        Log.e((String)"TPush", (String)("[XG_HWPUSH_V3] otherpush huawei save newToken error: " + e.getMessage()));
                    }
                }
                String action = "com.tencent.android.tpush.action.FEEDBACK";
                try {
                    Class.forName("com.tencent.android.tpush.service.XGVipPushService");
                    action = "com.tencent.android.xg.vip.action.FEEDBACK";
                }
                catch (ClassNotFoundException e) {
                    Log.w((String)"TPush", (String)("[XG_HWPUSH_V3] onNewToken:" + e.getMessage()));
                }
                try {
                    Intent i = new Intent(action);
                    i.putExtra("TPUSH.ERRORCODE", s != null ? 0 : -1);
                    i.putExtra("other_push_token", s);
                    i.putExtra("TPUSH.FEEDBACK", 1);
                    i.putExtra("PUSH.CHANNEL", 102);
                    i.setPackage(HWHmsMessageService.this.getApplicationContext().getPackageName());
                    HWHmsMessageService.this.getApplicationContext().sendBroadcast(i);
                }
                catch (Throwable e) {
                    Log.w((String)"TPush", (String)("[XG_HWPUSH_V3] onNewToken:" + e.getMessage()));
                }
            }
        });
    }

    public void onMessageReceived(RemoteMessage remoteMessage) {
        super.onMessageReceived(remoteMessage);
        Log.w((String)"TPush", (String)("[XG_HWPUSH_V3] On messageReceived: " + remoteMessage.getMessageId() + ", " + remoteMessage.getMessageType()));
        String action = "com.tencent.android.tpush.action.PUSH_MESSAGE";
        try {
            Class.forName("com.tencent.android.tpush.service.XGVipPushService");
            action = "com.tencent.android.xg.vip.action.PUSH_MESSAGE";
        }
        catch (ClassNotFoundException e) {
            Log.w((String)"TPush", (String)("[XG_HWPUSH_V3] onMessageReceived:" + e.getMessage()));
        }
        try {
            if (remoteMessage.getData().length() > 0) {
                String content = remoteMessage.getData();
                Log.i((String)"TPush", (String)("[XG_HWPUSH_V3] Message data payload: " + content));
                Intent i = new Intent(action);
                i.putExtra("PUSH.CHANNEL", 102);
                i.putExtra("content", content);
                i.putExtra("custom_content", "");
                i.putExtra("type", (Serializable)Long.valueOf(2L));
                i.setPackage(this.getPackageName());
                this.sendBroadcast(i);
            }
            if (remoteMessage.getNotification() != null) {
                Log.d((String)"TPush", (String)("[XG_HWPUSH_V3] Message Notification Body: " + remoteMessage.getNotification().getBody()));
            }
        }
        catch (Throwable e) {
            Log.e((String)"TPush", (String)("[XG_HWPUSH_V3] onMessageReceived:" + e.getMessage()));
        }
    }

    private static String md5(String seed) {
        if (null == seed) {
            return "";
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(seed.getBytes());
            byte[] arrayOfByte = digest.digest();
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < arrayOfByte.length; ++i) {
                int j = 0xFF & arrayOfByte[i];
                if (j < 16) {
                    buffer.append("0");
                }
                buffer.append(Integer.toHexString(j));
            }
            return buffer.toString();
        }
        catch (Throwable ex) {
            Log.e((String)"TPush", (String)("[XG_HWPUSH_V3] md5:" + ex.getMessage()));
            return "";
        }
    }
}

