/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.util;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Environment;
import android.os.PowerManager;
import android.os.Process;
import android.text.TextUtils;
import com.meizu.cloud.pushsdk.b.a;
import com.meizu.cloud.pushsdk.b.b.d;
import com.meizu.cloud.pushsdk.b.i;
import java.io.File;
import java.util.List;
import java.util.Locale;

public class MzSystemUtils {
    private static final String TAG = "MzSystemUtils";
    private static final String PUSH_SERVICE_PROCESS_NAME = "mzservice_v1";
    private static int flymeVersion = -1;
    private static String sCharacteristics;

    private static String getServicesByPackageName(Context context, String string) {
        PackageManager packageManager = context.getPackageManager();
        ServiceInfo[] serviceInfoArray = null;
        try {
            serviceInfoArray = packageManager.getPackageInfo((String)string, (int)4).services;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (serviceInfoArray == null) {
            return null;
        }
        for (ServiceInfo serviceInfo : serviceInfoArray) {
            if (!"com.meizu.cloud.pushsdk.pushservice.MzPushService".equals(serviceInfo.name)) continue;
            return serviceInfo.processName;
        }
        return null;
    }

    public static String getMzPushServicePackageName(Context context) {
        String string = context.getPackageName();
        try {
            String string2 = MzSystemUtils.isWatch() ? "com.meizu.wearable.cloud" : "com.meizu.cloud";
            String string3 = MzSystemUtils.getServicesByPackageName(context, string2);
            if (!TextUtils.isEmpty((CharSequence)string3) && string3.contains(PUSH_SERVICE_PROCESS_NAME)) {
                string = string2;
                return string;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        com.meizu.cloud.a.a.a(TAG, "start service package name " + string);
        return string;
    }

    public static String getAppVersionName(Context context, String string) {
        String string2;
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(string, 0);
            string2 = packageInfo.versionName;
            if (string2 == null || string2.length() <= 0) {
                return "";
            }
        }
        catch (Exception exception) {
            com.meizu.cloud.a.a.c(TAG, "Exception message " + exception.getMessage());
            return "";
        }
        return string2;
    }

    public static boolean compareVersion(String string, String string2) {
        String[] stringArray = string.split("\\.");
        String[] stringArray2 = string2.split("\\.");
        int n2 = Math.min(stringArray.length, stringArray2.length);
        int n3 = 0;
        for (int i2 = 0; i2 < n2 && (n3 = stringArray[i2].length() - stringArray2[i2].length()) == 0 && (n3 = stringArray[i2].compareTo(stringArray2[i2])) == 0; ++i2) {
        }
        n3 = n3 != 0 ? n3 : stringArray.length - stringArray2.length;
        return n3 >= 0;
    }

    public static void sendMessageFromBroadcast(Context context, Intent intent, String string, String string2) {
        String string3;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            intent.setAction(string);
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            intent.setPackage(string2);
        }
        if (!TextUtils.isEmpty((CharSequence)(string3 = MzSystemUtils.findReceiver(context, string, string2)))) {
            intent.setClassName(string2, string3);
        }
        context.sendBroadcast(intent);
    }

    public static String findReceiver(Context context, String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        try {
            Intent intent = new Intent(string);
            intent.setPackage(string2);
            List list = context.getPackageManager().queryBroadcastReceivers(intent, 0);
            if (list != null && list.size() > 0) {
                return ((ResolveInfo)list.get((int)0)).activityInfo.name;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static boolean isBrandMeizu(Context context) {
        boolean bl;
        boolean bl2 = bl = !TextUtils.isEmpty((CharSequence)i.a("ro.meizu.product.model")) || !TextUtils.isEmpty((CharSequence)i.a("ro.vendor.meizu.product.model")) || "meizu".equalsIgnoreCase(Build.BRAND) || "\u9b45\u84dd".equalsIgnoreCase(Build.BRAND) || "22c4185e".equalsIgnoreCase(Build.BRAND);
        if (!bl) {
            com.meizu.cloud.pushsdk.a.a.b(context.getApplicationContext());
        }
        return bl;
    }

    public static boolean isMeizu(Context context) {
        return MzSystemUtils.isBrandMeizu(context);
    }

    public static boolean isWatch() {
        if (TextUtils.isEmpty((CharSequence)sCharacteristics)) {
            sCharacteristics = i.a("ro.build.characteristics");
        }
        if (TextUtils.isEmpty((CharSequence)sCharacteristics)) {
            sCharacteristics = "phone";
            return false;
        }
        return sCharacteristics.contains("watch");
    }

    public static boolean isHuaWei() {
        String string = i.a("ro.build.version.emui");
        com.meizu.cloud.a.a.c(TAG, "huawei eui " + string);
        return !TextUtils.isEmpty((CharSequence)string);
    }

    public static boolean isXiaoMi() {
        return "Xiaomi".equals(Build.MODEL) || "Xiaomi".equals(Build.MANUFACTURER);
    }

    public static boolean isOverseas() {
        return MzSystemUtils.isInternational() || MzSystemUtils.isIndiaLocal();
    }

    public static boolean isInternational() {
        return a.a().a ? (Boolean)a.a().b : false;
    }

    public static boolean isIndiaLocal() {
        String string = i.a("ro.meizu.locale.region");
        return "india".equals(string);
    }

    public static boolean isMeizuAndFlyme() {
        d<Boolean> d2 = a.b();
        if (d2.a) {
            return (Boolean)d2.b == false;
        }
        return false;
    }

    public static String getNetWorkType(Context context) {
        String string = "";
        try {
            NetworkInfo networkInfo;
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo2 = networkInfo = connectivityManager != null ? connectivityManager.getActiveNetworkInfo() : null;
            if (networkInfo != null) {
                int n2 = networkInfo.getType();
                block1 : switch (n2) {
                    case 1: {
                        string = "WIFI";
                        break;
                    }
                    case 9: {
                        string = "ETHERNET";
                        break;
                    }
                    case 7: {
                        string = "BLUETOOTH";
                        break;
                    }
                    case 0: {
                        switch (networkInfo.getSubtype()) {
                            case 1: 
                            case 2: 
                            case 4: 
                            case 7: 
                            case 11: {
                                string = "MOBILE_2G";
                                break block1;
                            }
                            case 3: 
                            case 5: 
                            case 6: 
                            case 8: 
                            case 9: 
                            case 10: 
                            case 12: 
                            case 14: 
                            case 15: {
                                string = "MOBILE_3G";
                                break block1;
                            }
                            case 13: 
                            case 18: {
                                string = "MOBILE_4G";
                                break block1;
                            }
                            case 20: {
                                return "MOBILE_5G";
                            }
                        }
                        string = "MOBILE_XG";
                        break;
                    }
                    default: {
                        string = "OTHER";
                    }
                }
            }
        }
        catch (Exception exception) {
            com.meizu.cloud.a.a.c(TAG, "Security exception checking connection: " + exception.getMessage());
        }
        return string;
    }

    public static String getCurrentLanguage() {
        try {
            return Locale.getDefault().getLanguage();
        }
        catch (Exception exception) {
            com.meizu.cloud.a.a.c(TAG, "getCurrentLanguage error " + exception.getMessage());
            return null;
        }
    }

    public static String getAppVersionName(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionName;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static int getAppVersionCode(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionCode;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static boolean isPackageInstalled(Context context, String string) {
        try {
            context.getPackageManager().getPackageInfo(string, 0);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isRunningProcess(Context context, String string) {
        boolean bl = false;
        try {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            if (activityManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                bl = runningAppProcessInfo.processName.contains(string);
                if (!bl) continue;
                break;
            }
            com.meizu.cloud.a.a.a(TAG, string + " is running " + bl);
        }
        catch (Exception exception) {
            com.meizu.cloud.a.a.c(TAG, "can not get running process info so set running true");
            bl = true;
        }
        return bl;
    }

    public static String getProcessName(Context context) {
        try {
            int n2 = Process.myPid();
            String string = "";
            ActivityManager activityManager = (ActivityManager)context.getApplicationContext().getSystemService("activity");
            if (activityManager == null) {
                return null;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : activityManager.getRunningAppProcesses()) {
                com.meizu.cloud.a.a.a(TAG, "processName " + runningAppProcessInfo.processName);
                if (runningAppProcessInfo.pid != n2) continue;
                string = runningAppProcessInfo.processName;
                break;
            }
            return string;
        }
        catch (Exception exception) {
            com.meizu.cloud.a.a.c(TAG, "getProcessName error " + exception.getMessage());
            return null;
        }
    }

    public static boolean isExistReceiver(Context context, String string, String string2) {
        String string3;
        if (TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        boolean bl = false;
        Intent intent = new Intent(string2);
        intent.setPackage(string);
        List list = context.getPackageManager().queryBroadcastReceivers(intent, 0);
        if (list != null && list.size() > 0 && !TextUtils.isEmpty((CharSequence)(string3 = ((ResolveInfo)list.get((int)0)).activityInfo.name))) {
            bl = true;
        }
        return bl;
    }

    public static boolean isInteractive(Context context) {
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        if (powerManager == null) {
            return true;
        }
        try {
            return Build.VERSION.SDK_INT >= 20 ? powerManager.isInteractive() : powerManager.isScreenOn();
        }
        catch (Exception exception) {
            com.meizu.cloud.a.a.c(TAG, "isScreenOn error " + exception.getMessage());
            return true;
        }
    }

    public static String getDocumentsPath(Context context) {
        File file = context.getExternalFilesDir(Build.VERSION.SDK_INT >= 19 ? Environment.DIRECTORY_DOCUMENTS : "Documents");
        if (file != null) {
            return file.getPath();
        }
        return "/storage/emulated/0/Android/data/" + context.getPackageName() + "/files/Documents";
    }

    public static int getFlymeVersion() {
        if (flymeVersion > 0) {
            return flymeVersion;
        }
        try {
            String string = i.a("ro.build.flyme.version");
            try {
                flymeVersion = Integer.parseInt(string);
                return flymeVersion;
            }
            catch (Exception exception) {
                string = i.a("ro.flyme.version.id");
                if (TextUtils.isEmpty((CharSequence)string)) {
                    string = i.a("ro.build.display.id");
                }
                string = string.replace("Flyme", "").replace(" ", "");
                String string2 = string.substring(0, 1);
                flymeVersion = Integer.valueOf(string2);
                return flymeVersion;
            }
        }
        catch (Exception exception) {
            com.meizu.cloud.a.a.c(TAG, "getFlymeVersion error " + exception.getMessage());
            return -1;
        }
    }
}

