/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.android.mipush;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.util.Log;
import com.tencent.android.mipush.a;
import com.xiaomi.mipush.sdk.MiPushCommandMessage;
import com.xiaomi.mipush.sdk.MiPushMessage;
import com.xiaomi.mipush.sdk.PushMessageReceiver;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.List;
import org.json.JSONObject;

public class XMPushMessageReceiver
extends PushMessageReceiver {
    private static String errMsg = null;

    @Override
    public void onReceivePassThroughMessage(Context context, MiPushMessage miPushMessage) {
        Intent intent;
        String string = "com.tencent.android.tpush.action.PUSH_MESSAGE";
        try {
            intent = Class.forName("com.tencent.android.tpush.service.XGVipPushService");
            string = "com.tencent.android.xg.vip.action.PUSH_MESSAGE";
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.w((String)"TPush", (String)"[OtherPush_XG_MI] find XGVipPushService error");
        }
        try {
            Log.i((String)"TPush", (String)("[OtherPush_XG_MI] onReceivePassThroughMessage->  Title: " + miPushMessage.getTitle() + " Content: " + miPushMessage.getContent() + "description :" + miPushMessage.getDescription()));
            intent = new Intent(string);
            intent.putExtra("PUSH.CHANNEL", 103);
            intent.putExtra("pushChannel", 103);
            intent.putExtra("content", miPushMessage.getContent());
            intent.putExtra("title", miPushMessage.getTitle());
            intent.putExtra("type", (Serializable)Long.valueOf(2L));
            if (miPushMessage.getExtra() != null) {
                String string2;
                JSONObject jSONObject = new JSONObject(miPushMessage.getExtra());
                intent.putExtra("custom_content", jSONObject.toString());
                if (miPushMessage.getExtra().containsKey("msgId") && (string2 = miPushMessage.getExtra().get("msgId")) != null) {
                    intent.putExtra("msgId", (Serializable)Long.valueOf(string2));
                }
                if (miPushMessage.getExtra().containsKey("busiMsgId") && (string2 = miPushMessage.getExtra().get("busiMsgId")) != null) {
                    intent.putExtra("busiMsgId", (Serializable)Long.valueOf(string2));
                }
            } else {
                intent.putExtra("custom_content", "");
            }
            intent.putExtra("timestamps", System.currentTimeMillis() / 1000L);
            intent.setPackage(context.getPackageName());
            context.sendBroadcast(intent);
        }
        catch (Throwable throwable) {
            Log.e((String)"TPush", (String)"[OtherPush_XG_MI] onReceivePassThroughMessage ", (Throwable)throwable);
        }
    }

    @Override
    public void onNotificationMessageClicked(Context context, MiPushMessage miPushMessage) {
    }

    @Override
    public void onNotificationMessageArrived(Context context, MiPushMessage miPushMessage) {
        Intent intent;
        String string = "com.tencent.android.tpush.action.FEEDBACK";
        try {
            intent = Class.forName("com.tencent.android.tpush.service.XGVipPushService");
            string = "com.tencent.android.xg.vip.action.FEEDBACK";
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.w((String)"TPush", (String)"[OtherPush_XG_MI] find XGVipPushService error");
        }
        try {
            Log.i((String)"TPush", (String)("[OtherPush_XG_MI] onNotificationMessageArrived->  Title: " + miPushMessage.getTitle() + " Content: " + miPushMessage.getContent() + " Extra = " + miPushMessage.getExtra().toString() + "description :" + miPushMessage.getDescription()));
            intent = new Intent(string);
            intent.putExtra("TPUSH.FEEDBACK", 5);
            intent.putExtra("pushChannel", 103);
            intent.putExtra("PUSH.CHANNEL", 103);
            intent.putExtra("content", miPushMessage.getDescription());
            intent.putExtra("title", miPushMessage.getTitle());
            intent.putExtra("type", (Serializable)Long.valueOf(1L));
            if (miPushMessage.getExtra() != null) {
                String string2;
                JSONObject jSONObject = new JSONObject(miPushMessage.getExtra());
                intent.putExtra("custom_content", jSONObject.toString());
                if (miPushMessage.getExtra().containsKey("msgId") && (string2 = miPushMessage.getExtra().get("msgId")) != null) {
                    intent.putExtra("msgId", (Serializable)Long.valueOf(string2));
                }
                if (miPushMessage.getExtra().containsKey("busiMsgId") && (string2 = miPushMessage.getExtra().get("busiMsgId")) != null) {
                    intent.putExtra("busiMsgId", (Serializable)Long.valueOf(string2));
                }
                if (miPushMessage.getExtra().containsKey("ts")) {
                    string2 = miPushMessage.getExtra().get("ts");
                    if (string2 != null) {
                        intent.putExtra("pushTime", (Serializable)Long.valueOf(string2));
                    } else {
                        intent.putExtra("pushTime", System.currentTimeMillis());
                    }
                } else {
                    intent.putExtra("pushTime", System.currentTimeMillis());
                }
                if (miPushMessage.getExtra().containsKey("groupId")) {
                    intent.putExtra("groupId", miPushMessage.getExtra().get("groupId"));
                }
                if (miPushMessage.getExtra().containsKey("targetType") && (string2 = miPushMessage.getExtra().get("targetType")) != null) {
                    intent.putExtra("targetType", (Serializable)Long.valueOf(string2));
                }
                if (miPushMessage.getExtra().containsKey("source") && (string2 = miPushMessage.getExtra().get("source")) != null) {
                    intent.putExtra("source", (Serializable)Long.valueOf(string2));
                }
            } else {
                intent.putExtra("custom_content", "");
            }
            intent.putExtra("timestamps", System.currentTimeMillis() / 1000L);
            intent.setPackage(context.getPackageName());
            context.sendBroadcast(intent);
        }
        catch (Throwable throwable) {
            Log.e((String)"TPush", (String)"[OtherPush_XG_MI] onNotificationMessageArrived ", (Throwable)throwable);
        }
    }

    @Override
    public void onCommandResult(final Context context, final MiPushCommandMessage miPushCommandMessage) {
        a.a().a(new Runnable(){

            @Override
            public void run() {
                Object object;
                String string = "com.tencent.android.tpush.action.FEEDBACK";
                try {
                    object = Class.forName("com.tencent.android.tpush.service.XGVipPushService");
                    string = "com.tencent.android.xg.vip.action.FEEDBACK";
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Log.w((String)"TPush", (String)"[OtherPush_XG_MI] find XGVipPushService error");
                }
                try {
                    String string2;
                    object = "";
                    Intent intent = new Intent(string);
                    String string3 = miPushCommandMessage.getCommand();
                    Log.i((String)"TPush", (String)("[OtherPush_XG_MI] onCommandResult - command: " + string3 + ", result code: " + miPushCommandMessage.getResultCode()));
                    List<String> list = miPushCommandMessage.getCommandArguments();
                    String string4 = list != null && list.size() > 0 ? list.get(0) : null;
                    String string5 = string2 = list != null && list.size() > 1 ? list.get(1) : null;
                    if ("register".equals(string3)) {
                        String string6 = "errCode : " + miPushCommandMessage.getResultCode() + ", errMsg : unknown";
                        if (miPushCommandMessage.getResultCode() == 0L) {
                            object = string4;
                            intent.putExtra("TPUSH.ERRORCODE", 0);
                            Log.i((String)"TPush", (String)("[OtherPush_XG_MI] register success\uff0c regid is \uff1a" + (String)object));
                            string6 = "errCode : 0, errMsg : success";
                        } else if (miPushCommandMessage.getResultCode() == 70000002L) {
                            intent.putExtra("TPUSH.ERRORCODE", (int)miPushCommandMessage.getResultCode());
                            Log.i((String)"TPush", (String)("[OtherPush_XG_MI] register failed\uff0c arg1: " + string4 + "arg2:" + string2 + ",code :" + miPushCommandMessage.getResultCode()));
                        } else if (miPushCommandMessage.getResultCode() == 70000004L) {
                            intent.putExtra("TPUSH.ERRORCODE", (int)miPushCommandMessage.getResultCode());
                            Log.i((String)"TPush", (String)("[OtherPush_XG_MI] register failed\uff0c arg1: " + string4 + "arg2:" + string2 + ",code :" + miPushCommandMessage.getResultCode()));
                        } else if (miPushCommandMessage.getResultCode() == 70000003L) {
                            intent.putExtra("TPUSH.ERRORCODE", (int)miPushCommandMessage.getResultCode());
                            Log.i((String)"TPush", (String)("[OtherPush_XG_MI] register failed\uff0c arg1: " + string4 + "arg2:" + string2 + ",code :" + miPushCommandMessage.getResultCode()));
                        } else if (miPushCommandMessage.getResultCode() == 70000001L) {
                            intent.putExtra("TPUSH.ERRORCODE", (int)miPushCommandMessage.getResultCode());
                            Log.i((String)"TPush", (String)("[OtherPush_XG_MI] register failed\uff0c arg1: " + string4 + "arg2:" + string2 + ",code :" + miPushCommandMessage.getResultCode()));
                        } else {
                            intent.putExtra("TPUSH.ERRORCODE", (int)miPushCommandMessage.getResultCode());
                            Log.w((String)"TPush", (String)("[OtherPush_XG_MI] register failed, errorCode: " + miPushCommandMessage.getResultCode() + ", reason: " + miPushCommandMessage.getReason()));
                        }
                        try {
                            SharedPreferences sharedPreferences = context.getApplicationContext().getSharedPreferences("tpush.vip.shareprefs", 0);
                            if (null == errMsg || errMsg.length() <= 0) {
                                try {
                                    errMsg = sharedPreferences.getString(XMPushMessageReceiver.md5("other_push_error_code"), "");
                                }
                                catch (Throwable throwable) {
                                    Log.d((String)"TPush", (String)("[OtherPush_XG_MI] onCommandResult read returnMsg from sp error: " + throwable.getMessage()));
                                }
                            }
                            if (string6 != null && !string6.equals(errMsg)) {
                                errMsg = string6;
                                SharedPreferences.Editor editor = sharedPreferences.edit();
                                editor.putString(XMPushMessageReceiver.md5("other_push_error_code"), errMsg);
                                editor.apply();
                            }
                        }
                        catch (Throwable throwable) {
                            Log.w((String)"TPush", (String)("[OtherPush_XG_MI] onCommandResult save result errMsg error: " + throwable.getMessage()));
                        }
                    } else if ("set-alias".equals(string3) ? miPushCommandMessage.getResultCode() == 0L : ("unset-alias".equals(string3) ? miPushCommandMessage.getResultCode() == 0L : ("subscribe-topic".equals(string3) ? miPushCommandMessage.getResultCode() == 0L : ("unsubscibe-topic".equals(string3) ? miPushCommandMessage.getResultCode() == 0L : !"accept-time".equals(string3) || miPushCommandMessage.getResultCode() == 0L)))) {
                        // empty if block
                    }
                    intent.putExtra("other_push_token", (String)object);
                    intent.putExtra("TPUSH.FEEDBACK", 1);
                    intent.putExtra("PUSH.CHANNEL", 103);
                    intent.putExtra("pushChannel", 103);
                    intent.setPackage(context.getPackageName());
                    context.sendBroadcast(intent);
                }
                catch (Throwable throwable) {
                    Log.w((String)"TPush", (String)"[OtherPush_XG_MI] onCommandResult ", (Throwable)throwable);
                }
            }
        });
    }

    private static String md5(String string) {
        if (null == string) {
            return "";
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(string.getBytes());
            byte[] byArray = messageDigest.digest();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                int n2 = 0xFF & byArray[i2];
                if (n2 < 16) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(Integer.toHexString(n2));
            }
            return stringBuffer.toString();
        }
        catch (Throwable throwable) {
            return "";
        }
    }
}

