/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mipush.sdk;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.ServiceInfo;
import android.text.TextUtils;
import com.xiaomi.a.a.a.c;
import com.xiaomi.mipush.sdk.Constants;
import com.xiaomi.mipush.sdk.Logger;
import com.xiaomi.mipush.sdk.MiPushCommandMessage;
import com.xiaomi.mipush.sdk.MiPushMessage;
import com.xiaomi.mipush.sdk.MiTinyDataClient;
import com.xiaomi.mipush.sdk.PushConfiguration;
import com.xiaomi.mipush.sdk.PushMessageHandler;
import com.xiaomi.mipush.sdk.PushMessageHelper;
import com.xiaomi.mipush.sdk.a;
import com.xiaomi.mipush.sdk.ae;
import com.xiaomi.mipush.sdk.af;
import com.xiaomi.mipush.sdk.ao;
import com.xiaomi.mipush.sdk.au;
import com.xiaomi.mipush.sdk.av;
import com.xiaomi.mipush.sdk.b;
import com.xiaomi.mipush.sdk.e;
import com.xiaomi.mipush.sdk.f;
import com.xiaomi.mipush.sdk.i;
import com.xiaomi.mipush.sdk.r;
import com.xiaomi.mipush.sdk.t;
import com.xiaomi.mipush.sdk.v;
import com.xiaomi.push.ac;
import com.xiaomi.push.ar;
import com.xiaomi.push.ch;
import com.xiaomi.push.cr;
import com.xiaomi.push.cs;
import com.xiaomi.push.dq;
import com.xiaomi.push.dr;
import com.xiaomi.push.ds;
import com.xiaomi.push.ec;
import com.xiaomi.push.gg;
import com.xiaomi.push.gq;
import com.xiaomi.push.gu;
import com.xiaomi.push.gv;
import com.xiaomi.push.ha;
import com.xiaomi.push.hd;
import com.xiaomi.push.he;
import com.xiaomi.push.hl;
import com.xiaomi.push.hq;
import com.xiaomi.push.hr;
import com.xiaomi.push.hv;
import com.xiaomi.push.hx;
import com.xiaomi.push.hz;
import com.xiaomi.push.ii;
import com.xiaomi.push.jc;
import com.xiaomi.push.jd;
import com.xiaomi.push.je;
import com.xiaomi.push.jj;
import com.xiaomi.push.jl;
import com.xiaomi.push.m;
import com.xiaomi.push.service.ad;
import com.xiaomi.push.service.ag;
import com.xiaomi.push.service.receivers.NetworkStatusReceiver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;

public abstract class MiPushClient {
    public static final String COMMAND_REGISTER = "register";
    public static final String COMMAND_UNREGISTER = "unregister";
    public static final String COMMAND_SET_ALIAS = "set-alias";
    public static final String COMMAND_UNSET_ALIAS = "unset-alias";
    public static final String COMMAND_SET_ACCOUNT = "set-account";
    public static final String COMMAND_UNSET_ACCOUNT = "unset-account";
    public static final String COMMAND_SUBSCRIBE_TOPIC = "subscribe-topic";
    public static final String COMMAND_UNSUBSCRIBE_TOPIC = "unsubscibe-topic";
    public static final String COMMAND_SET_ACCEPT_TIME = "accept-time";
    public static final String PREF_EXTRA = "mipush_extra";
    private static Context sContext;
    private static long sCurMsgId;

    public static boolean shouldUseMIUIPush(Context context) {
        return ao.a(context).a();
    }

    public static void registerPush(Context context, String string, String string2) {
        MiPushClient.registerPush(context, string, string2, new PushConfiguration());
    }

    public static void registerPush(Context context, String string, String string2, String string3) {
        MiPushClient.registerPush(context, string, string2, new PushConfiguration(), string3, null);
    }

    public static void registerPush(Context context, String string, String string2, PushConfiguration pushConfiguration) {
        MiPushClient.registerPush(context, string, string2, pushConfiguration, null, null);
    }

    private static void registerPush(Context context, final String string, final String string2, PushConfiguration pushConfiguration, final String string3, final ICallbackResult iCallbackResult) {
        MiPushClient.checkNotNull(context, "context");
        MiPushClient.checkNotNull(string, "appID");
        MiPushClient.checkNotNull(string2, "appToken");
        sContext = context.getApplicationContext();
        if (sContext == null) {
            sContext = context;
        }
        context = sContext;
        jl.a(context);
        if (!NetworkStatusReceiver.a()) {
            MiPushClient.registerNetworkReceiver(sContext);
        }
        f.a(sContext).a(pushConfiguration);
        m.a(context).a(new Runnable(){

            @Override
            public void run() {
                MiPushClient.initialize(sContext, string, string2, null, string3, iCallbackResult);
            }
        });
    }

    private static void registerNetworkReceiver(Context context) {
        try {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            intentFilter.addCategory("android.intent.category.DEFAULT");
            Context context2 = context.getApplicationContext();
            je.a(context2, new NetworkStatusReceiver(null), intentFilter);
            je.a(context, NetworkStatusReceiver.class);
        }
        catch (Throwable throwable) {
            c.a("dynamic register network status receiver failed:" + throwable);
        }
    }

    @Deprecated
    public static void initialize(Context context, String string, String string2, MiPushClientCallback miPushClientCallback) {
        MiPushClient.initialize(context, string, string2, miPushClientCallback, null, null);
    }

    private static void initialize(Context context, String string, String string2, MiPushClientCallback miPushClientCallback, String string3, ICallbackResult iCallbackResult) {
        try {
            boolean bl2;
            c.a(context.getApplicationContext());
            c.f("sdk_version = 4_9_1");
            ac.a(context).c();
            ch.a(context);
            if (miPushClientCallback != null) {
                PushMessageHandler.a(miPushClientCallback);
            }
            if (iCallbackResult != null) {
                PushMessageHandler.a(iCallbackResult);
            }
            if (jl.b(sContext)) {
                v.a(sContext);
            }
            boolean bl3 = bl2 = b.a(sContext).a() != Constants.a();
            if (!bl2 && !MiPushClient.shouldSendRegRequest(sContext)) {
                ao.a(sContext).a();
                c.a("Could not send  register message within 5s repeatly .");
                return;
            }
            if (!bl2 && b.a(sContext).a(string, string2) && !b.a(sContext).f()) {
                Object object;
                Cloneable cloneable;
                if (1 == PushMessageHelper.getPushMode(sContext)) {
                    MiPushClient.checkNotNull(miPushClientCallback, "callback");
                    miPushClientCallback.onInitializeResult(0L, null, b.a(sContext).c());
                } else {
                    cloneable = new ArrayList<String>();
                    cloneable.add(b.a(sContext).c());
                    object = PushMessageHelper.generateCommandMessage(ec.a.k, cloneable, 0L, null, null, null);
                    PushMessageHelper.sendCommandMessageBroadcast(sContext, (MiPushCommandMessage)object);
                }
                ao.a(sContext).a();
                if (b.a(sContext).a()) {
                    cloneable = new hq();
                    ((hq)cloneable).b(b.a(sContext).a());
                    ((hq)cloneable).c(ha.g.ah);
                    ((hq)cloneable).a(ag.a());
                    ((hq)cloneable).h = new HashMap<String, String>();
                    ((hq)cloneable).h.put("app_version", gg.a(sContext, sContext.getPackageName()));
                    ((hq)cloneable).h.put("app_version_code", Integer.toString(gg.b(sContext, sContext.getPackageName())));
                    ((hq)cloneable).h.put("push_sdk_vn", "4_9_1");
                    ((hq)cloneable).h.put("push_sdk_vc", Integer.toString(40091));
                    object = b.a(sContext).e();
                    if (!TextUtils.isEmpty((CharSequence)object)) {
                        ((hq)cloneable).h.put("deviceid", (String)object);
                    }
                    ao.a(sContext).a(cloneable, gq.i, false, null);
                }
                if (!jd.a(sContext, "update_devId", false)) {
                    MiPushClient.updateImeiOrOaid();
                    jd.b(sContext, "update_devId", true);
                }
                if (MiPushClient.shouldUseMIUIPush(sContext) && MiPushClient.shouldPullNotification(sContext)) {
                    cloneable = new hq();
                    ((hq)cloneable).b(b.a(sContext).a());
                    ((hq)cloneable).c(ha.j.ah);
                    ((hq)cloneable).a(ag.a());
                    ((hq)cloneable).a(false);
                    ao.a(sContext).a(cloneable, gq.i, false, null, false);
                    MiPushClient.addPullNotificationTime(sContext);
                }
            } else {
                int n2;
                String string4;
                String string5 = ar.a(6);
                b.a(sContext).a();
                b.a(sContext).a(Constants.a());
                b.a(sContext).a(string, string2, string5);
                MiTinyDataClient.a.a().b("com.xiaomi.xmpushsdk.tinydataPending.appId");
                MiPushClient.clearExtras(sContext);
                MiPushClient.clearNotification(context);
                hr hr2 = new hr();
                hr2.a(ag.b());
                hr2.b(string);
                hr2.e(string2);
                hr2.d(sContext.getPackageName());
                hr2.f(string5);
                hr2.c(gg.a(sContext, sContext.getPackageName()));
                hr2.b(gg.b(sContext, sContext.getPackageName()));
                hr2.h("4_9_1");
                hr2.a(40091);
                hr2.a(he.c);
                if (!TextUtils.isEmpty((CharSequence)string3)) {
                    hr2.g(string3);
                }
                if (!jc.g() && !TextUtils.isEmpty((CharSequence)(string4 = ii.e(sContext)))) {
                    hr2.i(ar.a(string4) + "," + ii.h(sContext));
                }
                if ((n2 = ii.a()) >= 0) {
                    hr2.c(n2);
                }
                ao.a(sContext).a(hr2, bl2);
                sContext.getSharedPreferences(PREF_EXTRA, 4).getBoolean("mipush_registed", true);
            }
            MiPushClient.addRegRequestTime(sContext);
            MiPushClient.scheduleOcVersionCheckJob();
            MiPushClient.scheduleDataCollectionJobs(sContext);
            MiPushClient.initEventPerfLogic(sContext);
            av.a(sContext);
            if (!sContext.getPackageName().equals("com.xiaomi.xmsf")) {
                if (Logger.getUserLogger() != null) {
                    Logger.setLogger(sContext, Logger.getUserLogger());
                }
                c.a(2);
            }
            MiPushClient.operateSyncAction(context);
        }
        catch (Throwable throwable) {
            c.a(throwable);
        }
    }

    private static void scheduleOcVersionCheckJob() {
        int n2 = ad.a(sContext).a(gv.A.a(), 86400);
        m.a(sContext).a(new ae(sContext), n2, 5);
    }

    private static void scheduleDataCollectionJobs(Context context) {
        int n2 = gv.z.a();
        if (ad.a(sContext).a(n2, MiPushClient.getDefaultSwitch())) {
            cr.a().a(new r(context));
            m.a(sContext).a(new Runnable(){

                @Override
                public void run() {
                    cs.a(sContext);
                }
            }, 10);
        }
    }

    private static boolean getDefaultSwitch() {
        return jc.b();
    }

    private static void updateImeiOrOaid() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (!jc.g() && (ii.d(sContext) != null || ac.a(sContext).a())) {
                    hq hq2 = new hq();
                    hq2.b(b.a(sContext).a());
                    hq2.c(ha.g.ah);
                    hq2.a(ag.a());
                    hq2.a(new HashMap<String, String>());
                    String string = "";
                    String string2 = ii.d(sContext);
                    if (!TextUtils.isEmpty((CharSequence)string2)) {
                        string = string + ar.a(string2);
                    }
                    String string3 = ii.f(sContext);
                    if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string3)) {
                        string = string + "," + string3;
                    }
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        hq2.k().put("imei_md5", string);
                    }
                    ac.a(sContext).a(hq2.k());
                    int n2 = ii.a();
                    if (n2 >= 0) {
                        hq2.k().put("space_id", Integer.toString(n2));
                    }
                    ao.a(sContext).a(hq2, gq.i, false, null);
                }
            }
        }).start();
    }

    public static void awakeApps(final Context context, final String[] stringArray) {
        m.a(context).a(new Runnable(){

            @Override
            public void run() {
                try {
                    for (String string : stringArray) {
                        PackageInfo packageInfo;
                        if (TextUtils.isEmpty((CharSequence)string) || (packageInfo = context.getPackageManager().getPackageInfo(string, 4)) == null) continue;
                        MiPushClient.awakePushServiceByPackageInfo(context, packageInfo);
                    }
                }
                catch (Throwable throwable) {
                    c.a(throwable);
                }
            }
        });
    }

    private static void awakePushServiceByPackageInfo(Context context, PackageInfo packageInfo) {
        ServiceInfo[] serviceInfoArray = packageInfo.services;
        if (serviceInfoArray != null) {
            for (ServiceInfo serviceInfo : serviceInfoArray) {
                if (!serviceInfo.exported || !serviceInfo.enabled || !"com.xiaomi.mipush.sdk.PushMessageHandler".equals(serviceInfo.name) || context.getPackageName().equals(serviceInfo.packageName)) continue;
                try {
                    Thread.sleep((long)(Math.random() * 2.0 + 1.0) * 1000L);
                    Intent intent = new Intent();
                    intent.setClassName(serviceInfo.packageName, serviceInfo.name);
                    intent.setAction("com.xiaomi.mipush.sdk.WAKEUP");
                    intent.putExtra("waker_pkgname", context.getPackageName());
                    PushMessageHandler.a(context, intent);
                }
                catch (Throwable throwable) {}
                break;
            }
        }
    }

    public static List<String> getAllAlias(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        Set set = sharedPreferences.getAll().keySet();
        for (String string : set) {
            if (!string.startsWith("alias_")) continue;
            arrayList.add(string.substring("alias_".length()));
        }
        return arrayList;
    }

    public static List<String> getAllTopic(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        Set set = sharedPreferences.getAll().keySet();
        for (String string : set) {
            if (!string.startsWith("topic_") || string.contains("**ALL**")) continue;
            arrayList.add(string.substring("topic_".length()));
        }
        return arrayList;
    }

    public static List<String> getAllUserAccount(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        Set set = sharedPreferences.getAll().keySet();
        for (String string : set) {
            if (!string.startsWith("account_")) continue;
            arrayList.add(string.substring("account_".length()));
        }
        return arrayList;
    }

    protected static void clearExtras(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.clear();
        editor.commit();
    }

    private static void clearExtrasForInitialize(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        List<String> list2 = MiPushClient.getAllAlias(context);
        for (String list3 : list2) {
            editor.remove("alias_" + list3);
        }
        List<String> list4 = MiPushClient.getAllUserAccount(context);
        Iterator iterator = list4.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            editor.remove("account_" + (String)string);
        }
        List<String> list = MiPushClient.getAllTopic(context);
        for (String string : list) {
            editor.remove("topic_" + string);
        }
        editor.remove("accept_time");
        editor.commit();
    }

    static void reInitialize(Context context, he he2) {
        c.f("re-register reason: " + (Object)((Object)he2));
        String string = ar.a(6);
        String string2 = b.a(context).a();
        String string3 = b.a(context).b();
        b.a(context).a();
        MiPushClient.clearExtrasForInitialize(context);
        MiPushClient.clearNotification(context);
        b.a(context).a(Constants.a());
        b.a(context).a(string2, string3, string);
        hr hr2 = new hr();
        hr2.a(ag.b());
        hr2.b(string2);
        hr2.e(string3);
        hr2.f(string);
        hr2.d(context.getPackageName());
        hr2.c(gg.a(context, context.getPackageName()));
        hr2.b(gg.b(context, context.getPackageName()));
        hr2.h("4_9_1");
        hr2.a(40091);
        hr2.a(he2);
        int n2 = ii.a();
        if (n2 >= 0) {
            hr2.c(n2);
        }
        ao.a(context).a(hr2, false);
    }

    @Deprecated
    public static void reportMessageClicked(Context context, String string) {
        MiPushClient.reportMessageClicked(context, string, null, null);
    }

    public static void reportMessageClicked(Context context, MiPushMessage miPushMessage) {
        hd hd2 = new hd();
        hd2.a(miPushMessage.getMessageId());
        hd2.b(miPushMessage.getTopic());
        hd2.d(miPushMessage.getDescription());
        hd2.c(miPushMessage.getTitle());
        hd2.c(miPushMessage.getNotifyId());
        hd2.a(miPushMessage.getNotifyType());
        hd2.b(miPushMessage.getPassThrough());
        hd2.a(miPushMessage.getExtra());
        MiPushClient.reportMessageClicked(context, miPushMessage.getMessageId(), hd2, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    static void reportMessageClicked(Context context, String string, hd hd2, String string2) {
        hq hq2 = new hq();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            if (!b.a(context).b()) {
                c.d("do not report clicked message");
                return;
            }
            hq2.b(b.a(context).a());
        } else {
            hq2.b(string2);
        }
        hq2.c("bar:click");
        hq2.a(string);
        hq2.a(false);
        ao.a(context).a(hq2, gq.i, false, hd2);
    }

    static void reportIgnoreRegMessageClicked(Context context, String string, hd hd2, String string2, String string3) {
        hq hq2 = new hq();
        if (TextUtils.isEmpty((CharSequence)string3)) {
            c.d("do not report clicked message");
            return;
        }
        hq2.b(string3);
        hq2.c("bar:click");
        hq2.a(string);
        hq2.a(false);
        ao.a(context).a(hq2, gq.i, false, true, hd2, true, string2, string3);
    }

    public static void setLocalNotificationType(Context context, int n2) {
        int n3 = n2 & 0xFFFFFFFF;
        ao.a(context).b(n3);
    }

    public static void clearLocalNotificationType(Context context) {
        ao.a(context).f();
    }

    public static void unregisterPush(Context context) {
        i.c(context);
        ad.a(context).a();
        if (!b.a(context).b()) {
            return;
        }
        hx hx2 = new hx();
        hx2.a(ag.a());
        hx2.b(b.a(context).a());
        hx2.c(b.a(context).c());
        hx2.e(b.a(context).b());
        hx2.d(context.getPackageName());
        ao.a(context).a(hx2);
        PushMessageHandler.a();
        PushMessageHandler.b();
        b.a(context).b();
        MiPushClient.clearLocalNotificationType(context);
        MiPushClient.clearNotification(context);
        MiPushClient.clearExtras(context);
    }

    public static void disablePush(Context context) {
        ao.a(context).a(true);
    }

    public static void enablePush(Context context) {
        ao.a(context).a(false);
    }

    public static void syncAssemblePushToken(Context context) {
        ao.a(context).a(null, au.c, e.a);
    }

    public static void syncAssembleFCMPushToken(Context context) {
        ao.a(context).a(null, au.d, e.b);
    }

    public static void syncAssembleCOSPushToken(Context context) {
        ao.a(context).a(null, au.e, e.c);
    }

    public static void syncAssembleFTOSPushToken(Context context) {
        ao.a(context).a(null, au.f, e.d);
    }

    public static void setAlias(Context context, String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            MiPushClient.setCommand(context, ec.c.k, string, string2);
        }
    }

    public static void unsetAlias(Context context, String string, String string2) {
        MiPushClient.setCommand(context, ec.d.k, string, string2);
    }

    public static void setUserAccount(Context context, String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            MiPushClient.setCommand(context, ec.e.k, string, string2);
        }
    }

    public static void unsetUserAccount(Context context, String string, String string2) {
        MiPushClient.setCommand(context, ec.f.k, string, string2);
    }

    public static void subscribe(Context context, String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)b.a(context).a()) || TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        if (Math.abs(System.currentTimeMillis() - MiPushClient.topicSubscribedTime(context, string)) > 86400000L) {
            hv hv2 = new hv();
            String string3 = ag.a();
            hv2.a(string3);
            hv2.b(b.a(context).a());
            hv2.c(string);
            hv2.d(context.getPackageName());
            hv2.e(string2);
            c.f("cmd:" + (Object)((Object)ec.g) + ", " + string3);
            ao.a(context).a(hv2, gq.c, null);
        } else if (1 == PushMessageHelper.getPushMode(context)) {
            PushMessageHandler.a(context, string2, 0L, null, string);
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            MiPushCommandMessage miPushCommandMessage = PushMessageHelper.generateCommandMessage(ec.g.k, arrayList, 0L, null, null, null);
            PushMessageHelper.sendCommandMessageBroadcast(context, miPushCommandMessage);
        }
    }

    public static void unsubscribe(Context context, String string, String string2) {
        if (!b.a(context).b()) {
            return;
        }
        if (MiPushClient.topicSubscribedTime(context, string) < 0L) {
            c.a("Don't cancel subscribe for " + string + " is unsubscribed");
            return;
        }
        hz hz2 = new hz();
        String string3 = ag.a();
        hz2.a(string3);
        hz2.b(b.a(context).a());
        hz2.c(string);
        hz2.d(context.getPackageName());
        hz2.e(string2);
        c.f("cmd:" + (Object)((Object)ec.h) + ", " + string3);
        ao.a(context).a(hz2, gq.d, null);
    }

    public static void pausePush(Context context, String string) {
        MiPushClient.setAcceptTime(context, 0, 0, 0, 0, string);
    }

    public static void resumePush(Context context, String string) {
        MiPushClient.setAcceptTime(context, 0, 0, 23, 59, string);
    }

    public static void clearNotification(Context context, int n2) {
        ao.a(context).a(n2);
    }

    public static void clearNotification(Context context, String string, String string2) {
        ao.a(context).a(string, string2);
    }

    public static void removeWindow(Context context) {
        ao.a(context).e();
    }

    public static void clearNotification(Context context) {
        ao.a(context).a(-1);
    }

    public static void reportAppRunInBackground(Context context, boolean bl2) {
        if (!b.a(context).b()) {
            return;
        }
        ha ha2 = bl2 ? ha.R : ha.Q;
        hq hq2 = new hq();
        hq2.b(b.a(context).a());
        hq2.c(ha2.ah);
        hq2.d(context.getPackageName());
        hq2.a(ag.a());
        hq2.a(false);
        ao.a(context).a(hq2, gq.i, false, null, false);
    }

    public static String getRegId(Context context) {
        if (b.a(context).c()) {
            return b.a(context).c();
        }
        return null;
    }

    public static String getAppRegion(Context context) {
        if (b.a(context).c()) {
            return b.a(context).f();
        }
        return null;
    }

    protected static void setCommand(Context context, String string, String string2, String string3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            arrayList.add(string2);
        }
        if (ec.c.k.equalsIgnoreCase(string) && Math.abs(System.currentTimeMillis() - MiPushClient.aliasSetTime(context, string2)) < 86400000L) {
            if (1 == PushMessageHelper.getPushMode(context)) {
                PushMessageHandler.a(context, string3, string, 0L, null, arrayList);
            } else {
                MiPushCommandMessage miPushCommandMessage = PushMessageHelper.generateCommandMessage(ec.c.k, arrayList, 0L, null, string3, null);
                PushMessageHelper.sendCommandMessageBroadcast(context, miPushCommandMessage);
            }
        } else if (ec.d.k.equalsIgnoreCase(string) && MiPushClient.aliasSetTime(context, string2) < 0L) {
            c.a("Don't cancel alias for " + ar.a(arrayList.toString(), 3) + " is unseted");
        } else if (ec.e.k.equalsIgnoreCase(string) && Math.abs(System.currentTimeMillis() - MiPushClient.accountSetTime(context, string2)) < 3600000L) {
            if (1 == PushMessageHelper.getPushMode(context)) {
                PushMessageHandler.a(context, string3, string, 0L, null, arrayList);
            } else {
                MiPushCommandMessage miPushCommandMessage = PushMessageHelper.generateCommandMessage(ec.e.k, arrayList, 0L, null, string3, null);
                PushMessageHelper.sendCommandMessageBroadcast(context, miPushCommandMessage);
            }
        } else if (ec.f.k.equalsIgnoreCase(string) && MiPushClient.accountSetTime(context, string2) < 0L) {
            c.a("Don't cancel account for " + ar.a(arrayList.toString(), 3) + " is unseted");
        } else {
            MiPushClient.setCommand(context, string, arrayList, string3);
        }
    }

    protected static void setCommand(Context context, String string, ArrayList<String> arrayList, String string2) {
        if (TextUtils.isEmpty((CharSequence)b.a(context).a())) {
            return;
        }
        hl hl2 = new hl();
        String string3 = ag.a();
        hl2.a(string3);
        hl2.b(b.a(context).a());
        hl2.c(string);
        for (String string4 : arrayList) {
            hl2.d(string4);
        }
        hl2.f(string2);
        hl2.e(context.getPackageName());
        c.f("cmd:" + string + ", " + string3);
        ao.a(context).a(hl2, gq.j, null);
    }

    public static void setAcceptTime(Context context, int n2, int n3, int n4, int n5, String string) {
        if (n2 < 0 || n2 >= 24 || n4 < 0 || n4 >= 24 || n3 < 0 || n3 >= 60 || n5 < 0 || n5 >= 60) {
            throw new IllegalArgumentException("the input parameter is not valid.");
        }
        TimeZone timeZone = TimeZone.getTimeZone("GMT+08");
        TimeZone timeZone2 = TimeZone.getDefault();
        long l2 = 1440L;
        long l3 = (timeZone.getRawOffset() - timeZone2.getRawOffset()) / 1000 / 60;
        long l4 = ((long)(n2 * 60 + n3) + l3 + l2) % l2;
        long l5 = ((long)(n4 * 60 + n5) + l3 + l2) % l2;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(String.format("%1$02d:%2$02d", l4 / 60L, l4 % 60L));
        arrayList.add(String.format("%1$02d:%2$02d", l5 / 60L, l5 % 60L));
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(String.format("%1$02d:%2$02d", n2, n3));
        arrayList2.add(String.format("%1$02d:%2$02d", n4, n5));
        if (MiPushClient.acceptTimeSet(context, (String)arrayList.get(0), (String)arrayList.get(1))) {
            if (1 == PushMessageHelper.getPushMode(context)) {
                PushMessageHandler.a(context, string, ec.i.k, 0L, null, arrayList2);
            } else {
                MiPushCommandMessage miPushCommandMessage = PushMessageHelper.generateCommandMessage(ec.i.k, arrayList2, 0L, null, null, null);
                PushMessageHelper.sendCommandMessageBroadcast(context, miPushCommandMessage);
            }
        } else {
            MiPushClient.setCommand(context, ec.i.k, arrayList, string);
        }
    }

    protected static boolean getOpenHmsPush(Context context) {
        MiPushClient.checkNotNull(context, "context");
        return f.a(context).b(e.a);
    }

    protected static boolean getOpenFCMPush(Context context) {
        MiPushClient.checkNotNull(context, "context");
        return f.a(context).b(e.b);
    }

    protected static boolean getOpenOPPOPush(Context context) {
        MiPushClient.checkNotNull(context, "context");
        return f.a(context).b(e.c);
    }

    protected static boolean getOpenVIVOPush(Context context) {
        return f.a(context).b(e.d);
    }

    private static void checkNotNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException("param " + string + " is not nullable");
        }
    }

    static synchronized void addAlias(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().putLong("alias_" + string, System.currentTimeMillis()).commit();
    }

    static synchronized void removeAlias(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().remove("alias_" + string).commit();
    }

    static synchronized void removeAllAliases(Context context) {
        List<String> list = MiPushClient.getAllAlias(context);
        for (String string : list) {
            MiPushClient.removeAlias(context, string);
        }
    }

    static synchronized void addAccount(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().putLong("account_" + string, System.currentTimeMillis()).commit();
    }

    static synchronized void removeAccount(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().remove("account_" + string).commit();
    }

    static synchronized void removeAllAccounts(Context context) {
        List<String> list = MiPushClient.getAllUserAccount(context);
        for (String string : list) {
            MiPushClient.removeAccount(context, string);
        }
    }

    static synchronized void addTopic(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().putLong("topic_" + string, System.currentTimeMillis()).commit();
    }

    static synchronized void removeTopic(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().remove("topic_" + string).commit();
    }

    static synchronized void removeAllTopics(Context context) {
        List<String> list = MiPushClient.getAllTopic(context);
        for (String string : list) {
            MiPushClient.removeTopic(context, string);
        }
    }

    static synchronized void addAcceptTime(Context context, String string, String string2) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString("accept_time", string + "," + string2);
        jj.a(editor);
    }

    static synchronized void removeAcceptTime(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.remove("accept_time");
        jj.a(editor);
    }

    public static long topicSubscribedTime(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return sharedPreferences.getLong("topic_" + string, -1L);
    }

    public static long accountSetTime(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return sharedPreferences.getLong("account_" + string, -1L);
    }

    public static long aliasSetTime(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return sharedPreferences.getLong("alias_" + string, -1L);
    }

    private static boolean acceptTimeSet(Context context, String string, String string2) {
        String string3 = MiPushClient.getAcceptTime(context);
        return TextUtils.equals((CharSequence)string3, (CharSequence)(string + "," + string2));
    }

    protected static String getAcceptTime(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return sharedPreferences.getString("accept_time", "00:00-23:59");
    }

    private static void addPullNotificationTime(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong("last_pull_notification", System.currentTimeMillis());
        jj.a(editor);
    }

    private static boolean shouldPullNotification(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return Math.abs(System.currentTimeMillis() - sharedPreferences.getLong("last_pull_notification", -1L)) > 300000L;
    }

    private static void addRegRequestTime(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong("last_reg_request", System.currentTimeMillis());
        jj.a(editor);
    }

    private static boolean shouldSendRegRequest(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return Math.abs(System.currentTimeMillis() - sharedPreferences.getLong("last_reg_request", -1L)) > 5000L;
    }

    private static void initEventPerfLogic(final Context context) {
        ds.a(new ds.a(){

            @Override
            public void uploader(Context context, gu gu2) {
                MiTinyDataClient.upload(context, gu2);
            }
        });
        com.xiaomi.b.a.a a2 = ds.c(context);
        com.xiaomi.b.b.b.a(context).a("4_9_1");
        com.xiaomi.b.b.a.a(context, a2, new dq(context), new dr(context));
        a.a(context);
        t.a(context, a2);
        ad.a(context).a(new ad.a(100, "perf event job update"){

            @Override
            protected void onCallback() {
                ds.b(context);
            }
        });
    }

    @Deprecated
    public static void registerCrashHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        Thread.setDefaultUncaughtExceptionHandler(uncaughtExceptionHandler);
    }

    private static void operateSyncAction(Context context) {
        if ("syncing".equals(af.a(sContext).a(au.a))) {
            MiPushClient.disablePush(sContext);
        }
        if ("syncing".equals(af.a(sContext).a(au.b))) {
            MiPushClient.enablePush(sContext);
        }
        if ("syncing".equals(af.a(sContext).a(au.c))) {
            MiPushClient.syncAssemblePushToken(sContext);
        }
        if ("syncing".equals(af.a(sContext).a(au.d))) {
            MiPushClient.syncAssembleFCMPushToken(sContext);
        }
        if ("syncing".equals(af.a(sContext).a(au.e))) {
            MiPushClient.syncAssembleCOSPushToken(context);
        }
        if ("syncing".equals(af.a(sContext).a(au.f))) {
            MiPushClient.syncAssembleFTOSPushToken(context);
        }
    }

    public static void registerToken(Context context, String string, String string2, String string3, UPSRegisterCallBack uPSRegisterCallBack) {
        MiPushClient.registerPush(context, string, string2, new PushConfiguration(), null, uPSRegisterCallBack);
    }

    public static void unRegisterToken(Context context, UPSUnRegisterCallBack uPSUnRegisterCallBack) {
        MiPushClient.unregisterPush(context);
        if (uPSUnRegisterCallBack != null) {
            TokenResult tokenResult = new TokenResult();
            tokenResult.setToken(null);
            tokenResult.getToken();
            tokenResult.setResultCode(0L);
            tokenResult.getResultCode();
            uPSUnRegisterCallBack.onResult(tokenResult);
        }
    }

    public static void turnOnPush(Context context, UPSTurnCallBack uPSTurnCallBack) {
        MiPushClient.enablePush(context);
        if (uPSTurnCallBack != null) {
            CodeResult codeResult = new CodeResult();
            codeResult.setResultCode(0L);
            codeResult.getResultCode();
            uPSTurnCallBack.onResult(codeResult);
        }
    }

    public static void turnOffPush(Context context, UPSTurnCallBack uPSTurnCallBack) {
        MiPushClient.disablePush(context);
        if (uPSTurnCallBack != null) {
            CodeResult codeResult = new CodeResult();
            codeResult.setResultCode(0L);
            codeResult.getResultCode();
            uPSTurnCallBack.onResult(codeResult);
        }
    }

    static {
        sCurMsgId = System.currentTimeMillis();
    }

    public static class CodeResult {
        private long resultCode = -1L;

        protected void setResultCode(long l2) {
            this.resultCode = l2;
        }

        public long getResultCode() {
            return this.resultCode;
        }
    }

    public static class TokenResult {
        private String token = null;
        private long resultCode = -1L;

        protected void setToken(String string) {
            this.token = string;
        }

        public String getToken() {
            return this.token;
        }

        protected void setResultCode(long l2) {
            this.resultCode = l2;
        }

        public long getResultCode() {
            return this.resultCode;
        }
    }

    public static interface UPSTurnCallBack
    extends ICallbackResult<CodeResult> {
    }

    public static interface UPSUnRegisterCallBack
    extends ICallbackResult<TokenResult> {
    }

    public static interface UPSRegisterCallBack
    extends ICallbackResult<TokenResult> {
    }

    public static interface ICallbackResult<R> {
        public void onResult(R var1);
    }

    @Deprecated
    public static abstract class MiPushClientCallback {
        private String category;

        protected String getCategory() {
            return this.category;
        }

        protected void setCategory(String string) {
            this.category = string;
        }

        public void onReceiveMessage(String string, String string2, String string3, boolean bl2) {
        }

        public void onReceiveMessage(MiPushMessage miPushMessage) {
        }

        public void onInitializeResult(long l2, String string, String string2) {
        }

        public void onSubscribeResult(long l2, String string, String string2) {
        }

        public void onUnsubscribeResult(long l2, String string, String string2) {
        }

        public void onCommandResult(String string, long l2, String string2, List<String> list) {
        }
    }
}

