/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.vasdolly.common;

import com.tencent.vasdolly.common.Pair;
import com.tencent.vasdolly.common.apk.ApkSigningBlockUtils;
import com.tencent.vasdolly.common.apk.SignatureNotFoundException;
import java.nio.ByteBuffer;

public class ApkSectionInfo {
    static int COPY_CONTENT_MAX_SIZE = 0x20000000;
    public boolean lowMemory = false;
    public long apkSize;
    public Pair<ByteBuffer, Long> contentEntry;
    public Pair<ByteBuffer, Long> apkSigningBlock;
    public Pair<ByteBuffer, Long> centralDir;
    public Pair<ByteBuffer, Long> eocd;

    public void checkParamters() throws SignatureNotFoundException {
        boolean result;
        if (!this.lowMemory && this.contentEntry == null || this.apkSigningBlock == null || this.centralDir == null || this.eocd == null) {
            throw new RuntimeException("ApkSectionInfo paramters is not valid : " + this.toString());
        }
        boolean bl = result = (this.lowMemory || this.contentEntry.getSecond() == 0L && (long)this.contentEntry.getFirst().remaining() == this.apkSigningBlock.getSecond()) && (long)this.apkSigningBlock.getFirst().remaining() + this.apkSigningBlock.getSecond() == this.centralDir.getSecond() && (long)this.centralDir.getFirst().remaining() + this.centralDir.getSecond() == this.eocd.getSecond() && (long)this.eocd.getFirst().remaining() + this.eocd.getSecond() == this.apkSize;
        if (!result) {
            throw new RuntimeException("ApkSectionInfo paramters is not valid : " + this.toString());
        }
        this.checkEocdCentralDirOffset();
    }

    public void rewind() {
        if (this.contentEntry != null) {
            this.contentEntry.getFirst().rewind();
        }
        if (this.apkSigningBlock != null) {
            this.apkSigningBlock.getFirst().rewind();
        }
        if (this.centralDir != null) {
            this.centralDir.getFirst().rewind();
        }
        if (this.eocd != null) {
            this.eocd.getFirst().rewind();
        }
    }

    public void checkEocdCentralDirOffset() throws SignatureNotFoundException {
        long centralDirOffset = ApkSigningBlockUtils.getCentralDirOffset(this.eocd.getFirst(), this.eocd.getSecond());
        if (centralDirOffset != this.centralDir.getSecond()) {
            throw new RuntimeException("CentralDirOffset mismatch , EocdCentralDirOffset : " + centralDirOffset + ", centralDirOffset : " + this.centralDir.getSecond());
        }
    }

    public String toString() {
        return "lowMemory : " + this.lowMemory + "\n apkSize : " + this.apkSize + "\n contentEntry : " + this.contentEntry + "\n schemeV2Block : " + this.apkSigningBlock + "\n centralDir : " + this.centralDir + "\n eocd : " + this.eocd;
    }
}

