/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.vasdolly.common;

import com.tencent.vasdolly.common.ApkSectionInfo;
import com.tencent.vasdolly.common.Pair;
import com.tencent.vasdolly.common.apk.ApkSigningBlockUtils;
import com.tencent.vasdolly.common.apk.SignatureNotFoundException;
import com.tencent.vasdolly.common.apk.ZipUtils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.LinkedHashMap;
import java.util.Map;

public class V2SchemeUtil {
    public static final int APK_SIGNATURE_SCHEME_V2_BLOCK_ID = 1896449818;

    public static Map<Integer, ByteBuffer> getAllIdValue(ByteBuffer apkSchemeBlock) throws SignatureNotFoundException {
        ApkSigningBlockUtils.checkByteOrderLittleEndian(apkSchemeBlock);
        ByteBuffer pairs = ApkSigningBlockUtils.sliceFromTo(apkSchemeBlock, 8, apkSchemeBlock.capacity() - 24);
        LinkedHashMap<Integer, ByteBuffer> idValues = new LinkedHashMap<Integer, ByteBuffer>();
        int entryCount = 0;
        while (pairs.hasRemaining()) {
            ++entryCount;
            if (pairs.remaining() < 8) {
                throw new SignatureNotFoundException("Insufficient data to read size of APK Signing Block entry #" + entryCount);
            }
            long lenLong = pairs.getLong();
            if (lenLong < 4L || lenLong > Integer.MAX_VALUE) {
                throw new SignatureNotFoundException("APK Signing Block entry #" + entryCount + " size out of range: " + lenLong);
            }
            int len = (int)lenLong;
            int nextEntryPos = pairs.position() + len;
            if (len > pairs.remaining()) {
                throw new SignatureNotFoundException("APK Signing Block entry #" + entryCount + " size out of range: " + len + ", available: " + pairs.remaining());
            }
            int id = pairs.getInt();
            idValues.put(id, ApkSigningBlockUtils.getByteBuffer(pairs, len - 4));
            pairs.position(nextEntryPos);
        }
        if (idValues.isEmpty()) {
            throw new SignatureNotFoundException("not have Id-Value Pair in APK Signing Block entry #" + entryCount);
        }
        return idValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer getApkSigningBlock(File channelFile) throws SignatureNotFoundException, IOException {
        if (channelFile == null || !channelFile.exists() || !channelFile.isFile()) {
            return null;
        }
        try (RandomAccessFile apk = null;){
            apk = new RandomAccessFile(channelFile, "r");
            Pair<ByteBuffer, Long> eocdAndOffsetInFile = ApkSigningBlockUtils.getEocd(apk);
            ByteBuffer eocd = eocdAndOffsetInFile.getFirst();
            long eocdOffset = eocdAndOffsetInFile.getSecond();
            if (ZipUtils.isZip64EndOfCentralDirectoryLocatorPresent(apk, eocdOffset)) {
                throw new SignatureNotFoundException("ZIP64 APK not supported");
            }
            long centralDirOffset = ApkSigningBlockUtils.getCentralDirOffset(eocd, eocdOffset);
            Pair<ByteBuffer, Long> apkSignatureBlock = ApkSigningBlockUtils.findApkSigningBlock(apk, centralDirOffset);
            ByteBuffer byteBuffer = apkSignatureBlock.getFirst();
            return byteBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApkSectionInfo getApkSectionInfo(File baseApk, boolean lowMemory) throws IOException, SignatureNotFoundException {
        try (RandomAccessFile apk = null;){
            apk = new RandomAccessFile(baseApk, "r");
            Pair<ByteBuffer, Long> eocdAndOffsetInFile = ApkSigningBlockUtils.getEocd(apk);
            ByteBuffer eocd = eocdAndOffsetInFile.getFirst();
            long eocdOffset = eocdAndOffsetInFile.getSecond();
            if (ZipUtils.isZip64EndOfCentralDirectoryLocatorPresent(apk, eocdOffset)) {
                throw new SignatureNotFoundException("ZIP64 APK not supported");
            }
            long centralDirOffset = ApkSigningBlockUtils.getCentralDirOffset(eocd, eocdOffset);
            Pair<ByteBuffer, Long> apkSchemeV2Block = ApkSigningBlockUtils.findApkSigningBlock(apk, centralDirOffset);
            Pair<ByteBuffer, Long> centralDir = V2SchemeUtil.findCentralDir(apk, centralDirOffset, (int)(eocdOffset - centralDirOffset));
            ApkSectionInfo apkSectionInfo = new ApkSectionInfo();
            apkSectionInfo.apkSize = baseApk.length();
            apkSectionInfo.lowMemory = lowMemory;
            if (apkSectionInfo.apkSize > (long)ApkSectionInfo.COPY_CONTENT_MAX_SIZE) {
                apkSectionInfo.lowMemory = true;
            }
            if (!apkSectionInfo.lowMemory) {
                apkSectionInfo.contentEntry = V2SchemeUtil.findContentEntry(apk, (int)apkSchemeV2Block.getSecond().longValue());
            }
            apkSectionInfo.apkSigningBlock = apkSchemeV2Block;
            apkSectionInfo.centralDir = centralDir;
            apkSectionInfo.eocd = eocdAndOffsetInFile;
            apkSectionInfo.checkParamters();
            System.out.println("baseApk : " + baseApk.getAbsolutePath() + "\nApkSectionInfo = " + apkSectionInfo);
            ApkSectionInfo apkSectionInfo2 = apkSectionInfo;
            return apkSectionInfo2;
        }
    }

    public static Pair<ByteBuffer, Long> findCentralDir(RandomAccessFile baseApk, long centralDirOffset, int length) throws IOException {
        ByteBuffer byteBuffer = V2SchemeUtil.getByteBuffer(baseApk, centralDirOffset, length);
        return Pair.create(byteBuffer, centralDirOffset);
    }

    public static Pair<ByteBuffer, Long> findContentEntry(RandomAccessFile baseApk, int length) throws IOException {
        ByteBuffer byteBuffer = V2SchemeUtil.getByteBuffer(baseApk, 0L, length);
        return Pair.create(byteBuffer, 0L);
    }

    private static ByteBuffer getByteBuffer(RandomAccessFile baseApk, long offset, int length) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(length);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        baseApk.seek(offset);
        baseApk.readFully(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.capacity());
        return byteBuffer;
    }

    public static ByteBuffer generateApkSigningBlock(Map<Integer, ByteBuffer> idValueMap) {
        if (idValueMap == null || idValueMap.isEmpty()) {
            throw new RuntimeException("getNewApkV2SchemeBlock , id value pair is empty");
        }
        long length = 24L;
        for (Map.Entry<Integer, ByteBuffer> entry : idValueMap.entrySet()) {
            ByteBuffer byteBuffer = entry.getValue();
            length += (long)(12 + byteBuffer.remaining());
        }
        boolean needPadding = idValueMap.containsKey(1114793335);
        System.out.println("generateApkSigningBlock , needPadding = " + needPadding);
        if (needPadding) {
            int paddingBlockSize = 12 + idValueMap.get(1114793335).remaining();
            idValueMap.remove(1114793335);
            int remainder = (int)(((length -= (long)paddingBlockSize) + 8L) % 4096L);
            if (remainder != 0) {
                int padding = 4096 - remainder;
                if (padding < 12) {
                    padding += 4096;
                }
                int bufferSize = padding - 8 - 4;
                ByteBuffer dummy = ByteBuffer.allocate(bufferSize).order(ByteOrder.LITTLE_ENDIAN);
                idValueMap.put(1114793335, dummy);
                System.out.println("generateApkSigningBlock , final length = " + (length += (long)padding) + " padding = " + padding + " bufferSize = " + bufferSize);
            }
        }
        ByteBuffer newApkV2Scheme = ByteBuffer.allocate((int)(length + 8L));
        newApkV2Scheme.order(ByteOrder.LITTLE_ENDIAN);
        newApkV2Scheme.putLong(length);
        for (Map.Entry<Integer, ByteBuffer> entry : idValueMap.entrySet()) {
            ByteBuffer byteBuffer = entry.getValue();
            newApkV2Scheme.putLong(byteBuffer.remaining() + 4);
            newApkV2Scheme.putInt(entry.getKey());
            newApkV2Scheme.put(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
        }
        newApkV2Scheme.putLong(length);
        newApkV2Scheme.putLong(2334950737559900225L);
        newApkV2Scheme.putLong(3617552046287187010L);
        if (newApkV2Scheme.remaining() > 0) {
            throw new RuntimeException("generateNewApkV2SchemeBlock error");
        }
        newApkV2Scheme.flip();
        return newApkV2Scheme;
    }

    public static boolean containV2Signature(File apk) {
        try {
            ByteBuffer apkSigningBlock = V2SchemeUtil.getApkSigningBlock(apk);
            Map<Integer, ByteBuffer> idValueMap = V2SchemeUtil.getAllIdValue(apkSigningBlock);
            if (idValueMap.containsKey(1896449818)) {
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SignatureNotFoundException e) {
            System.out.println("APK : " + apk.getAbsolutePath() + " not have apk v2 signature block");
        }
        return false;
    }
}

