/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.vasdolly.common;

import com.tencent.vasdolly.common.V2SchemeUtil;
import com.tencent.vasdolly.common.apk.SignatureNotFoundException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;

public class V3SchemeUtil {
    public static final int APK_SIGNATURE_SCHEME_V3_BLOCK_ID = -262969152;

    public static boolean containV3Signature(File apk) {
        try {
            ByteBuffer apkSigningBlock = V2SchemeUtil.getApkSigningBlock(apk);
            Map<Integer, ByteBuffer> idValueMap = V2SchemeUtil.getAllIdValue(apkSigningBlock);
            if (idValueMap.containsKey(-262969152)) {
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SignatureNotFoundException e) {
            System.out.println("APK : " + apk.getAbsolutePath() + " not have apk v3 signature block");
        }
        return false;
    }
}

