/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.vasdolly.plugin;

import com.android.build.api.variant.ApplicationVariant;
import com.android.build.api.variant.Variant;
import com.tencent.vasdolly.plugin.VasDollyPlugin;
import com.tencent.vasdolly.plugin.extension.ChannelConfigExtension;
import com.tencent.vasdolly.plugin.extension.RebuildChannelConfigExtension;
import com.tencent.vasdolly.plugin.task.ApkChannelPackageTask;
import com.tencent.vasdolly.plugin.task.RebuildApkChannelPackageTask;
import com.tencent.vasdolly.plugin.util.AndroidComponentsExtensionCompat;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\b\u0010\u000e\u001a\u00020\rH\u0002J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0002X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/tencent/vasdolly/plugin/VasDollyPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "channelConfigExt", "Lcom/tencent/vasdolly/plugin/extension/ChannelConfigExtension;", "channelInfoList", "", "", "project", "rebuildConfigExt", "Lcom/tencent/vasdolly/plugin/extension/RebuildChannelConfigExtension;", "apply", "", "createChannelTask", "getChannelList", "Companion", "plugin"})
public final class VasDollyPlugin
implements Plugin<Project> {
    private Project project;
    private ChannelConfigExtension channelConfigExt;
    private RebuildChannelConfigExtension rebuildConfigExt;
    private List<String> channelInfoList;
    @NotNull
    public static final String PROPERTY_CHANNELS = "channels";
    @NotNull
    public static final String PROPERTY_CHANNEL_FILE = "channel_file";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        if (!project.getPlugins().hasPlugin("com.android.application")) {
            throw (Throwable)new GradleException("VasDolly plugin 'com.android.application' must be apply");
        }
        Object object = project.getExtensions().create("channel", ChannelConfigExtension.class, new Object[]{project});
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.extensions.creat\u2026ion::class.java, project)");
        this.channelConfigExt = (ChannelConfigExtension)object;
        Object object2 = project.getExtensions().create("rebuildChannel", RebuildChannelConfigExtension.class, new Object[]{project});
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"project.extensions.creat\u2026        project\n        )");
        this.rebuildConfigExt = (RebuildChannelConfigExtension)object2;
        this.channelInfoList = this.getChannelList();
        this.createChannelTask();
    }

    private final void createChannelTask() {
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        AndroidComponentsExtensionCompat androidComponents = AndroidComponentsExtensionCompat.Companion.getAndroidComponentsExtension(project);
        androidComponents.onAllVariants((Function1<? super Variant, Unit>)((Function1)new Function1<Variant, Unit>(this){
            final /* synthetic */ VasDollyPlugin this$0;

            public final void invoke(@NotNull Variant variant) {
                Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                if (variant instanceof ApplicationVariant) {
                    String variantName = StringsKt.capitalize((String)variant.getName());
                    String string = "find android build variant name:" + variant.getName();
                    boolean bl = false;
                    System.out.println((Object)string);
                    VasDollyPlugin.access$getProject$p(this.this$0).getTasks().register("channel" + variantName, ApkChannelPackageTask.class, (Action)new Action<ApkChannelPackageTask>(this, variant, variantName){
                        final /* synthetic */ createChannelTask.1 this$0;
                        final /* synthetic */ Variant $variant;
                        final /* synthetic */ String $variantName;

                        public final void execute(ApkChannelPackageTask it) {
                            it.setVariant((ApplicationVariant)this.$variant);
                            it.setChannelExtension(VasDollyPlugin.access$getChannelConfigExt$p(this.this$0.this$0));
                            it.getChannelList().addAll(VasDollyPlugin.access$getChannelInfoList$p(this.this$0.this$0));
                            it.setMergeExtChannelList(!VasDollyPlugin.access$getProject$p(this.this$0.this$0).hasProperty("channels"));
                            it.dependsOn(new Object[]{"assemble" + this.$variantName});
                        }
                        {
                            this.this$0 = var1_1;
                            this.$variant = variant;
                            this.$variantName = string;
                        }
                    });
                }
            }
            {
                this.this$0 = vasDollyPlugin;
                super(1);
            }
        }));
        Project project2 = this.project;
        if (project2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        project2.getTasks().register("reBuildChannel", RebuildApkChannelPackageTask.class, (Action)new Action<RebuildApkChannelPackageTask>(this){
            final /* synthetic */ VasDollyPlugin this$0;

            public final void execute(RebuildApkChannelPackageTask it) {
                it.setMergeExtChannelList(!VasDollyPlugin.access$getProject$p(this.this$0).hasProperty("channels"));
                it.getChannelList().addAll(VasDollyPlugin.access$getChannelInfoList$p(this.this$0));
                it.setRebuildExt(VasDollyPlugin.access$getRebuildConfigExt$p(this.this$0));
            }
            {
                this.this$0 = vasDollyPlugin;
            }
        });
    }

    private final List<String> getChannelList() {
        boolean bl = false;
        List channelList = new ArrayList();
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        if (project.hasProperty(PROPERTY_CHANNELS)) {
            Project project2 = this.project;
            if (project2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            }
            Object v = project2.getProperties().get(PROPERTY_CHANNELS);
            if (v == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String channels = (String)v;
            CharSequence charSequence = channels;
            boolean bl2 = false;
            if (charSequence.length() > 0) {
                this.channelInfoList = StringsKt.split$default((CharSequence)channels, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
            }
            if (this.channelInfoList.isEmpty()) {
                throw (Throwable)new InvalidUserDataException("Property(channels) channel list is empty , please fix it");
            }
            charSequence = "get project channel list from `channels` property,channels:" + channelList;
            bl2 = false;
            System.out.println(charSequence);
        } else {
            Project project3 = this.project;
            if (project3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            }
            if (project3.hasProperty(PROPERTY_CHANNEL_FILE)) {
                Project project4 = this.project;
                if (project4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"project");
                }
                Object v = project4.getProperties().get(PROPERTY_CHANNEL_FILE);
                if (v == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                String channelFilePath = (String)v;
                CharSequence charSequence = channelFilePath;
                boolean bl3 = false;
                if (charSequence.length() > 0) {
                    File channelFile;
                    Project project5 = this.project;
                    if (project5 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"project");
                    }
                    if ((channelFile = project5.getRootProject().file((Object)channelFilePath)).exists()) {
                        File file = channelFile;
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"channelFile");
                        if (file.isFile()) {
                            FilesKt.forEachLine$default((File)channelFile, null, (Function1)((Function1)new Function1<String, Unit>(channelList){
                                final /* synthetic */ List $channelList;

                                public final void invoke(@NotNull String channel) {
                                    Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                                    this.$channelList.add(channel);
                                }
                                {
                                    this.$channelList = list;
                                    super(1);
                                }
                            }), (int)1, null);
                        }
                    }
                }
                charSequence = "get project channel list from `channel_file` property,file:" + channelFilePath + ",channels:" + channelList;
                bl3 = false;
                System.out.println(charSequence);
            }
        }
        return channelList;
    }

    public VasDollyPlugin() {
        boolean bl = false;
        this.channelInfoList = CollectionsKt.emptyList();
    }

    public static final /* synthetic */ Project access$getProject$p(VasDollyPlugin $this) {
        Project project = $this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        return project;
    }

    public static final /* synthetic */ void access$setProject$p(VasDollyPlugin $this, Project project) {
        $this.project = project;
    }

    public static final /* synthetic */ ChannelConfigExtension access$getChannelConfigExt$p(VasDollyPlugin $this) {
        ChannelConfigExtension channelConfigExtension = $this.channelConfigExt;
        if (channelConfigExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"channelConfigExt");
        }
        return channelConfigExtension;
    }

    public static final /* synthetic */ void access$setChannelConfigExt$p(VasDollyPlugin $this, ChannelConfigExtension channelConfigExtension) {
        $this.channelConfigExt = channelConfigExtension;
    }

    public static final /* synthetic */ List access$getChannelInfoList$p(VasDollyPlugin $this) {
        return $this.channelInfoList;
    }

    public static final /* synthetic */ void access$setChannelInfoList$p(VasDollyPlugin $this, List list) {
        $this.channelInfoList = list;
    }

    public static final /* synthetic */ RebuildChannelConfigExtension access$getRebuildConfigExt$p(VasDollyPlugin $this) {
        RebuildChannelConfigExtension rebuildChannelConfigExtension = $this.rebuildConfigExt;
        if (rebuildChannelConfigExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rebuildConfigExt");
        }
        return rebuildChannelConfigExtension;
    }

    public static final /* synthetic */ void access$setRebuildConfigExt$p(VasDollyPlugin $this, RebuildChannelConfigExtension rebuildChannelConfigExtension) {
        $this.rebuildConfigExt = rebuildChannelConfigExtension;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/tencent/vasdolly/plugin/VasDollyPlugin$Companion;", "", "()V", "PROPERTY_CHANNELS", "", "PROPERTY_CHANNEL_FILE", "plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

