/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.vasdolly.plugin.task;

import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.variant.ApplicationVariant;
import com.android.build.api.variant.BuiltArtifact;
import com.android.build.api.variant.BuiltArtifacts;
import com.android.build.api.variant.BuiltArtifactsLoader;
import com.android.build.api.variant.SigningConfig;
import com.android.build.api.variant.VariantOutput;
import com.tencent.vasdolly.plugin.extension.ChannelConfigExtension;
import com.tencent.vasdolly.plugin.extension.ConfigExtension;
import com.tencent.vasdolly.plugin.task.ChannelPackageTask;
import com.tencent.vasdolly.plugin.util.SimpleAGPVersion;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0019H\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u001dH\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u0004H\u0002J\b\u0010\u001f\u001a\u00020\u0016H\u0007R \u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u0004\u0018\u00010\n8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u0004\u0018\u00010\u00108GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"Lcom/tencent/vasdolly/plugin/task/ApkChannelPackageTask;", "Lcom/tencent/vasdolly/plugin/task/ChannelPackageTask;", "()V", "baseApk", "Ljava/io/File;", "getBaseApk", "()Ljava/io/File;", "setBaseApk", "(Ljava/io/File;)V", "channelExtension", "Lcom/tencent/vasdolly/plugin/extension/ChannelConfigExtension;", "getChannelExtension", "()Lcom/tencent/vasdolly/plugin/extension/ChannelConfigExtension;", "setChannelExtension", "(Lcom/tencent/vasdolly/plugin/extension/ChannelConfigExtension;)V", "variant", "Lcom/android/build/api/variant/ApplicationVariant;", "getVariant", "()Lcom/android/build/api/variant/ApplicationVariant;", "setVariant", "(Lcom/android/build/api/variant/ApplicationVariant;)V", "checkParameter", "", "generateChannelApk", "getChannelApkName", "", "baseApkName", "channel", "getExtensionChannelList", "", "getVariantBaseApk", "taskAction", "plugin"})
public class ApkChannelPackageTask
extends ChannelPackageTask {
    @Internal
    @Nullable
    private File baseApk;
    @Nullable
    private ApplicationVariant variant;
    @Nullable
    private ChannelConfigExtension channelExtension;

    @Nullable
    public final File getBaseApk() {
        return this.baseApk;
    }

    public final void setBaseApk(@Nullable File file) {
        this.baseApk = file;
    }

    @Input
    @Nullable
    public final ApplicationVariant getVariant() {
        return this.variant;
    }

    public final void setVariant(@Nullable ApplicationVariant applicationVariant) {
        this.variant = applicationVariant;
    }

    @Input
    @Nullable
    public final ChannelConfigExtension getChannelExtension() {
        return this.channelExtension;
    }

    public final void setChannelExtension(@Nullable ChannelConfigExtension channelConfigExtension) {
        this.channelExtension = channelConfigExtension;
    }

    @TaskAction
    public final void taskAction() {
        this.checkParameter();
        this.generateChannelApk();
    }

    private final void checkParameter() {
        Object object;
        if (this.getMergeExtChannelList()) {
            this.mergeChannelList();
        }
        if (this.getChannelList().isEmpty()) {
            throw (Throwable)new InvalidUserDataException("Task " + this.getName() + " channel list is empty,please check it");
        }
        String string = "Task " + this.getName() + ", channelList: " + this.getChannelList();
        boolean bl = false;
        System.out.println((Object)string);
        if (this.variant == null) {
            throw (Throwable)new InvalidUserDataException("Task " + this.getName() + " variant is null");
        }
        File file = this.getVariantBaseApk();
        if (file == null) {
            throw (Throwable)new RuntimeException("can't find base apk");
        }
        this.baseApk = file;
        File file2 = this.baseApk;
        string = "Task " + this.getName() + ", baseApk: " + (file2 != null ? file2.getAbsolutePath() : null);
        bl = false;
        System.out.println((Object)string);
        if (this.channelExtension == null) {
            throw (Throwable)new InvalidUserDataException("Task " + this.getName() + " channel is null");
        }
        ChannelConfigExtension channelConfigExtension = this.channelExtension;
        if (channelConfigExtension != null) {
            channelConfigExtension.checkParams();
        }
        string = "Task " + this.getName() + ", channel files outputDir:" + ((object = this.channelExtension) != null && (object = ((ConfigExtension)object).getOutputDir()) != null ? ((File)object).getAbsolutePath() : null);
        bl = false;
        System.out.println((Object)string);
    }

    private final File getVariantBaseApk() {
        File file;
        ApplicationVariant applicationVariant = this.variant;
        if (applicationVariant != null) {
            Directory directory;
            SimpleAGPVersion agpVersion7;
            ApplicationVariant applicationVariant2 = applicationVariant;
            boolean bl = false;
            boolean bl2 = false;
            ApplicationVariant variant = applicationVariant2;
            boolean bl3 = false;
            SimpleAGPVersion currentAGPVersion = SimpleAGPVersion.Companion.getANDROID_GRADLE_PLUGIN_VERSION();
            if (currentAGPVersion.compareTo(agpVersion7 = new SimpleAGPVersion(7, 0)) < 0) {
                Class<?> artifactCls = Class.forName("com.android.build.api.artifact.ArtifactType");
                Class<?> clazz = Class.forName("com.android.build.api.artifact.ArtifactType$APK");
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"Class.forName(\"com.andro\u2026t.ArtifactType${'$'}APK\")");
                KClass apkClass = JvmClassMappingKt.getKotlinClass(clazz);
                Object object = variant.getArtifacts().getClass().getMethod("get", artifactCls).invoke((Object)variant.getArtifacts(), apkClass.getObjectInstance());
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.provider.Provider<org.gradle.api.file.Directory>");
                }
                Provider provider = (Provider)object;
                directory = (Directory)provider.get();
            } else {
                directory = (Directory)variant.getArtifacts().get((SingleArtifact)SingleArtifact.APK.INSTANCE).get();
            }
            Directory apkFolder = directory;
            BuiltArtifactsLoader builtArtifactsLoader = variant.getArtifacts().getBuiltArtifactsLoader();
            Directory directory2 = apkFolder;
            Intrinsics.checkNotNullExpressionValue((Object)directory2, (String)"apkFolder");
            BuiltArtifacts builtArtifacts = builtArtifactsLoader.load(directory2);
            if (builtArtifacts != null) {
                BuiltArtifacts builtArtifacts2 = builtArtifacts;
                boolean bl4 = false;
                boolean bl5 = false;
                BuiltArtifacts it = builtArtifacts2;
                boolean bl6 = false;
                file = new File(((BuiltArtifact)CollectionsKt.first((Iterable)it.getElements())).getOutputFile());
            } else {
                file = null;
            }
        } else {
            file = null;
        }
        return file;
    }

    private final void generateChannelApk() {
        ChannelConfigExtension channelConfigExtension = this.channelExtension;
        File outputDir = channelConfigExtension != null ? channelConfigExtension.getOutputDir() : null;
        File file = this.baseApk;
        File file2 = outputDir;
        String string = "generateChannelApk baseApk:" + (file != null ? file.getAbsolutePath() : null) + ",outputDir:" + (file2 != null ? file2.getPath() : null);
        boolean bl = false;
        System.out.println((Object)string);
        ApplicationVariant applicationVariant = this.variant;
        Object object = applicationVariant != null ? applicationVariant.getSigningConfig() : null;
        Intrinsics.checkNotNull((Object)object);
        SigningConfig signingConfig = object;
        ChannelConfigExtension channelConfigExtension2 = this.channelExtension;
        boolean lowMemory = channelConfigExtension2 != null ? channelConfigExtension2.getLowMemory() : false;
        ChannelConfigExtension channelConfigExtension3 = this.channelExtension;
        boolean isFastMode = channelConfigExtension3 != null ? channelConfigExtension3.getFastMode() : false;
        Object object2 = signingConfig.getEnableV2Signing().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"signingConfig.enableV2Signing.get()");
        if (((Boolean)object2).booleanValue()) {
            File file3 = this.baseApk;
            Intrinsics.checkNotNull((Object)file3);
            File file4 = outputDir;
            Intrinsics.checkNotNull((Object)file4);
            this.generateV2ChannelApk(file3, file4, lowMemory, isFastMode);
        } else {
            Object object3 = signingConfig.getEnableV1Signing().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"signingConfig.enableV1Signing.get()");
            if (((Boolean)object3).booleanValue()) {
                File file5 = this.baseApk;
                Intrinsics.checkNotNull((Object)file5);
                File file6 = outputDir;
                Intrinsics.checkNotNull((Object)file6);
                this.generateV1ChannelApk(file5, file6, isFastMode);
            } else {
                throw (Throwable)new GradleException("not have precise channel package mode");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String getChannelApkName(@NotNull String baseApkName, @NotNull String channel) {
        Intrinsics.checkNotNullParameter((Object)baseApkName, (String)"baseApkName");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        String timeFormat = "yyyyMMdd-HHmmss";
        ChannelConfigExtension channelConfigExtension = this.channelExtension;
        String string = channelConfigExtension != null ? channelConfigExtension.getBuildTimeDateFormat() : null;
        Intrinsics.checkNotNull((Object)string);
        CharSequence charSequence = string;
        boolean bl = false;
        if (charSequence.length() > 0) {
            ChannelConfigExtension channelConfigExtension2 = this.channelExtension;
            String string2 = channelConfigExtension2 != null ? channelConfigExtension2.getBuildTimeDateFormat() : null;
            Intrinsics.checkNotNull((Object)string2);
            timeFormat = string2;
        }
        String buildTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern(timeFormat));
        Object object = this.variant;
        VariantOutput outInfo = object != null && (object = object.getOutputs()) != null ? (VariantOutput)CollectionsKt.first((List)object) : null;
        boolean bl2 = false;
        Map keyValue = new LinkedHashMap();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        String string3 = project.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"project.name");
        keyValue.put("appName", string3);
        keyValue.put("flavorName", channel);
        Object object2 = this.variant;
        if (object2 == null || (object2 = object2.getBuildType()) == null) {
            object2 = "";
        }
        keyValue.put("buildType", object2);
        Object object3 = outInfo;
        if (object3 == null || (object3 = object3.getVersionName()) == null || (object3 = (String)object3.get()) == null) {
            object3 = "";
        }
        keyValue.put("versionName", object3);
        VariantOutput variantOutput = outInfo;
        keyValue.put("versionCode", String.valueOf(variantOutput != null && (variantOutput = variantOutput.getVersionCode()) != null ? (Integer)variantOutput.get() : null));
        Object object4 = this.variant;
        if (object4 == null || (object4 = object4.getApplicationId()) == null || (object4 = (String)object4.get()) == null) {
            object4 = "";
        }
        keyValue.put("appId", object4);
        String string4 = buildTime;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"buildTime");
        keyValue.put("buildTime", string4);
        String apkNamePrefix = "${appName}-${versionName}-${versionCode}-${flavorName}-${buildType}-${buildTime}";
        ChannelConfigExtension channelConfigExtension3 = this.channelExtension;
        String string5 = channelConfigExtension3 != null ? channelConfigExtension3.getApkNameFormat() : null;
        Intrinsics.checkNotNull((Object)string5);
        CharSequence charSequence2 = string5;
        boolean bl3 = false;
        if (charSequence2.length() > 0) {
            ChannelConfigExtension channelConfigExtension4 = this.channelExtension;
            String string6 = channelConfigExtension4 != null ? channelConfigExtension4.getApkNameFormat() : null;
            Intrinsics.checkNotNull((Object)string6);
            apkNamePrefix = string6;
        }
        Map $this$forEach$iv = keyValue;
        boolean $i$f$forEach = false;
        Map map = $this$forEach$iv;
        boolean bl4 = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            void k;
            Map.Entry element$iv;
            Map.Entry $dstr$k$v = element$iv = iterator.next();
            boolean bl5 = false;
            Map.Entry entry = $dstr$k$v;
            boolean bl6 = false;
            String string7 = (String)entry.getKey();
            entry = $dstr$k$v;
            bl6 = false;
            String v = (String)entry.getValue();
            apkNamePrefix = StringsKt.replace$default((String)apkNamePrefix, (String)("${" + (String)k + "}"), (String)v, (boolean)false, (int)4, null);
        }
        return apkNamePrefix + ".apk";
    }

    @Override
    @NotNull
    public List<String> getExtensionChannelList() {
        Object object = this.channelExtension;
        if (object == null || (object = ((ConfigExtension)object).getExtensionChannelList()) == null) {
            boolean bl = false;
            object = CollectionsKt.emptyList();
        }
        return object;
    }
}

