/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.vasdolly.plugin.task;

import com.tencent.vasdolly.common.ApkSectionInfo;
import com.tencent.vasdolly.reader.ChannelReader;
import com.tencent.vasdolly.verify.VerifyApk;
import com.tencent.vasdolly.writer.ChannelWriter;
import com.tencent.vasdolly.writer.IdValueWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u000bJ&\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bJ\u0018\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H&J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001cH'J\u0006\u0010\u001d\u001a\u00020\u0011R$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lcom/tencent/vasdolly/plugin/task/ChannelPackageTask;", "Lorg/gradle/api/DefaultTask;", "()V", "channelList", "", "", "getChannelList", "()Ljava/util/List;", "setChannelList", "(Ljava/util/List;)V", "mergeExtChannelList", "", "getMergeExtChannelList", "()Z", "setMergeExtChannelList", "(Z)V", "generateV1ChannelApk", "", "baseApk", "Ljava/io/File;", "outputDir", "isFastMode", "generateV2ChannelApk", "lowMemory", "getChannelApkName", "baseApkName", "channel", "getExtensionChannelList", "", "mergeChannelList", "plugin"})
public abstract class ChannelPackageTask
extends DefaultTask {
    @Input
    private boolean mergeExtChannelList = true;
    @Input
    @NotNull
    private List<String> channelList;

    public final boolean getMergeExtChannelList() {
        return this.mergeExtChannelList;
    }

    public final void setMergeExtChannelList(boolean bl) {
        this.mergeExtChannelList = bl;
    }

    @NotNull
    public final List<String> getChannelList() {
        return this.channelList;
    }

    public final void setChannelList(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.channelList = list;
    }

    public final void mergeChannelList() {
        List<String> extensionChannelList = this.getExtensionChannelList();
        Collection collection = extensionChannelList;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.channelList.addAll((Collection<String>)extensionChannelList);
        }
    }

    public final void generateV2ChannelApk(@NotNull File baseApk, @NotNull File outputDir, boolean lowMemory, boolean isFastMode) {
        Intrinsics.checkNotNullParameter((Object)baseApk, (String)"baseApk");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        String string = "------ " + this.getProject() + ".name:" + this.getName() + " generate v2 channel apk  , begin ------";
        boolean bl = false;
        System.out.println((Object)string);
        ApkSectionInfo apkSectionInfo = IdValueWriter.getApkSectionInfo((File)baseApk, (boolean)lowMemory);
        Iterable $this$forEach$iv = this.channelList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String channel = (String)element$iv;
            boolean bl2 = false;
            String string2 = baseApk.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"baseApk.name");
            String apkChannelName = this.getChannelApkName(string2, channel);
            String string3 = "++++++++++++++++++++++++++++++  channel(" + channel + ")  ++++++++++++++++++++++++++++++";
            boolean bl3 = false;
            System.out.println((Object)string3);
            string3 = "generateV2ChannelApk,channel=" + channel + ",apkChannelName=" + apkChannelName;
            bl3 = false;
            System.out.println((Object)string3);
            File destFile = new File(outputDir, apkChannelName);
            if (apkSectionInfo.lowMemory) {
                FilesKt.copyTo$default((File)baseApk, (File)destFile, (boolean)false, (int)0, (int)6, null);
            }
            ChannelWriter.addChannelByV2((ApkSectionInfo)apkSectionInfo, (File)destFile, (String)channel);
            if (!isFastMode) {
                if (!ChannelReader.verifyChannelByV2((File)destFile, (String)channel)) {
                    throw (Throwable)new GradleException("generateV2ChannelApk, " + destFile + " add channel failure");
                }
                String string4 = "generateV2ChannelApk, " + destFile + " add channel success";
                boolean bl4 = false;
                System.out.println((Object)string4);
                if (VerifyApk.verifyV2Signature((File)destFile)) {
                    string4 = "generateV2ChannelApk,after add channel,apk " + destFile + " v2 verify success";
                    bl4 = false;
                    System.out.println((Object)string4);
                } else {
                    throw (Throwable)new GradleException("generateV2ChannelApk,after add channel, apk " + destFile + " v2 verify failure");
                }
            }
            apkSectionInfo.rewind();
            if (isFastMode) continue;
            apkSectionInfo.checkEocdCentralDirOffset();
        }
        String string5 = "------ " + this.getProject() + ".name:" + this.getName() + " generate v2 channel apk , end ------";
        boolean bl5 = false;
        System.out.println((Object)string5);
    }

    public final void generateV1ChannelApk(@NotNull File baseApk, @NotNull File outputDir, boolean isFastMode) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)baseApk, (String)"baseApk");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        String string = "------" + this.getProject() + ".name:" + this.getName() + " generate v1 channel apk, begin------";
        boolean bl2 = false;
        System.out.println((Object)string);
        if (!ChannelReader.containV1Signature((File)baseApk)) {
            String msg = this.getName() + " get signing config apk " + baseApk.getAbsolutePath() + " not signed by v1,you can't install Apk below Android7.0";
            throw (Throwable)new GradleException(msg);
        }
        String apkChannel = ChannelReader.getChannelByV1((File)baseApk);
        if (apkChannel != null) {
            CharSequence charSequence = apkChannel;
            bl = false;
            if (charSequence.length() > 0) {
                throw (Throwable)new GradleException("baseApk " + baseApk + ".getAbsolutePath() has channel");
            }
        }
        Iterable $this$forEach$iv = this.channelList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String channel = (String)element$iv;
            boolean bl3 = false;
            String string2 = baseApk.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"baseApk.name");
            String apkChannelName = this.getChannelApkName(string2, channel);
            String string3 = "++++++++++++++++++++++++++++++  channel(" + channel + ")  ++++++++++++++++++++++++++++++";
            boolean bl4 = false;
            System.out.println((Object)string3);
            string3 = "generateV1ChannelApk,channel=" + channel + ",apkChannelName=" + apkChannelName;
            bl4 = false;
            System.out.println((Object)string3);
            File destFile = new File(outputDir, apkChannelName);
            FilesKt.copyTo$default((File)baseApk, (File)destFile, (boolean)false, (int)0, (int)6, null);
            ChannelWriter.addChannelByV1((File)destFile, (String)channel);
            if (!isFastMode) continue;
            if (!ChannelReader.verifyChannelByV1((File)destFile, (String)channel)) {
                throw (Throwable)new GradleException("generateV1ChannelApk,apk " + destFile + " add channel failure");
            }
            String string4 = "generateV1ChannelApk,apk " + destFile + " add channel success";
            boolean bl5 = false;
            System.out.println((Object)string4);
            if (VerifyApk.verifyV1Signature((File)destFile)) {
                string4 = "generateV1ChannelApk,after add channel,apk " + destFile + " v1 verify success";
                bl5 = false;
                System.out.println((Object)string4);
                continue;
            }
            throw (Throwable)new GradleException("generateV1ChannelApk , after add channel , apk " + destFile + " v1 verify failure");
        }
        String string5 = "------" + this.getProject() + ".name:" + this.getName() + " generate v1 channel apk , end------";
        bl = false;
        System.out.println((Object)string5);
    }

    @NotNull
    public abstract String getChannelApkName(@NotNull String var1, @NotNull String var2);

    @Internal
    @NotNull
    public abstract List<String> getExtensionChannelList();

    public ChannelPackageTask() {
        boolean bl = false;
        this.channelList = new ArrayList();
        this.setGroup("com.tencent.vasdolly");
    }
}

