/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wcdb.compat;

public class SQLiteCipherSpec {
    public static final int HMAC_DEFAULT = -1;
    public static final int HMAC_SHA1 = 0;
    public static final int HMAC_SHA256 = 1;
    public static final int HMAC_SHA512 = 2;
    static final String[] HMAC_ALGO_MAPPING = new String[]{"HMAC_SHA1", "HMAC_SHA256", "HMAC_SHA512"};
    static final String[] PBKDF2_ALGO_MAPPING = new String[]{"PBKDF2_HMAC_SHA1", "PBKDF2_HMAC_SHA256", "PBKDF2_HMAC_SHA512"};
    public int kdfIteration;
    public boolean hmacEnabled = true;
    public int hmacAlgorithm = -1;
    public int kdfAlgorithm = -1;
    public int pageSize = 4096;
    int cipherVersion = 0;

    public SQLiteCipherSpec() {
    }

    public SQLiteCipherSpec(SQLiteCipherSpec rhs) {
        this.kdfIteration = rhs.kdfIteration;
        this.hmacEnabled = rhs.hmacEnabled;
        this.hmacAlgorithm = rhs.hmacAlgorithm;
        this.kdfAlgorithm = rhs.kdfAlgorithm;
        this.cipherVersion = rhs.cipherVersion;
        this.pageSize = rhs.pageSize;
    }

    public SQLiteCipherSpec setKDFIteration(int iter) {
        if (this.kdfIteration != iter) {
            this.kdfIteration = iter;
            this.cipherVersion = -1;
        }
        return this;
    }

    public SQLiteCipherSpec withHMACEnabled(boolean enabled) {
        if (this.hmacEnabled != enabled) {
            this.hmacEnabled = enabled;
            this.cipherVersion = -1;
        }
        return this;
    }

    public SQLiteCipherSpec setHmacAlgorithm(int algo) {
        if (this.hmacAlgorithm != algo) {
            this.hmacAlgorithm = algo;
            this.cipherVersion = -1;
        }
        return this;
    }

    public SQLiteCipherSpec setKdfAlgorithm(int algo) {
        if (this.kdfAlgorithm != algo) {
            this.kdfAlgorithm = algo;
            this.cipherVersion = -1;
        }
        return this;
    }

    public SQLiteCipherSpec setPageSize(int size) {
        this.pageSize = size;
        return this;
    }

    public SQLiteCipherSpec setSQLCipherVersion(int version) {
        switch (version) {
            case 1: {
                this.cipherVersion = 1;
                this.hmacEnabled = false;
                this.kdfIteration = 4000;
                this.hmacAlgorithm = 0;
                this.kdfAlgorithm = 0;
                break;
            }
            case 2: {
                this.cipherVersion = 2;
                this.hmacEnabled = true;
                this.kdfIteration = 4000;
                this.hmacAlgorithm = 0;
                this.kdfAlgorithm = 0;
                break;
            }
            case 3: {
                this.cipherVersion = 3;
                this.hmacEnabled = true;
                this.kdfIteration = 64000;
                this.hmacAlgorithm = 0;
                this.kdfAlgorithm = 0;
                break;
            }
            case 4: {
                this.cipherVersion = 4;
                this.hmacEnabled = true;
                this.kdfIteration = 256000;
                this.hmacAlgorithm = 2;
                this.kdfAlgorithm = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported SQLCipher version: " + version);
            }
        }
        return this;
    }
}

