/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wcdb.compat;

import android.database.AbstractCursor;
import com.tencent.wcdb.base.Value;
import com.tencent.wcdb.winq.ColumnType;
import java.util.List;

class ValueCursor
extends AbstractCursor {
    private final List<Value[]> mRows;
    private final String[] mColumnNames;

    ValueCursor(List<Value[]> rows, String[] columnNames) {
        this.mRows = rows;
        this.mColumnNames = columnNames;
    }

    public int getCount() {
        return this.mRows.size();
    }

    public String[] getColumnNames() {
        return this.mColumnNames;
    }

    public int getType(int column) {
        Value[] row = this.mRows.get(this.mPos);
        return row[column].getType().ordinal();
    }

    public String getString(int column) {
        Value[] row = this.mRows.get(this.mPos);
        return row[column].getText();
    }

    public short getShort(int column) {
        Value[] row = this.mRows.get(this.mPos);
        return (short)row[column].getLong();
    }

    public int getInt(int column) {
        Value[] row = this.mRows.get(this.mPos);
        return row[column].getInt();
    }

    public long getLong(int column) {
        Value[] row = this.mRows.get(this.mPos);
        return row[column].getLong();
    }

    public float getFloat(int column) {
        Value[] row = this.mRows.get(this.mPos);
        return (float)row[column].getDouble();
    }

    public double getDouble(int column) {
        Value[] row = this.mRows.get(this.mPos);
        return row[column].getDouble();
    }

    public byte[] getBlob(int column) {
        Value[] row = this.mRows.get(this.mPos);
        return row[column].getBLOB();
    }

    public boolean isNull(int column) {
        Value[] row = this.mRows.get(this.mPos);
        return row[column].getType() == ColumnType.Null;
    }
}

