/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wcdb.compat;

import android.os.CancellationSignal;
import com.tencent.wcdb.compat.SQLiteDatabase;
import com.tencent.wcdb.compat.SQLiteStatement;
import com.tencent.wcdb.core.Handle;

public final class DatabaseUtils {
    private DatabaseUtils() {
    }

    public static long longForQuery(SQLiteDatabase db, String sql, Object[] selectionArgs) {
        try (SQLiteStatement stmt = db.compileStatement(sql);){
            stmt.bindAllArgs(selectionArgs);
            long l = stmt.simpleQueryForLong();
            return l;
        }
    }

    public static String stringForQuery(SQLiteDatabase db, String sql, Object[] selectionArgs) {
        try (SQLiteStatement stmt = db.compileStatement(sql);){
            stmt.bindAllArgs(selectionArgs);
            String string = stmt.simpleQueryForString();
            return string;
        }
    }

    static void bindCancellationSignal(Handle handle, CancellationSignal cancellationSignal) {
        if (cancellationSignal == null) {
            return;
        }
        final Handle.CancellationSignal cs = new Handle.CancellationSignal();
        cancellationSignal.setOnCancelListener(new CancellationSignal.OnCancelListener(){

            public void onCancel() {
                cs.cancel();
            }
        });
        if (cancellationSignal.isCanceled()) {
            cs.cancel();
        }
        handle.attachCancellationSignal(cs);
    }
}

