/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wcdb.compat;

import android.database.sqlite.SQLiteClosable;
import android.database.sqlite.SQLiteDoneException;
import android.os.CancellationSignal;
import com.tencent.wcdb.base.Value;
import com.tencent.wcdb.compat.DatabaseUtils;
import com.tencent.wcdb.core.Database;
import com.tencent.wcdb.core.Handle;
import com.tencent.wcdb.core.PreparedStatement;
import java.util.ArrayList;
import java.util.Arrays;

public final class SQLiteStatement
extends SQLiteClosable {
    private final Database mDB;
    private final String mSql;
    private final ArrayList<Object> mBindArgs = new ArrayList();

    SQLiteStatement(Database db, String sql, Object[] bindArgs) {
        this.mDB = db;
        this.mSql = sql;
        if (bindArgs != null) {
            this.mBindArgs.addAll(Arrays.asList(bindArgs));
        }
    }

    private void execute(Handle handle, CancellationSignal cancellationSignal) {
        DatabaseUtils.bindCancellationSignal(handle, cancellationSignal);
        PreparedStatement stmt = handle.preparedWithMainStatement(this.mSql);
        int i = 1;
        for (Object arg : this.mBindArgs) {
            stmt.bindValue(new Value(arg), i++);
        }
        do {
            stmt.step();
        } while (!stmt.isDone());
        stmt.finalizeStatement();
    }

    private Value executeForValue(Handle handle, CancellationSignal cancellationSignal) {
        DatabaseUtils.bindCancellationSignal(handle, cancellationSignal);
        PreparedStatement stmt = handle.preparedWithMainStatement(this.mSql);
        int i = 1;
        for (Object arg : this.mBindArgs) {
            stmt.bindValue(new Value(arg), i++);
        }
        stmt.step();
        if (stmt.isDone()) {
            throw new SQLiteDoneException();
        }
        Value result = stmt.getValue(0);
        stmt.finalizeStatement();
        return result;
    }

    public void execute() {
        this.execute(null);
    }

    public void execute(CancellationSignal cancellationSignal) {
        try (Handle handle = this.mDB.getHandle(true);){
            this.execute(handle, cancellationSignal);
        }
    }

    public int executeUpdateDelete() {
        return this.executeUpdateDelete(null);
    }

    public int executeUpdateDelete(CancellationSignal cancellationSignal) {
        try (Handle handle = this.mDB.getHandle(true);){
            this.execute(handle, cancellationSignal);
            int n = handle.getChanges();
            return n;
        }
    }

    public long executeInsert() {
        return this.executeInsert(null);
    }

    public long executeInsert(CancellationSignal cancellationSignal) {
        try (Handle handle = this.mDB.getHandle(true);){
            this.execute(handle, cancellationSignal);
            long l = handle.getLastInsertedRowId();
            return l;
        }
    }

    public long simpleQueryForLong() {
        return this.simpleQueryForLong(null);
    }

    public long simpleQueryForLong(CancellationSignal cancellationSignal) {
        try (Handle handle = this.mDB.getHandle(true);){
            long l = this.executeForValue(handle, cancellationSignal).getLong();
            return l;
        }
    }

    public String simpleQueryForString() {
        return this.simpleQueryForString(null);
    }

    public String simpleQueryForString(CancellationSignal cancellationSignal) {
        try (Handle handle = this.mDB.getHandle(true);){
            String string = this.executeForValue(handle, cancellationSignal).getText();
            return string;
        }
    }

    public void bindNull(int index) {
        this.bind(index, null);
    }

    public void bindLong(int index, long value) {
        this.bind(index, value);
    }

    public void bindDouble(int index, double value) {
        this.bind(index, value);
    }

    public void bindString(int index, String value) {
        if (value == null) {
            throw new IllegalArgumentException("the bind value at index " + index + " is null");
        }
        this.bind(index, value);
    }

    public void bindBlob(int index, byte[] value) {
        if (value == null) {
            throw new IllegalArgumentException("the bind value at index " + index + " is null");
        }
        this.bind(index, value);
    }

    public void bindAllArgs(Object[] bindArgs) {
        if (bindArgs == null) {
            return;
        }
        int length = bindArgs.length;
        if (this.mBindArgs.size() < length) {
            this.mBindArgs.ensureCapacity(length);
            do {
                this.mBindArgs.add(null);
            } while (this.mBindArgs.size() < length);
        }
        for (int i = 0; i < length; ++i) {
            this.mBindArgs.set(i, bindArgs[i]);
        }
    }

    public void clearBindings() {
        this.mBindArgs.clear();
    }

    protected void onAllReferencesReleased() {
        this.clearBindings();
    }

    private void bind(int index, Object value) {
        if (index < 1) {
            throw new IllegalArgumentException("Cannot bind argument at index " + index + " because the index is out of range.");
        }
        if (this.mBindArgs.size() < index) {
            this.mBindArgs.ensureCapacity(index);
            do {
                this.mBindArgs.add(null);
            } while (this.mBindArgs.size() < index);
        }
        this.mBindArgs.set(index - 1, value);
    }

    public String toString() {
        return "SQLiteProgram: " + this.mSql;
    }
}

