/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wcdb.compat;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteClosable;
import android.database.sqlite.SQLiteQueryBuilder;
import android.database.sqlite.SQLiteTransactionListener;
import android.os.CancellationSignal;
import android.os.OperationCanceledException;
import android.text.TextUtils;
import com.tencent.wcdb.base.Value;
import com.tencent.wcdb.base.WCDBException;
import com.tencent.wcdb.base.WCDBInterruptException;
import com.tencent.wcdb.compat.DatabaseErrorHandler;
import com.tencent.wcdb.compat.DatabaseUtils;
import com.tencent.wcdb.compat.SQLiteCipherSpec;
import com.tencent.wcdb.compat.SQLiteStatement;
import com.tencent.wcdb.compat.ValueCursor;
import com.tencent.wcdb.core.Database;
import com.tencent.wcdb.core.Handle;
import com.tencent.wcdb.core.PreparedStatement;
import com.tencent.wcdb.winq.Statement;
import com.tencent.wcdb.winq.StatementInsert;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class SQLiteDatabase
extends SQLiteClosable {
    private final Database mDB;
    public static final int CONFLICT_ROLLBACK = 1;
    public static final int CONFLICT_ABORT = 2;
    public static final int CONFLICT_FAIL = 3;
    public static final int CONFLICT_IGNORE = 4;
    public static final int CONFLICT_REPLACE = 5;
    public static final int CONFLICT_NONE = 0;
    private static final String[] CONFLICT_VALUES = new String[]{"", " OR ROLLBACK ", " OR ABORT ", " OR FAIL ", " OR IGNORE ", " OR REPLACE "};
    private final ThreadLocal<Transaction> mTransactionStack = new ThreadLocal();
    private volatile boolean isOpen = false;
    private static final Database.CipherVersion[] kCipherVersionMapping = Database.CipherVersion.values();
    private static final DatabaseErrorHandler sDefaultErrorHandler = new DatabaseErrorHandler(){

        @Override
        public void onCorruption(SQLiteDatabase dbObj) {
            Database db = dbObj.getInnerDB();
            db.removeFiles();
        }
    };

    SQLiteDatabase(Database db) {
        this.mDB = db;
    }

    public Database getInnerDB() {
        return this.mDB;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    protected void onAllReferencesReleased() {
        this.mDB.close(new Database.CloseCallBack(){

            public void onClose() throws WCDBException {
                SQLiteDatabase.this.isOpen = false;
            }
        });
    }

    public static int releaseMemory() {
        Database.purgeAll();
        return 0;
    }

    private static void throwIfNoTransaction(Transaction stack) {
        if (stack == null) {
            throw new IllegalStateException("Cannot perform this operation because there is no current transaction.");
        }
    }

    private static void throwIfTransactionMarkedSuccessful(Transaction stack) {
        if (stack != null && stack.markedSuccessful) {
            throw new IllegalStateException("Cannot perform this operation because the transaction has already been marked successful.  The only thing you can do now is call endTransaction().");
        }
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void beginTransaction() {
        this.beginTransactionWithListener(null);
    }

    public void beginTransactionNonExclusive() {
        this.beginTransactionWithListener(null);
    }

    public void beginTransactionWithListener(SQLiteTransactionListener transactionListener) {
        Transaction stack = this.mTransactionStack.get();
        SQLiteDatabase.throwIfTransactionMarkedSuccessful(stack);
        if (stack == null) {
            this.mDB.beginTransaction();
        }
        if (transactionListener != null) {
            try {
                transactionListener.onBegin();
            }
            catch (RuntimeException e) {
                if (stack == null) {
                    this.mDB.rollbackTransaction();
                }
                throw e;
            }
        }
        Transaction transaction = new Transaction();
        transaction.listener = transactionListener;
        transaction.parent = stack;
        this.mTransactionStack.set(transaction);
    }

    public void beginTransactionWithListenerNonExclusive(SQLiteTransactionListener transactionListener) {
        this.beginTransactionWithListener(transactionListener);
    }

    public void endTransaction() {
        Transaction stack = this.mTransactionStack.get();
        SQLiteDatabase.throwIfNoTransaction(stack);
        boolean successful = stack.markedSuccessful && !stack.childFailed;
        SQLiteTransactionListener listener = stack.listener;
        RuntimeException listenerException = null;
        if (listener != null) {
            try {
                if (successful) {
                    listener.onCommit();
                } else {
                    listener.onRollback();
                }
            }
            catch (RuntimeException e) {
                listenerException = e;
                successful = false;
            }
        }
        Transaction parent = stack.parent;
        this.mTransactionStack.set(parent);
        if (parent != null) {
            parent.childFailed = true;
        } else if (successful) {
            this.mDB.commitTransaction();
        } else {
            this.mDB.rollbackTransaction();
        }
        if (listenerException != null) {
            throw listenerException;
        }
    }

    public void setTransactionSuccessful() {
        Transaction stack = this.mTransactionStack.get();
        SQLiteDatabase.throwIfNoTransaction(stack);
        SQLiteDatabase.throwIfTransactionMarkedSuccessful(stack);
        stack.markedSuccessful = true;
    }

    public boolean inTransaction() {
        return this.mDB.isInTransaction();
    }

    public int getVersion() {
        return this.mDB.getValueFromSQL("PRAGMA user_version").getInt();
    }

    public void setVersion(int version) {
        this.mDB.execute("PRAGMA user_version = " + version);
    }

    public long getMaximumSize() {
        long pageCount = this.mDB.getValueFromSQL("PRAGMA max_page_count").getLong();
        return pageCount * this.getPageSize();
    }

    public long setMaximumSize(long numBytes) {
        long pageSize = this.getPageSize();
        long numPages = numBytes / pageSize;
        if (numBytes % pageSize != 0L) {
            ++numPages;
        }
        long newPageCount = this.mDB.getValueFromSQL("PRAGMA max_page_count = " + numPages).getLong();
        return newPageCount * pageSize;
    }

    public long getPageSize() {
        return this.mDB.getValueFromSQL("PRAGMA page_size").getLong();
    }

    public void setPageSize(long numBytes) {
        this.mDB.execute("PRAGMA page_size = " + numBytes);
    }

    public SQLiteStatement compileStatement(String sql) {
        return new SQLiteStatement(this.mDB, sql, null);
    }

    public Cursor query(boolean distinct, String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        return this.query(distinct, table, columns, selection, selectionArgs, groupBy, having, orderBy, limit, null);
    }

    public Cursor query(boolean distinct, String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit, CancellationSignal cancellationSignal) {
        String sql = SQLiteQueryBuilder.buildQueryString((boolean)distinct, (String)table, (String[])columns, (String)selection, (String)groupBy, (String)having, (String)orderBy, (String)limit);
        return this.rawQuery(sql, selectionArgs, cancellationSignal);
    }

    public Cursor query(String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy) {
        return this.query(false, table, columns, selection, selectionArgs, groupBy, having, orderBy, null);
    }

    public Cursor query(String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        return this.query(false, table, columns, selection, selectionArgs, groupBy, having, orderBy, limit);
    }

    public Cursor rawQuery(String sql, Object[] selectionArgs) {
        return this.rawQuery(sql, selectionArgs, null);
    }

    public Cursor rawQuery(String sql, Object[] selectionArgs, CancellationSignal cancellationSignal) {
        ValueCursor valueCursor;
        block11: {
            Handle handle = this.mDB.getHandle(false);
            try {
                int i;
                DatabaseUtils.bindCancellationSignal(handle, cancellationSignal);
                PreparedStatement stmt = handle.preparedWithMainStatement(sql);
                if (selectionArgs != null) {
                    int nArgs = selectionArgs.length;
                    for (i = 0; i < nArgs; ++i) {
                        stmt.bindValue(new Value(selectionArgs[i]), i + 1);
                    }
                }
                String[] columnNames = new String[stmt.getColumnCount()];
                for (i = 0; i < columnNames.length; ++i) {
                    columnNames[i] = stmt.getColumnName(i);
                }
                List result = stmt.getMultiRows();
                stmt.finalizeStatement();
                valueCursor = new ValueCursor(result, columnNames);
                if (handle == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (handle != null) {
                        try {
                            handle.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (WCDBInterruptException e) {
                    throw (OperationCanceledException)new OperationCanceledException().initCause((Throwable)e);
                }
            }
            handle.close();
        }
        return valueCursor;
    }

    public long insert(String table, String nullColumnHack, ContentValues values) {
        try {
            return this.insertWithOnConflict(table, nullColumnHack, values, 0);
        }
        catch (WCDBException e) {
            return -1L;
        }
    }

    public long insertOrThrow(String table, String nullColumnHack, ContentValues values) throws SQLException {
        return this.insertWithOnConflict(table, nullColumnHack, values, 0);
    }

    public long replace(String table, String nullColumnHack, ContentValues initialValues) {
        try {
            return this.insertWithOnConflict(table, nullColumnHack, initialValues, 5);
        }
        catch (SQLException e) {
            return -1L;
        }
    }

    public long replaceOrThrow(String table, String nullColumnHack, ContentValues initialValues) throws SQLException {
        return this.insertWithOnConflict(table, nullColumnHack, initialValues, 5);
    }

    public long insertWithOnConflict(String table, String nullColumnHack, ContentValues initialValues, int conflictAlgorithm) {
        String[] columns;
        Object[] bindArgs;
        int size;
        int n = size = initialValues != null && initialValues.size() > 0 ? initialValues.size() : 0;
        if (size > 0) {
            bindArgs = new Object[size];
            columns = new String[size];
            int i = 0;
            Iterator iterator = initialValues.keySet().iterator();
            while (iterator.hasNext()) {
                String colName;
                columns[i] = colName = (String)iterator.next();
                bindArgs[i++] = initialValues.get(colName);
            }
        } else {
            columns = new String[]{nullColumnHack};
            bindArgs = new Object[]{null};
        }
        StatementInsert insert = new StatementInsert().insertInto(table);
        switch (conflictAlgorithm) {
            case 0: {
                break;
            }
            case 1: {
                insert.orRollback();
                break;
            }
            case 2: {
                insert.orAbort();
                break;
            }
            case 3: {
                insert.orFail();
                break;
            }
            case 4: {
                insert.orIgnore();
                break;
            }
            case 5: {
                insert.orReplace();
            }
        }
        insert.columns(columns).valuesWithBindParameters(bindArgs.length);
        try (Handle handle = this.mDB.getHandle(true);){
            PreparedStatement stmt = handle.preparedWithMainStatement((Statement)insert);
            for (int i = 0; i < bindArgs.length; ++i) {
                stmt.bindValue(new Value(bindArgs[i]), i + 1);
            }
            do {
                stmt.step();
            } while (!stmt.isDone());
            stmt.finalizeStatement();
            long l = handle.getLastInsertedRowId();
            return l;
        }
    }

    public int delete(String table, String whereClause, String[] whereArgs) {
        String sql = "DELETE FROM " + table + (!TextUtils.isEmpty((CharSequence)whereClause) ? " WHERE " + whereClause : "");
        try (Handle handle = this.mDB.getHandle(true);){
            PreparedStatement stmt = handle.preparedWithMainStatement(sql);
            for (int i = 0; i < whereArgs.length; ++i) {
                stmt.bindText(whereArgs[i], i + 1);
            }
            do {
                stmt.step();
            } while (!stmt.isDone());
            stmt.finalizeStatement();
            int n = handle.getChanges();
            return n;
        }
    }

    public int update(String table, ContentValues values, String whereClause, String[] whereArgs) {
        return this.updateWithOnConflict(table, values, whereClause, whereArgs, 0);
    }

    public int updateWithOnConflict(String table, ContentValues values, String whereClause, String[] whereArgs, int conflictAlgorithm) {
        StringBuilder sql = new StringBuilder(120);
        sql.append("UPDATE ");
        sql.append(CONFLICT_VALUES[conflictAlgorithm]);
        sql.append(table);
        sql.append(" SET ");
        int setValuesSize = values.size();
        int bindArgsSize = whereArgs == null ? setValuesSize : setValuesSize + whereArgs.length;
        Object[] bindArgs = new Object[bindArgsSize];
        int i = 0;
        for (String colName : values.keySet()) {
            sql.append(i > 0 ? "," : "");
            sql.append(colName);
            bindArgs[i++] = values.get(colName);
            sql.append("=?");
        }
        if (whereArgs != null) {
            for (i = setValuesSize; i < bindArgsSize; ++i) {
                bindArgs[i] = whereArgs[i - setValuesSize];
            }
        }
        if (!TextUtils.isEmpty((CharSequence)whereClause)) {
            sql.append(" WHERE ");
            sql.append(whereClause);
        }
        try (Handle handle = this.mDB.getHandle(true);){
            PreparedStatement stmt = handle.preparedWithMainStatement(sql.toString());
            for (i = 0; i < bindArgsSize; ++i) {
                stmt.bindValue(new Value(bindArgs[i]), i + 1);
            }
            do {
                stmt.step();
            } while (!stmt.isDone());
            stmt.finalizeStatement();
            int n = handle.getChanges();
            return n;
        }
    }

    public void execSQL(String sql) {
        this.execSQL(sql, null);
    }

    public void execSQL(String sql, Object[] bindArgs) {
        this.execSQL(sql, bindArgs, null);
    }

    public void execSQL(String sql, Object[] bindArgs, CancellationSignal cancellationSignal) {
        try (SQLiteStatement stmt = new SQLiteStatement(this.mDB, sql, bindArgs);){
            stmt.execute(cancellationSignal);
        }
    }

    public String getPath() {
        return this.mDB.getPath();
    }

    public String toString() {
        return "SQLiteDatabase: " + this.getPath();
    }

    public static SQLiteDatabase wrap(Database db) {
        SQLiteDatabase dbObj = new SQLiteDatabase(db);
        dbObj.isOpen = db.canOpen();
        return dbObj;
    }

    public static SQLiteDatabase openDatabase(String path) {
        return SQLiteDatabase.openDatabase(path, null, null, null);
    }

    public static SQLiteDatabase openDatabase(String path, DatabaseErrorHandler errorHandler) {
        return SQLiteDatabase.openDatabase(path, null, null, errorHandler);
    }

    public static SQLiteDatabase openDatabase(String path, byte[] password, SQLiteCipherSpec cipher) {
        return SQLiteDatabase.openDatabase(path, password, cipher, null);
    }

    public static SQLiteDatabase openDatabase(String path, byte[] password, final SQLiteCipherSpec cipher, final DatabaseErrorHandler errorHandler) {
        Database db = new Database(path);
        if (password != null) {
            if (cipher == null) {
                db.setCipherKey(password);
            } else if (cipher.cipherVersion >= 0) {
                db.setCipherKey(password, cipher.pageSize, kCipherVersionMapping[cipher.cipherVersion]);
            } else {
                db.setCipherKey(password, cipher.pageSize);
                db.setConfig("com.Tencent.WCDB.Config.CipherSpecCompat", new Database.Config(){

                    public void onInvocation(@NotNull Handle handle) throws WCDBException {
                        handle.execute("PRAGMA cipher_use_hmac = " + cipher.hmacEnabled);
                        if (cipher.kdfIteration != 0) {
                            handle.execute("PRAGMA kdf_iter = " + cipher.kdfIteration);
                        }
                        if (cipher.hmacAlgorithm != -1) {
                            handle.execute("PRAGMA cipher_hmac_algorithm = " + SQLiteCipherSpec.HMAC_ALGO_MAPPING[cipher.hmacAlgorithm]);
                        }
                        if (cipher.kdfAlgorithm != -1) {
                            handle.execute("PRAGMA cipher_kdf_algorithm = " + SQLiteCipherSpec.PBKDF2_ALGO_MAPPING[cipher.kdfAlgorithm]);
                        }
                    }
                }, Database.ConfigPriority.highest);
            }
        }
        final SQLiteDatabase dbObj = new SQLiteDatabase(db);
        Database.CorruptionNotification corruptionNotification = new Database.CorruptionNotification(){
            private final DatabaseErrorHandler mHandler;
            {
                this.mHandler = errorHandler == null ? sDefaultErrorHandler : errorHandler;
            }

            public void onCorrupted(Database database) {
                this.mHandler.onCorruption(dbObj);
            }
        };
        db.setNotificationWhenCorrupted(corruptionNotification);
        if (!db.canOpen()) {
            corruptionNotification.onCorrupted(db);
            Handle handle = db.getHandle();
            handle.invalidate();
        }
        dbObj.isOpen = true;
        return dbObj;
    }

    private static final class Transaction {
        Transaction parent;
        SQLiteTransactionListener listener;
        boolean markedSuccessful;
        boolean childFailed;

        private Transaction() {
        }
    }
}

