/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wcdb.compiler;

import com.tencent.wcdb.compiler.JavaFieldORMInfo;
import com.tencent.wcdb.compiler.resolvedInfo.ColumnInfo;
import com.tencent.wcdb.compiler.resolvedInfo.FTSModuleInfo;
import com.tencent.wcdb.compiler.resolvedInfo.MultiIndexesInfo;
import com.tencent.wcdb.compiler.resolvedInfo.MultiPrimaryInfo;
import com.tencent.wcdb.compiler.resolvedInfo.MultiUniqueInfo;
import com.tencent.wcdb.compiler.resolvedInfo.TableConfigInfo;
import java.util.List;

public class JavaCodeGenerator {
    public String packageName;
    public String className;
    public String ormClassName;
    public TableConfigInfo tableConstraintInfo;
    public List<ColumnInfo> allColumnInfo;
    private StringBuilder builder;
    private static final String TAB = "\t";

    public String generate() {
        this.builder = new StringBuilder();
        this.builder.append("package ").append(this.packageName).append(";\n\n");
        this.generateImport();
        this.builder.append("public class ").append(this.ormClassName).append(" implements TableBinding<").append(this.className).append("> {\n");
        this.builder.append("\tprivate static final Binding baseBinding;\n");
        this.builder.append("\tpublic static final ").append(this.ormClassName).append(" INSTANCE;\n\n");
        this.generateFields();
        this.builder.append("\n");
        this.builder.append("\tstatic {\n\n");
        this.builder.append("\t\tbaseBinding = new Binding();\n");
        this.builder.append("\t\tINSTANCE = new ").append(this.ormClassName).append("();\n\n");
        this.generateColumns();
        this.generateTableConfig();
        this.builder.append("\t}\n\n");
        this.generateBindingType();
        this.generateBindingFields();
        this.generateBaseBinding();
        this.generateExtractObject();
        this.generateBindObject();
        this.generateAutoIncrementConfig();
        this.builder.append("}");
        return this.builder.toString();
    }

    private void generateImport() {
        this.builder.append("import com.tencent.wcdb.core.PreparedStatement;\n");
        this.builder.append("import com.tencent.wcdb.orm.*;\n");
        this.builder.append("import com.tencent.wcdb.winq.Column;\n");
        this.builder.append("import com.tencent.wcdb.winq.ColumnConstraint;\n");
        this.builder.append("import com.tencent.wcdb.winq.ColumnDef;\n");
        this.builder.append("import com.tencent.wcdb.winq.ColumnType;\n");
        this.builder.append("import com.tencent.wcdb.winq.StatementCreateIndex;\n");
        this.builder.append("import com.tencent.wcdb.winq.TableConstraint;\n\n");
    }

    private void generateFields() {
        for (ColumnInfo info : this.allColumnInfo) {
            this.builder.append("\tpublic static final Field<").append(this.className).append("> ").append(info.getPropertyName()).append(";\n");
        }
    }

    private void generateColumns() {
        int fieldId = 1;
        for (ColumnInfo columnInfo : this.allColumnInfo) {
            JavaFieldORMInfo ormInfo = JavaFieldORMInfo.allInfo.get(columnInfo.getPropertyType());
            assert (ormInfo != null);
            String propertyName = columnInfo.getPropertyName();
            String columnName = columnInfo.getColumnName();
            if (columnName.length() == 0) {
                columnName = propertyName;
            }
            this.builder.append("\t\t").append(propertyName).append(" = new Field(\"").append(columnName).append("\", INSTANCE, ").append(fieldId).append(", ").append(columnInfo.isPrimary() && columnInfo.isAutoIncrement()).append(", ").append(columnInfo.isPrimary()).append(");\n");
            ++fieldId;
            this.builder.append("\t\tColumnDef ").append(propertyName).append("Def = new ColumnDef(").append(propertyName).append(", ColumnType.").append(ormInfo.columnType).append(");\n");
            String constraintPrefix = "\t\t" + propertyName + "Def.constraint(new ColumnConstraint()";
            if (columnInfo.isPrimary()) {
                this.builder.append(constraintPrefix).append(".primaryKey()").append(columnInfo.isAutoIncrement() ? ".autoIncrement());\n" : ");\n");
            }
            if (columnInfo.getDefaultValue() != null) {
                if (ormInfo.columnType.equals("Integer")) {
                    this.builder.append(constraintPrefix).append(".defaultTo(").append(columnInfo.getDefaultValue().getIntValue()).append("));\n");
                } else if (ormInfo.columnType.equals("Float")) {
                    this.builder.append(constraintPrefix).append(".defaultTo(").append(columnInfo.getDefaultValue().getDoubleValue()).append("));\n");
                } else {
                    this.builder.append(constraintPrefix).append(".defaultTo(\"").append(columnInfo.getDefaultValue().getTextValue()).append("\"));\n");
                }
            }
            if (columnInfo.isUnique()) {
                this.builder.append(constraintPrefix).append(".unique()").append(");\n");
            }
            if (columnInfo.isNotNull()) {
                this.builder.append(constraintPrefix).append(".notNull()").append(");\n");
            }
            if (columnInfo.isNotIndexed()) {
                this.builder.append(constraintPrefix).append(".unIndex()").append(");\n");
            }
            this.builder.append("\t\tbaseBinding.addColumnDef(").append(propertyName).append("Def);\n");
            if (columnInfo.getEnableAutoIncrementForExistingTable()) {
                this.builder.append("\t\tbaseBinding.enableAutoIncrementForExistingTable();\n");
            }
            if (!columnInfo.getHasIndex()) continue;
            String indexName = columnInfo.getIndexName();
            boolean isFullName = true;
            if (indexName.length() == 0) {
                isFullName = false;
                indexName = "_" + columnName + "_index";
            }
            this.builder.append("\t\tbaseBinding.addIndex(\"").append(indexName).append("\", ").append(isFullName).append(", new StatementCreateIndex().ifNotExist()");
            if (columnInfo.getIndexIsUnique()) {
                this.builder.append(".unique()");
            }
            this.builder.append(".indexedBy(").append(propertyName).append("));\n\n");
        }
    }

    private void generateTableConfig() {
        FTSModuleInfo ftsModuleInfo;
        for (MultiIndexesInfo indexes : this.tableConstraintInfo.getMultiIndexes()) {
            String indexName = indexes.getName();
            boolean isFullName = true;
            if (indexName.length() == 0) {
                isFullName = false;
                indexName = "_" + String.join((CharSequence)"_", indexes.getColumns()) + "_index";
            }
            this.builder.append("\t\tbaseBinding.addIndex(\"").append(indexName).append("\", ").append(isFullName).append(", new StatementCreateIndex().ifNotExist().indexedBy(new Column[]{\n\t\t\t");
            for (String column : indexes.getColumns()) {
                this.builder.append(column).append(", ");
            }
            this.builder.append("\n\t\t}));\n");
        }
        for (MultiPrimaryInfo primaries : this.tableConstraintInfo.getMultiPrimaries()) {
            this.builder.append("\t\tbaseBinding.addTableConstraint(new TableConstraint().primaryKey().indexedBy(new Column[]{\n\t\t\t");
            for (String column : primaries.getColumns()) {
                this.builder.append(column).append(", ");
            }
            this.builder.append("\n\t\t}));\n");
        }
        for (MultiUniqueInfo uniques : this.tableConstraintInfo.getMultiUnique()) {
            this.builder.append("\t\tbaseBinding.addTableConstraint(new TableConstraint().unique().indexedBy(new Column[]{\n\t\t\t");
            for (String column : uniques.getColumns()) {
                this.builder.append(column).append(", ");
            }
            this.builder.append("\n\t\t}));\n");
        }
        if (this.tableConstraintInfo.isWithoutRowId()) {
            this.builder.append("\t\tbaseBinding.configWithoutRowId();\n");
        }
        if ((ftsModuleInfo = this.tableConstraintInfo.getFtsModule()) == null || ftsModuleInfo.getFtsVersion().isEmpty()) {
            return;
        }
        this.builder.append("\t\tbaseBinding.configVirtualModule(\"").append(ftsModuleInfo.getFtsVersion()).append("\");\n");
        StringBuilder tokenizer = new StringBuilder("tokenize = ");
        tokenizer.append(ftsModuleInfo.getTokenizer());
        for (String para : ftsModuleInfo.getTokenizerParameters()) {
            tokenizer.append(" ").append(para);
        }
        this.builder.append("\t\tbaseBinding.configVirtualModuleArgument(\"").append((CharSequence)tokenizer).append("\");\n");
        if (!ftsModuleInfo.getExternalTable().isEmpty()) {
            this.builder.append("\t\tbaseBinding.configVirtualModuleArgument(\"content='").append(ftsModuleInfo.getExternalTable()).append("'\");\n");
        }
    }

    private void generateBindingType() {
        this.builder.append("\t@Override\n");
        this.builder.append("\tpublic Class<").append(this.className).append("> bindingType() {\n");
        this.builder.append("\t\treturn ").append(this.className).append(".class;\n");
        this.builder.append("\t}\n\n");
    }

    private void generateBindingFields() {
        this.builder.append("\t@Override\n");
        this.builder.append("\tpublic Field<").append(this.className).append(">[] allBindingFields() {\n");
        this.builder.append("\t\treturn new Field[]{");
        for (ColumnInfo columnInfo : this.allColumnInfo) {
            this.builder.append(columnInfo.getPropertyName()).append(", ");
        }
        this.builder.append("};\n\t}\n\n");
        this.builder.append("\tpublic static Field<").append(this.className).append(">[] allFields() {\n");
        this.builder.append("\t\treturn new Field[]{");
        for (ColumnInfo columnInfo : this.allColumnInfo) {
            this.builder.append(columnInfo.getPropertyName()).append(", ");
        }
        this.builder.append("};\n\t}\n\n");
    }

    private void generateBaseBinding() {
        this.builder.append("\t@Override\n");
        this.builder.append("\tpublic Binding baseBinding() {\n");
        this.builder.append("\t\treturn baseBinding;\n");
        this.builder.append("\t}\n\n");
    }

    private void generateExtractObject() {
        this.builder.append("\t@Override\n");
        this.builder.append("\tpublic <R extends ").append(this.className).append("> R extractObject(Field<").append(this.className).append(">[] fields, PreparedStatement preparedStatement, Class<R> cls) throws ReflectiveOperationException {\n");
        this.builder.append("\t\tR newOne = cls.newInstance();\n");
        this.builder.append("\t\tint index = 0;\n");
        this.builder.append("\t\tfor(Field<").append(this.className).append("> field : fields) {\n");
        this.builder.append("\t\t\tswitch (field.getFieldId()) {\n");
        int index = 1;
        for (ColumnInfo columnInfo : this.allColumnInfo) {
            JavaFieldORMInfo info = JavaFieldORMInfo.allInfo.get(columnInfo.getPropertyType());
            assert (info != null);
            this.builder.append("\t\t\t\tcase ").append(index).append(":\n");
            if (info.nullable) {
                this.builder.append("\t\t\t\t\tif (preparedStatement.getColumnType(index) != ColumnType.Null) {\n");
                this.builder.append("\t\t\t\t\t\tnewOne.").append(columnInfo.getPropertyName()).append(" = ").append(info.fieldSetter).append("(index);\n");
                this.builder.append("\t\t\t\t\t}\n");
            } else {
                this.builder.append("\t\t\t\t\tnewOne.").append(columnInfo.getPropertyName()).append(" = ").append(info.fieldSetter).append("(index);\n");
            }
            this.builder.append("\t\t\t\t\tbreak;\n");
            ++index;
        }
        this.builder.append("\t\t\t\tdefault:\n");
        this.builder.append("\t\t\t\t\tassert false : \"Invalid id \" + field.getFieldId() + \" of field \" + field.getDescription() + \" in ").append(this.className).append(".\";\n");
        this.builder.append("\t\t\t}\n");
        this.builder.append("\t\t\tindex++;\n");
        this.builder.append("\t\t}\n");
        this.builder.append("\t\treturn newOne;\n");
        this.builder.append("\t}\n\n");
    }

    private void generateBindObject() {
        this.builder.append("\t@Override\n");
        this.builder.append("\tpublic void bindField(").append(this.className).append(" object, Field<").append(this.className).append("> field, int index, PreparedStatement preparedStatement) {\n");
        this.builder.append("\t\tswitch (field.getFieldId()) {\n");
        int index = 1;
        for (ColumnInfo columnInfo : this.allColumnInfo) {
            String type = columnInfo.getPropertyType();
            JavaFieldORMInfo info = JavaFieldORMInfo.allInfo.get(type);
            String field = columnInfo.getPropertyName();
            assert (info != null);
            this.builder.append("\t\t\tcase ").append(index).append(":\n");
            if (info.nullable) {
                this.builder.append("\t\t\t\tif ( object.").append(field).append(" != null ) {\n");
                this.builder.append("\t\t\t\t\tpreparedStatement.").append(info.fieldGetter).append("(object.").append(field).append(", index);\n");
                this.builder.append("\t\t\t\t} else {\n");
                this.builder.append("\t\t\t\t\tpreparedStatement.bindNull(index);\n");
                this.builder.append("\t\t\t\t}\n");
            } else {
                this.builder.append("\t\t\t\tpreparedStatement.").append(info.fieldGetter).append("(object.").append(field).append(", index);\n");
            }
            this.builder.append("\t\t\t\tbreak;\n");
            ++index;
        }
        this.builder.append("\t\t\tdefault:\n");
        this.builder.append("\t\t\t\tassert false : \"Invalid id \" + field.getFieldId() + \" of field \" + field.getDescription() + \" in ").append(this.className).append(".\";\n");
        this.builder.append("\t\t}\n");
        this.builder.append("\t}\n\n");
    }

    private void generateAutoIncrementConfig() {
        this.builder.append("\t@Override\n");
        this.builder.append("\tpublic boolean isAutoIncrement(").append(this.className).append(" object) {\n");
        ColumnInfo autoIncrementColumn = null;
        for (ColumnInfo info : this.allColumnInfo) {
            if (!info.isAutoIncrement() || !info.isPrimary()) continue;
            autoIncrementColumn = info;
            break;
        }
        if (autoIncrementColumn != null) {
            this.builder.append("\t\treturn object.").append(autoIncrementColumn.getPropertyName()).append(" == 0;\n");
        } else {
            this.builder.append("\t\treturn false;\n");
        }
        this.builder.append("\t}\n\n");
        this.builder.append("\t@Override\n");
        this.builder.append("\tpublic void setLastInsertRowId(").append(this.className).append(" object, long lastInsertRowId) {\n");
        if (autoIncrementColumn != null) {
            this.builder.append("\t\tobject.").append(autoIncrementColumn.getPropertyName()).append(" = (").append(autoIncrementColumn.getPropertyType()).append(") lastInsertRowId;\n");
        }
        this.builder.append("\t}\n\n");
    }
}

