/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wcdb.compiler;

import com.tencent.wcdb.compiler.KotlinPropertyORMInfo;
import com.tencent.wcdb.compiler.KotlinPropertyORMInfoKt;
import com.tencent.wcdb.compiler.resolvedInfo.ColumnInfo;
import com.tencent.wcdb.compiler.resolvedInfo.DefaultValueInfo;
import com.tencent.wcdb.compiler.resolvedInfo.FTSModuleInfo;
import com.tencent.wcdb.compiler.resolvedInfo.MultiIndexesInfo;
import com.tencent.wcdb.compiler.resolvedInfo.MultiPrimaryInfo;
import com.tencent.wcdb.compiler.resolvedInfo.MultiUniqueInfo;
import com.tencent.wcdb.compiler.resolvedInfo.TableConfigInfo;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001f\u001a\u00020\u000eJ\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020!H\u0002J\b\u0010#\u001a\u00020!H\u0002J\b\u0010$\u001a\u00020!H\u0002J\b\u0010%\u001a\u00020!H\u0002J\b\u0010&\u001a\u00020!H\u0002J\b\u0010'\u001a\u00020!H\u0002J\b\u0010(\u001a\u00020!H\u0002J\b\u0010)\u001a\u00020!H\u0002J\b\u0010*\u001a\u00020!H\u0002R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00060\u000bj\u0002`\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u001a\u0010\u0016\u001a\u00020\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0010\"\u0004\b\u0018\u0010\u0012R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006+"}, d2={"Lcom/tencent/wcdb/compiler/KotlinCodeGenerator;", "", "()V", "allColumnInfo", "", "Lcom/tencent/wcdb/compiler/resolvedInfo/ColumnInfo;", "getAllColumnInfo", "()Ljava/util/List;", "setAllColumnInfo", "(Ljava/util/List;)V", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "className", "", "getClassName", "()Ljava/lang/String;", "setClassName", "(Ljava/lang/String;)V", "ormClassName", "getOrmClassName", "setOrmClassName", "packageName", "getPackageName", "setPackageName", "tableConstraintInfo", "Lcom/tencent/wcdb/compiler/resolvedInfo/TableConfigInfo;", "getTableConstraintInfo", "()Lcom/tencent/wcdb/compiler/resolvedInfo/TableConfigInfo;", "setTableConstraintInfo", "(Lcom/tencent/wcdb/compiler/resolvedInfo/TableConfigInfo;)V", "generate", "generateAutoIncrementConfig", "", "generateBaseBinding", "generateBindObject", "generateBindingFields", "generateBindingType", "generateColumns", "generateExtractObject", "generateFields", "generateImport", "generateTableConfig", "compiler"})
public final class KotlinCodeGenerator {
    public String packageName;
    public String className;
    public String ormClassName;
    public TableConfigInfo tableConstraintInfo;
    public List<ColumnInfo> allColumnInfo;
    private StringBuilder builder;

    @NotNull
    public final String getPackageName() {
        String string = this.packageName;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"packageName");
        return null;
    }

    public final void setPackageName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.packageName = string;
    }

    @NotNull
    public final String getClassName() {
        String string = this.className;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"className");
        return null;
    }

    public final void setClassName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.className = string;
    }

    @NotNull
    public final String getOrmClassName() {
        String string = this.ormClassName;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"ormClassName");
        return null;
    }

    public final void setOrmClassName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.ormClassName = string;
    }

    @NotNull
    public final TableConfigInfo getTableConstraintInfo() {
        TableConfigInfo tableConfigInfo = this.tableConstraintInfo;
        if (tableConfigInfo != null) {
            return tableConfigInfo;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"tableConstraintInfo");
        return null;
    }

    public final void setTableConstraintInfo(@NotNull TableConfigInfo tableConfigInfo) {
        Intrinsics.checkNotNullParameter((Object)tableConfigInfo, (String)"<set-?>");
        this.tableConstraintInfo = tableConfigInfo;
    }

    @NotNull
    public final List<ColumnInfo> getAllColumnInfo() {
        List<ColumnInfo> list = this.allColumnInfo;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"allColumnInfo");
        return null;
    }

    public final void setAllColumnInfo(@NotNull List<ColumnInfo> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.allColumnInfo = list;
    }

    @NotNull
    public final String generate() {
        this.builder = new StringBuilder();
        StringBuilder stringBuilder = this.builder;
        if (stringBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder = null;
        }
        stringBuilder.append("package " + this.getPackageName() + "\n\n");
        this.generateImport();
        StringBuilder stringBuilder2 = this.builder;
        if (stringBuilder2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder2 = null;
        }
        stringBuilder2.append("object " + this.getOrmClassName() + ": TableBinding<" + this.getClassName() + "> {\n");
        StringBuilder stringBuilder3 = this.builder;
        if (stringBuilder3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder3 = null;
        }
        stringBuilder3.append("\tprivate final val baseBinding: Binding\n");
        this.generateFields();
        StringBuilder stringBuilder4 = this.builder;
        if (stringBuilder4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder4 = null;
        }
        stringBuilder4.append("\n\tinit {\n");
        StringBuilder stringBuilder5 = this.builder;
        if (stringBuilder5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder5 = null;
        }
        stringBuilder5.append("\t\tbaseBinding = Binding()\n");
        this.generateColumns();
        this.generateTableConfig();
        StringBuilder stringBuilder6 = this.builder;
        if (stringBuilder6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder6 = null;
        }
        stringBuilder6.append("\t}\n\n");
        this.generateBindingType();
        this.generateBindingFields();
        this.generateBaseBinding();
        this.generateExtractObject();
        this.generateBindObject();
        this.generateAutoIncrementConfig();
        StringBuilder stringBuilder7 = this.builder;
        if (stringBuilder7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder7 = null;
        }
        stringBuilder7.append("}\n\n");
        StringBuilder stringBuilder8 = this.builder;
        if (stringBuilder8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder8 = null;
        }
        String string = stringBuilder8.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    private final void generateImport() {
        StringBuilder stringBuilder = this.builder;
        if (stringBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder = null;
        }
        stringBuilder.append("import com.tencent.wcdb.core.PreparedStatement\n");
        StringBuilder stringBuilder2 = this.builder;
        if (stringBuilder2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder2 = null;
        }
        stringBuilder2.append("import com.tencent.wcdb.orm.*\n");
        StringBuilder stringBuilder3 = this.builder;
        if (stringBuilder3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder3 = null;
        }
        stringBuilder3.append("import com.tencent.wcdb.winq.Column\n");
        StringBuilder stringBuilder4 = this.builder;
        if (stringBuilder4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder4 = null;
        }
        stringBuilder4.append("import com.tencent.wcdb.winq.ColumnConstraint\n");
        StringBuilder stringBuilder5 = this.builder;
        if (stringBuilder5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder5 = null;
        }
        stringBuilder5.append("import com.tencent.wcdb.winq.ColumnDef\n");
        StringBuilder stringBuilder6 = this.builder;
        if (stringBuilder6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder6 = null;
        }
        stringBuilder6.append("import com.tencent.wcdb.winq.ColumnType\n");
        StringBuilder stringBuilder7 = this.builder;
        if (stringBuilder7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder7 = null;
        }
        stringBuilder7.append("import com.tencent.wcdb.winq.StatementCreateIndex\n");
        StringBuilder stringBuilder8 = this.builder;
        if (stringBuilder8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder8 = null;
        }
        stringBuilder8.append("import com.tencent.wcdb.winq.TableConstraint\n\n");
    }

    private final void generateFields() {
        Iterator<ColumnInfo> iterator = this.getAllColumnInfo().iterator();
        while (iterator.hasNext()) {
            String propertyName = iterator.next().component1();
            StringBuilder stringBuilder = this.builder;
            if (stringBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                stringBuilder = null;
            }
            stringBuilder.append("\t@JvmField\n");
            StringBuilder stringBuilder2 = this.builder;
            if (stringBuilder2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                stringBuilder2 = null;
            }
            stringBuilder2.append("\tfinal val " + propertyName + " : Field<" + this.getClassName() + ">\n");
        }
    }

    private final void generateColumns() {
        int fieldId = 1;
        for (ColumnInfo columnInfo : this.getAllColumnInfo()) {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2;
            StringBuilder stringBuilder3;
            KotlinPropertyORMInfo ormInfo;
            StringBuilder stringBuilder4;
            Intrinsics.checkNotNull((Object)KotlinPropertyORMInfoKt.getAllKotlinPropertyORMInfo().get(columnInfo.getPropertyType()));
            String propertyName = columnInfo.getPropertyName();
            String columnName = columnInfo.getColumnName();
            if (((CharSequence)columnName).length() == 0) {
                columnName = propertyName;
            }
            if ((stringBuilder4 = this.builder) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                stringBuilder4 = null;
            }
            stringBuilder4.append("\t\t" + propertyName + " = Field(\"" + columnName + "\", this, " + fieldId + ", " + (columnInfo.isPrimary() && columnInfo.isAutoIncrement()) + ", " + columnInfo.isPrimary() + ")\n");
            ++fieldId;
            StringBuilder stringBuilder5 = this.builder;
            if (stringBuilder5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                stringBuilder5 = null;
            }
            stringBuilder5.append("\t\tval " + propertyName + "Def = ColumnDef(" + propertyName + ", ColumnType." + ormInfo.getColumnType() + ")\n");
            String constraintPrefix = "\t\t" + propertyName + "Def.constraint(\n\t\t\tColumnConstraint()";
            if (columnInfo.isPrimary()) {
                StringBuilder stringBuilder6 = this.builder;
                if (stringBuilder6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                    stringBuilder6 = null;
                }
                stringBuilder6.append(constraintPrefix).append(".primaryKey()").append(columnInfo.isAutoIncrement() ? ".autoIncrement()\n\t\t)\n" : "\n\t\t)\n");
            }
            if (columnInfo.getDefaultValue() != null) {
                if (Intrinsics.areEqual((Object)ormInfo.getColumnType(), (Object)"Integer")) {
                    StringBuilder stringBuilder7 = this.builder;
                    if (stringBuilder7 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                        stringBuilder7 = null;
                    }
                    StringBuilder stringBuilder8 = stringBuilder7.append(constraintPrefix);
                    StringBuilder stringBuilder9 = new StringBuilder().append(".defaultTo(");
                    DefaultValueInfo defaultValueInfo = columnInfo.getDefaultValue();
                    Intrinsics.checkNotNull((Object)defaultValueInfo);
                    stringBuilder8.append(stringBuilder9.append(defaultValueInfo.getIntValue()).append(")\n\t\t)\n").toString());
                } else if (Intrinsics.areEqual((Object)ormInfo.getColumnType(), (Object)"Float")) {
                    StringBuilder stringBuilder10 = this.builder;
                    if (stringBuilder10 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                        stringBuilder10 = null;
                    }
                    StringBuilder stringBuilder11 = stringBuilder10.append(constraintPrefix);
                    StringBuilder stringBuilder12 = new StringBuilder().append(".defaultTo(");
                    DefaultValueInfo defaultValueInfo = columnInfo.getDefaultValue();
                    Intrinsics.checkNotNull((Object)defaultValueInfo);
                    stringBuilder11.append(stringBuilder12.append(defaultValueInfo.getDoubleValue()).append(")\n\t\t)\n").toString());
                } else {
                    StringBuilder stringBuilder13 = this.builder;
                    if (stringBuilder13 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                        stringBuilder13 = null;
                    }
                    StringBuilder stringBuilder14 = stringBuilder13.append(constraintPrefix);
                    StringBuilder stringBuilder15 = new StringBuilder().append(".defaultTo(\"");
                    DefaultValueInfo defaultValueInfo = columnInfo.getDefaultValue();
                    Intrinsics.checkNotNull((Object)defaultValueInfo);
                    stringBuilder14.append(stringBuilder15.append(defaultValueInfo.getTextValue()).append("\")\n\t\t)\n").toString());
                }
            }
            if (columnInfo.isUnique()) {
                StringBuilder stringBuilder16 = this.builder;
                if (stringBuilder16 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                    stringBuilder16 = null;
                }
                stringBuilder16.append(constraintPrefix).append(".unique()\n\t\t)\n");
            }
            if (columnInfo.isNotNull()) {
                StringBuilder stringBuilder17 = this.builder;
                if (stringBuilder17 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                    stringBuilder17 = null;
                }
                stringBuilder17.append(constraintPrefix).append(".notNull()\n\t\t)\n");
            }
            if (columnInfo.isNotIndexed()) {
                StringBuilder stringBuilder18 = this.builder;
                if (stringBuilder18 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                    stringBuilder18 = null;
                }
                stringBuilder18.append(constraintPrefix).append(".unIndex()\n\t\t)\n");
            }
            if ((stringBuilder3 = this.builder) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                stringBuilder3 = null;
            }
            stringBuilder3.append("\t\tbaseBinding.addColumnDef(" + propertyName + "Def)\n");
            if (columnInfo.getEnableAutoIncrementForExistingTable()) {
                StringBuilder stringBuilder19 = this.builder;
                if (stringBuilder19 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                    stringBuilder19 = null;
                }
                stringBuilder19.append("\t\tbaseBinding.enableAutoIncrementForExistingTable()\n");
            }
            if (!columnInfo.getHasIndex()) continue;
            String indexName = columnInfo.getIndexName();
            boolean isFullName = true;
            if (((CharSequence)indexName).length() == 0) {
                indexName = '_' + columnName + "_index";
                isFullName = false;
            }
            if ((stringBuilder2 = this.builder) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                stringBuilder2 = null;
            }
            stringBuilder2.append("\t\tbaseBinding.addIndex(\"" + indexName + "\" , " + isFullName + ", StatementCreateIndex().ifNotExist()");
            if (columnInfo.getIndexIsUnique()) {
                StringBuilder stringBuilder20 = this.builder;
                if (stringBuilder20 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                    stringBuilder20 = null;
                }
                stringBuilder20.append(".unique()");
            }
            if ((stringBuilder = this.builder) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                stringBuilder = null;
            }
            stringBuilder.append(".indexedBy(" + propertyName + "))\n\n");
        }
    }

    private final void generateTableConfig() {
        FTSModuleInfo ftsModuleInfo;
        List<String> columns;
        for (MultiIndexesInfo multiIndexesInfo : this.getTableConstraintInfo().getMultiIndexes()) {
            StringBuilder stringBuilder;
            String name = multiIndexesInfo.component1();
            Iterator<String> columns2 = multiIndexesInfo.component2();
            String indexName = name;
            boolean isFullName = true;
            if (((CharSequence)indexName).length() == 0) {
                indexName = CollectionsKt.joinToString$default((Iterable)((Iterable)((Object)columns2)), (CharSequence)"_", (CharSequence)"_", (CharSequence)"_index", (int)0, null, null, (int)56, null);
                isFullName = false;
            }
            if ((stringBuilder = this.builder) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                stringBuilder = null;
            }
            stringBuilder.append("\t\tbaseBinding.addIndex(\"" + indexName + "\", " + isFullName + ", StatementCreateIndex().ifNotExist().indexedBy(\n\t\t\t");
            Iterator iterator = columns2.iterator();
            while (iterator.hasNext()) {
                String column = (String)iterator.next();
                StringBuilder stringBuilder2 = this.builder;
                if (stringBuilder2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                    stringBuilder2 = null;
                }
                stringBuilder2.append(column).append(", ");
            }
            StringBuilder stringBuilder3 = this.builder;
            if (stringBuilder3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                stringBuilder3 = null;
            }
            stringBuilder3.append("\n\t\t))\n");
        }
        Iterator<Object> iterator = this.getTableConstraintInfo().getMultiPrimaries().iterator();
        while (iterator.hasNext()) {
            columns = ((MultiPrimaryInfo)iterator.next()).component1();
            StringBuilder stringBuilder = this.builder;
            if (stringBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                stringBuilder = null;
            }
            stringBuilder.append("\t\tbaseBinding.addTableConstraint(TableConstraint().primaryKey().indexedBy(\n\t\t\t");
            for (String column : columns) {
                StringBuilder stringBuilder4 = this.builder;
                if (stringBuilder4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                    stringBuilder4 = null;
                }
                stringBuilder4.append(column).append(", ");
            }
            StringBuilder stringBuilder5 = this.builder;
            if (stringBuilder5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                stringBuilder5 = null;
            }
            stringBuilder5.append("\n\t\t))\n");
        }
        iterator = this.getTableConstraintInfo().getMultiUnique().iterator();
        while (iterator.hasNext()) {
            columns = ((MultiUniqueInfo)iterator.next()).component1();
            StringBuilder stringBuilder = this.builder;
            if (stringBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                stringBuilder = null;
            }
            stringBuilder.append("\t\tbaseBinding.addTableConstraint(TableConstraint().unique().indexedBy(\n\t\t\t");
            for (String column : columns) {
                StringBuilder stringBuilder6 = this.builder;
                if (stringBuilder6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                    stringBuilder6 = null;
                }
                stringBuilder6.append(column).append(", ");
            }
            StringBuilder stringBuilder7 = this.builder;
            if (stringBuilder7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                stringBuilder7 = null;
            }
            stringBuilder7.append("\n\t\t))\n");
        }
        if (this.getTableConstraintInfo().isWithoutRowId()) {
            StringBuilder stringBuilder = this.builder;
            if (stringBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                stringBuilder = null;
            }
            stringBuilder.append("\t\tbaseBinding.configWithoutRowId()");
        }
        if ((ftsModuleInfo = this.getTableConstraintInfo().getFtsModule()) == null || ((CharSequence)ftsModuleInfo.getFtsVersion()).length() == 0) {
            return;
        }
        StringBuilder stringBuilder = this.builder;
        if (stringBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder = null;
        }
        stringBuilder.append("\t\tbaseBinding.configVirtualModule(\"" + ftsModuleInfo.getFtsVersion() + "\")\n");
        StringBuilder tokenizer = new StringBuilder("tokenize = ");
        tokenizer.append(ftsModuleInfo.getTokenizer());
        for (String para : ftsModuleInfo.getTokenizerParameters()) {
            tokenizer.append(" ").append(para);
        }
        StringBuilder stringBuilder8 = this.builder;
        if (stringBuilder8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder8 = null;
        }
        stringBuilder8.append("\t\tbaseBinding.configVirtualModuleArgument(\"" + tokenizer + "\")\n");
        if (((CharSequence)ftsModuleInfo.getExternalTable()).length() > 0) {
            StringBuilder stringBuilder9 = this.builder;
            if (stringBuilder9 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                stringBuilder9 = null;
            }
            stringBuilder9.append("\t\tbaseBinding.configVirtualModuleArgument(\"content='" + ftsModuleInfo.getExternalTable() + "'\");\n");
        }
    }

    private final void generateBindingType() {
        StringBuilder stringBuilder = this.builder;
        if (stringBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder = null;
        }
        stringBuilder.append("\toverride fun bindingType() = " + this.getClassName() + "::class.java\n");
    }

    private final void generateBindingFields() {
        StringBuilder stringBuilder = this.builder;
        if (stringBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder = null;
        }
        stringBuilder.append("\toverride fun allBindingFields() = allFields()\n");
        StringBuilder stringBuilder2 = this.builder;
        if (stringBuilder2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder2 = null;
        }
        stringBuilder2.append("\t@JvmStatic\n");
        StringBuilder stringBuilder3 = this.builder;
        if (stringBuilder3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder3 = null;
        }
        stringBuilder3.append("\tfun allFields() = arrayOf(");
        Iterator<ColumnInfo> iterator = this.getAllColumnInfo().iterator();
        while (iterator.hasNext()) {
            String propertyName = iterator.next().component1();
            StringBuilder stringBuilder4 = this.builder;
            if (stringBuilder4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                stringBuilder4 = null;
            }
            stringBuilder4.append(propertyName).append(", ");
        }
        StringBuilder stringBuilder5 = this.builder;
        if (stringBuilder5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder5 = null;
        }
        stringBuilder5.append(")\n");
    }

    private final void generateBaseBinding() {
        StringBuilder stringBuilder = this.builder;
        if (stringBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder = null;
        }
        stringBuilder.append("\toverride fun baseBinding() = baseBinding\n");
    }

    private final void generateExtractObject() {
        StringBuilder stringBuilder = this.builder;
        if (stringBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder = null;
        }
        stringBuilder.append("\toverride fun <R : " + this.getClassName() + "> extractObject(\n");
        StringBuilder stringBuilder2 = this.builder;
        if (stringBuilder2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder2 = null;
        }
        stringBuilder2.append("\t\tfields: Array<Field<" + this.getClassName() + ">>,\n");
        StringBuilder stringBuilder3 = this.builder;
        if (stringBuilder3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder3 = null;
        }
        stringBuilder3.append("\t\tpreparedStatement: PreparedStatement,\n");
        StringBuilder stringBuilder4 = this.builder;
        if (stringBuilder4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder4 = null;
        }
        stringBuilder4.append("\t\tcls: Class<R>\n");
        StringBuilder stringBuilder5 = this.builder;
        if (stringBuilder5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder5 = null;
        }
        stringBuilder5.append("\t): R  {\n");
        StringBuilder stringBuilder6 = this.builder;
        if (stringBuilder6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder6 = null;
        }
        stringBuilder6.append("\t\tval newOne = cls.newInstance()\n");
        StringBuilder stringBuilder7 = this.builder;
        if (stringBuilder7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder7 = null;
        }
        stringBuilder7.append("\t\tvar index = 0\n");
        StringBuilder stringBuilder8 = this.builder;
        if (stringBuilder8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder8 = null;
        }
        stringBuilder8.append("\t\tfor (field in fields) {\n");
        StringBuilder stringBuilder9 = this.builder;
        if (stringBuilder9 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder9 = null;
        }
        stringBuilder9.append("\t\t\twhen (field.fieldId) {\n");
        int index = 1;
        for (ColumnInfo columnInfo : this.getAllColumnInfo()) {
            KotlinPropertyORMInfo info;
            String propertyName = columnInfo.component1();
            String propertyType = columnInfo.component2();
            boolean nullable = columnInfo.component3();
            Intrinsics.checkNotNull((Object)KotlinPropertyORMInfoKt.getAllKotlinPropertyORMInfo().get(propertyType));
            if (nullable) {
                StringBuilder stringBuilder10 = this.builder;
                if (stringBuilder10 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                    stringBuilder10 = null;
                }
                stringBuilder10.append("\t\t\t\t" + index + " -> {\n");
                StringBuilder stringBuilder11 = this.builder;
                if (stringBuilder11 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                    stringBuilder11 = null;
                }
                stringBuilder11.append("\t\t\t\t\tif ( preparedStatement.getColumnType(index) != ColumnType.Null) {\n");
                StringBuilder stringBuilder12 = this.builder;
                if (stringBuilder12 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                    stringBuilder12 = null;
                }
                stringBuilder12.append("\t\t\t\t\t\tnewOne." + propertyName + " = preparedStatement." + info.getSetter() + '\n');
                StringBuilder stringBuilder13 = this.builder;
                if (stringBuilder13 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                    stringBuilder13 = null;
                }
                stringBuilder13.append("\t\t\t\t\t}\n");
                StringBuilder stringBuilder14 = this.builder;
                if (stringBuilder14 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                    stringBuilder14 = null;
                }
                stringBuilder14.append("\t\t\t\t}\n");
            } else {
                StringBuilder stringBuilder15 = this.builder;
                if (stringBuilder15 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                    stringBuilder15 = null;
                }
                stringBuilder15.append("\t\t\t\t" + index + " -> newOne." + propertyName + " = preparedStatement." + info.getSetter() + '\n');
            }
            ++index;
        }
        StringBuilder stringBuilder16 = this.builder;
        if (stringBuilder16 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder16 = null;
        }
        stringBuilder16.append("\t\t\t\telse -> assert(false) {\n");
        StringBuilder stringBuilder17 = this.builder;
        if (stringBuilder17 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder17 = null;
        }
        stringBuilder17.append("\t\t\t\t\t\"Invalid id \" + field.getFieldId() + \" of field \" + field.getDescription() + \" in " + this.getClassName() + ".\"\n");
        StringBuilder stringBuilder18 = this.builder;
        if (stringBuilder18 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder18 = null;
        }
        stringBuilder18.append("\t\t\t\t}\n");
        StringBuilder stringBuilder19 = this.builder;
        if (stringBuilder19 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder19 = null;
        }
        stringBuilder19.append("\t\t\t}\n");
        StringBuilder stringBuilder20 = this.builder;
        if (stringBuilder20 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder20 = null;
        }
        stringBuilder20.append("\t\t\tindex++\n");
        StringBuilder stringBuilder21 = this.builder;
        if (stringBuilder21 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder21 = null;
        }
        stringBuilder21.append("\t\t}\n");
        StringBuilder stringBuilder22 = this.builder;
        if (stringBuilder22 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder22 = null;
        }
        stringBuilder22.append("\t\treturn newOne\n");
        StringBuilder stringBuilder23 = this.builder;
        if (stringBuilder23 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder23 = null;
        }
        stringBuilder23.append("\t}\n\n");
    }

    private final void generateBindObject() {
        StringBuilder stringBuilder = this.builder;
        if (stringBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder = null;
        }
        stringBuilder.append("\toverride fun bindField(\n");
        StringBuilder stringBuilder2 = this.builder;
        if (stringBuilder2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder2 = null;
        }
        stringBuilder2.append("\t\t`object`: " + this.getClassName() + ",\n");
        StringBuilder stringBuilder3 = this.builder;
        if (stringBuilder3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder3 = null;
        }
        stringBuilder3.append("\t\tfield: Field<" + this.getClassName() + ">,\n");
        StringBuilder stringBuilder4 = this.builder;
        if (stringBuilder4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder4 = null;
        }
        stringBuilder4.append("\t\tindex: Int,\n");
        StringBuilder stringBuilder5 = this.builder;
        if (stringBuilder5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder5 = null;
        }
        stringBuilder5.append("\t\tpreparedStatement: PreparedStatement\n");
        StringBuilder stringBuilder6 = this.builder;
        if (stringBuilder6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder6 = null;
        }
        stringBuilder6.append("\t) {\n");
        StringBuilder stringBuilder7 = this.builder;
        if (stringBuilder7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder7 = null;
        }
        stringBuilder7.append("\t\twhen (field.fieldId) {\n");
        int index = 1;
        for (ColumnInfo columnInfo : this.getAllColumnInfo()) {
            KotlinPropertyORMInfo info;
            String propertyName = columnInfo.component1();
            String propertyType = columnInfo.component2();
            boolean nullable = columnInfo.component3();
            Intrinsics.checkNotNull((Object)KotlinPropertyORMInfoKt.getAllKotlinPropertyORMInfo().get(propertyType));
            if (nullable) {
                StringBuilder stringBuilder8 = this.builder;
                if (stringBuilder8 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                    stringBuilder8 = null;
                }
                stringBuilder8.append("\t\t\t" + index + " -> {\n");
                StringBuilder stringBuilder9 = this.builder;
                if (stringBuilder9 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                    stringBuilder9 = null;
                }
                stringBuilder9.append("\t\t\t\tif (`object`." + propertyName + " != null) {\n");
                StringBuilder stringBuilder10 = this.builder;
                if (stringBuilder10 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                    stringBuilder10 = null;
                }
                stringBuilder10.append("\t\t\t\t\tpreparedStatement." + info.getGetter() + "(`object`." + propertyName + ", index)\n");
                StringBuilder stringBuilder11 = this.builder;
                if (stringBuilder11 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                    stringBuilder11 = null;
                }
                stringBuilder11.append("\t\t\t\t} else {\n");
                StringBuilder stringBuilder12 = this.builder;
                if (stringBuilder12 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                    stringBuilder12 = null;
                }
                stringBuilder12.append("\t\t\t\t\tpreparedStatement.bindNull(index)\n");
                StringBuilder stringBuilder13 = this.builder;
                if (stringBuilder13 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                    stringBuilder13 = null;
                }
                stringBuilder13.append("\t\t\t\t}\n");
                StringBuilder stringBuilder14 = this.builder;
                if (stringBuilder14 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                    stringBuilder14 = null;
                }
                stringBuilder14.append("\t\t\t}\n");
            } else {
                StringBuilder stringBuilder15 = this.builder;
                if (stringBuilder15 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                    stringBuilder15 = null;
                }
                stringBuilder15.append("\t\t\t" + index + " -> preparedStatement." + info.getGetter() + "(`object`." + propertyName + ", index)\n");
            }
            ++index;
        }
        StringBuilder stringBuilder16 = this.builder;
        if (stringBuilder16 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder16 = null;
        }
        stringBuilder16.append("\t\t\telse -> assert(false) {\n");
        StringBuilder stringBuilder17 = this.builder;
        if (stringBuilder17 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder17 = null;
        }
        stringBuilder17.append("\t\t\t\t\"Invalid id \" + field.getFieldId() + \" of field \" + field.getDescription() + \" in " + this.getClassName() + ".\"\n");
        StringBuilder stringBuilder18 = this.builder;
        if (stringBuilder18 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder18 = null;
        }
        stringBuilder18.append("\t\t\t}\n");
        StringBuilder stringBuilder19 = this.builder;
        if (stringBuilder19 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder19 = null;
        }
        stringBuilder19.append("\t\t}\n");
        StringBuilder stringBuilder20 = this.builder;
        if (stringBuilder20 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder20 = null;
        }
        stringBuilder20.append("\t}\n\n");
    }

    private final void generateAutoIncrementConfig() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        StringBuilder stringBuilder3 = this.builder;
        if (stringBuilder3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder3 = null;
        }
        stringBuilder3.append("\toverride fun isAutoIncrement(`object`: " + this.getClassName() + "): Boolean {\n");
        ColumnInfo autoIncrementColumn = null;
        for (ColumnInfo info : this.getAllColumnInfo()) {
            if (!info.isAutoIncrement() || !info.isPrimary()) continue;
            autoIncrementColumn = info;
            break;
        }
        if (autoIncrementColumn != null) {
            StringBuilder stringBuilder4 = this.builder;
            if (stringBuilder4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                stringBuilder4 = null;
            }
            stringBuilder4.append("\t\treturn `object`." + autoIncrementColumn.getPropertyName() + " == 0\n");
        } else {
            StringBuilder stringBuilder5 = this.builder;
            if (stringBuilder5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                stringBuilder5 = null;
            }
            stringBuilder5.append("\t\treturn false\n");
        }
        if ((stringBuilder2 = this.builder) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder2 = null;
        }
        stringBuilder2.append("\t}\n\n");
        StringBuilder stringBuilder6 = this.builder;
        if (stringBuilder6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder6 = null;
        }
        stringBuilder6.append("\toverride fun setLastInsertRowId(`object`: " + this.getClassName() + ", lastInsertRowId: Long) {\n");
        if (autoIncrementColumn != null) {
            StringBuilder stringBuilder7;
            String convert = "";
            String string = autoIncrementColumn.getPropertyType();
            String string2 = Reflection.getOrCreateKotlinClass(Character.TYPE).getQualifiedName();
            Intrinsics.checkNotNull((Object)string2);
            if (Intrinsics.areEqual((Object)string, (Object)string2)) {
                convert = ".toInt().toChar()";
            } else {
                String string3 = Reflection.getOrCreateKotlinClass(Byte.TYPE).getQualifiedName();
                Intrinsics.checkNotNull((Object)string3);
                if (Intrinsics.areEqual((Object)string, (Object)string3)) {
                    convert = ".toByte()";
                } else {
                    String string4 = Reflection.getOrCreateKotlinClass(Short.TYPE).getQualifiedName();
                    Intrinsics.checkNotNull((Object)string4);
                    if (Intrinsics.areEqual((Object)string, (Object)string4)) {
                        convert = ".toShort()";
                    } else {
                        String string5 = Reflection.getOrCreateKotlinClass(Integer.TYPE).getQualifiedName();
                        Intrinsics.checkNotNull((Object)string5);
                        if (Intrinsics.areEqual((Object)string, (Object)string5)) {
                            convert = ".toInt()";
                        }
                    }
                }
            }
            if ((stringBuilder7 = this.builder) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                stringBuilder7 = null;
            }
            stringBuilder7.append("\t\t`object`." + autoIncrementColumn.getPropertyName() + " = lastInsertRowId" + convert + '\n');
        }
        if ((stringBuilder = this.builder) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            stringBuilder = null;
        }
        stringBuilder.append("\t}\n\n");
    }
}

