/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wcdb.compiler;

import com.tencent.wcdb.FTSModule;
import com.tencent.wcdb.FTSVersion;
import com.tencent.wcdb.WCDBDefault;
import com.tencent.wcdb.WCDBField;
import com.tencent.wcdb.WCDBIndex;
import com.tencent.wcdb.WCDBTableCoding;
import com.tencent.wcdb.compiler.JavaCodeGenerator;
import com.tencent.wcdb.compiler.JavaFieldORMInfo;
import com.tencent.wcdb.compiler.resolvedInfo.ColumnInfo;
import com.tencent.wcdb.compiler.resolvedInfo.MultiIndexesInfo;
import com.tencent.wcdb.compiler.resolvedInfo.MultiPrimaryInfo;
import com.tencent.wcdb.compiler.resolvedInfo.MultiUniqueInfo;
import com.tencent.wcdb.compiler.resolvedInfo.TableConfigInfo;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@SupportedOptions(value={"verbose"})
public class JavaAnnotationProcessor
extends AbstractProcessor {
    public static final String OPTION_VERBOSE = "verbose";
    private static final String TAB = "    ";
    Filer filer;
    Messager msg;
    Types typeUtil;
    Elements elementUtil;
    private boolean writerRoundDone = false;
    private int round = 0;
    private boolean verbose = true;
    private int primaryKeyCount = 0;
    private TableConfigInfo tableConstraintInfo;
    private ArrayList<ColumnInfo> allFieldInfo;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.verbose = Boolean.parseBoolean(processingEnvironment.getOptions().get(OPTION_VERBOSE));
        this.filer = processingEnvironment.getFiler();
        this.msg = processingEnvironment.getMessager();
        this.typeUtil = processingEnvironment.getTypeUtils();
        this.elementUtil = processingEnvironment.getElementUtils();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(WCDBTableCoding.class.getCanonicalName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        try {
            ++this.round;
            this.verboseLog("WCDB Processing round " + this.round + ", new annotations: " + !annotations.isEmpty() + ", processingOver: " + env.processingOver());
            if (env.processingOver() && !annotations.isEmpty()) {
                this.msg.printMessage(Diagnostic.Kind.ERROR, "Unexpected WCDB processing state: annotations still available after processing over");
                return false;
            }
            if (annotations.isEmpty()) {
                return false;
            }
            if (this.writerRoundDone) {
                this.msg.printMessage(Diagnostic.Kind.ERROR, "Unexpected WCDB processing state: annotations still available after writing.");
            }
            Set<? extends Element> elements = env.getElementsAnnotatedWith(WCDBTableCoding.class);
            for (Element element : elements) {
                if (!this.checkClassElement(element)) {
                    return false;
                }
                this.primaryKeyCount = 0;
                WCDBTableCoding config = element.getAnnotation(WCDBTableCoding.class);
                assert (config != null);
                FTSModule ftsModule = this.getFTSModule(element, config);
                if (!this.checkFTSModule(element, ftsModule)) {
                    return false;
                }
                this.tableConstraintInfo = TableConfigInfo.Companion.resolve(config, ftsModule);
                this.allFieldInfo = new ArrayList();
                this.verboseLog("WCDB Processing: " + element);
                for (Element element2 : element.getEnclosedElements()) {
                    WCDBField fieldAnnotation;
                    if (element2.getKind() != ElementKind.FIELD || (fieldAnnotation = element2.getAnnotation(WCDBField.class)) == null) continue;
                    WCDBDefault defaultValueAnnotation = element2.getAnnotation(WCDBDefault.class);
                    WCDBIndex indexAnnotation = element2.getAnnotation(WCDBIndex.class);
                    if (!this.checkFieldElement(element2, fieldAnnotation, indexAnnotation, defaultValueAnnotation)) {
                        this.allFieldInfo.clear();
                        break;
                    }
                    this.verboseLog("Found WCDBField: " + element2 + " " + element2.asType().toString());
                    this.allFieldInfo.add(ColumnInfo.Companion.resolve(element2, fieldAnnotation, indexAnnotation, defaultValueAnnotation));
                }
                if (!this.checkColumnInTableConstraint(element)) {
                    return false;
                }
                if (this.allFieldInfo.size() <= 0) continue;
                this.createORMFile((TypeElement)element);
            }
            this.writerRoundDone = true;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            this.msg.printMessage(Diagnostic.Kind.ERROR, "Unexpected error in WCDBAnnotationProcessor: " + e);
        }
        return true;
    }

    private void verboseLog(String content) {
        if (this.verbose) {
            this.msg.printMessage(Diagnostic.Kind.NOTE, content);
        }
    }

    private boolean checkClassElement(Element element) {
        if (element.getKind() != ElementKind.CLASS) {
            this.msg.printMessage(Diagnostic.Kind.ERROR, "@WCDBTableCoding is only valid for classes", element);
            return false;
        }
        Set<Modifier> modifiers = element.getModifiers();
        if (modifiers.contains((Object)Modifier.PRIVATE) || modifiers.contains((Object)Modifier.PROTECTED)) {
            this.msg.printMessage(Diagnostic.Kind.ERROR, "The class with annotation @WCDBTableCoding can not be private or protected", element);
            return false;
        }
        if (modifiers.contains((Object)Modifier.ABSTRACT)) {
            this.msg.printMessage(Diagnostic.Kind.ERROR, "The class with annotation @WCDBTableCoding can not be abstract", element);
            return false;
        }
        return true;
    }

    private FTSModule getFTSModule(Element element, WCDBTableCoding config) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(WCDBTableCoding.class.getName())) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
                if (!entry.getKey().getSimpleName().toString().equals("ftsModule")) continue;
                return config.ftsModule();
            }
        }
        return null;
    }

    private boolean checkFTSModule(Element element, FTSModule ftsModule) {
        if (ftsModule == null) {
            return true;
        }
        if (ftsModule.version() == FTSVersion.NONE) {
            if (!ftsModule.tokenizer().isEmpty() || ftsModule.tokenizerParameters().length > 0) {
                this.msg.printMessage(Diagnostic.Kind.ERROR, "You need to config fts version in @FTSModule", element);
                return false;
            }
            return true;
        }
        if (ftsModule.tokenizer().isEmpty()) {
            this.msg.printMessage(Diagnostic.Kind.ERROR, "You need to config a tokenizer in @FTSModule", element);
            return false;
        }
        return true;
    }

    private boolean checkFieldElement(Element element, WCDBField fieldAnnotation, WCDBIndex indexAnnotation, WCDBDefault defaultValueAnnotation) {
        if (element.getModifiers().contains((Object)Modifier.PRIVATE) || element.getModifiers().contains((Object)Modifier.PROTECTED)) {
            this.msg.printMessage(Diagnostic.Kind.ERROR, "The field with annotation @WCDBField can not be private or protected", element);
            return false;
        }
        String type = element.asType().toString();
        if (!JavaFieldORMInfo.allTypes.contains(type)) {
            String info = "The type " + type + " of field " + element.toString() + " in " + element.getEnclosingElement().getSimpleName() + " is Unsupported!\nWCDB only supports Java basic types and byte[].";
            this.msg.printMessage(Diagnostic.Kind.ERROR, info, element);
            return false;
        }
        if (fieldAnnotation.isPrimary()) {
            ++this.primaryKeyCount;
            if (this.primaryKeyCount > 1) {
                String info = "@WCDBField can only configure one primary key in " + element.getEnclosingElement().getSimpleName() + ". If multiple primary keys are required, configure multiPrimaries in @WCDBTableCoding. ";
                this.msg.printMessage(Diagnostic.Kind.ERROR, info, element);
                return false;
            }
            if (fieldAnnotation.isAutoIncrement() && !JavaFieldORMInfo.allInfo.get((Object)type).columnType.equals("Integer")) {
                String info = "Auto-increment field must be integer";
                this.msg.printMessage(Diagnostic.Kind.ERROR, info, element);
                return false;
            }
            if (indexAnnotation != null) {
                String info = element.getEnclosingElement().getSimpleName() + " is confined as primary key, so it does not need to configure @WCDBIndex";
                this.msg.printMessage(Diagnostic.Kind.ERROR, info, element);
                return false;
            }
        } else if (fieldAnnotation.isAutoIncrement()) {
            String info = "Only the primary key can be configured as auto-increment";
            this.msg.printMessage(Diagnostic.Kind.ERROR, info, element);
            return false;
        }
        if (defaultValueAnnotation != null) {
            int valueCount = 0;
            boolean typeMissMatch = false;
            String columnType = JavaFieldORMInfo.allInfo.get((Object)type).columnType;
            if (defaultValueAnnotation.intValue() != 0L) {
                ++valueCount;
                if (!columnType.equals("Integer")) {
                    typeMissMatch = true;
                }
            }
            if (defaultValueAnnotation.doubleValue() != 0.0) {
                ++valueCount;
                if (!columnType.equals("Float")) {
                    typeMissMatch = true;
                }
            }
            if (defaultValueAnnotation.textValue().length() > 0) {
                ++valueCount;
                if (!columnType.equals("Text")) {
                    typeMissMatch = true;
                }
            }
            if (valueCount > 1) {
                this.msg.printMessage(Diagnostic.Kind.ERROR, "Only one default value can be configured for a field", element);
                return false;
            }
            if (typeMissMatch) {
                if (columnType.equals("BLOB")) {
                    this.msg.printMessage(Diagnostic.Kind.ERROR, "Assigning a default value to BLOB is unsupported", element);
                } else {
                    this.msg.printMessage(Diagnostic.Kind.ERROR, "Default value should be a " + columnType, element);
                }
                return false;
            }
        }
        return true;
    }

    private boolean checkColumnInTableConstraint(Element element) {
        if (this.tableConstraintInfo.getMultiIndexes().isEmpty() && this.tableConstraintInfo.getMultiPrimaries().isEmpty() && this.tableConstraintInfo.getMultiUnique().isEmpty()) {
            return true;
        }
        HashSet<String> allColumns = new HashSet<String>();
        for (ColumnInfo columnInfo : this.allFieldInfo) {
            allColumns.add(columnInfo.getColumnName().isEmpty() ? columnInfo.getPropertyName() : columnInfo.getColumnName());
        }
        for (MultiIndexesInfo multiIndexes : this.tableConstraintInfo.getMultiIndexes()) {
            for (String column : multiIndexes.getColumns()) {
                if (allColumns.contains(column)) continue;
                this.msg.printMessage(Diagnostic.Kind.ERROR, "Can't find column \"" + column + "\" in class orm config.", element);
                return false;
            }
        }
        for (MultiPrimaryInfo multiPrimary : this.tableConstraintInfo.getMultiPrimaries()) {
            for (String column : multiPrimary.getColumns()) {
                if (allColumns.contains(column)) continue;
                this.msg.printMessage(Diagnostic.Kind.ERROR, "Can't find column \"" + column + "\" in class orm config.", element);
                return false;
            }
        }
        for (MultiUniqueInfo multiUnique : this.tableConstraintInfo.getMultiUnique()) {
            for (String column : multiUnique.getColumns()) {
                if (allColumns.contains(column)) continue;
                this.msg.printMessage(Diagnostic.Kind.ERROR, "Can't find column \"" + column + "\" in class orm config.", element);
                return false;
            }
        }
        return true;
    }

    private void createORMFile(TypeElement element) throws RuntimeException {
        String packageName = this.elementUtil.getPackageOf(element).toString();
        String className = String.valueOf(element.getSimpleName());
        String ormClassName = "DB" + element.getSimpleName();
        JavaCodeGenerator codeGenerator = new JavaCodeGenerator();
        codeGenerator.packageName = packageName;
        codeGenerator.className = className;
        codeGenerator.ormClassName = ormClassName;
        codeGenerator.tableConstraintInfo = this.tableConstraintInfo;
        codeGenerator.allColumnInfo = this.allFieldInfo;
        String javaCode = codeGenerator.generate();
        BufferedWriter writer = null;
        try {
            JavaFileObject outputFile = this.filer.createSourceFile(packageName + "." + ormClassName, new Element[0]);
            writer = new BufferedWriter(outputFile.openWriter());
            writer.write(javaCode);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write source for " + element.getSimpleName(), e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

