/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wcdb.compiler;

import com.google.devtools.ksp.UtilsKt;
import com.google.devtools.ksp.processing.CodeGenerator;
import com.google.devtools.ksp.processing.Dependencies;
import com.google.devtools.ksp.processing.KSPLogger;
import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.processing.SymbolProcessor;
import com.google.devtools.ksp.processing.SymbolProcessorEnvironment;
import com.google.devtools.ksp.processing.SymbolProcessorProvider;
import com.google.devtools.ksp.symbol.ClassKind;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSAnnotation;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSDeclaration;
import com.google.devtools.ksp.symbol.KSFile;
import com.google.devtools.ksp.symbol.KSName;
import com.google.devtools.ksp.symbol.KSNode;
import com.google.devtools.ksp.symbol.KSPropertyDeclaration;
import com.google.devtools.ksp.symbol.KSVisitor;
import com.google.devtools.ksp.symbol.KSVisitorVoid;
import com.google.devtools.ksp.symbol.Modifier;
import com.tencent.wcdb.WCDBDefault;
import com.tencent.wcdb.WCDBField;
import com.tencent.wcdb.WCDBIndex;
import com.tencent.wcdb.WCDBTableCoding;
import com.tencent.wcdb.compiler.JavaCodeGenerator;
import com.tencent.wcdb.compiler.KotlinCodeGenerator;
import com.tencent.wcdb.compiler.KotlinPropertyORMInfo;
import com.tencent.wcdb.compiler.KotlinPropertyORMInfoKt;
import com.tencent.wcdb.compiler.resolvedInfo.ColumnInfo;
import com.tencent.wcdb.compiler.resolvedInfo.DefaultValueInfo;
import com.tencent.wcdb.compiler.resolvedInfo.FTSModuleInfo;
import com.tencent.wcdb.compiler.resolvedInfo.MultiIndexesInfo;
import com.tencent.wcdb.compiler.resolvedInfo.MultiPrimaryInfo;
import com.tencent.wcdb.compiler.resolvedInfo.MultiUniqueInfo;
import com.tencent.wcdb.compiler.resolvedInfo.TableConfigInfo;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001/B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\bH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J*\u0010\u001d\u001a\u0004\u0018\u00010\u001e\"\b\b\u0000\u0010\u001f*\u00020 2\u0006\u0010\u0018\u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H\u001f0#H\u0002J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020+H\u0002J\u001d\u0010,\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u001cH\u0016\u00a2\u0006\u0002\u0010.R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/tencent/wcdb/compiler/KotlinAnnotationProcessor;", "Lcom/google/devtools/ksp/symbol/KSVisitorVoid;", "Lcom/google/devtools/ksp/processing/SymbolProcessor;", "environment", "Lcom/google/devtools/ksp/processing/SymbolProcessorEnvironment;", "(Lcom/google/devtools/ksp/processing/SymbolProcessorEnvironment;)V", "allPropertyInfo", "", "Lcom/tencent/wcdb/compiler/resolvedInfo/ColumnInfo;", "isKotlin", "", "primaryKeyCount", "", "tableConstraintInfo", "Lcom/tencent/wcdb/compiler/resolvedInfo/TableConfigInfo;", "verbose", "checkClass", "classDeclaration", "Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "checkColumnInTableConstraint", "checkFTSModule", "ftsModuleInfo", "Lcom/tencent/wcdb/compiler/resolvedInfo/FTSModuleInfo;", "checkProperty", "declaration", "Lcom/google/devtools/ksp/symbol/KSPropertyDeclaration;", "columnInfo", "createORMFile", "", "getAnnotation", "Lcom/google/devtools/ksp/symbol/KSAnnotation;", "T", "", "Lcom/google/devtools/ksp/symbol/KSDeclaration;", "annotationClass", "Lkotlin/reflect/KClass;", "process", "", "Lcom/google/devtools/ksp/symbol/KSAnnotated;", "resolver", "Lcom/google/devtools/ksp/processing/Resolver;", "verboseLog", "content", "", "visitClassDeclaration", "data", "(Lcom/google/devtools/ksp/symbol/KSClassDeclaration;Lkotlin/Unit;)V", "Provider", "compiler"})
public final class KotlinAnnotationProcessor
extends KSVisitorVoid
implements SymbolProcessor {
    @NotNull
    private final SymbolProcessorEnvironment environment;
    private boolean verbose;
    private boolean isKotlin;
    private int primaryKeyCount;
    @Nullable
    private TableConfigInfo tableConstraintInfo;
    @NotNull
    private final List<ColumnInfo> allPropertyInfo;

    public KotlinAnnotationProcessor(@NotNull SymbolProcessorEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.environment = environment;
        this.allPropertyInfo = new ArrayList();
    }

    @NotNull
    public List<KSAnnotated> process(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        KSPLogger.warn$default((KSPLogger)this.environment.getLogger(), (String)"WCDB KSP Processing", null, (int)2, null);
        this.verbose = this.environment.getOptions().containsKey("verbose");
        String string = Reflection.getOrCreateKotlinClass(WCDBTableCoding.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        Sequence symbols = Resolver.getSymbolsWithAnnotation$default((Resolver)resolver, (String)string, (boolean)false, (int)2, null);
        List ret = new ArrayList();
        Iterable $this$forEach$iv = SequencesKt.toList((Sequence)symbols);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KSAnnotated it = (KSAnnotated)element$iv;
            boolean bl = false;
            if (!UtilsKt.validate$default((KSNode)((KSNode)it), null, (int)1, null)) {
                ret.add(it);
                continue;
            }
            it.accept((KSVisitor)this, (Object)Unit.INSTANCE);
        }
        return ret;
    }

    public void visitClassDeclaration(@NotNull KSClassDeclaration classDeclaration, @NotNull Unit data) {
        Intrinsics.checkNotNullParameter((Object)classDeclaration, (String)"classDeclaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        StringBuilder stringBuilder = new StringBuilder().append("WCDB Processing: ");
        KSName kSName = classDeclaration.getQualifiedName();
        Intrinsics.checkNotNull((Object)kSName);
        this.verboseLog(stringBuilder.append(kSName.asString()).toString());
        if (!this.checkClass(classDeclaration)) {
            return;
        }
        this.tableConstraintInfo = TableConfigInfo.Companion.resolve(this.getAnnotation((KSDeclaration)classDeclaration, Reflection.getOrCreateKotlinClass(WCDBTableCoding.class)), this.environment.getLogger());
        if (this.tableConstraintInfo == null) {
            KSPLogger kSPLogger = this.environment.getLogger();
            StringBuilder stringBuilder2 = new StringBuilder().append("Failed to resolve @WCDBTableCoding in ");
            KSName kSName2 = classDeclaration.getQualifiedName();
            Intrinsics.checkNotNull((Object)kSName2);
            kSPLogger.error(stringBuilder2.append(kSName2.asString()).append('!').toString(), (KSNode)classDeclaration);
            return;
        }
        KSFile kSFile = classDeclaration.getContainingFile();
        Intrinsics.checkNotNull((Object)kSFile);
        this.isKotlin = StringsKt.endsWith$default((String)kSFile.getFileName(), (String)".kt", (boolean)false, (int)2, null);
        this.primaryKeyCount = 0;
        this.allPropertyInfo.clear();
        for (KSPropertyDeclaration property : classDeclaration.getAllProperties()) {
            ColumnInfo resolvedColumnInfo;
            KSAnnotation defaultValueAnnotation;
            KSAnnotation fieldAnnotation;
            if (this.getAnnotation((KSDeclaration)property, Reflection.getOrCreateKotlinClass(WCDBField.class)) == null) continue;
            KSAnnotation indexAnnotation = this.getAnnotation((KSDeclaration)property, Reflection.getOrCreateKotlinClass(WCDBIndex.class));
            if (ColumnInfo.Companion.resolve(property, fieldAnnotation, indexAnnotation, defaultValueAnnotation = this.getAnnotation((KSDeclaration)property, Reflection.getOrCreateKotlinClass(WCDBDefault.class)), this.environment.getLogger()) == null) {
                return;
            }
            if (!this.checkProperty(property, resolvedColumnInfo)) {
                return;
            }
            this.verboseLog("Found WCDBField: " + property.getSimpleName().asString());
            this.allPropertyInfo.add(resolvedColumnInfo);
        }
        if (!this.checkColumnInTableConstraint(classDeclaration)) {
            return;
        }
        if (!((Collection)this.allPropertyInfo).isEmpty()) {
            this.createORMFile(classDeclaration);
        }
    }

    private final void verboseLog(String content) {
        if (this.verbose) {
            KSPLogger.info$default((KSPLogger)this.environment.getLogger(), (String)content, null, (int)2, null);
        }
    }

    private final boolean checkClass(KSClassDeclaration classDeclaration) {
        if (classDeclaration.getClassKind() != ClassKind.CLASS) {
            this.environment.getLogger().error("@WCDBTableCoding can only be apply to normal class", (KSNode)classDeclaration);
            return false;
        }
        Set modifiers = classDeclaration.getModifiers();
        if (modifiers.contains(Modifier.PRIVATE) || modifiers.contains(Modifier.PROTECTED)) {
            this.environment.getLogger().error("The class with annotation @WCDBTableCoding can not be private or protected", (KSNode)classDeclaration);
            return false;
        }
        if (modifiers.contains(Modifier.ABSTRACT)) {
            this.environment.getLogger().error("The class with annotation @WCDBTableCoding can not be abstract", (KSNode)classDeclaration);
            return false;
        }
        return true;
    }

    private final boolean checkFTSModule(KSClassDeclaration classDeclaration, FTSModuleInfo ftsModuleInfo) {
        if (ftsModuleInfo == null) {
            return true;
        }
        if (((CharSequence)ftsModuleInfo.getFtsVersion()).length() == 0) {
            if (((CharSequence)ftsModuleInfo.getTokenizer()).length() > 0 || !((Collection)ftsModuleInfo.getTokenizerParameters()).isEmpty()) {
                this.environment.getLogger().error("You need to config fts version in @FTSModule", (KSNode)classDeclaration);
                return false;
            }
            return true;
        }
        if (((CharSequence)ftsModuleInfo.getTokenizer()).length() == 0) {
            this.environment.getLogger().error("You need to config a tokenizer in @FTSModule", (KSNode)classDeclaration);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final <T> KSAnnotation getAnnotation(KSDeclaration declaration, KClass<T> annotationClass) {
        Object e;
        Object v0;
        boolean bl;
        Sequence sequence = declaration.getAnnotations();
        Iterator iterator = sequence.iterator();
        do {
            if (!iterator.hasNext()) {
                v0 = null;
                return v0;
            }
            e = iterator.next();
            KSAnnotation it = (KSAnnotation)e;
            boolean bl2 = false;
            String string = it.getShortName().asString();
            String string2 = annotationClass.getSimpleName();
            Intrinsics.checkNotNull((Object)string2);
            if (Intrinsics.areEqual((Object)string, (Object)string2)) {
                KSName kSName = it.getAnnotationType().resolve().getDeclaration().getQualifiedName();
                Intrinsics.checkNotNull((Object)kSName);
                String string3 = kSName.asString();
                String string4 = annotationClass.getQualifiedName();
                Intrinsics.checkNotNull((Object)string4);
                if (Intrinsics.areEqual((Object)string3, (Object)string4)) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        v0 = e;
        return v0;
    }

    private final boolean checkProperty(KSPropertyDeclaration declaration, ColumnInfo columnInfo) {
        Set modifier = declaration.getModifiers();
        if (modifier.contains(Modifier.PRIVATE) || modifier.contains(Modifier.PROTECTED)) {
            this.environment.getLogger().error("The field with annotation @WCDBField can not be private or protected", (KSNode)declaration);
            return false;
        }
        if (!KotlinPropertyORMInfoKt.getAllKotlinPropertyTypes().contains(columnInfo.getPropertyType())) {
            StringBuilder stringBuilder = new StringBuilder().append("\n                    The type ").append(columnInfo.getPropertyType()).append(" of field ").append(declaration.getSimpleName().asString()).append(" in \n                    ");
            KSDeclaration kSDeclaration = declaration.getParentDeclaration();
            Intrinsics.checkNotNull((Object)kSDeclaration);
            KSName kSName = kSDeclaration.getQualifiedName();
            Intrinsics.checkNotNull((Object)kSName);
            String message = stringBuilder.append(kSName.asString()).append(" is Unsupported!\n                    ").toString();
            message = message + (!this.isKotlin ? "WCDB only supports Java basic types and byte[]." : "WCDB only supports Kotlin basic types and ByteArray.");
            this.environment.getLogger().error(message, (KSNode)declaration);
            return false;
        }
        if (columnInfo.isPrimary()) {
            int message = this.primaryKeyCount;
            this.primaryKeyCount = message + 1;
            if (this.primaryKeyCount > 1) {
                StringBuilder stringBuilder = new StringBuilder().append("@WCDBField can only configure one primary key in \n                    ");
                KSDeclaration kSDeclaration = declaration.getParentDeclaration();
                Intrinsics.checkNotNull((Object)kSDeclaration);
                KSName kSName = kSDeclaration.getQualifiedName();
                Intrinsics.checkNotNull((Object)kSName);
                String message2 = stringBuilder.append(kSName.asString()).append(". \n                    If multiple primary keys are required, configure multiPrimaries in @WCDBTableCoding. \n                    ").toString();
                this.environment.getLogger().error(message2, (KSNode)declaration);
                return false;
            }
            if (columnInfo.isAutoIncrement()) {
                KotlinPropertyORMInfo kotlinPropertyORMInfo = KotlinPropertyORMInfoKt.getAllKotlinPropertyORMInfo().get(columnInfo.getPropertyType());
                if (!Intrinsics.areEqual((Object)(kotlinPropertyORMInfo != null ? kotlinPropertyORMInfo.getColumnType() : null), (Object)"Integer")) {
                    this.environment.getLogger().error("Auto-increment field must be integer", (KSNode)declaration);
                    return false;
                }
            }
            if (columnInfo.getHasIndex()) {
                this.environment.getLogger().error(declaration.getSimpleName().asString() + " is confined as primary key, so it does not need to configure @WCDBIndex", (KSNode)declaration);
                return false;
            }
        } else if (columnInfo.isAutoIncrement()) {
            this.environment.getLogger().error("Only the primary key can be configured as auto-increment", (KSNode)declaration);
            return false;
        }
        if (columnInfo.getDefaultValue() != null) {
            int valueCount = 0;
            KotlinPropertyORMInfo kotlinPropertyORMInfo = KotlinPropertyORMInfoKt.getAllKotlinPropertyORMInfo().get(columnInfo.getPropertyType());
            Intrinsics.checkNotNull((Object)kotlinPropertyORMInfo);
            String columnType = kotlinPropertyORMInfo.getColumnType();
            boolean typeMissMatch = false;
            DefaultValueInfo defaultValueInfo = columnInfo.getDefaultValue();
            Intrinsics.checkNotNull((Object)defaultValueInfo);
            if (defaultValueInfo.getIntValue() != 0L) {
                ++valueCount;
                if (!Intrinsics.areEqual((Object)columnType, (Object)"Integer")) {
                    typeMissMatch = true;
                }
            }
            DefaultValueInfo defaultValueInfo2 = columnInfo.getDefaultValue();
            Intrinsics.checkNotNull((Object)defaultValueInfo2);
            if (!(defaultValueInfo2.getDoubleValue() == 0.0)) {
                ++valueCount;
                if (!Intrinsics.areEqual((Object)columnType, (Object)"Float")) {
                    typeMissMatch = true;
                }
            }
            DefaultValueInfo defaultValueInfo3 = columnInfo.getDefaultValue();
            Intrinsics.checkNotNull((Object)defaultValueInfo3);
            if (((CharSequence)defaultValueInfo3.getTextValue()).length() > 0) {
                ++valueCount;
                if (!Intrinsics.areEqual((Object)columnType, (Object)"Text")) {
                    typeMissMatch = true;
                }
            }
            if (valueCount > 1) {
                this.environment.getLogger().error("Only one default value can be configured for a field", (KSNode)declaration);
                return false;
            }
            if (typeMissMatch) {
                if (Intrinsics.areEqual((Object)columnType, (Object)"BLOB'")) {
                    this.environment.getLogger().error("Assigning a default value to BLOB is unsupported", (KSNode)declaration);
                } else {
                    this.environment.getLogger().error("Default value should be a " + columnType, (KSNode)declaration);
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkColumnInTableConstraint(KSClassDeclaration classDeclaration) {
        void $this$mapTo$iv$iv;
        TableConfigInfo tableConfigInfo = this.tableConstraintInfo;
        Intrinsics.checkNotNull((Object)tableConfigInfo);
        if (tableConfigInfo.getMultiIndexes().isEmpty()) {
            TableConfigInfo tableConfigInfo2 = this.tableConstraintInfo;
            Intrinsics.checkNotNull((Object)tableConfigInfo2);
            if (tableConfigInfo2.getMultiPrimaries().isEmpty()) {
                TableConfigInfo tableConfigInfo3 = this.tableConstraintInfo;
                Intrinsics.checkNotNull((Object)tableConfigInfo3);
                if (tableConfigInfo3.getMultiUnique().isEmpty()) {
                    return true;
                }
            }
        }
        Iterable $this$map$iv = this.allPropertyInfo;
        boolean $i$f$map = false;
        Iterator<String> iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void columnInfo;
            ColumnInfo columnInfo2 = (ColumnInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((CharSequence)columnInfo.getColumnName()).length() == 0 ? columnInfo.getPropertyName() : columnInfo.getColumnName());
        }
        Set allColumns = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        TableConfigInfo tableConfigInfo4 = this.tableConstraintInfo;
        Intrinsics.checkNotNull((Object)tableConfigInfo4);
        for (MultiIndexesInfo multiIndexes : tableConfigInfo4.getMultiIndexes()) {
            for (String column : multiIndexes.getColumns()) {
                if (allColumns.contains(column)) continue;
                this.environment.getLogger().error("Can't find column \"" + column + "\" in class orm config.", (KSNode)classDeclaration);
                return false;
            }
        }
        TableConfigInfo tableConfigInfo5 = this.tableConstraintInfo;
        Intrinsics.checkNotNull((Object)tableConfigInfo5);
        for (MultiPrimaryInfo multiPrimaries : tableConfigInfo5.getMultiPrimaries()) {
            for (String column : multiPrimaries.getColumns()) {
                if (allColumns.contains(column)) continue;
                this.environment.getLogger().error("Can't find column \"" + column + "\" in class orm config.", (KSNode)classDeclaration);
                return false;
            }
        }
        TableConfigInfo tableConfigInfo6 = this.tableConstraintInfo;
        Intrinsics.checkNotNull((Object)tableConfigInfo6);
        for (MultiUniqueInfo multiUnique : tableConfigInfo6.getMultiUnique()) {
            for (String column : multiUnique.getColumns()) {
                if (allColumns.contains(column)) continue;
                this.environment.getLogger().error("Can't find column \"" + column + "\" in class orm config.", (KSNode)classDeclaration);
                return false;
            }
        }
        return true;
    }

    private final void createORMFile(KSClassDeclaration classDeclaration) {
        Object codeGenerator;
        String className = classDeclaration.getSimpleName().asString();
        String ormClassName = "DB" + className;
        KSFile kSFile = classDeclaration.getContainingFile();
        Intrinsics.checkNotNull((Object)kSFile);
        String packageName = kSFile.getPackageName().asString();
        String code = null;
        if (this.isKotlin) {
            codeGenerator = new KotlinCodeGenerator();
            ((KotlinCodeGenerator)codeGenerator).setPackageName(packageName);
            ((KotlinCodeGenerator)codeGenerator).setClassName(className);
            ((KotlinCodeGenerator)codeGenerator).setOrmClassName(ormClassName);
            TableConfigInfo tableConfigInfo = this.tableConstraintInfo;
            Intrinsics.checkNotNull((Object)tableConfigInfo);
            ((KotlinCodeGenerator)codeGenerator).setTableConstraintInfo(tableConfigInfo);
            ((KotlinCodeGenerator)codeGenerator).setAllColumnInfo(this.allPropertyInfo);
            code = ((KotlinCodeGenerator)codeGenerator).generate();
        } else {
            for (ColumnInfo propertyInfo : this.allPropertyInfo) {
                String string = KotlinPropertyORMInfoKt.getK2JTypeMap().get(propertyInfo.getPropertyType());
                Intrinsics.checkNotNull((Object)string);
                propertyInfo.setPropertyType(string);
            }
            codeGenerator = new JavaCodeGenerator();
            ((JavaCodeGenerator)codeGenerator).packageName = packageName;
            ((JavaCodeGenerator)codeGenerator).className = className;
            ((JavaCodeGenerator)codeGenerator).ormClassName = ormClassName;
            ((JavaCodeGenerator)codeGenerator).tableConstraintInfo = this.tableConstraintInfo;
            ((JavaCodeGenerator)codeGenerator).allColumnInfo = this.allPropertyInfo;
            String string = ((JavaCodeGenerator)codeGenerator).generate();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"codeGenerator.generate()");
            code = string;
        }
        CodeGenerator codeGenerator2 = this.environment.getCodeGenerator();
        Object object = new KSFile[1];
        Intrinsics.checkNotNull((Object)classDeclaration.getContainingFile());
        OutputStream file = codeGenerator2.createNewFile(new Dependencies(false, (KSFile[])object), packageName, ormClassName, this.isKotlin ? "kt" : "java");
        object = code;
        byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        file.write(byArray);
        file.close();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/tencent/wcdb/compiler/KotlinAnnotationProcessor$Provider;", "Lcom/google/devtools/ksp/processing/SymbolProcessorProvider;", "()V", "create", "Lcom/google/devtools/ksp/processing/SymbolProcessor;", "environment", "Lcom/google/devtools/ksp/processing/SymbolProcessorEnvironment;", "compiler"})
    public static final class Provider
    implements SymbolProcessorProvider {
        @NotNull
        public SymbolProcessor create(@NotNull SymbolProcessorEnvironment environment) {
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            return new KotlinAnnotationProcessor(environment);
        }
    }
}

