/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wcdb.core;

import com.tencent.wcdb.base.WCDBException;
import com.tencent.wcdb.chaincall.Delete;
import com.tencent.wcdb.chaincall.Insert;
import com.tencent.wcdb.chaincall.Select;
import com.tencent.wcdb.chaincall.Update;
import com.tencent.wcdb.core.Database;
import com.tencent.wcdb.core.Handle;
import com.tencent.wcdb.core.HandleOperation;
import com.tencent.wcdb.core.Table;
import com.tencent.wcdb.orm.Field;
import com.tencent.wcdb.orm.TableBinding;
import com.tencent.wcdb.winq.Expression;
import com.tencent.wcdb.winq.OrderingTerm;
import com.tencent.wcdb.winq.StatementDropIndex;
import com.tencent.wcdb.winq.StatementDropTable;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HandleORMOperation
extends HandleOperation {
    abstract Database getDatabase();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void createTable(@NotNull String tableName, @NotNull TableBinding<T> binding) throws WCDBException {
        Handle handle = this.getHandle(true);
        try {
            if (!binding.baseBinding().createTable(tableName, handle)) {
                throw handle.createException();
            }
        }
        finally {
            if (this.autoInvalidateHandle() && handle != null) {
                handle.invalidate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void createVirtualTable(@NotNull String tableName, @NotNull TableBinding<T> binding) throws WCDBException {
        Handle handle = this.getHandle(true);
        try {
            if (!binding.baseBinding().createVirtualTable(tableName, handle)) {
                throw handle.createException();
            }
        }
        finally {
            if (this.autoInvalidateHandle() && handle != null) {
                handle.invalidate();
            }
        }
    }

    public boolean tableExist(@NotNull String tableName) throws WCDBException {
        Handle handle = this.getHandle(false);
        int ret = Handle.tableExist(handle.getCppHandle(), tableName);
        WCDBException exception = null;
        if (ret > 1) {
            exception = handle.createException();
        }
        if (this.autoInvalidateHandle()) {
            handle.invalidate();
        }
        if (exception != null) {
            throw exception;
        }
        return ret == 1;
    }

    @NotNull
    public <T> Table<T> getTable(@NotNull String tableName, @NotNull TableBinding<T> binding) {
        return new Table<T>(tableName, binding, this.getDatabase());
    }

    public void dropTable(@NotNull String tableName) throws WCDBException {
        this.execute(new StatementDropTable().dropTable(tableName).ifExist());
    }

    public void dropIndex(@NotNull String indexName) throws WCDBException {
        this.execute(new StatementDropIndex().dropIndex(indexName).ifExist());
    }

    @NotNull
    public <T> Insert<T> prepareInsert() {
        return new Insert(this.getHandle(true), false, this.autoInvalidateHandle());
    }

    @NotNull
    public <T> Update<T> prepareUpdate() {
        return new Update(this.getHandle(true), false, this.autoInvalidateHandle());
    }

    @NotNull
    public <T> Select<T> prepareSelect() {
        return new Select(this.getHandle(false), false, this.autoInvalidateHandle());
    }

    @NotNull
    public Delete prepareDelete() {
        return new Delete(this.getHandle(true), false, this.autoInvalidateHandle());
    }

    public <T> void insertObject(@Nullable T object, @NotNull Field<T>[] fields, @NotNull String tableName) throws WCDBException {
        this.prepareInsert().intoTable(tableName).value(object).onFields(fields).execute();
    }

    public <T> void insertOrReplaceObject(@Nullable T object, @NotNull Field<T>[] fields, @NotNull String tableName) throws WCDBException {
        this.prepareInsert().orReplace().intoTable(tableName).value(object).onFields(fields).execute();
    }

    public <T> void insertOrIgnoreObject(@Nullable T object, @NotNull Field<T>[] fields, @NotNull String tableName) throws WCDBException {
        this.prepareInsert().orIgnore().intoTable(tableName).value(object).onFields(fields).execute();
    }

    public <T> void insertObjects(@NotNull Collection<T> objects, @NotNull Field<T>[] fields, @NotNull String tableName) throws WCDBException {
        this.prepareInsert().intoTable(tableName).values(objects).onFields(fields).execute();
    }

    public <T> void insertOrReplaceObjects(@NotNull Collection<T> objects, @NotNull Field<T>[] fields, @NotNull String tableName) throws WCDBException {
        this.prepareInsert().orReplace().intoTable(tableName).values(objects).onFields(fields).execute();
    }

    public <T> void insertOrIgnoreObjects(@NotNull Collection<T> objects, @NotNull Field<T>[] fields, @NotNull String tableName) throws WCDBException {
        this.prepareInsert().orIgnore().intoTable(tableName).values(objects).onFields(fields).execute();
    }

    public void deleteObjects(@NotNull String tableName) throws WCDBException {
        this.prepareDelete().fromTable(tableName).execute();
    }

    public void deleteObjects(@NotNull String tableName, @Nullable Expression condition) throws WCDBException {
        this.prepareDelete().fromTable(tableName).where(condition).execute();
    }

    public void deleteObjects(@NotNull String tableName, @Nullable Expression condition, @Nullable OrderingTerm order, long limit) throws WCDBException {
        this.prepareDelete().fromTable(tableName).where(condition).orderBy(order).limit(limit).execute();
    }

    public void deleteObjects(@NotNull String tableName, @Nullable Expression condition, @Nullable OrderingTerm order, long limit, long offset) throws WCDBException {
        this.prepareDelete().fromTable(tableName).where(condition).orderBy(order).limit(limit).offset(offset).execute();
    }

    public void deleteObjects(@NotNull String tableName, @Nullable OrderingTerm order, long limit) throws WCDBException {
        this.prepareDelete().fromTable(tableName).orderBy(order).limit(limit).execute();
    }

    public void deleteObjects(@NotNull String tableName, @Nullable OrderingTerm order, long limit, long offset) throws WCDBException {
        this.prepareDelete().fromTable(tableName).orderBy(order).limit(limit).offset(offset).execute();
    }

    public <T> void updateObject(@Nullable T object, @NotNull Field<T> field, @NotNull String tableName) throws WCDBException {
        this.prepareUpdate().table(tableName).set(field).toObject(object).execute();
    }

    public <T> void updateObject(@Nullable T object, @NotNull Field<T> field, @NotNull String tableName, @Nullable Expression condition) throws WCDBException {
        this.prepareUpdate().table(tableName).set(field).toObject(object).where(condition).execute();
    }

    public <T> void updateObject(@Nullable T object, @NotNull Field<T> field, @NotNull String tableName, @Nullable Expression condition, @Nullable OrderingTerm order, long limit) throws WCDBException {
        this.prepareUpdate().table(tableName).set(field).toObject(object).where(condition).orderBy(order).limit(limit).execute();
    }

    public <T> void updateObject(@Nullable T object, @NotNull Field<T> field, @NotNull String tableName, @Nullable Expression condition, @Nullable OrderingTerm order, long limit, long offset) throws WCDBException {
        this.prepareUpdate().table(tableName).set(field).toObject(object).where(condition).orderBy(order).limit(limit).offset(offset).execute();
    }

    public <T> void updateObject(@Nullable T object, @NotNull Field<T> field, @NotNull String tableName, @Nullable OrderingTerm order, long limit) throws WCDBException {
        this.prepareUpdate().table(tableName).set(field).toObject(object).orderBy(order).limit(limit).execute();
    }

    public <T> void updateObject(@Nullable T object, @NotNull Field<T> field, @NotNull String tableName, @Nullable OrderingTerm order, long limit, long offset) throws WCDBException {
        this.prepareUpdate().table(tableName).set(field).toObject(object).orderBy(order).limit(limit).offset(offset).execute();
    }

    public <T> void updateObject(@Nullable T object, @NotNull Field<T>[] fields, @NotNull String tableName) throws WCDBException {
        this.prepareUpdate().table(tableName).set(fields).toObject(object).execute();
    }

    public <T> void updateObject(@Nullable T object, @NotNull Field<T>[] fields, @NotNull String tableName, @Nullable Expression condition) throws WCDBException {
        this.prepareUpdate().table(tableName).set(fields).toObject(object).where(condition).execute();
    }

    public <T> void updateObject(@Nullable T object, @NotNull Field<T>[] fields, @NotNull String tableName, @Nullable Expression condition, @Nullable OrderingTerm order, long limit) throws WCDBException {
        this.prepareUpdate().table(tableName).set(fields).toObject(object).where(condition).orderBy(order).limit(limit).execute();
    }

    public <T> void updateObject(@Nullable T object, @NotNull Field<T>[] fields, @NotNull String tableName, @Nullable Expression condition, @Nullable OrderingTerm order, long limit, long offset) throws WCDBException {
        this.prepareUpdate().table(tableName).set(fields).toObject(object).where(condition).orderBy(order).limit(limit).offset(offset).execute();
    }

    public <T> void updateObject(@Nullable T object, @NotNull Field<T>[] fields, @NotNull String tableName, @Nullable OrderingTerm order, long limit) throws WCDBException {
        this.prepareUpdate().table(tableName).set(fields).toObject(object).orderBy(order).limit(limit).execute();
    }

    public <T> void updateObject(@Nullable T object, @NotNull Field<T>[] fields, @NotNull String tableName, @Nullable OrderingTerm order, long limit, long offset) throws WCDBException {
        this.prepareUpdate().table(tableName).set(fields).toObject(object).orderBy(order).limit(limit).offset(offset).execute();
    }

    @Nullable
    public <T> T getFirstObject(@NotNull Field<T>[] fields, @NotNull String tableName) throws WCDBException {
        return this.prepareSelect().select(fields).from(tableName).firstObject();
    }

    @Nullable
    public <T, R extends T> R getFirstObject(@NotNull Field<T>[] fields, @NotNull String tableName, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(fields).from(tableName).firstObject(cls);
    }

    @Nullable
    public <T> T getFirstObject(@NotNull Field<T>[] fields, @NotNull String tableName, @Nullable Expression condition) throws WCDBException {
        return this.prepareSelect().select(fields).from(tableName).where(condition).firstObject();
    }

    @Nullable
    public <T, R extends T> R getFirstObject(@NotNull Field<T>[] fields, @NotNull String tableName, @Nullable Expression condition, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(fields).from(tableName).where(condition).firstObject(cls);
    }

    @Nullable
    public <T> T getFirstObject(@NotNull Field<T>[] fields, @NotNull String tableName, @Nullable Expression condition, @Nullable OrderingTerm order) throws WCDBException {
        return this.prepareSelect().select(fields).from(tableName).where(condition).orderBy(order).firstObject();
    }

    @Nullable
    public <T, R extends T> R getFirstObject(@NotNull Field<T>[] fields, @NotNull String tableName, @Nullable Expression condition, @Nullable OrderingTerm order, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(fields).from(tableName).where(condition).orderBy(order).firstObject(cls);
    }

    @Nullable
    public <T> T getFirstObject(@NotNull Field<T>[] fields, @NotNull String tableName, @Nullable Expression condition, @Nullable OrderingTerm order, long offset) throws WCDBException {
        return this.prepareSelect().select(fields).from(tableName).where(condition).orderBy(order).limit(1L).offset(offset).firstObject();
    }

    @Nullable
    public <T, R extends T> R getFirstObject(@NotNull Field<T>[] fields, @NotNull String tableName, @Nullable Expression condition, @Nullable OrderingTerm order, long offset, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(fields).from(tableName).where(condition).orderBy(order).limit(1L).offset(offset).firstObject(cls);
    }

    @Nullable
    public <T> T getFirstObject(@NotNull Field<T>[] fields, @NotNull String tableName, @Nullable OrderingTerm order) throws WCDBException {
        return this.prepareSelect().select(fields).from(tableName).orderBy(order).firstObject();
    }

    @Nullable
    public <T, R extends T> R getFirstObject(@NotNull Field<T>[] fields, @NotNull String tableName, @Nullable OrderingTerm order, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(fields).from(tableName).orderBy(order).firstObject(cls);
    }

    @Nullable
    public <T> T getFirstObject(@NotNull Field<T>[] fields, @NotNull String tableName, @Nullable OrderingTerm order, long offset) throws WCDBException {
        return this.prepareSelect().select(fields).from(tableName).orderBy(order).limit(1L).offset(offset).firstObject();
    }

    @Nullable
    public <T, R extends T> R getFirstObject(@NotNull Field<T>[] fields, @NotNull String tableName, @Nullable OrderingTerm order, long offset, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(fields).from(tableName).orderBy(order).limit(1L).offset(offset).firstObject(cls);
    }

    @NotNull
    public <T> List<T> getAllObjects(@NotNull Field<T>[] fields, @NotNull String tableName) throws WCDBException {
        return this.prepareSelect().select(fields).from(tableName).allObjects();
    }

    @NotNull
    public <T, R extends T> List<R> getAllObjects(@NotNull Field<T>[] fields, @NotNull String tableName, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(fields).from(tableName).allObjects(cls);
    }

    @NotNull
    public <T> List<T> getAllObjects(@NotNull Field<T>[] fields, @NotNull String tableName, @Nullable Expression condition) throws WCDBException {
        return this.prepareSelect().select(fields).from(tableName).where(condition).allObjects();
    }

    @NotNull
    public <T, R extends T> List<R> getAllObjects(@NotNull Field<T>[] fields, @NotNull String tableName, @Nullable Expression condition, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(fields).from(tableName).where(condition).allObjects(cls);
    }

    @NotNull
    public <T> List<T> getAllObjects(@NotNull Field<T>[] fields, @NotNull String tableName, @Nullable Expression condition, @Nullable OrderingTerm order) throws WCDBException {
        return this.prepareSelect().select(fields).from(tableName).where(condition).orderBy(order).allObjects();
    }

    @NotNull
    public <T, R extends T> List<R> getAllObjects(@NotNull Field<T>[] fields, @NotNull String tableName, @Nullable Expression condition, @Nullable OrderingTerm order, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(fields).from(tableName).where(condition).orderBy(order).allObjects(cls);
    }

    @NotNull
    public <T> List<T> getAllObjects(@NotNull Field<T>[] fields, @NotNull String tableName, @Nullable Expression condition, @Nullable OrderingTerm order, long limit) throws WCDBException {
        return this.prepareSelect().select(fields).from(tableName).where(condition).orderBy(order).limit(limit).allObjects();
    }

    @NotNull
    public <T, R extends T> List<R> getAllObjects(@NotNull Field<T>[] fields, @NotNull String tableName, @Nullable Expression condition, @Nullable OrderingTerm order, long limit, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(fields).from(tableName).where(condition).orderBy(order).limit(limit).allObjects(cls);
    }

    @NotNull
    public <T> List<T> getAllObjects(@NotNull Field<T>[] fields, @NotNull String tableName, @Nullable Expression condition, @Nullable OrderingTerm order, long limit, long offset) throws WCDBException {
        return this.prepareSelect().select(fields).from(tableName).where(condition).orderBy(order).limit(limit).offset(offset).allObjects();
    }

    @NotNull
    public <T, R extends T> List<R> getAllObjects(@NotNull Field<T>[] fields, @NotNull String tableName, @Nullable Expression condition, @Nullable OrderingTerm order, long limit, long offset, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(fields).from(tableName).where(condition).orderBy(order).limit(limit).offset(offset).allObjects(cls);
    }

    @NotNull
    public <T> List<T> getAllObjects(@NotNull Field<T>[] fields, @NotNull String tableName, @Nullable OrderingTerm order) throws WCDBException {
        return this.prepareSelect().select(fields).from(tableName).orderBy(order).allObjects();
    }

    @NotNull
    public <T, R extends T> List<R> getAllObjects(@NotNull Field<T>[] fields, @NotNull String tableName, @Nullable OrderingTerm order, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(fields).from(tableName).orderBy(order).allObjects(cls);
    }

    @NotNull
    public <T> List<T> getAllObjects(@NotNull Field<T>[] fields, @NotNull String tableName, @Nullable OrderingTerm order, long limit) throws WCDBException {
        return this.prepareSelect().select(fields).from(tableName).orderBy(order).limit(limit).allObjects();
    }

    @NotNull
    public <T, R extends T> List<R> getAllObjects(@NotNull Field<T>[] fields, @NotNull String tableName, @Nullable OrderingTerm order, long limit, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(fields).from(tableName).orderBy(order).limit(limit).allObjects(cls);
    }

    @NotNull
    public <T> List<T> getAllObjects(@NotNull Field<T>[] fields, @NotNull String tableName, @Nullable OrderingTerm order, long limit, long offset) throws WCDBException {
        return this.prepareSelect().select(fields).from(tableName).orderBy(order).limit(limit).offset(offset).allObjects();
    }

    @NotNull
    public <T, R extends T> List<R> getAllObjects(@NotNull Field<T>[] fields, @NotNull String tableName, @Nullable OrderingTerm order, long limit, long offset, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(fields).from(tableName).orderBy(order).limit(limit).offset(offset).allObjects(cls);
    }
}

