/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wcdb.winq;

import com.tencent.wcdb.base.CppObject;
import com.tencent.wcdb.winq.ExpressionConvertible;
import com.tencent.wcdb.winq.FrameSpec;
import com.tencent.wcdb.winq.Identifier;
import com.tencent.wcdb.winq.OrderingTerm;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowDef
extends Identifier {
    @Override
    protected int getType() {
        return 16;
    }

    public WindowDef() {
        this.cppObj = WindowDef.createCppObj();
    }

    private static native long createCppObj();

    @NotNull
    public WindowDef partitionBy(String ... columnNames) {
        if (columnNames == null || columnNames.length == 0) {
            return this;
        }
        int[] types = new int[columnNames.length];
        Arrays.fill(types, 6);
        WindowDef.configPartitions(this.cppObj, types, null, null, columnNames);
        return this;
    }

    @NotNull
    public WindowDef partitionBy(ExpressionConvertible ... expressions) {
        if (expressions == null || expressions.length == 0) {
            return this;
        }
        int[] types = new int[expressions.length];
        long[] cppObjs = new long[expressions.length];
        for (int i = 0; i < expressions.length; ++i) {
            types[i] = Identifier.getCppType(expressions[i]);
            cppObjs[i] = CppObject.get(expressions[i]);
        }
        WindowDef.configPartitions(this.cppObj, types, cppObjs, null, null);
        return this;
    }

    private static native void configPartitions(long var0, int[] var2, long[] var3, double[] var4, String[] var5);

    @NotNull
    public WindowDef orderBy(OrderingTerm ... orders) {
        if (orders == null || orders.length == 0) {
            return this;
        }
        long[] cppOrders = new long[orders.length];
        for (int i = 0; i < orders.length; ++i) {
            cppOrders[i] = CppObject.get(orders[i]);
        }
        WindowDef.configOrders(this.cppObj, cppOrders);
        return this;
    }

    private static native void configOrders(long var0, long[] var2);

    @NotNull
    public WindowDef frameSpec(@Nullable FrameSpec frameSpec) {
        WindowDef.configFrameSpec(this.cppObj, CppObject.get(frameSpec));
        return this;
    }

    private static native void configFrameSpec(long var0, long var2);
}

