/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wcdb.chaincall;

import com.tencent.wcdb.base.WCDBException;
import com.tencent.wcdb.chaincall.ChainCall;
import com.tencent.wcdb.core.Handle;
import com.tencent.wcdb.core.PreparedStatement;
import com.tencent.wcdb.core.Transaction;
import com.tencent.wcdb.orm.Field;
import com.tencent.wcdb.orm.TableBinding;
import com.tencent.wcdb.winq.StatementInsert;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Insert<T>
extends ChainCall<StatementInsert> {
    private boolean hasConflictAction = false;
    private Field<T>[] fields = null;
    private Collection<T> values = null;
    private long lastInsertRowId = 0L;

    public Insert(@NotNull Handle handle, boolean needChanges, boolean autoInvalidateHandle) {
        super(handle, needChanges, autoInvalidateHandle);
        this.statement = new StatementInsert();
    }

    @NotNull
    public Insert<T> orReplace() {
        this.hasConflictAction = true;
        ((StatementInsert)this.statement).orReplace();
        return this;
    }

    @NotNull
    public Insert<T> orIgnore() {
        this.hasConflictAction = true;
        ((StatementInsert)this.statement).orIgnore();
        return this;
    }

    @NotNull
    public Insert<T> intoTable(@NotNull String table) {
        ((StatementInsert)this.statement).insertInto(table);
        return this;
    }

    @SafeVarargs
    @NotNull
    public final Insert<T> onFields(Field<T> ... fields) {
        this.fields = fields;
        ((StatementInsert)this.statement).columns(fields).valuesWithBindParameters(fields.length);
        return this;
    }

    @NotNull
    public Insert<T> value(@Nullable T object) {
        this.values = Collections.singleton(object);
        return this;
    }

    @NotNull
    public Insert<T> values(@NotNull Collection<T> objects) {
        this.values = objects;
        return this;
    }

    @NotNull
    public Insert<T> execute() throws WCDBException {
        if (this.values.size() == 0) {
            return this;
        }
        assert (this.fields != null && this.fields.length > 0);
        try {
            if (this.values.size() > 1) {
                this.handle.runTransaction(new Transaction(){

                    @Override
                    public boolean insideTransaction(@NotNull Handle handle) throws WCDBException {
                        Insert.this.realExecute();
                        return true;
                    }
                });
            } else {
                this.realExecute();
            }
        }
        finally {
            this.invalidateHandle();
        }
        return this;
    }

    public long getLastInsertRowId() {
        return this.lastInsertRowId;
    }

    private void realExecute() throws WCDBException {
        TableBinding<T> binding = Field.getBinding(this.fields);
        PreparedStatement preparedStatement = this.handle.preparedWithMainStatement(this.statement);
        this.lastInsertRowId = 0L;
        for (T object : this.values) {
            preparedStatement.reset();
            int index = 1;
            boolean isAutoIncrement = !this.hasConflictAction && binding.isAutoIncrement(object);
            for (Field<T> field : this.fields) {
                if (isAutoIncrement && field.isAutoIncrement()) {
                    preparedStatement.bindNull(index);
                } else {
                    binding.bindField(object, field, index, preparedStatement);
                }
                ++index;
            }
            preparedStatement.step();
            if (!isAutoIncrement) continue;
            binding.setLastInsertRowId(object, this.handle.getLastInsertedRowId());
        }
        if (this.values.size() > 0) {
            this.lastInsertRowId = this.handle.getLastInsertedRowId();
        }
        this.updateChanges();
        preparedStatement.finalizeStatement();
    }
}

