/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wcdb.core;

import com.tencent.wcdb.base.CppObject;
import com.tencent.wcdb.base.Value;
import com.tencent.wcdb.base.WCDBException;
import com.tencent.wcdb.core.Handle;
import com.tencent.wcdb.core.HandleORMOperation;
import com.tencent.wcdb.orm.Field;
import com.tencent.wcdb.winq.Expression;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Database
extends HandleORMOperation {
    public static String OperationInfoKeyHandleCount = "HandleCount";
    public static String OperationInfoKeyOpenTime = "OpenTime";
    public static String OperationInfoKeyOpenCPUTime = "OpenCPUTime";
    public static String OperationInfoKeySchemaUsage = "SchemaUsage";
    public static String OperationInfoKeyTableCount = "TableCount";
    public static String OperationInfoKeyIndexCount = "IndexCount";
    public static String OperationInfoKeyTriggerCount = "TriggerCount";
    public static final long DictDefaultMatchValue = Long.MAX_VALUE;

    private Database() {
    }

    public Database(@NotNull String path) {
        this.cppObj = Database.createDatabase(path, false, false);
    }

    public Database(@NotNull String path, boolean readonly) {
        this.cppObj = Database.createDatabase(path, readonly, false);
    }

    public static Database createInMemoryDatabase() {
        long cppObj = Database.createDatabase("", false, true);
        Database database = new Database();
        database.cppObj = cppObj;
        return database;
    }

    private static native long createDatabase(String var0, boolean var1, boolean var2);

    @NotNull
    public String getPath() {
        return Database.getPath(this.cppObj);
    }

    private static native String getPath(long var0);

    public void setTag(long tag) {
        Database.setTag(this.cppObj, tag);
    }

    private static native void setTag(long var0, long var2);

    public long getTag() {
        return Database.getTag(this.cppObj);
    }

    private static native long getTag(long var0);

    public boolean canOpen() {
        return Database.canOpen(this.cppObj);
    }

    private static native boolean canOpen(long var0);

    public boolean isOpened() {
        return Database.isOpened(this.cppObj);
    }

    private static native boolean isOpened(long var0);

    private static void onClose(@NotNull CloseCallBack callBack) throws WCDBException {
        callBack.onClose();
    }

    public void close(@Nullable CloseCallBack callBack) {
        if (this.cppObj != 0L) {
            Database.close(this.cppObj, callBack);
        }
    }

    public void close() {
        Database.close(this.cppObj, null);
    }

    private static native void close(long var0, CloseCallBack var2);

    public void blockade() {
        Database.blockade(this.cppObj);
    }

    private static native void blockade(long var0);

    public void unblockade() {
        Database.unblockade(this.cppObj);
    }

    private static native void unblockade(long var0);

    public boolean isBlockaded() {
        return Database.isBlockaded(this.cppObj);
    }

    private static native boolean isBlockaded(long var0);

    @NotNull
    public Handle getHandle() {
        return new Handle(this, false);
    }

    @Override
    @NotNull
    public Handle getHandle(boolean writeHint) {
        return new Handle(this, writeHint);
    }

    static native long getHandle(long var0, boolean var2);

    public void purge() {
        Database.purge(this.cppObj);
    }

    private static native void purge(long var0);

    public static native void purgeAll();

    public int getNumberOfAliveHandle() {
        return Database.getNumberOfAliveHandle(this.cppObj);
    }

    private static native int getNumberOfAliveHandle(long var0);

    public static native void releaseSQLiteMemory(int var0);

    public static native void setSoftHeapLimit(long var0);

    private static boolean onProgressUpdate(ProgressMonitor progress, double percentage, double increment) {
        return progress.onProgressUpdate(percentage, increment);
    }

    public void vacuum(@Nullable ProgressMonitor monitor) throws WCDBException {
        if (!Database.vacuum(this.cppObj, monitor)) {
            throw this.createException();
        }
    }

    private static native boolean vacuum(long var0, ProgressMonitor var2);

    public void enableAutoVacuum(boolean incremental) {
        Database.enableAutoVacuum(this.cppObj, incremental);
    }

    private static native void enableAutoVacuum(long var0, boolean var2);

    public void incrementalVacuum(int pages) throws WCDBException {
        if (!Database.incrementalVacuum(this.cppObj, pages)) {
            throw this.createException();
        }
    }

    private static native boolean incrementalVacuum(long var0, int var2);

    WCDBException createException() {
        return WCDBException.createException(Database.getError(this.cppObj));
    }

    private static WCDBException createThreadedException() {
        return WCDBException.createException(Database.getThreadedError());
    }

    private static native long getError(long var0);

    private static native long getThreadedError();

    @NotNull
    public List<String> getPaths() {
        return Database.getPaths(this.cppObj);
    }

    private static native List<String> getPaths(long var0);

    public void removeFiles() throws WCDBException {
        if (!Database.removeFiles(this.cppObj)) {
            throw this.createException();
        }
    }

    private static native boolean removeFiles(long var0);

    public void moveFile(@NotNull String destination) throws WCDBException {
        if (!Database.moveFile(this.cppObj, destination)) {
            throw this.createException();
        }
    }

    private static native boolean moveFile(long var0, String var2);

    public long getFileSize() throws WCDBException {
        long ret = Database.getFileSize(this.cppObj);
        if (ret < 0L) {
            throw this.createException();
        }
        return ret;
    }

    private static native long getFileSize(long var0);

    public void setCipherKey(@NotNull byte[] key, int pageSize, CipherVersion version) {
        Database.setCipherKey(this.cppObj, key, pageSize, version.ordinal());
    }

    public void setCipherKey(@NotNull byte[] key, int pageSize) {
        this.setCipherKey(key, pageSize, CipherVersion.defaultVersion);
    }

    public void setCipherKey(@NotNull byte[] key) {
        this.setCipherKey(key, 4096);
    }

    private static native void setCipherKey(long var0, byte[] var2, int var3, int var4);

    public static void setDefaultCipherVersion(CipherVersion version) {
        Database.setDefaultCipherVersion(version.ordinal());
    }

    private static native void setDefaultCipherVersion(int var0);

    private static boolean onConfig(long cppHandle, Config config) {
        Handle handle = new Handle(cppHandle, null);
        boolean ret = true;
        try {
            config.onInvocation(handle);
        }
        catch (WCDBException e) {
            ret = false;
        }
        return ret;
    }

    public void setConfig(@NotNull String configName, @Nullable Config invocation, @Nullable Config unInvocation, ConfigPriority priority) {
        int cppPriority = 0;
        switch (priority) {
            case low: {
                cppPriority = 100;
                break;
            }
            case high: {
                cppPriority = -100;
                break;
            }
            case highest: {
                cppPriority = Integer.MIN_VALUE;
            }
        }
        Database.setConfig(this.cppObj, configName, invocation, unInvocation, cppPriority);
    }

    public void setConfig(@NotNull String configName, @Nullable Config invocation, ConfigPriority priority) {
        this.setConfig(configName, invocation, null, priority);
    }

    public void setConfig(@NotNull String configName, @Nullable Config invocation) {
        this.setConfig(configName, invocation, ConfigPriority.default_);
    }

    private static native void setConfig(long var0, String var2, Config var3, Config var4, int var5);

    public void enableLiteMode(boolean enable) {
        Database.enableLiteMode(this.cppObj, enable);
    }

    private static native void enableLiteMode(long var0, boolean var2);

    private static void onTracePerformance(PerformanceTracer tracer, long tag, String path, long handleId, String sql, long costInNanoseconds, int[] infoValues) {
        PerformanceInfo info = null;
        if (infoValues != null && infoValues.length == 6) {
            info = new PerformanceInfo();
            info.tablePageReadCount = infoValues[0];
            info.tablePageWriteCount = infoValues[1];
            info.indexPageReadCount = infoValues[2];
            info.indexPageWriteCount = infoValues[3];
            info.overflowPageReadCount = infoValues[4];
            info.overflowPageWriteCount = infoValues[5];
            info.costInNanoseconds = costInNanoseconds;
        }
        assert (info != null);
        tracer.onTrace(tag, path, handleId, sql, info);
    }

    public static native void globalTracePerformance(@Nullable PerformanceTracer var0);

    public void tracePerformance(@Nullable PerformanceTracer tracer) {
        Database.tracePerformance(this.cppObj, tracer);
    }

    private static native void tracePerformance(long var0, PerformanceTracer var2);

    private static void onTraceSQL(SQLTracer tracer, long tag, String path, long handleId, String sql, String info) {
        tracer.onTrace(tag, path, handleId, sql, info);
    }

    public static native void globalTraceSQL(@Nullable SQLTracer var0);

    public void traceSQL(@Nullable SQLTracer tracer) {
        Database.traceSQL(this.cppObj, tracer);
    }

    private static native void traceSQL(long var0, SQLTracer var2);

    public void setFullSQLTraceEnable(boolean enable) {
        Database.setFullSQLTraceEnable(this.cppObj, enable);
    }

    private static native void setFullSQLTraceEnable(long var0, boolean var2);

    private static void onTraceException(ExceptionTracer tracer, long cppError) {
        tracer.onTrace(WCDBException.createException(cppError));
    }

    public static native void globalTraceException(@Nullable ExceptionTracer var0);

    public void traceException(@Nullable ExceptionTracer tracer) {
        Database.traceException(this.cppObj, tracer);
    }

    private static native void traceException(long var0, ExceptionTracer var2);

    private static void onTraceOperation(OperationTracer tracer, long cppDatabase, int cppOperation, long info) {
        Database database = new Database();
        database.cppObj = cppDatabase;
        Operation operation = Operation.Create;
        switch (cppOperation) {
            case 1: {
                operation = Operation.SetTag;
                break;
            }
            case 2: {
                operation = Operation.OpenHandle;
            }
        }
        HashMap<String, Value> javaInfo = new HashMap<String, Value>();
        Database.enumerateInfo(javaInfo, info);
        tracer.onTrace(database, operation, javaInfo);
    }

    private static native void enumerateInfo(HashMap<String, Value> var0, long var1);

    private static void onEnumerateInfo(HashMap<String, Value> javaInfo, String key, int type, long intValue, double doubleValue, String stringValue) {
        if (type == 3) {
            javaInfo.put(key, new Value(intValue));
        } else if (type == 5) {
            javaInfo.put(key, new Value(doubleValue));
        } else if (type == 6) {
            javaInfo.put(key, new Value(stringValue));
        }
    }

    public static native void globalTraceDatabaseOperation(@Nullable OperationTracer var0);

    public static native void globalTraceBusy(@Nullable BusyTracer var0, double var1);

    private static void onBusyTrace(BusyTracer tracer, long tag, String path, long tid, String sql) {
        tracer.onTrace(tag, path, tid, sql);
    }

    public void addTokenizer(@NotNull String tokenizer) {
        Database.addTokenizer(this.cppObj, tokenizer);
    }

    private static native void addTokenizer(long var0, String var2);

    public static void configPinyinDict(@NotNull Map<String, List<String>> pinyinDict) {
        String[] keys = pinyinDict.keySet().toArray(new String[0]);
        if (keys.length == 0) {
            return;
        }
        String[][] values = new String[keys.length][];
        for (int i = 0; i < keys.length; ++i) {
            List<String> pinyin = pinyinDict.get(keys[i]);
            if (pinyin == null) continue;
            values[i] = pinyin.toArray(new String[0]);
        }
        Database.configPinyinDict(keys, values);
    }

    private static native void configPinyinDict(String[] var0, String[][] var1);

    public static void configTraditionalChineseDict(@NotNull Map<String, String> traditionalChineseDict) {
        String[] keys = traditionalChineseDict.keySet().toArray(new String[0]);
        if (keys.length == 0) {
            return;
        }
        String[] values = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            values[i] = traditionalChineseDict.get(keys[i]);
        }
        Database.configTraditionalChineseDict(keys, values);
    }

    private static native void configTraditionalChineseDict(String[] var0, String[] var1);

    public void addAuxiliaryFunction(@NotNull String auxiliaryFunction) {
        Database.addAuxiliaryFunction(this.cppObj, auxiliaryFunction);
    }

    private static native void addAuxiliaryFunction(long var0, String var2);

    private static void onCorrupted(CorruptionNotification monitor, long cppDatabase) {
        Database database = new Database();
        database.cppObj = cppDatabase;
        monitor.onCorrupted(database);
    }

    public void setNotificationWhenCorrupted(@Nullable CorruptionNotification monitor) {
        Database.setNotificationWhenCorrupted(this.cppObj, monitor);
    }

    private static native void setNotificationWhenCorrupted(long var0, CorruptionNotification var2);

    public boolean checkIfCorrupted() {
        return Database.checkIfCorrupted(this.cppObj);
    }

    private static native boolean checkIfCorrupted(long var0);

    public boolean checkIfIsAlreadyCorrupted() {
        return Database.checkIfIsAlreadyCorrupted(this.cppObj);
    }

    private static native boolean checkIfIsAlreadyCorrupted(long var0);

    public void enableAutoBackup(boolean enable) {
        Database.enableAutoBackup(this.cppObj, enable);
    }

    private static native void enableAutoBackup(long var0, boolean var2);

    public void backup() throws WCDBException {
        if (!Database.backup(this.cppObj)) {
            throw this.createException();
        }
    }

    private static native boolean backup(long var0);

    private static boolean checkTableShouldBeBackup(BackupFilter filter, String tableName) {
        return filter.tableShouldBeBackup(tableName);
    }

    public void filterBackup(@Nullable BackupFilter filter) {
        Database.filterBackup(this.cppObj, filter);
    }

    private static native void filterBackup(long var0, BackupFilter var2);

    public double retrieve(@Nullable ProgressMonitor monitor) throws WCDBException {
        double score = Database.retrieve(this.cppObj, monitor);
        if (score < 0.0) {
            throw this.createException();
        }
        return score;
    }

    private static native double retrieve(long var0, ProgressMonitor var2);

    public void deposit() throws WCDBException {
        if (!Database.deposit(this.cppObj)) {
            throw this.createException();
        }
    }

    private static native boolean deposit(long var0);

    public void removeDepositedFiles() throws WCDBException {
        if (!Database.removeDepositedFiles(this.cppObj)) {
            throw this.createException();
        }
    }

    private static native boolean removeDepositedFiles(long var0);

    public boolean containDepositedFiles() {
        return Database.containDepositedFiles(this.cppObj);
    }

    private static native boolean containDepositedFiles(long var0);

    public void passiveCheckpoint() throws WCDBException {
        if (!Database.passiveCheckpoint(this.cppObj)) {
            throw this.createException();
        }
    }

    private static native boolean passiveCheckpoint(long var0);

    public void truncateCheckpoint() throws WCDBException {
        if (!Database.truncateCheckpoint(this.cppObj)) {
            throw this.createException();
        }
    }

    private static native boolean truncateCheckpoint(long var0);

    public void setAutoCheckpointEnable(boolean enable) {
        Database.setAutoCheckpointEnable(this.cppObj, enable);
    }

    private static native void setAutoCheckpointEnable(long var0, boolean var2);

    public static native void setAutoCheckpointMinFrames(int var0);

    private static void filterMigrate(MigrationFilter filter, long cppInfoSetter, long cppInfo, String table) {
        MigrationInfo info = new MigrationInfo();
        info.table = table;
        filter.filterMigrate(info);
        Database.setMigrationInfo(cppInfoSetter, cppInfo, info.sourceTable, CppObject.get(info.filterCondition));
    }

    private static native void setMigrationInfo(long var0, long var2, String var4, long var5);

    public void addMigrationSource(@NotNull String sourcePath, @Nullable byte[] sourceCipher, @NotNull MigrationFilter filter) {
        Database.addMigrationSource(this.cppObj, sourcePath, sourceCipher, filter);
    }

    public void addMigrationSource(@NotNull String sourcePath, @NotNull MigrationFilter filter) {
        this.addMigrationSource(sourcePath, null, filter);
    }

    private static native void addMigrationSource(long var0, String var2, byte[] var3, MigrationFilter var4);

    public void stepMigration() throws WCDBException {
        if (!Database.stepMigration(this.cppObj)) {
            throw this.createException();
        }
    }

    private static native boolean stepMigration(long var0);

    public void enableAutoMigration(boolean enable) {
        Database.enableAutoMigration(this.cppObj, enable);
    }

    private static native void enableAutoMigration(long var0, boolean var2);

    private static void onTableMigrated(MigrationNotification notification, long cppDatabase, String table, String sourceTable) {
        Database database = new Database();
        database.cppObj = cppDatabase;
        MigrationInfo info = null;
        if (table != null && table.length() > 0) {
            info = new MigrationInfo();
            info.table = table;
            info.sourceTable = sourceTable;
        }
        notification.onMigrated(database, info);
    }

    public void setNotificationWhenMigrated(@Nullable MigrationNotification notification) {
        Database.setNotificationWhenMigrated(this.cppObj, notification);
    }

    private static native void setNotificationWhenMigrated(long var0, MigrationNotification var2);

    public boolean isMigrated() {
        return Database.isMigrated(this.cppObj);
    }

    private static native boolean isMigrated(long var0);

    @NotNull
    public static byte[] trainDictWithString(@NotNull List<String> samples, byte dictId) throws WCDBException {
        byte[] dict = Database.trainDict(samples.toArray(new String[0]), dictId);
        if (dict == null || dict.length == 0) {
            throw Database.createThreadedException();
        }
        return dict;
    }

    private static native byte[] trainDict(String[] var0, byte var1);

    @NotNull
    public static byte[] trainDictWithData(@NotNull List<byte[]> samples, byte dictId) throws WCDBException {
        byte[] dict = Database.trainDict((byte[][])samples.toArray((T[])new byte[0][]), dictId);
        if (dict == null || dict.length == 0) {
            throw Database.createThreadedException();
        }
        return dict;
    }

    private static native byte[] trainDict(byte[][] var0, byte var1);

    public static void registerDict(@NotNull byte[] dict, byte dictId) throws WCDBException {
        if (!Database.nativeRegisterDict(dict, dictId)) {
            throw Database.createThreadedException();
        }
    }

    private static native boolean nativeRegisterDict(byte[] var0, byte var1);

    private static native void addZSTDNormalCompress(long var0, long var2);

    private static native void addZSTDDictCompress(long var0, long var2, byte var4);

    private static native void addZSTDMultiDictCompress(long var0, long var2, long var4, long[] var6, byte[] var7);

    private static native void enableReplaceCompression(long var0);

    private static void filterCompress(CompressionFilter filter, long cppInfo, String table) {
        CompressionInfo info = new CompressionInfo(cppInfo, table);
        filter.filterCompress(info);
    }

    public void setCompression(@Nullable CompressionFilter filter) {
        Database.setCompression(this.cppObj, filter);
    }

    private static native void setCompression(long var0, CompressionFilter var2);

    public void disableCompressNewData(boolean disable) {
        Database.disableCompressNewData(this.cppObj, disable);
    }

    private static native void disableCompressNewData(long var0, boolean var2);

    public void stepCompression() throws WCDBException {
        if (!Database.stepCompression(this.cppObj)) {
            throw this.createException();
        }
    }

    private static native boolean stepCompression(long var0);

    public void enableAutoCompression(boolean enable) {
        Database.enableAutoCompression(this.cppObj, enable);
    }

    private static native void enableAutoCompression(long var0, boolean var2);

    private static void onTableCompressed(CompressionNotification notification, long cppDatabase, String table) {
        Database database = new Database();
        database.cppObj = cppDatabase;
        notification.onCompressed(database, table);
    }

    public void setNotificationWhenCompressed(@Nullable CompressionNotification notification) {
        Database.setNotificationWhenCompressed(this.cppObj, notification);
    }

    private static native void setNotificationWhenCompressed(long var0, CompressionNotification var2);

    public boolean isCompressed() {
        return Database.isCompressed(this.cppObj);
    }

    private static native boolean isCompressed(long var0);

    public void rollbackCompression(@Nullable ProgressMonitor monitor) throws WCDBException {
        if (!Database.rollbackCompression(this.cppObj, monitor)) {
            throw this.createException();
        }
    }

    private static native boolean rollbackCompression(long var0, ProgressMonitor var2);

    @Override
    boolean autoInvalidateHandle() {
        return true;
    }

    @Override
    Database getDatabase() {
        return this;
    }

    public static interface CloseCallBack {
        public void onClose() throws WCDBException;
    }

    public static interface ProgressMonitor {
        public boolean onProgressUpdate(double var1, double var3);
    }

    public static enum CipherVersion {
        defaultVersion,
        version1,
        version2,
        version3,
        version4;

    }

    public static interface Config {
        public void onInvocation(@NotNull Handle var1) throws WCDBException;
    }

    public static enum ConfigPriority {
        low,
        default_,
        high,
        highest;

    }

    public static class PerformanceInfo {
        public int tablePageReadCount;
        public int tablePageWriteCount;
        public int indexPageReadCount;
        public int indexPageWriteCount;
        public int overflowPageReadCount;
        public int overflowPageWriteCount;
        public long costInNanoseconds;
    }

    public static interface PerformanceTracer {
        public void onTrace(long var1, @NotNull String var3, long var4, @NotNull String var6, @NotNull PerformanceInfo var7);
    }

    public static interface SQLTracer {
        public void onTrace(long var1, @NotNull String var3, long var4, @NotNull String var6, @NotNull String var7);
    }

    public static interface ExceptionTracer {
        public void onTrace(@NotNull WCDBException var1);
    }

    public static enum Operation {
        Create,
        SetTag,
        OpenHandle;

    }

    public static interface OperationTracer {
        public void onTrace(@NotNull Database var1, Operation var2, @NotNull HashMap<String, Value> var3);
    }

    public static interface BusyTracer {
        public void onTrace(long var1, @NotNull String var3, long var4, @NotNull String var6);
    }

    public static interface CorruptionNotification {
        public void onCorrupted(@NotNull Database var1);
    }

    public static interface BackupFilter {
        public boolean tableShouldBeBackup(@NotNull String var1);
    }

    public static class MigrationInfo {
        public String table;
        public String sourceTable;
        public Expression filterCondition;
    }

    public static interface MigrationFilter {
        public void filterMigrate(@NotNull MigrationInfo var1);
    }

    public static interface MigrationNotification {
        public void onMigrated(@NotNull Database var1, @Nullable MigrationInfo var2);
    }

    public static class CompressionInfo {
        public String table;
        private long cppInfo;

        public <T> void addZSTDNormalCompress(@NotNull Field<T> field) {
            Database.addZSTDNormalCompress(this.cppInfo, CppObject.get(field));
        }

        public <T> void addZSTDDictCompress(@NotNull Field<T> field, byte dictId) {
            Database.addZSTDDictCompress(this.cppInfo, CppObject.get(field), dictId);
        }

        public <T> void enableReplaceCompression() {
            Database.enableReplaceCompression(this.cppInfo);
        }

        public <T> void addZSTDMultiDictCompress(@NotNull Field<T> field, @NotNull Field<T> matchField, @NotNull Map<Long, Byte> dicts) {
            long[] values = new long[dicts.size()];
            byte[] dictIds = new byte[dicts.size()];
            int index = 0;
            for (Map.Entry<Long, Byte> entry : dicts.entrySet()) {
                values[index] = entry.getKey();
                dictIds[index] = entry.getValue();
                ++index;
            }
            Database.addZSTDMultiDictCompress(this.cppInfo, CppObject.get(field), CppObject.get(matchField), values, dictIds);
        }

        CompressionInfo(long cppInfo, String table) {
            this.cppInfo = cppInfo;
            this.table = table;
        }
    }

    public static interface CompressionFilter {
        public void filterCompress(@NotNull CompressionInfo var1);
    }

    public static interface CompressionNotification {
        public void onCompressed(@NotNull Database var1, @Nullable String var2);
    }
}

