/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wcdb.core;

import com.tencent.wcdb.base.CppObject;
import com.tencent.wcdb.base.WCDBException;
import com.tencent.wcdb.core.Database;
import com.tencent.wcdb.core.HandleORMOperation;
import com.tencent.wcdb.core.PausableTransaction;
import com.tencent.wcdb.core.PreparedStatement;
import com.tencent.wcdb.core.Transaction;
import com.tencent.wcdb.winq.Statement;
import org.jetbrains.annotations.NotNull;

public class Handle
extends HandleORMOperation
implements AutoCloseable {
    private PreparedStatement mainStatement = null;
    private final Database database;
    private boolean writeHint = false;

    Handle(Database database, boolean writeHint) {
        this.database = database;
        this.writeHint = writeHint;
    }

    Handle(long cppObj, Database database) {
        this.cppObj = cppObj;
        this.database = database;
    }

    public long getCppHandle() throws WCDBException {
        if (this.cppObj == 0L) {
            assert (this.database != null);
            this.cppObj = Database.getHandle(CppObject.get(this.database), this.writeHint);
            if (this.cppObj == 0L) {
                throw this.database.createException();
            }
        }
        return this.cppObj;
    }

    WCDBException createException() {
        return WCDBException.createException(Handle.getError(this.cppObj));
    }

    static native long getError(long var0);

    @NotNull
    public PreparedStatement getOrCreatePreparedStatement(@NotNull Statement statement) throws WCDBException {
        long cppPreparedStatement = Handle.getOrCreatePreparedStatement(this.getCppHandle(), CppObject.get(statement));
        if (cppPreparedStatement == 0L) {
            throw this.createException();
        }
        return new PreparedStatement(cppPreparedStatement);
    }

    static native long getOrCreatePreparedStatement(long var0, long var2);

    @NotNull
    public PreparedStatement getOrCreatePreparedStatement(@NotNull String sql) throws WCDBException {
        long cppPreparedStatement = Handle.getOrCreatePreparedStatementWithSQL(this.getCppHandle(), sql);
        if (cppPreparedStatement == 0L) {
            throw this.createException();
        }
        return new PreparedStatement(cppPreparedStatement);
    }

    static native long getOrCreatePreparedStatementWithSQL(long var0, String var2);

    @NotNull
    public PreparedStatement preparedWithMainStatement(@NotNull Statement statement) throws WCDBException {
        if (this.mainStatement == null) {
            this.mainStatement = new PreparedStatement(Handle.getMainStatement(this.getCppHandle()));
            this.mainStatement.autoFinalize = true;
        }
        this.mainStatement.prepare(statement);
        return this.mainStatement;
    }

    @NotNull
    public PreparedStatement preparedWithMainStatement(@NotNull String sql) throws WCDBException {
        if (this.mainStatement == null) {
            this.mainStatement = new PreparedStatement(Handle.getMainStatement(this.getCppHandle()));
            this.mainStatement.autoFinalize = true;
        }
        this.mainStatement.prepare(sql);
        return this.mainStatement;
    }

    static native long getMainStatement(long var0);

    public void finalizeAllStatements() {
        if (this.cppObj != 0L) {
            Handle.finalizeAllStatements(this.cppObj);
        }
    }

    static native void finalizeAllStatements(long var0);

    public void invalidate() {
        this.mainStatement = null;
        if (this.cppObj != 0L) {
            Handle.releaseCPPObject(this.cppObj);
            this.cppObj = 0L;
            this.writeHint = false;
        }
    }

    @Override
    public void close() {
        this.invalidate();
    }

    static native int tableExist(long var0, String var2);

    static native boolean execute(long var0, long var2);

    static native boolean executeSQL(long var0, String var2);

    public int getChanges() throws WCDBException {
        return Handle.getChanges(this.getCppHandle());
    }

    static native int getChanges(long var0);

    public int getTotalChanges() throws WCDBException {
        return Handle.getTotalChanges(this.getCppHandle());
    }

    static native int getTotalChanges(long var0);

    public long getLastInsertedRowId() throws WCDBException {
        return Handle.getLastInsertedRowId(this.getCppHandle());
    }

    static native long getLastInsertedRowId(long var0);

    static native boolean isInTransaction(long var0);

    static native boolean beginTransaction(long var0);

    static native boolean commitTransaction(long var0);

    static native void rollbackTransaction(long var0);

    @Override
    Handle getHandle(boolean writeHint) {
        return this;
    }

    @Override
    Database getDatabase() {
        return this.database;
    }

    @Override
    boolean autoInvalidateHandle() {
        return false;
    }

    private boolean onTransaction(long cppHandle, Transaction transaction) {
        boolean ret;
        Handle handle = new Handle(cppHandle, this.database);
        try {
            ret = transaction.insideTransaction(handle);
        }
        catch (WCDBException e) {
            ret = false;
        }
        return ret;
    }

    native boolean runTransaction(long var1, Transaction var3);

    private int onPausableTransaction(long cppHandle, PausableTransaction transaction, boolean isNewTransaction) {
        int ret;
        Handle handle = new Handle(cppHandle, this.database);
        try {
            ret = transaction.insideTransaction(handle, isNewTransaction) ? 1 : 0;
        }
        catch (WCDBException e) {
            ret = 2;
        }
        return ret;
    }

    native boolean runPausableTransaction(long var1, PausableTransaction var3);

    private static native long createCancellationSignal();

    private static native void cancelSignal(long var0);

    public void attachCancellationSignal(@NotNull CancellationSignal signal) throws WCDBException {
        Handle.attachCancellationSignal(this.getCppHandle(), CppObject.get(signal));
    }

    private static native void attachCancellationSignal(long var0, long var2);

    public void detachCancellationSignal() {
        if (this.cppObj != 0L) {
            Handle.detachCancellationSignal(this.cppObj);
        }
    }

    private static native void detachCancellationSignal(long var0);

    public static class CancellationSignal
    extends CppObject {
        public CancellationSignal() {
            this.cppObj = Handle.createCancellationSignal();
        }

        public void cancel() {
            Handle.cancelSignal(this.cppObj);
        }
    }
}

