/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wcdb.core;

import com.tencent.wcdb.base.WCDBException;
import com.tencent.wcdb.chaincall.Delete;
import com.tencent.wcdb.chaincall.Insert;
import com.tencent.wcdb.chaincall.Select;
import com.tencent.wcdb.chaincall.Update;
import com.tencent.wcdb.core.TableOperation;
import com.tencent.wcdb.orm.Field;
import com.tencent.wcdb.orm.TableBinding;
import com.tencent.wcdb.winq.Expression;
import com.tencent.wcdb.winq.OrderingTerm;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableORMOperation<T>
extends TableOperation {
    TableBinding<T> binding = null;

    TableORMOperation() {
    }

    @NotNull
    public TableBinding<T> getBinding() {
        return this.binding;
    }

    @NotNull
    public Insert<T> prepareInsert() {
        Insert insert = new Insert(this.database.getHandle(true), false, true);
        insert.intoTable(this.tableName);
        return insert;
    }

    @NotNull
    public Update<T> prepareUpdate() {
        Update update = new Update(this.database.getHandle(true), false, true);
        update.table(this.tableName);
        return update;
    }

    @NotNull
    public Select<T> prepareSelect() {
        Select select = new Select(this.database.getHandle(false), false, true);
        select.from(this.tableName);
        return select;
    }

    @NotNull
    public Delete prepareDelete() throws WCDBException {
        Delete delete = new Delete(this.database.getHandle(true), false, true);
        delete.fromTable(this.tableName);
        return delete;
    }

    public void insertObject(@Nullable T object) throws WCDBException {
        this.prepareInsert().value(object).onFields(this.binding.allBindingFields()).execute();
    }

    public void insertObject(@Nullable T object, @NotNull Field<T>[] fields) throws WCDBException {
        this.prepareInsert().value(object).onFields(fields).execute();
    }

    public void insertOrReplaceObject(@Nullable T object) throws WCDBException {
        this.prepareInsert().orReplace().value(object).onFields(this.binding.allBindingFields()).execute();
    }

    public void insertOrReplaceObject(@Nullable T object, @NotNull Field<T>[] fields) throws WCDBException {
        this.prepareInsert().orReplace().value(object).onFields(fields).execute();
    }

    public void insertOrIgnoreObject(@Nullable T object) throws WCDBException {
        this.prepareInsert().orIgnore().value(object).onFields(this.binding.allBindingFields()).execute();
    }

    public void insertOrIgnoreObject(@Nullable T object, @NotNull Field<T>[] fields) throws WCDBException {
        this.prepareInsert().orIgnore().value(object).onFields(fields).execute();
    }

    public void insertObjects(@NotNull Collection<T> objects) throws WCDBException {
        this.prepareInsert().values(objects).onFields(this.binding.allBindingFields()).execute();
    }

    public void insertObjects(@NotNull Collection<T> objects, @NotNull Field<T>[] fields) throws WCDBException {
        this.prepareInsert().values(objects).onFields(fields).execute();
    }

    public void insertOrReplaceObjects(@NotNull Collection<T> objects) throws WCDBException {
        this.prepareInsert().orReplace().values(objects).onFields(this.binding.allBindingFields()).execute();
    }

    public void insertOrReplaceObjects(@NotNull Collection<T> objects, @NotNull Field<T>[] fields) throws WCDBException {
        this.prepareInsert().orReplace().values(objects).onFields(fields).execute();
    }

    public void insertOrIgnoreObjects(@NotNull Collection<T> objects) throws WCDBException {
        this.prepareInsert().orIgnore().values(objects).onFields(this.binding.allBindingFields()).execute();
    }

    public void insertOrIgnoreObjects(@NotNull Collection<T> objects, @NotNull Field<T>[] fields) throws WCDBException {
        this.prepareInsert().orIgnore().values(objects).onFields(fields).execute();
    }

    public void deleteObjects() throws WCDBException {
        this.prepareDelete().execute();
    }

    public void deleteObjects(@Nullable Expression condition) throws WCDBException {
        this.prepareDelete().where(condition).execute();
    }

    public void deleteObjects(@Nullable Expression condition, @Nullable OrderingTerm order, long limit) throws WCDBException {
        this.prepareDelete().where(condition).orderBy(order).limit(limit).execute();
    }

    public void deleteObjects(@Nullable Expression condition, @Nullable OrderingTerm order, long limit, long offset) throws WCDBException {
        this.prepareDelete().where(condition).orderBy(order).limit(limit).offset(offset).execute();
    }

    public void deleteObjects(@Nullable OrderingTerm order, long limit) throws WCDBException {
        this.prepareDelete().orderBy(order).limit(limit).execute();
    }

    public void deleteObjects(@Nullable OrderingTerm order, long limit, long offset) throws WCDBException {
        this.prepareDelete().orderBy(order).limit(limit).offset(offset).execute();
    }

    public void updateObject(@Nullable T object) throws WCDBException {
        this.prepareUpdate().set(this.binding.allBindingFields()).toObject(object).execute();
    }

    public void updateObject(@Nullable T object, @Nullable Expression condition) throws WCDBException {
        this.prepareUpdate().set(this.binding.allBindingFields()).toObject(object).where(condition).execute();
    }

    public void updateObject(@Nullable T object, @Nullable Expression condition, @Nullable OrderingTerm order, long limit) throws WCDBException {
        this.prepareUpdate().set(this.binding.allBindingFields()).toObject(object).where(condition).orderBy(order).limit(limit).execute();
    }

    public void updateObject(@Nullable T object, @Nullable Expression condition, @Nullable OrderingTerm order, long limit, long offset) throws WCDBException {
        this.prepareUpdate().set(this.binding.allBindingFields()).toObject(object).where(condition).orderBy(order).limit(limit).offset(offset).execute();
    }

    public void updateObject(@Nullable T object, @Nullable OrderingTerm order, long limit) throws WCDBException {
        this.prepareUpdate().set(this.binding.allBindingFields()).toObject(object).orderBy(order).limit(limit).execute();
    }

    public void updateObject(@Nullable T object, @Nullable OrderingTerm order, long limit, long offset) throws WCDBException {
        this.prepareUpdate().set(this.binding.allBindingFields()).toObject(object).orderBy(order).limit(limit).offset(offset).execute();
    }

    public void updateObject(@Nullable T object, @NotNull Field<T> field) throws WCDBException {
        this.prepareUpdate().set(field).toObject(object).execute();
    }

    public void updateObject(@Nullable T object, @NotNull Field<T> field, @Nullable Expression condition) throws WCDBException {
        this.prepareUpdate().set(field).toObject(object).where(condition).execute();
    }

    public void updateObject(@Nullable T object, @NotNull Field<T> field, @Nullable Expression condition, @Nullable OrderingTerm order, long limit) throws WCDBException {
        this.prepareUpdate().set(field).toObject(object).where(condition).orderBy(order).limit(limit).execute();
    }

    public void updateObject(@Nullable T object, @NotNull Field<T> field, @Nullable Expression condition, @Nullable OrderingTerm order, long limit, long offset) throws WCDBException {
        this.prepareUpdate().set(field).toObject(object).where(condition).orderBy(order).limit(limit).offset(offset).execute();
    }

    public void updateObject(@Nullable T object, @NotNull Field<T> field, @Nullable OrderingTerm order, long limit) throws WCDBException {
        this.prepareUpdate().set(field).toObject(object).orderBy(order).limit(limit).execute();
    }

    public void updateObject(@Nullable T object, @NotNull Field<T> field, @Nullable OrderingTerm order, long limit, long offset) throws WCDBException {
        this.prepareUpdate().set(field).toObject(object).orderBy(order).limit(limit).offset(offset).execute();
    }

    public void updateObject(@Nullable T object, @NotNull Field<T>[] fields) throws WCDBException {
        this.prepareUpdate().set(fields).toObject(object).execute();
    }

    public void updateObject(@Nullable T object, @NotNull Field<T>[] fields, @Nullable Expression condition) throws WCDBException {
        this.prepareUpdate().set(fields).toObject(object).where(condition).execute();
    }

    public void updateObject(@Nullable T object, @NotNull Field<T>[] fields, @Nullable Expression condition, @Nullable OrderingTerm order, long limit) throws WCDBException {
        this.prepareUpdate().set(fields).toObject(object).where(condition).orderBy(order).limit(limit).execute();
    }

    public void updateObject(@Nullable T object, @NotNull Field<T>[] fields, @Nullable Expression condition, @Nullable OrderingTerm order, long limit, long offset) throws WCDBException {
        this.prepareUpdate().set(fields).toObject(object).where(condition).orderBy(order).limit(limit).offset(offset).execute();
    }

    public void updateObject(@Nullable T object, @NotNull Field<T>[] fields, @Nullable OrderingTerm order, long limit) throws WCDBException {
        this.prepareUpdate().set(fields).toObject(object).orderBy(order).limit(limit).execute();
    }

    public void updateObject(@Nullable T object, @NotNull Field<T>[] fields, @Nullable OrderingTerm order, long limit, long offset) throws WCDBException {
        this.prepareUpdate().set(fields).toObject(object).orderBy(order).limit(limit).offset(offset).execute();
    }

    @Nullable
    public T getFirstObject() throws WCDBException {
        return this.prepareSelect().select(this.binding.allBindingFields()).firstObject();
    }

    @Nullable
    public <R extends T> R getFirstObject(@NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(this.binding.allBindingFields()).firstObject(cls);
    }

    @Nullable
    public T getFirstObject(@Nullable Expression condition) throws WCDBException {
        return this.prepareSelect().select(this.binding.allBindingFields()).where(condition).firstObject();
    }

    @Nullable
    public <R extends T> R getFirstObject(@Nullable Expression condition, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(this.binding.allBindingFields()).where(condition).firstObject(cls);
    }

    @Nullable
    public T getFirstObject(@Nullable Expression condition, @Nullable OrderingTerm order) throws WCDBException {
        return this.prepareSelect().select(this.binding.allBindingFields()).where(condition).orderBy(order).firstObject();
    }

    @Nullable
    public <R extends T> R getFirstObject(@Nullable Expression condition, @Nullable OrderingTerm order, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(this.binding.allBindingFields()).where(condition).orderBy(order).firstObject(cls);
    }

    @Nullable
    public T getFirstObject(@Nullable Expression condition, @Nullable OrderingTerm order, long offset) throws WCDBException {
        return this.prepareSelect().select(this.binding.allBindingFields()).where(condition).orderBy(order).limit(1L).offset(offset).firstObject();
    }

    @Nullable
    public <R extends T> R getFirstObject(@Nullable Expression condition, @Nullable OrderingTerm order, long offset, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(this.binding.allBindingFields()).where(condition).orderBy(order).limit(1L).offset(offset).firstObject(cls);
    }

    @Nullable
    public T getFirstObject(@Nullable OrderingTerm order) throws WCDBException {
        return this.prepareSelect().select(this.binding.allBindingFields()).orderBy(order).firstObject();
    }

    @Nullable
    public <R extends T> R getFirstObject(@Nullable OrderingTerm order, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(this.binding.allBindingFields()).orderBy(order).firstObject(cls);
    }

    @Nullable
    public T getFirstObject(@Nullable OrderingTerm order, long offset) throws WCDBException {
        return this.prepareSelect().select(this.binding.allBindingFields()).orderBy(order).limit(1L).offset(offset).firstObject();
    }

    @Nullable
    public <R extends T> R getFirstObject(@Nullable OrderingTerm order, long offset, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(this.binding.allBindingFields()).orderBy(order).limit(1L).offset(offset).firstObject(cls);
    }

    @Nullable
    public T getFirstObject(@NotNull Field<T>[] fields) throws WCDBException {
        return this.prepareSelect().select(fields).firstObject();
    }

    @Nullable
    public <R extends T> R getFirstObject(@NotNull Field<T>[] fields, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(fields).firstObject(cls);
    }

    @Nullable
    public T getFirstObject(@NotNull Field<T>[] fields, @Nullable Expression condition) throws WCDBException {
        return this.prepareSelect().select(fields).where(condition).firstObject();
    }

    @Nullable
    public <R extends T> R getFirstObject(@NotNull Field<T>[] fields, @Nullable Expression condition, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(fields).where(condition).firstObject(cls);
    }

    @Nullable
    public T getFirstObject(@NotNull Field<T>[] fields, @Nullable Expression condition, @Nullable OrderingTerm order) throws WCDBException {
        return this.prepareSelect().select(fields).where(condition).orderBy(order).firstObject();
    }

    @Nullable
    public <R extends T> R getFirstObject(@NotNull Field<T>[] fields, @Nullable Expression condition, @Nullable OrderingTerm order, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(fields).where(condition).orderBy(order).firstObject(cls);
    }

    @Nullable
    public T getFirstObject(@NotNull Field<T>[] fields, @Nullable Expression condition, @Nullable OrderingTerm order, long offset) throws WCDBException {
        return this.prepareSelect().select(fields).where(condition).orderBy(order).limit(1L).offset(offset).firstObject();
    }

    @Nullable
    public <R extends T> R getFirstObject(@NotNull Field<T>[] fields, @Nullable Expression condition, @Nullable OrderingTerm order, long offset, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(fields).where(condition).orderBy(order).limit(1L).offset(offset).firstObject(cls);
    }

    @Nullable
    public T getFirstObject(@NotNull Field<T>[] fields, @Nullable OrderingTerm order) throws WCDBException {
        return this.prepareSelect().select(fields).orderBy(order).firstObject();
    }

    @Nullable
    public <R extends T> R getFirstObject(@NotNull Field<T>[] fields, @Nullable OrderingTerm order, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(fields).orderBy(order).firstObject(cls);
    }

    @Nullable
    public T getFirstObject(@NotNull Field<T>[] fields, @Nullable OrderingTerm order, long offset) throws WCDBException {
        return this.prepareSelect().select(fields).orderBy(order).limit(1L).offset(offset).firstObject();
    }

    @Nullable
    public <R extends T> R getFirstObject(@NotNull Field<T>[] fields, @Nullable OrderingTerm order, long offset, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(fields).orderBy(order).limit(1L).offset(offset).firstObject(cls);
    }

    @NotNull
    public List<T> getAllObjects() throws WCDBException {
        return this.prepareSelect().select(this.binding.allBindingFields()).allObjects();
    }

    @NotNull
    public <R extends T> List<R> getAllObjects(@NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(this.binding.allBindingFields()).allObjects(cls);
    }

    @NotNull
    public List<T> getAllObjects(@Nullable Expression condition) throws WCDBException {
        return this.prepareSelect().select(this.binding.allBindingFields()).where(condition).allObjects();
    }

    @NotNull
    public <R extends T> List<R> getAllObjects(@Nullable Expression condition, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(this.binding.allBindingFields()).where(condition).allObjects(cls);
    }

    @NotNull
    public List<T> getAllObjects(@Nullable Expression condition, @Nullable OrderingTerm order) throws WCDBException {
        return this.prepareSelect().select(this.binding.allBindingFields()).where(condition).orderBy(order).allObjects();
    }

    @NotNull
    public <R extends T> List<R> getAllObjects(@Nullable Expression condition, @Nullable OrderingTerm order, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(this.binding.allBindingFields()).where(condition).orderBy(order).allObjects(cls);
    }

    @NotNull
    public List<T> getAllObjects(@Nullable Expression condition, @Nullable OrderingTerm order, long limit) throws WCDBException {
        return this.prepareSelect().select(this.binding.allBindingFields()).where(condition).orderBy(order).limit(limit).allObjects();
    }

    @NotNull
    public <R extends T> List<R> getAllObjects(@Nullable Expression condition, @Nullable OrderingTerm order, long limit, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(this.binding.allBindingFields()).where(condition).orderBy(order).limit(limit).allObjects(cls);
    }

    @NotNull
    public List<T> getAllObjects(@Nullable Expression condition, @Nullable OrderingTerm order, long limit, long offset) throws WCDBException {
        return this.prepareSelect().select(this.binding.allBindingFields()).where(condition).orderBy(order).limit(limit).offset(offset).allObjects();
    }

    @NotNull
    public <R extends T> List<R> getAllObjects(@Nullable Expression condition, @Nullable OrderingTerm order, long limit, long offset, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(this.binding.allBindingFields()).where(condition).orderBy(order).limit(limit).offset(offset).allObjects(cls);
    }

    @NotNull
    public List<T> getAllObjects(@Nullable OrderingTerm order) throws WCDBException {
        return this.prepareSelect().select(this.binding.allBindingFields()).orderBy(order).allObjects();
    }

    @NotNull
    public <R extends T> List<R> getAllObjects(@Nullable OrderingTerm order, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(this.binding.allBindingFields()).orderBy(order).allObjects(cls);
    }

    @NotNull
    public List<T> getAllObjects(@Nullable OrderingTerm order, long limit) throws WCDBException {
        return this.prepareSelect().select(this.binding.allBindingFields()).orderBy(order).limit(limit).allObjects();
    }

    @NotNull
    public <R extends T> List<R> getAllObjects(@Nullable OrderingTerm order, long limit, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(this.binding.allBindingFields()).orderBy(order).limit(limit).allObjects(cls);
    }

    @NotNull
    public List<T> getAllObjects(@Nullable OrderingTerm order, long limit, long offset) throws WCDBException {
        return this.prepareSelect().select(this.binding.allBindingFields()).orderBy(order).limit(limit).offset(offset).allObjects();
    }

    @NotNull
    public <R extends T> List<R> getAllObjects(@Nullable OrderingTerm order, long limit, long offset, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(this.binding.allBindingFields()).orderBy(order).limit(limit).offset(offset).allObjects(cls);
    }

    @NotNull
    public List<T> getAllObjects(@NotNull Field<T>[] fields) throws WCDBException {
        return this.prepareSelect().select(fields).allObjects();
    }

    @NotNull
    public <R extends T> List<R> getAllObjects(@NotNull Field<T>[] fields, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(fields).allObjects(cls);
    }

    @NotNull
    public List<T> getAllObjects(@NotNull Field<T>[] fields, @Nullable Expression condition) throws WCDBException {
        return this.prepareSelect().select(fields).where(condition).allObjects();
    }

    @NotNull
    public <R extends T> List<R> getAllObjects(@NotNull Field<T>[] fields, @Nullable Expression condition, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(fields).where(condition).allObjects(cls);
    }

    @NotNull
    public List<T> getAllObjects(@NotNull Field<T>[] fields, @Nullable Expression condition, @Nullable OrderingTerm order) throws WCDBException {
        return this.prepareSelect().select(fields).where(condition).orderBy(order).allObjects();
    }

    @NotNull
    public <R extends T> List<R> getAllObjects(@NotNull Field<T>[] fields, @Nullable Expression condition, @Nullable OrderingTerm order, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(fields).where(condition).orderBy(order).allObjects(cls);
    }

    @NotNull
    public List<T> getAllObjects(@NotNull Field<T>[] fields, @Nullable Expression condition, @Nullable OrderingTerm order, long limit) throws WCDBException {
        return this.prepareSelect().select(fields).where(condition).orderBy(order).limit(limit).allObjects();
    }

    @NotNull
    public <R extends T> List<R> getAllObjects(@NotNull Field<T>[] fields, @Nullable Expression condition, @Nullable OrderingTerm order, long limit, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(fields).where(condition).orderBy(order).limit(limit).allObjects(cls);
    }

    @NotNull
    public List<T> getAllObjects(@NotNull Field<T>[] fields, @Nullable Expression condition, @Nullable OrderingTerm order, long limit, long offset) throws WCDBException {
        return this.prepareSelect().select(fields).where(condition).orderBy(order).limit(limit).offset(offset).allObjects();
    }

    @NotNull
    public <R extends T> List<R> getAllObjects(@NotNull Field<T>[] fields, @Nullable Expression condition, @Nullable OrderingTerm order, long limit, long offset, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(fields).where(condition).orderBy(order).limit(limit).offset(offset).allObjects(cls);
    }

    @NotNull
    public List<T> getAllObjects(@NotNull Field<T>[] fields, @Nullable OrderingTerm order) throws WCDBException {
        return this.prepareSelect().select(fields).orderBy(order).allObjects();
    }

    @NotNull
    public <R extends T> List<R> getAllObjects(@NotNull Field<T>[] fields, @Nullable OrderingTerm order, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(fields).orderBy(order).allObjects(cls);
    }

    @NotNull
    public List<T> getAllObjects(@NotNull Field<T>[] fields, @Nullable OrderingTerm order, long limit) throws WCDBException {
        return this.prepareSelect().select(fields).orderBy(order).limit(limit).allObjects();
    }

    @NotNull
    public <R extends T> List<R> getAllObjects(@NotNull Field<T>[] fields, @Nullable OrderingTerm order, long limit, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(fields).orderBy(order).limit(limit).allObjects(cls);
    }

    @NotNull
    public List<T> getAllObjects(@NotNull Field<T>[] fields, @Nullable OrderingTerm order, long limit, long offset) throws WCDBException {
        return this.prepareSelect().select(fields).orderBy(order).limit(limit).offset(offset).allObjects();
    }

    @NotNull
    public <R extends T> List<R> getAllObjects(@NotNull Field<T>[] fields, @Nullable OrderingTerm order, long limit, long offset, @NotNull Class<R> cls) throws WCDBException {
        return this.prepareSelect().select(fields).orderBy(order).limit(limit).offset(offset).allObjects(cls);
    }
}

