/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wcdb.winq;

import com.tencent.wcdb.base.CppObject;
import com.tencent.wcdb.winq.ColumnDef;
import com.tencent.wcdb.winq.ColumnType;
import com.tencent.wcdb.winq.ExpressionOperable;
import com.tencent.wcdb.winq.Identifier;
import com.tencent.wcdb.winq.IndexedColumnConvertible;
import com.tencent.wcdb.winq.Order;
import com.tencent.wcdb.winq.OrderingTerm;
import com.tencent.wcdb.winq.ResultColumn;
import com.tencent.wcdb.winq.ResultColumnConvertible;
import com.tencent.wcdb.winq.Schema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Column
extends ExpressionOperable
implements IndexedColumnConvertible,
ResultColumnConvertible {
    @Override
    protected int getType() {
        return 7;
    }

    public Column(@NotNull String name) {
        this.cppObj = Column.createCppObj(name, 0L);
    }

    protected Column(String name, long tableBinding) {
        this.cppObj = Column.createCppObj(name, tableBinding);
    }

    private static native long createCppObj(String var0, long var1);

    protected native long copy(long var1);

    @NotNull
    public Column table(@Nullable String table) {
        this.inTable(this.cppObj, table);
        return this;
    }

    protected native void inTable(long var1, String var3);

    @NotNull
    public Column of(@Nullable Schema schema) {
        this.ofSchema(this.cppObj, Identifier.getCppType(schema), CppObject.get(schema), null);
        return this;
    }

    @NotNull
    public Column of(@Nullable String schema) {
        this.ofSchema(this.cppObj, 6, 0L, schema);
        return this;
    }

    protected void ofSchema(Schema schema) {
        this.ofSchema(this.cppObj, Identifier.getCppType(schema), CppObject.get(schema), null);
    }

    protected void ofSchema(String schema) {
        this.ofSchema(this.cppObj, 6, 0L, schema);
    }

    protected native void ofSchema(long var1, int var3, long var4, String var6);

    @NotNull
    public ResultColumn as(@Nullable String alias) {
        return new ResultColumn(Column.configAlias(this.cppObj, alias));
    }

    private static native long configAlias(long var0, String var2);

    protected Column() {
    }

    public static Column all() {
        Column ret = new Column();
        ret.cppObj = Column.allColumn();
        return ret;
    }

    private static native long allColumn();

    @NotNull
    public static Column rowId() {
        Column ret = new Column();
        ret.cppObj = Column.rowidColumn();
        return ret;
    }

    private static native long rowidColumn();

    @NotNull
    public OrderingTerm order(Order order) {
        return new OrderingTerm(this).order(order);
    }

    @NotNull
    public ColumnDef asDef(ColumnType columnType) {
        return new ColumnDef(this, columnType);
    }
}

