/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wcdb.base;

import com.tencent.wcdb.base.WCDBCorruptOrIOException;
import com.tencent.wcdb.base.WCDBInterruptException;
import com.tencent.wcdb.base.WCDBNormalException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WCDBException
extends RuntimeException {
    public final Level level;
    public final Code code;
    public final Map<String, Object> info;

    WCDBException(Level level, Code code, long cppObj) {
        this.level = level;
        this.code = code;
        String message = WCDBException.getMessage(cppObj);
        this.info = new LinkedHashMap<String, Object>();
        this.info.put(Key.message.value, message);
        this.enumerateInfo(cppObj);
    }

    public static WCDBException createException(long cppObj) {
        Level level = Level.valueOf(WCDBException.getLevel(cppObj));
        Code code = Code.valueOf(WCDBException.getCode(cppObj));
        if (level != Level.Error) {
            return new WCDBNormalException(level, code, cppObj);
        }
        if (code == Code.Interrupt) {
            return new WCDBInterruptException(level, code, cppObj);
        }
        if (code == Code.Permission || code == Code.Readonly || code == Code.IOError || code == Code.Corrupt || code == Code.Full || code == Code.CantOpen || code == Code.NotADatabase) {
            return new WCDBCorruptOrIOException(level, code, cppObj);
        }
        return new WCDBNormalException(level, code, cppObj);
    }

    private static native int getLevel(long var0);

    private static native int getCode(long var0);

    private static native String getMessage(long var0);

    private native void enumerateInfo(long var1);

    private void addInfo(String key, int valueType, long intValue, double doubleValue, String stringValue) {
        if (valueType == 3) {
            this.info.put(key, intValue);
        } else if (valueType == 5) {
            this.info.put(key, doubleValue);
        } else if (valueType == 6) {
            this.info.put(key, stringValue);
        }
    }

    public long tag() {
        Object tag = this.info.get(Key.tag.getValue());
        if (tag != null) {
            return (Long)tag;
        }
        return 0L;
    }

    public ExtendCode extendCode() {
        Object code = this.info.get(Key.extendedCode.getValue());
        if (code != null) {
            return ExtendCode.valueOf(((Long)code).intValue());
        }
        return ExtendCode.Unknown;
    }

    @Nullable
    public String message() {
        return (String)this.info.get(Key.message.getValue());
    }

    @Nullable
    public String sql() {
        return (String)this.info.get(Key.SQL.getValue());
    }

    @Nullable
    public String path() {
        return (String)this.info.get(Key.path.getValue());
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("Code: ").append(this.code.value());
        for (Map.Entry<String, Object> entry : this.info.entrySet()) {
            sb.append("; ").append(entry.getKey()).append(": ").append(entry.getValue());
        }
        return sb.toString();
    }

    @NotNull
    public String toStringForLog() {
        return "[WCDB] [" + (Object)((Object)this.level) + "] " + this.getMessage();
    }

    public static enum Level {
        Ignore,
        Debug,
        Notice,
        Warning,
        Error,
        Fatal,
        Unknown;


        public static Level valueOf(int value) {
            switch (value) {
                case 1: {
                    return Ignore;
                }
                case 2: {
                    return Debug;
                }
                case 3: {
                    return Notice;
                }
                case 4: {
                    return Warning;
                }
                case 5: {
                    return Error;
                }
                case 6: {
                    return Fatal;
                }
            }
            return Unknown;
        }

        @NotNull
        public String toString() {
            switch (this) {
                case Ignore: {
                    return "IGNORE";
                }
                case Debug: {
                    return "DEBUG";
                }
                case Notice: {
                    return "NOTICE";
                }
                case Warning: {
                    return "WARNING";
                }
                case Error: {
                    return "ERROR";
                }
                case Fatal: {
                    return "FATAL";
                }
            }
            return "UNKNOWN";
        }
    }

    public static enum Code {
        OK(0),
        Error(1),
        Internal(2),
        Permission(3),
        Abort(4),
        Busy(5),
        Locked(6),
        NoMemory(7),
        Readonly(8),
        Interrupt(9),
        IOError(10),
        Corrupt(11),
        NotFound(12),
        Full(13),
        CantOpen(14),
        Protocol(15),
        Empty(16),
        Schema(17),
        Exceed(18),
        Constraint(19),
        Mismatch(20),
        Misuse(21),
        NoLargeFileSupport(22),
        Authorization(23),
        Format(24),
        Range(25),
        NotADatabase(26),
        Notice(27),
        Warning(28),
        Row(100),
        Done(101),
        Unknown(-1);

        private final int value;

        private Code(int value) {
            this.value = value;
        }

        public static Code valueOf(int value) {
            switch (value) {
                case 0: {
                    return OK;
                }
                case 1: {
                    return Error;
                }
                case 2: {
                    return Internal;
                }
                case 3: {
                    return Permission;
                }
                case 4: {
                    return Abort;
                }
                case 5: {
                    return Busy;
                }
                case 6: {
                    return Locked;
                }
                case 7: {
                    return NoMemory;
                }
                case 8: {
                    return Readonly;
                }
                case 9: {
                    return Interrupt;
                }
                case 10: {
                    return IOError;
                }
                case 11: {
                    return Corrupt;
                }
                case 12: {
                    return NotFound;
                }
                case 13: {
                    return Full;
                }
                case 14: {
                    return CantOpen;
                }
                case 15: {
                    return Protocol;
                }
                case 16: {
                    return Empty;
                }
                case 17: {
                    return Schema;
                }
                case 18: {
                    return Exceed;
                }
                case 19: {
                    return Constraint;
                }
                case 20: {
                    return Mismatch;
                }
                case 21: {
                    return Misuse;
                }
                case 22: {
                    return NoLargeFileSupport;
                }
                case 23: {
                    return Authorization;
                }
                case 24: {
                    return Format;
                }
                case 25: {
                    return Range;
                }
                case 26: {
                    return NotADatabase;
                }
                case 27: {
                    return Notice;
                }
                case 28: {
                    return Warning;
                }
                case 100: {
                    return Row;
                }
                case 101: {
                    return Done;
                }
            }
            return Unknown;
        }

        public int value() {
            return this.value;
        }
    }

    public static enum Key {
        tag("Tag"),
        path("Path"),
        type("Type"),
        source("Source"),
        SQL("SQL"),
        extendedCode("ExtCode"),
        message("Message");

        private final String value;

        private Key(String value) {
            this.value = value;
        }

        String getValue() {
            return this.value;
        }
    }

    public static enum ExtendCode {
        ErrorMissingCollseq(257),
        ErrorRetry(513),
        ErrorSnapshot(769),
        IOErrorRead(266),
        IOErrorShortRead(522),
        IOErrorWrite(778),
        IOErrorFsync(1034),
        IOErrorDirFsync(1290),
        IOErrorTruncate(1546),
        IOErrorFstat(1802),
        IOErrorUnlock(2058),
        IOErrorRdlock(2314),
        IOErrorDelete(2570),
        IOErrorBlocked(2826),
        IOErrorNoMemory(3082),
        IOErrorAccess(3338),
        IOErrorCheckReservedLock(3594),
        IOErrorLock(3850),
        IOErrorClose(4106),
        IOErrorDirClose(4362),
        IOErrorShmOpen(4618),
        IOErrorShmSize(4874),
        IOErrorShmLock(5130),
        IOErrorShmMap(5386),
        IOErrorSeek(5642),
        IOErrorDeleteNoEntry(5898),
        IOErrorMmap(6154),
        IOErrorGetTempPath(6410),
        IOErrorConvPath(6666),
        IOErrorVnode(6922),
        IOErrorAuthorization(7178),
        IOErrorBeginAtomic(7434),
        IOErrorCommitAtomic(7690),
        IOErrorRollbackAtomic(7946),
        LockedSharedCache(262),
        LockedVirtualTable(518),
        BusyRecovery(261),
        BusySnapshot(517),
        CantOpenNoTempDir(270),
        CantOpenIsDir(526),
        CantOpenFullPath(782),
        CantOpenConvPath(1038),
        CantOpenDirtyWal(1294),
        CorruptVirtualTable(267),
        CorruptSequence(523),
        ReadonlyRecovery(264),
        ReadonlyCantLock(520),
        ReadonlyRollback(776),
        ReadonlyDatabaseMoved(1032),
        ReadonlyCantInit(1288),
        ReadonlyDirectory(1544),
        AbortRollback(516),
        ConstraintCheck(275),
        ConstraintCommitHook(531),
        ConstraintForeignKey(787),
        ConstraintFunction(1043),
        ConstraintNotNull(1299),
        ConstraintPrimaryKey(1555),
        ConstraintTrigger(1811),
        ConstraintUnique(2067),
        ConstraintVirtualTable(2323),
        ConstraintRowID(2579),
        NoticeRecoverWal(283),
        NoticeRecoverRollback(539),
        WarningAutoIndex(284),
        AuthorizationUser(279),
        OKLoadPermanently(256),
        Unknown(-1);

        private final int value;

        private ExtendCode(int value) {
            this.value = value;
        }

        public static ExtendCode valueOf(int value) {
            switch (value) {
                case 257: {
                    return ErrorMissingCollseq;
                }
                case 513: {
                    return ErrorRetry;
                }
                case 769: {
                    return ErrorSnapshot;
                }
                case 266: {
                    return IOErrorRead;
                }
                case 522: {
                    return IOErrorShortRead;
                }
                case 778: {
                    return IOErrorWrite;
                }
                case 1034: {
                    return IOErrorFsync;
                }
                case 1290: {
                    return IOErrorDirFsync;
                }
                case 1546: {
                    return IOErrorTruncate;
                }
                case 1802: {
                    return IOErrorFstat;
                }
                case 2058: {
                    return IOErrorUnlock;
                }
                case 2314: {
                    return IOErrorRdlock;
                }
                case 2570: {
                    return IOErrorDelete;
                }
                case 2826: {
                    return IOErrorBlocked;
                }
                case 3082: {
                    return IOErrorNoMemory;
                }
                case 3338: {
                    return IOErrorAccess;
                }
                case 3594: {
                    return IOErrorCheckReservedLock;
                }
                case 3850: {
                    return IOErrorLock;
                }
                case 4106: {
                    return IOErrorClose;
                }
                case 4362: {
                    return IOErrorDirClose;
                }
                case 4618: {
                    return IOErrorShmOpen;
                }
                case 4874: {
                    return IOErrorShmSize;
                }
                case 5130: {
                    return IOErrorShmLock;
                }
                case 5386: {
                    return IOErrorShmMap;
                }
                case 5642: {
                    return IOErrorSeek;
                }
                case 5898: {
                    return IOErrorDeleteNoEntry;
                }
                case 6154: {
                    return IOErrorMmap;
                }
                case 6410: {
                    return IOErrorGetTempPath;
                }
                case 6666: {
                    return IOErrorConvPath;
                }
                case 6922: {
                    return IOErrorVnode;
                }
                case 7178: {
                    return IOErrorAuthorization;
                }
                case 7434: {
                    return IOErrorBeginAtomic;
                }
                case 7690: {
                    return IOErrorCommitAtomic;
                }
                case 7946: {
                    return IOErrorRollbackAtomic;
                }
                case 262: {
                    return LockedSharedCache;
                }
                case 518: {
                    return LockedVirtualTable;
                }
                case 261: {
                    return BusyRecovery;
                }
                case 517: {
                    return BusySnapshot;
                }
                case 270: {
                    return CantOpenNoTempDir;
                }
                case 526: {
                    return CantOpenIsDir;
                }
                case 782: {
                    return CantOpenFullPath;
                }
                case 1038: {
                    return CantOpenConvPath;
                }
                case 1294: {
                    return CantOpenDirtyWal;
                }
                case 267: {
                    return CorruptVirtualTable;
                }
                case 523: {
                    return CorruptSequence;
                }
                case 264: {
                    return ReadonlyRecovery;
                }
                case 520: {
                    return ReadonlyCantLock;
                }
                case 776: {
                    return ReadonlyRollback;
                }
                case 1032: {
                    return ReadonlyDatabaseMoved;
                }
                case 1288: {
                    return ReadonlyCantInit;
                }
                case 1544: {
                    return ReadonlyDirectory;
                }
                case 516: {
                    return AbortRollback;
                }
                case 275: {
                    return ConstraintCheck;
                }
                case 531: {
                    return ConstraintCommitHook;
                }
                case 787: {
                    return ConstraintForeignKey;
                }
                case 1043: {
                    return ConstraintFunction;
                }
                case 1299: {
                    return ConstraintNotNull;
                }
                case 1555: {
                    return ConstraintPrimaryKey;
                }
                case 1811: {
                    return ConstraintTrigger;
                }
                case 2067: {
                    return ConstraintUnique;
                }
                case 2323: {
                    return ConstraintVirtualTable;
                }
                case 2579: {
                    return ConstraintRowID;
                }
                case 283: {
                    return NoticeRecoverWal;
                }
                case 539: {
                    return NoticeRecoverRollback;
                }
                case 284: {
                    return WarningAutoIndex;
                }
                case 279: {
                    return AuthorizationUser;
                }
                case 256: {
                    return OKLoadPermanently;
                }
            }
            return Unknown;
        }

        public int value() {
            return this.value;
        }
    }
}

