/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wcdb.winq;

import com.tencent.wcdb.base.CppObject;
import com.tencent.wcdb.winq.CommonTableExpression;
import com.tencent.wcdb.winq.Expression;
import com.tencent.wcdb.winq.ExpressionConvertible;
import com.tencent.wcdb.winq.Identifier;
import com.tencent.wcdb.winq.OrderingTerm;
import com.tencent.wcdb.winq.ResultColumnConvertible;
import com.tencent.wcdb.winq.Statement;
import com.tencent.wcdb.winq.TableOrSubqueryConvertible;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatementSelect
extends Statement
implements TableOrSubqueryConvertible {
    @Override
    protected int getType() {
        return 42;
    }

    public StatementSelect() {
        this.cppObj = StatementSelect.createCppObj();
    }

    private static native long createCppObj();

    @NotNull
    public StatementSelect with(CommonTableExpression ... expressions) {
        if (expressions == null || expressions.length == 0) {
            return this;
        }
        long[] cppExps = new long[expressions.length];
        for (int i = 0; i < expressions.length; ++i) {
            cppExps[i] = CppObject.get(expressions[i]);
        }
        StatementSelect.configWith(this.cppObj, cppExps);
        return this;
    }

    @NotNull
    public StatementSelect withRecursive(CommonTableExpression ... expressions) {
        if (expressions == null || expressions.length == 0) {
            return this;
        }
        long[] cppExps = new long[expressions.length];
        for (int i = 0; i < expressions.length; ++i) {
            cppExps[i] = CppObject.get(expressions[i]);
        }
        StatementSelect.configWith(this.cppObj, cppExps);
        StatementSelect.configRecursive(this.cppObj);
        return this;
    }

    private static native void configWith(long var0, long[] var2);

    private static native void configRecursive(long var0);

    @NotNull
    public StatementSelect select(ResultColumnConvertible ... resultColumns) {
        if (resultColumns.length == 0) {
            return this;
        }
        int totalCount = resultColumns.length;
        int[] types = new int[totalCount];
        long[] cppObjs = new long[totalCount];
        for (int i = 0; i < totalCount; ++i) {
            types[i] = Identifier.getCppType(resultColumns[i]);
            cppObjs[i] = CppObject.get(resultColumns[i]);
        }
        StatementSelect.configResultColumns(this.cppObj, types, cppObjs, null, null);
        return this;
    }

    @NotNull
    public StatementSelect select(String ... resultColumns) {
        if (resultColumns.length == 0) {
            return this;
        }
        int[] types = new int[resultColumns.length];
        Arrays.fill(types, 6);
        StatementSelect.configResultColumns(this.cppObj, types, null, null, resultColumns);
        return this;
    }

    @NotNull
    public StatementSelect select(Object ... resultColumns) {
        if (resultColumns.length == 0) {
            return this;
        }
        int totalCount = resultColumns.length;
        int[] types = new int[totalCount];
        long[] cppObjs = new long[totalCount];
        Object columnNames = new String[totalCount];
        int intIndex = 0;
        int stringIndex = 0;
        for (int i = 0; i < totalCount; ++i) {
            Object obj = resultColumns[i];
            if (obj instanceof String) {
                types[i] = 6;
                columnNames[stringIndex] = (String)obj;
                ++stringIndex;
                continue;
            }
            if (!(obj instanceof ResultColumnConvertible)) continue;
            ResultColumnConvertible resultColumn = (ResultColumnConvertible)obj;
            types[i] = Identifier.getCppType(resultColumn);
            cppObjs[intIndex] = CppObject.get(resultColumn);
            ++intIndex;
        }
        if ((double)((String[])columnNames).length * 0.75 > (double)stringIndex) {
            columnNames = stringIndex == 0 ? null : Arrays.copyOf(columnNames, stringIndex);
        }
        StatementSelect.configResultColumns(this.cppObj, types, cppObjs, null, columnNames);
        return this;
    }

    private static native void configResultColumns(long var0, int[] var2, long[] var3, double[] var4, String[] var5);

    @NotNull
    public StatementSelect distinct() {
        StatementSelect.configDistinct(this.cppObj);
        return this;
    }

    private static native void configDistinct(long var0);

    @NotNull
    public StatementSelect from(TableOrSubqueryConvertible ... tableOrSubqueries) {
        if (tableOrSubqueries.length == 0) {
            return this;
        }
        int totalCount = tableOrSubqueries.length;
        int[] types = new int[totalCount];
        long[] cppObjs = new long[totalCount];
        for (int i = 0; i < totalCount; ++i) {
            types[i] = Identifier.getCppType(tableOrSubqueries[i]);
            cppObjs[i] = CppObject.get(tableOrSubqueries[i]);
        }
        StatementSelect.configTableOrSubqueries(this.cppObj, types, cppObjs, null, null);
        return this;
    }

    @NotNull
    public StatementSelect from(String ... tableNames) {
        if (tableNames.length == 0) {
            return this;
        }
        int[] types = new int[tableNames.length];
        Arrays.fill(types, 6);
        StatementSelect.configTableOrSubqueries(this.cppObj, types, null, null, tableNames);
        return this;
    }

    @NotNull
    public StatementSelect from(Object ... tableOrSubqueries) {
        if (tableOrSubqueries.length == 0) {
            return this;
        }
        int totalCount = tableOrSubqueries.length;
        int[] types = new int[totalCount];
        long[] cppObjs = new long[totalCount];
        Object tablNames = new String[totalCount];
        int intIndex = 0;
        int stringIndex = 0;
        for (int i = 0; i < totalCount; ++i) {
            Object obj = tableOrSubqueries[i];
            if (obj instanceof String) {
                types[i] = 6;
                tablNames[stringIndex] = (String)obj;
                ++stringIndex;
                continue;
            }
            if (!(obj instanceof TableOrSubqueryConvertible)) continue;
            TableOrSubqueryConvertible tableOrSubquery = (TableOrSubqueryConvertible)obj;
            types[i] = Identifier.getCppType(tableOrSubquery);
            cppObjs[intIndex] = CppObject.get(tableOrSubquery);
            ++intIndex;
        }
        if ((double)((String[])tablNames).length * 0.75 > (double)stringIndex) {
            tablNames = stringIndex == 0 ? null : Arrays.copyOf(tablNames, stringIndex);
        }
        StatementSelect.configTableOrSubqueries(this.cppObj, types, cppObjs, null, tablNames);
        return this;
    }

    private static native void configTableOrSubqueries(long var0, int[] var2, long[] var3, double[] var4, String[] var5);

    @NotNull
    public StatementSelect where(@Nullable Expression condition) {
        StatementSelect.configCondition(this.cppObj, CppObject.get(condition));
        return this;
    }

    private static native void configCondition(long var0, long var2);

    @NotNull
    public StatementSelect groupBy(ExpressionConvertible ... expressions) {
        if (expressions == null || expressions.length == 0) {
            return this;
        }
        int totalCount = expressions.length;
        int[] types = new int[totalCount];
        long[] cppObjs = new long[totalCount];
        for (int i = 0; i < totalCount; ++i) {
            types[i] = Identifier.getCppType(expressions[i]);
            cppObjs[i] = CppObject.get(expressions[i]);
        }
        StatementSelect.configGroups(this.cppObj, types, cppObjs, null, null);
        return this;
    }

    @NotNull
    public StatementSelect groupBy(String ... columnNames) {
        if (columnNames == null || columnNames.length == 0) {
            return this;
        }
        int[] types = new int[columnNames.length];
        Arrays.fill(types, 6);
        StatementSelect.configGroups(this.cppObj, types, null, null, columnNames);
        return this;
    }

    @NotNull
    public StatementSelect groupBy(Object ... expressions) {
        if (expressions == null || expressions.length == 0) {
            return this;
        }
        int totalCount = expressions.length;
        int[] types = new int[totalCount];
        long[] cppObjs = new long[totalCount];
        Object columnNames = new String[totalCount];
        int intIndex = 0;
        int stringIndex = 0;
        for (int i = 0; i < totalCount; ++i) {
            Object obj = expressions[i];
            if (obj instanceof String) {
                types[i] = 6;
                columnNames[stringIndex] = (String)obj;
                ++stringIndex;
                continue;
            }
            if (!(obj instanceof ExpressionConvertible)) continue;
            ExpressionConvertible expression = (ExpressionConvertible)obj;
            types[i] = Identifier.getCppType(expression);
            cppObjs[intIndex] = CppObject.get(expression);
            ++intIndex;
        }
        if ((double)((String[])columnNames).length * 0.75 > (double)stringIndex) {
            columnNames = stringIndex == 0 ? null : Arrays.copyOf(columnNames, stringIndex);
        }
        StatementSelect.configGroups(this.cppObj, types, cppObjs, null, columnNames);
        return this;
    }

    private static native void configGroups(long var0, int[] var2, long[] var3, double[] var4, String[] var5);

    @NotNull
    public StatementSelect having(@Nullable Expression expression) {
        StatementSelect.configHaving(this.cppObj, CppObject.get(expression));
        return this;
    }

    private static native void configHaving(long var0, long var2);

    @NotNull
    public StatementSelect union() {
        StatementSelect.configUnion(this.cppObj);
        return this;
    }

    private static native void configUnion(long var0);

    @NotNull
    public StatementSelect unionAll() {
        StatementSelect.configUnionAll(this.cppObj);
        return this;
    }

    private static native void configUnionAll(long var0);

    @NotNull
    public StatementSelect intersect() {
        StatementSelect.configIntersect(this.cppObj);
        return this;
    }

    private static native void configIntersect(long var0);

    @NotNull
    public StatementSelect except() {
        StatementSelect.configExcept(this.cppObj);
        return this;
    }

    private static native void configExcept(long var0);

    @NotNull
    public StatementSelect orderBy(OrderingTerm ... orders) {
        if (orders == null || orders.length == 0) {
            return this;
        }
        long[] cppOrders = new long[orders.length];
        for (int i = 0; i < orders.length; ++i) {
            cppOrders[i] = CppObject.get(orders[i]);
        }
        StatementSelect.configOrders(this.cppObj, cppOrders);
        return this;
    }

    private static native void configOrders(long var0, long[] var2);

    @NotNull
    public StatementSelect limit(long from, long to) {
        StatementSelect.configLimitRange(this.cppObj, 3, from, 3, to);
        return this;
    }

    @NotNull
    public StatementSelect limit(long from, @Nullable ExpressionConvertible to) {
        StatementSelect.configLimitRange(this.cppObj, 3, from, Identifier.getCppType(to), CppObject.get(to));
        return this;
    }

    @NotNull
    public StatementSelect limit(@Nullable ExpressionConvertible from, @Nullable ExpressionConvertible to) {
        StatementSelect.configLimitRange(this.cppObj, Identifier.getCppType(from), CppObject.get(from), Identifier.getCppType(to), CppObject.get(to));
        return this;
    }

    @NotNull
    public StatementSelect limit(@Nullable ExpressionConvertible from, long to) {
        StatementSelect.configLimitRange(this.cppObj, Identifier.getCppType(from), CppObject.get(from), 3, to);
        return this;
    }

    private static native void configLimitRange(long var0, int var2, long var3, int var5, long var6);

    @NotNull
    public StatementSelect limit(long count) {
        StatementSelect.configLimitCount(this.cppObj, 3, count);
        return this;
    }

    @NotNull
    public StatementSelect limit(@Nullable ExpressionConvertible count) {
        StatementSelect.configLimitCount(this.cppObj, Identifier.getCppType(count), CppObject.get(count));
        return this;
    }

    private static native void configLimitCount(long var0, int var2, long var3);

    @NotNull
    public StatementSelect offset(long offset) {
        StatementSelect.configOffset(this.cppObj, 3, offset);
        return this;
    }

    @NotNull
    public StatementSelect offset(@Nullable ExpressionConvertible offset) {
        StatementSelect.configOffset(this.cppObj, Identifier.getCppType(offset), CppObject.get(offset));
        return this;
    }

    private static native void configOffset(long var0, int var2, long var3);
}

