/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wcdb.winq;

import com.tencent.wcdb.base.CppObject;
import com.tencent.wcdb.winq.Column;
import com.tencent.wcdb.winq.CommonTableExpression;
import com.tencent.wcdb.winq.ConflictAction;
import com.tencent.wcdb.winq.Expression;
import com.tencent.wcdb.winq.ExpressionConvertible;
import com.tencent.wcdb.winq.Identifier;
import com.tencent.wcdb.winq.MultiTypeArray;
import com.tencent.wcdb.winq.OrderingTerm;
import com.tencent.wcdb.winq.QualifiedTable;
import com.tencent.wcdb.winq.Statement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatementUpdate
extends Statement {
    @Override
    protected int getType() {
        return 45;
    }

    public StatementUpdate() {
        this.cppObj = StatementUpdate.createCppObj();
    }

    private static native long createCppObj();

    @NotNull
    public StatementUpdate with(CommonTableExpression ... expressions) {
        if (expressions == null || expressions.length == 0) {
            return this;
        }
        long[] cppExps = new long[expressions.length];
        for (int i = 0; i < expressions.length; ++i) {
            cppExps[i] = CppObject.get(expressions[i]);
        }
        StatementUpdate.configWith(this.cppObj, cppExps);
        return this;
    }

    @NotNull
    public StatementUpdate withRecursive(CommonTableExpression ... expressions) {
        if (expressions == null || expressions.length == 0) {
            return this;
        }
        long[] cppExps = new long[expressions.length];
        for (int i = 0; i < expressions.length; ++i) {
            cppExps[i] = CppObject.get(expressions[i]);
        }
        StatementUpdate.configWith(this.cppObj, cppExps);
        StatementUpdate.configRecursive(this.cppObj);
        return this;
    }

    private static native void configWith(long var0, long[] var2);

    private static native void configRecursive(long var0);

    @NotNull
    public StatementUpdate update(@NotNull String tableName) {
        StatementUpdate.configTable(this.cppObj, 6, 0L, tableName);
        return this;
    }

    @NotNull
    public StatementUpdate update(@NotNull QualifiedTable table) {
        StatementUpdate.configTable(this.cppObj, Identifier.getCppType(table), CppObject.get(table), null);
        return this;
    }

    private static native void configTable(long var0, int var2, long var3, String var5);

    @NotNull
    public StatementUpdate orReplace() {
        StatementUpdate.configConflictAction(this.cppObj, ConflictAction.Replace.ordinal());
        return this;
    }

    @NotNull
    public StatementUpdate orRollback() {
        StatementUpdate.configConflictAction(this.cppObj, ConflictAction.Rollback.ordinal());
        return this;
    }

    @NotNull
    public StatementUpdate orAbort() {
        StatementUpdate.configConflictAction(this.cppObj, ConflictAction.Abort.ordinal());
        return this;
    }

    @NotNull
    public StatementUpdate orFail() {
        StatementUpdate.configConflictAction(this.cppObj, ConflictAction.Fail.ordinal());
        return this;
    }

    @NotNull
    public StatementUpdate orIgnore() {
        StatementUpdate.configConflictAction(this.cppObj, ConflictAction.Ignore.ordinal());
        return this;
    }

    private static native void configConflictAction(long var0, int var2);

    @NotNull
    public StatementUpdate setColumnsToBindParameters(Column ... columns) {
        if (columns.length == 0) {
            return this;
        }
        long[] cppObjs = new long[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            cppObjs[i] = CppObject.get(columns[i]);
        }
        StatementUpdate.configColumnsToBindParameters(this.cppObj, 7, cppObjs, null);
        return this;
    }

    @NotNull
    public StatementUpdate setColumnsToBindParameters(String ... columnNames) {
        if (columnNames.length == 0) {
            return this;
        }
        StatementUpdate.configColumnsToBindParameters(this.cppObj, 6, null, columnNames);
        return this;
    }

    private static native void configColumnsToBindParameters(long var0, int var2, long[] var3, String[] var4);

    @NotNull
    public StatementUpdate setColumnsToValues(@NotNull Column[] columns, @NotNull Object[] values) {
        if (columns.length == 0 || values.length == 0) {
            return this;
        }
        long[] cppColumns = new long[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            cppColumns[i] = CppObject.get(columns[i]);
        }
        MultiTypeArray array = new MultiTypeArray(values);
        StatementUpdate.configColumnsToValues(this.cppObj, 7, cppColumns, null, array.types, array.longValues, array.doubleValues, array.stringValues);
        return this;
    }

    @NotNull
    public StatementUpdate setColumnsToValues(@NotNull String[] columnNames, @NotNull Object[] values) {
        if (columnNames.length == 0 || values.length == 0) {
            return this;
        }
        MultiTypeArray array = new MultiTypeArray(values);
        StatementUpdate.configColumnsToValues(this.cppObj, 6, null, columnNames, array.types, array.longValues, array.doubleValues, array.stringValues);
        return this;
    }

    private static native void configColumnsToValues(long var0, int var2, long[] var3, String[] var4, int[] var5, long[] var6, double[] var7, String[] var8);

    @NotNull
    public StatementUpdate set(Column ... columns) {
        if (columns.length == 0) {
            return this;
        }
        long[] cppObjs = new long[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            cppObjs[i] = CppObject.get(columns[i]);
        }
        StatementUpdate.configColumns(this.cppObj, 7, cppObjs, null);
        return this;
    }

    @NotNull
    public StatementUpdate set(String ... columnNames) {
        if (columnNames.length == 0) {
            return this;
        }
        StatementUpdate.configColumns(this.cppObj, 6, null, columnNames);
        return this;
    }

    private static native void configColumns(long var0, int var2, long[] var3, String[] var4);

    @NotNull
    public StatementUpdate to(boolean arg) {
        StatementUpdate.configToValue(this.cppObj, 2, arg ? 1L : 0L, 0.0, null);
        return this;
    }

    @NotNull
    public StatementUpdate to(byte arg) {
        StatementUpdate.configToValue(this.cppObj, 3, arg, 0.0, null);
        return this;
    }

    @NotNull
    public StatementUpdate to(short arg) {
        StatementUpdate.configToValue(this.cppObj, 3, arg, 0.0, null);
        return this;
    }

    @NotNull
    public StatementUpdate to(int arg) {
        StatementUpdate.configToValue(this.cppObj, 3, arg, 0.0, null);
        return this;
    }

    @NotNull
    public StatementUpdate to(long arg) {
        StatementUpdate.configToValue(this.cppObj, 3, arg, 0.0, null);
        return this;
    }

    @NotNull
    public StatementUpdate to(float arg) {
        StatementUpdate.configToValue(this.cppObj, 5, 0L, arg, null);
        return this;
    }

    @NotNull
    public StatementUpdate to(double arg) {
        StatementUpdate.configToValue(this.cppObj, 5, 0L, arg, null);
        return this;
    }

    @NotNull
    public StatementUpdate to(@Nullable String arg) {
        if (arg != null) {
            StatementUpdate.configToValue(this.cppObj, 6, 0L, 0.0, arg);
        } else {
            StatementUpdate.configToValue(this.cppObj, 1, 0L, 0.0, null);
        }
        return this;
    }

    @NotNull
    public StatementUpdate to(@Nullable ExpressionConvertible arg) {
        StatementUpdate.configToValue(this.cppObj, Identifier.getCppType(arg), CppObject.get(arg), 0.0, null);
        return this;
    }

    private static native void configToValue(long var0, int var2, long var3, double var5, String var7);

    @NotNull
    public StatementUpdate where(@Nullable Expression condition) {
        StatementUpdate.configCondition(this.cppObj, CppObject.get(condition));
        return this;
    }

    private static native void configCondition(long var0, long var2);

    @NotNull
    public StatementUpdate orderBy(OrderingTerm ... orders) {
        if (orders == null || orders.length == 0) {
            return this;
        }
        long[] cppOrders = new long[orders.length];
        for (int i = 0; i < orders.length; ++i) {
            cppOrders[i] = CppObject.get(orders[i]);
        }
        StatementUpdate.configOrders(this.cppObj, cppOrders);
        return this;
    }

    private static native void configOrders(long var0, long[] var2);

    @NotNull
    public StatementUpdate limit(long from, long to) {
        StatementUpdate.configLimitRange(this.cppObj, 3, from, 3, to);
        return this;
    }

    @NotNull
    public StatementUpdate limit(long from, @Nullable ExpressionConvertible to) {
        StatementUpdate.configLimitRange(this.cppObj, 3, from, Identifier.getCppType(to), CppObject.get(to));
        return this;
    }

    @NotNull
    public StatementUpdate limit(@Nullable ExpressionConvertible from, @Nullable ExpressionConvertible to) {
        StatementUpdate.configLimitRange(this.cppObj, Identifier.getCppType(from), CppObject.get(from), Identifier.getCppType(to), CppObject.get(to));
        return this;
    }

    @NotNull
    public StatementUpdate limit(@Nullable ExpressionConvertible from, long to) {
        StatementUpdate.configLimitRange(this.cppObj, Identifier.getCppType(from), CppObject.get(from), 3, to);
        return this;
    }

    private static native void configLimitRange(long var0, int var2, long var3, int var5, long var6);

    @NotNull
    public StatementUpdate limit(long count) {
        StatementUpdate.configLimitCount(this.cppObj, 3, count);
        return this;
    }

    @NotNull
    public StatementUpdate limit(@Nullable ExpressionConvertible count) {
        StatementUpdate.configLimitCount(this.cppObj, Identifier.getCppType(count), CppObject.get(count));
        return this;
    }

    private static native void configLimitCount(long var0, int var2, long var3);

    @NotNull
    public StatementUpdate offset(long offset) {
        StatementUpdate.configOffset(this.cppObj, 3, offset);
        return this;
    }

    @NotNull
    public StatementUpdate offset(@Nullable ExpressionConvertible offset) {
        StatementUpdate.configOffset(this.cppObj, Identifier.getCppType(offset), CppObject.get(offset));
        return this;
    }

    private static native void configOffset(long var0, int var2, long var3);
}

