/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wcdb.winq;

import com.tencent.wcdb.base.CppObject;
import com.tencent.wcdb.winq.BindParameter;
import com.tencent.wcdb.winq.Column;
import com.tencent.wcdb.winq.ColumnType;
import com.tencent.wcdb.winq.ExpressionConvertible;
import com.tencent.wcdb.winq.ExpressionOperable;
import com.tencent.wcdb.winq.Identifier;
import com.tencent.wcdb.winq.IndexedColumnConvertible;
import com.tencent.wcdb.winq.LiteralValue;
import com.tencent.wcdb.winq.ResultColumn;
import com.tencent.wcdb.winq.ResultColumnConvertible;
import com.tencent.wcdb.winq.Schema;
import com.tencent.wcdb.winq.StatementSelect;
import com.tencent.wcdb.winq.WindowDef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Expression
extends ExpressionOperable
implements IndexedColumnConvertible,
ResultColumnConvertible {
    @Override
    protected int getType() {
        return 11;
    }

    Expression() {
    }

    public Expression(@Nullable LiteralValue value) {
        this.cppObj = Expression.createCppObj(Identifier.getCppType(value), CppObject.get(value));
    }

    public Expression(@Nullable BindParameter bindParameter) {
        this.cppObj = Expression.createCppObj(Identifier.getCppType(bindParameter), CppObject.get(bindParameter));
    }

    public Expression(@Nullable Column column) {
        this.cppObj = Expression.createCppObj(Identifier.getCppType(column), CppObject.get(column));
    }

    public Expression(@Nullable StatementSelect select) {
        this.cppObj = Expression.createCppObj(Identifier.getCppType(select), CppObject.get(select));
    }

    private static native long createCppObj(int var0, long var1);

    @NotNull
    public static Expression function(@NotNull String funcName) {
        return Expression.createExpression(Expression.createWithFunction(funcName));
    }

    private static native long createWithFunction(String var0);

    @NotNull
    public Expression schema(@Nullable String schema) {
        Expression.schema(this.cppObj, 6, 0L, schema);
        return this;
    }

    @NotNull
    public Expression schema(@Nullable Schema schema) {
        Expression.schema(this.cppObj, Identifier.getCppType(schema), CppObject.get(schema), null);
        return this;
    }

    private static native void schema(long var0, int var2, long var3, String var5);

    @NotNull
    public Expression distinct() {
        Expression.distinct(this.cppObj);
        return this;
    }

    private static native void distinct(long var0);

    @NotNull
    public Expression invoke() {
        Expression.invoke(this.cppObj);
        return this;
    }

    private static native void invoke(long var0);

    @NotNull
    public Expression invokeAll() {
        Expression.invokeAll(this.cppObj);
        return this;
    }

    private static native void invokeAll(long var0);

    @NotNull
    public Expression argument(boolean arg) {
        Expression.argument(this.cppObj, 2, arg ? 1L : 0L, 0.0, null);
        return this;
    }

    @NotNull
    public Expression argument(byte arg) {
        Expression.argument(this.cppObj, 3, arg, 0.0, null);
        return this;
    }

    @NotNull
    public Expression argument(short arg) {
        Expression.argument(this.cppObj, 3, arg, 0.0, null);
        return this;
    }

    @NotNull
    public Expression argument(int arg) {
        Expression.argument(this.cppObj, 3, arg, 0.0, null);
        return this;
    }

    @NotNull
    public Expression argument(long arg) {
        Expression.argument(this.cppObj, 3, arg, 0.0, null);
        return this;
    }

    @NotNull
    public Expression argument(float arg) {
        Expression.argument(this.cppObj, 5, 0L, arg, null);
        return this;
    }

    @NotNull
    public Expression argument(double arg) {
        Expression.argument(this.cppObj, 5, 0L, arg, null);
        return this;
    }

    @NotNull
    public Expression argument(@Nullable String arg) {
        if (arg != null) {
            Expression.argument(this.cppObj, 6, 0L, 0.0, arg);
        } else {
            Expression.argument(this.cppObj, 1, 0L, 0.0, null);
        }
        return this;
    }

    @NotNull
    public Expression argument(@Nullable ExpressionConvertible arg) {
        Expression.argument(this.cppObj, Identifier.getCppType(arg), CppObject.get(arg), 0.0, null);
        return this;
    }

    private static native void argument(long var0, int var2, long var3, double var5, String var7);

    @NotNull
    public Expression escape(@NotNull String content) {
        Expression.escape(this.cppObj, content);
        return this;
    }

    private static native void escape(long var0, String var2);

    @NotNull
    public static Expression exists(@NotNull StatementSelect select) {
        Expression exp = new Expression();
        exp.cppObj = Expression.createWithExistStatement(CppObject.get(select));
        return exp;
    }

    private static native long createWithExistStatement(long var0);

    @NotNull
    public static Expression notExists(@NotNull StatementSelect select) {
        Expression exp = new Expression();
        exp.cppObj = Expression.createWithNotExistStatement(CppObject.get(select));
        return exp;
    }

    private static native long createWithNotExistStatement(long var0);

    @NotNull
    public static Expression cast(@NotNull String columnName) {
        Expression ret = new Expression();
        ret.cppObj = Expression.cast(6, 0L, columnName);
        return ret;
    }

    @NotNull
    public static Expression cast(@NotNull ExpressionConvertible expression) {
        Expression ret = new Expression();
        ret.cppObj = Expression.cast(Identifier.getCppType(expression), CppObject.get(expression), null);
        return ret;
    }

    private static native long cast(int var0, long var1, String var3);

    @NotNull
    public Expression as(ColumnType type) {
        Expression.as(this.cppObj, type.ordinal());
        return this;
    }

    @NotNull
    public ResultColumn as(@Nullable String alias) {
        return new ResultColumn(Expression.as(this.cppObj, alias));
    }

    private static native long as(long var0, String var2);

    private static native void as(long var0, int var2);

    @NotNull
    public static Expression case_() {
        Expression ret = new Expression();
        ret.cppObj = Expression.caseWithExp(0, 0L, null);
        return ret;
    }

    @NotNull
    public static Expression case_(@Nullable String columnName) {
        if (columnName == null) {
            return Expression.case_();
        }
        Expression ret = new Expression();
        ret.cppObj = Expression.caseWithExp(6, 0L, columnName);
        return ret;
    }

    @NotNull
    public static Expression case_(@Nullable ExpressionConvertible expression) {
        Expression ret = new Expression();
        ret.cppObj = Expression.caseWithExp(Identifier.getCppType(expression), CppObject.get(expression), null);
        return ret;
    }

    private static native long caseWithExp(int var0, long var1, String var3);

    @NotNull
    public Expression when(boolean arg) {
        Expression.setWithWhenExp(this.cppObj, 2, arg ? 1L : 0L, 0.0, null);
        return this;
    }

    @NotNull
    public Expression when(byte arg) {
        Expression.setWithWhenExp(this.cppObj, 3, arg, 0.0, null);
        return this;
    }

    @NotNull
    public Expression when(short arg) {
        Expression.setWithWhenExp(this.cppObj, 3, arg, 0.0, null);
        return this;
    }

    @NotNull
    public Expression when(int arg) {
        Expression.setWithWhenExp(this.cppObj, 3, arg, 0.0, null);
        return this;
    }

    @NotNull
    public Expression when(long arg) {
        Expression.setWithWhenExp(this.cppObj, 3, arg, 0.0, null);
        return this;
    }

    @NotNull
    public Expression when(float arg) {
        Expression.setWithWhenExp(this.cppObj, 5, 0L, arg, null);
        return this;
    }

    @NotNull
    public Expression when(double arg) {
        Expression.setWithWhenExp(this.cppObj, 5, 0L, arg, null);
        return this;
    }

    @NotNull
    public Expression when(@Nullable String arg) {
        if (arg != null) {
            Expression.setWithWhenExp(this.cppObj, 6, 0L, 0.0, arg);
        } else {
            Expression.setWithWhenExp(this.cppObj, 1, 0L, 0.0, null);
        }
        return this;
    }

    @NotNull
    public Expression when(@Nullable ExpressionConvertible arg) {
        Expression.setWithWhenExp(this.cppObj, Identifier.getCppType(arg), CppObject.get(arg), 0.0, null);
        return this;
    }

    private static native void setWithWhenExp(long var0, int var2, long var3, double var5, String var7);

    @NotNull
    public Expression then(boolean arg) {
        Expression.setWithThenExp(this.cppObj, 2, arg ? 1L : 0L, 0.0, null);
        return this;
    }

    @NotNull
    public Expression then(byte arg) {
        Expression.setWithThenExp(this.cppObj, 3, arg, 0.0, null);
        return this;
    }

    @NotNull
    public Expression then(short arg) {
        Expression.setWithThenExp(this.cppObj, 3, arg, 0.0, null);
        return this;
    }

    @NotNull
    public Expression then(int arg) {
        Expression.setWithThenExp(this.cppObj, 3, arg, 0.0, null);
        return this;
    }

    @NotNull
    public Expression then(long arg) {
        Expression.setWithThenExp(this.cppObj, 3, arg, 0.0, null);
        return this;
    }

    @NotNull
    public Expression then(float arg) {
        Expression.setWithThenExp(this.cppObj, 5, 0L, arg, null);
        return this;
    }

    @NotNull
    public Expression then(double arg) {
        Expression.setWithThenExp(this.cppObj, 5, 0L, arg, null);
        return this;
    }

    @NotNull
    public Expression then(@Nullable String arg) {
        if (arg != null) {
            Expression.setWithThenExp(this.cppObj, 6, 0L, 0.0, arg);
        } else {
            Expression.setWithThenExp(this.cppObj, 1, 0L, 0.0, null);
        }
        return this;
    }

    @NotNull
    public Expression then(@Nullable ExpressionConvertible arg) {
        Expression.setWithThenExp(this.cppObj, Identifier.getCppType(arg), CppObject.get(arg), 0.0, null);
        return this;
    }

    private static native void setWithThenExp(long var0, int var2, long var3, double var5, String var7);

    @NotNull
    public Expression else_(boolean arg) {
        Expression.setWithElseExp(this.cppObj, 2, arg ? 1L : 0L, 0.0, null);
        return this;
    }

    @NotNull
    public Expression else_(byte arg) {
        Expression.setWithElseExp(this.cppObj, 3, arg, 0.0, null);
        return this;
    }

    @NotNull
    public Expression else_(short arg) {
        Expression.setWithElseExp(this.cppObj, 3, arg, 0.0, null);
        return this;
    }

    @NotNull
    public Expression else_(int arg) {
        Expression.setWithElseExp(this.cppObj, 3, arg, 0.0, null);
        return this;
    }

    @NotNull
    public Expression else_(long arg) {
        Expression.setWithElseExp(this.cppObj, 3, arg, 0.0, null);
        return this;
    }

    @NotNull
    public Expression else_(float arg) {
        Expression.setWithElseExp(this.cppObj, 5, 0L, arg, null);
        return this;
    }

    @NotNull
    public Expression else_(double arg) {
        Expression.setWithElseExp(this.cppObj, 5, 0L, arg, null);
        return this;
    }

    @NotNull
    public Expression else_(@Nullable String arg) {
        if (arg != null) {
            Expression.setWithElseExp(this.cppObj, 6, 0L, 0.0, arg);
        } else {
            Expression.setWithElseExp(this.cppObj, 1, 0L, 0.0, null);
        }
        return this;
    }

    @NotNull
    public Expression else_(@Nullable ExpressionConvertible arg) {
        Expression.setWithElseExp(this.cppObj, Identifier.getCppType(arg), CppObject.get(arg), 0.0, null);
        return this;
    }

    private static native void setWithElseExp(long var0, int var2, long var3, double var5, String var7);

    @NotNull
    public static Expression windowFunction(@NotNull String funcName) {
        Expression ret = new Expression();
        ret.cppObj = Expression.createWithWindowFunction(funcName);
        return ret;
    }

    private static native long createWithWindowFunction(String var0);

    @NotNull
    public Expression filter(@NotNull Expression condition) {
        Expression.filter(this.cppObj, condition.cppObj);
        return this;
    }

    private static native void filter(long var0, long var2);

    @NotNull
    public Expression over(@NotNull WindowDef windowDef) {
        Expression.overWindowDef(this.cppObj, CppObject.get(windowDef));
        return this;
    }

    private static native void overWindowDef(long var0, long var2);

    @NotNull
    public Expression over(@NotNull String window) {
        Expression.overWindow(this.cppObj, window);
        return this;
    }

    private static native void overWindow(long var0, String var2);
}

