/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wcdb.winq;

import com.tencent.wcdb.base.CppObject;
import com.tencent.wcdb.base.Value;
import com.tencent.wcdb.winq.Identifier;
import java.util.Arrays;

class MultiTypeArray {
    int[] types;
    long[] longValues;
    double[] doubleValues;
    String[] stringValues;

    MultiTypeArray(Object[] values) {
        int valueCount = values.length;
        this.types = new int[valueCount];
        this.longValues = new long[valueCount];
        this.doubleValues = new double[valueCount];
        this.stringValues = new String[valueCount];
        int longIndex = 0;
        int doubleIndex = 0;
        int stringIndex = 0;
        block20: for (int i = 0; i < valueCount; ++i) {
            Object obj = values[i];
            int valueType = MultiTypeArray.getObjectType(obj);
            block0 : switch (valueType) {
                case 0: {
                    this.types[i] = 1;
                    ++longIndex;
                    continue block20;
                }
                case 1: {
                    this.types[i] = 2;
                    this.longValues[longIndex] = (Boolean)obj != false ? 1L : 0L;
                    ++longIndex;
                    continue block20;
                }
                case 3: {
                    this.types[i] = 3;
                    this.longValues[longIndex] = ((Byte)obj).byteValue();
                    ++longIndex;
                    continue block20;
                }
                case 2: {
                    this.types[i] = 3;
                    this.longValues[longIndex] = ((Character)obj).charValue();
                    ++longIndex;
                    continue block20;
                }
                case 4: {
                    this.types[i] = 3;
                    this.longValues[longIndex] = ((Short)obj).shortValue();
                    ++longIndex;
                    continue block20;
                }
                case 5: {
                    this.types[i] = 3;
                    this.longValues[longIndex] = ((Integer)obj).intValue();
                    ++longIndex;
                    continue block20;
                }
                case 6: {
                    this.types[i] = 3;
                    this.longValues[longIndex] = (Long)obj;
                    ++longIndex;
                    continue block20;
                }
                case 7: {
                    this.types[i] = 5;
                    this.doubleValues[doubleIndex] = ((Float)obj).floatValue();
                    ++doubleIndex;
                    continue block20;
                }
                case 8: {
                    this.types[i] = 5;
                    this.doubleValues[doubleIndex] = (Double)obj;
                    ++doubleIndex;
                    continue block20;
                }
                case 9: {
                    this.types[i] = 6;
                    this.stringValues[stringIndex] = (String)obj;
                    ++stringIndex;
                    continue block20;
                }
                case 10: {
                    Identifier identifier = (Identifier)obj;
                    this.types[i] = Identifier.getCppType(identifier);
                    this.longValues[longIndex] = CppObject.get(identifier);
                    ++longIndex;
                    continue block20;
                }
                case 11: {
                    Value valueObj = (Value)obj;
                    switch (valueObj.getType()) {
                        case Null: {
                            this.types[i] = 1;
                            ++longIndex;
                            break block0;
                        }
                        case Integer: {
                            this.types[i] = 3;
                            this.longValues[longIndex] = valueObj.getLong();
                            ++longIndex;
                            break block0;
                        }
                        case Float: {
                            this.types[i] = 5;
                            this.doubleValues[doubleIndex] = valueObj.getDouble();
                            ++doubleIndex;
                            break block0;
                        }
                        case Text: {
                            this.types[i] = 6;
                            this.stringValues[stringIndex] = valueObj.getText();
                            ++stringIndex;
                        }
                    }
                }
            }
        }
        if ((double)this.stringValues.length * 0.75 > (double)stringIndex) {
            this.stringValues = stringIndex == 0 ? null : Arrays.copyOf(this.stringValues, stringIndex);
        }
    }

    protected static int getObjectType(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Identifier) {
            return 10;
        }
        Class<?> cls = obj.getClass();
        if (cls == String.class) {
            return 9;
        }
        if (cls == Integer.class) {
            return 5;
        }
        if (cls == Float.class) {
            return 7;
        }
        if (cls == Double.class) {
            return 8;
        }
        if (cls == Boolean.class) {
            return 1;
        }
        if (cls == Short.class) {
            return 4;
        }
        if (cls == Long.class) {
            return 6;
        }
        if (cls == Character.class) {
            return 2;
        }
        if (cls == Byte.class) {
            return 3;
        }
        if (cls == Value.class) {
            return 11;
        }
        return 12;
    }
}

