/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wcdb.chaincall;

import com.tencent.wcdb.base.WCDBException;
import com.tencent.wcdb.chaincall.ChainCall;
import com.tencent.wcdb.core.Handle;
import com.tencent.wcdb.core.PreparedStatement;
import com.tencent.wcdb.orm.Field;
import com.tencent.wcdb.winq.Expression;
import com.tencent.wcdb.winq.ExpressionConvertible;
import com.tencent.wcdb.winq.OrderingTerm;
import com.tencent.wcdb.winq.StatementSelect;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Select<T>
extends ChainCall<StatementSelect> {
    private Field<T>[] fields = null;

    public Select(@NotNull Handle handle, boolean needChanges, boolean autoInvalidateHandle) {
        super(handle, needChanges, autoInvalidateHandle);
        this.statement = new StatementSelect();
    }

    @SafeVarargs
    @NotNull
    public final Select<T> select(Field<T> ... fields) {
        this.fields = fields;
        ((StatementSelect)this.statement).select(fields);
        return this;
    }

    @NotNull
    public Select<T> where(@Nullable Expression condition) {
        ((StatementSelect)this.statement).where(condition);
        return this;
    }

    @NotNull
    public Select<T> orderBy(@Nullable OrderingTerm order) {
        ((StatementSelect)this.statement).orderBy(order);
        return this;
    }

    @NotNull
    public Select<T> orderBy(OrderingTerm ... orders) {
        ((StatementSelect)this.statement).orderBy(orders);
        return this;
    }

    @NotNull
    public Select<T> limit(long count) {
        ((StatementSelect)this.statement).limit(count);
        return this;
    }

    @NotNull
    public Select<T> limit(@Nullable ExpressionConvertible count) {
        ((StatementSelect)this.statement).limit(count);
        return this;
    }

    @NotNull
    public Select<T> offset(long offset) {
        ((StatementSelect)this.statement).offset(offset);
        return this;
    }

    @NotNull
    public Select<T> offset(@Nullable ExpressionConvertible offset) {
        ((StatementSelect)this.statement).offset(offset);
        return this;
    }

    @NotNull
    public Select<T> from(@NotNull String tableName) {
        ((StatementSelect)this.statement).from(tableName);
        return this;
    }

    @Nullable
    public T firstObject() throws WCDBException {
        return this.firstObject(Field.getBindClass(this.fields));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <R extends T> R firstObject(Class<R> cls) throws WCDBException {
        R ret = null;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.prepareStatement();
            preparedStatement.step();
            if (!preparedStatement.isDone()) {
                ret = preparedStatement.getOneObject(this.fields, cls);
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.finalizeStatement();
            }
            this.invalidateHandle();
        }
        return ret;
    }

    @NotNull
    public List<T> allObjects() throws WCDBException {
        return this.allObjects(Field.getBindClass(this.fields));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public <R extends T> List<R> allObjects(Class<R> cls) throws WCDBException {
        List<R> ret;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.prepareStatement();
            ret = preparedStatement.getAllObjects(this.fields, cls);
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.finalizeStatement();
            }
            this.invalidateHandle();
        }
        return ret;
    }

    private PreparedStatement prepareStatement() throws WCDBException {
        return this.handle.preparedWithMainStatement(this.statement);
    }
}

