/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wcdb.core;

import com.tencent.wcdb.base.CppObject;
import com.tencent.wcdb.base.Value;
import com.tencent.wcdb.base.WCDBException;
import com.tencent.wcdb.orm.Field;
import com.tencent.wcdb.orm.TableBinding;
import com.tencent.wcdb.winq.ColumnType;
import com.tencent.wcdb.winq.Statement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PreparedStatement
extends CppObject {
    boolean autoFinalize = false;
    int columnCount = -1;

    PreparedStatement(long cppObj) {
        this.cppObj = cppObj;
    }

    private WCDBException createException() {
        return WCDBException.createException(PreparedStatement.getError(this.cppObj));
    }

    private static native long getError(long var0);

    void prepare(Statement statement) throws WCDBException {
        if (!PreparedStatement.prepare(this.cppObj, CppObject.get(statement))) {
            throw this.createException();
        }
    }

    private static native boolean prepare(long var0, long var2);

    void prepare(String sql) throws WCDBException {
        if (!PreparedStatement.prepareSQL(this.cppObj, sql)) {
            throw this.createException();
        }
    }

    private static native boolean prepareSQL(long var0, String var2);

    public boolean checkPrepared() {
        return PreparedStatement.checkPrepared(this.cppObj);
    }

    private static native boolean checkPrepared(long var0);

    public void step() throws WCDBException {
        if (!PreparedStatement.step(this.cppObj)) {
            if (this.autoFinalize) {
                this.finalizeStatement();
            }
            throw this.createException();
        }
    }

    private static native boolean step(long var0);

    public void reset() {
        PreparedStatement.reset(this.cppObj);
    }

    private static native void reset(long var0);

    public void clearBindings() {
        PreparedStatement.clearBindings(this.cppObj);
    }

    private static native void clearBindings(long var0);

    public void finalizeStatement() {
        PreparedStatement.finalize(this.cppObj);
    }

    private static native void finalize(long var0);

    public boolean isDone() {
        return PreparedStatement.isDone(this.cppObj);
    }

    private static native boolean isDone(long var0);

    public void bindBool(boolean value, int index) {
        PreparedStatement.bindInteger(this.cppObj, value ? 1L : 0L, index);
    }

    public void bindBool(@Nullable Boolean value, int index) {
        if (value != null) {
            PreparedStatement.bindInteger(this.cppObj, value != false ? 1L : 0L, index);
        } else {
            this.bindNull(index);
        }
    }

    public void bindInteger(byte value, int index) {
        PreparedStatement.bindInteger(this.cppObj, value, index);
    }

    public void bindInteger(@Nullable Byte value, int index) {
        if (value != null) {
            PreparedStatement.bindInteger(this.cppObj, value.byteValue(), index);
        } else {
            this.bindNull(index);
        }
    }

    public void bindInteger(short value, int index) {
        PreparedStatement.bindInteger(this.cppObj, value, index);
    }

    public void bindInteger(@Nullable Short value, int index) {
        if (value != null) {
            PreparedStatement.bindInteger(this.cppObj, value.shortValue(), index);
        } else {
            this.bindNull(index);
        }
    }

    public void bindInteger(int value, int index) {
        PreparedStatement.bindInteger(this.cppObj, value, index);
    }

    public void bindInteger(@Nullable Integer value, int index) {
        if (value != null) {
            PreparedStatement.bindInteger(this.cppObj, value.intValue(), index);
        } else {
            this.bindNull(index);
        }
    }

    public void bindInteger(long value, int index) {
        PreparedStatement.bindInteger(this.cppObj, value, index);
    }

    public void bindInteger(@Nullable Long value, int index) {
        if (value != null) {
            PreparedStatement.bindInteger(this.cppObj, value, index);
        } else {
            this.bindNull(index);
        }
    }

    private static native void bindInteger(long var0, long var2, int var4);

    public void bindDouble(float value, int index) {
        PreparedStatement.bindDouble(this.cppObj, value, index);
    }

    public void bindDouble(@Nullable Float value, int index) {
        if (value != null) {
            PreparedStatement.bindDouble(this.cppObj, value.floatValue(), index);
        } else {
            this.bindNull(index);
        }
    }

    public void bindDouble(double value, int index) {
        PreparedStatement.bindDouble(this.cppObj, value, index);
    }

    public void bindDouble(@Nullable Double value, int index) {
        if (value != null) {
            PreparedStatement.bindDouble(this.cppObj, value, index);
        } else {
            this.bindNull(index);
        }
    }

    private static native void bindDouble(long var0, double var2, int var4);

    public void bindText(@Nullable String value, int index) {
        if (value == null) {
            this.bindNull(index);
            return;
        }
        PreparedStatement.bindText(this.cppObj, value, index);
    }

    private static native void bindText(long var0, String var2, int var3);

    public void bindBLOB(@Nullable byte[] value, int index) {
        if (value == null) {
            this.bindNull(index);
            return;
        }
        PreparedStatement.bindBLOB(this.cppObj, value, index);
    }

    private static native void bindBLOB(long var0, byte[] var2, int var3);

    public void bindNull(int index) {
        PreparedStatement.bindNull(this.cppObj, index);
    }

    private static native void bindNull(long var0, int var2);

    public void bindValue(@Nullable Value value, int index) {
        if (value == null) {
            this.bindNull(index);
            return;
        }
        switch (value.getType()) {
            case Integer: {
                this.bindInteger(value.getLong(), index);
                return;
            }
            case Float: {
                this.bindDouble(value.getDouble(), index);
                return;
            }
            case Text: {
                this.bindText(value.getText(), index);
                return;
            }
            case BLOB: {
                this.bindBLOB(value.getBLOB(), index);
                return;
            }
            case Null: {
                this.bindNull(index);
            }
        }
    }

    public void bindRow(@NotNull Value[] row) {
        int index = 1;
        for (Value value : row) {
            this.bindValue(value, index);
            ++index;
        }
    }

    public <T> void bindObject(@Nullable T obj, @NotNull TableBinding<T> binding) {
        if (obj == null) {
            return;
        }
        int index = 1;
        for (Field<T> field : binding.allBindingFields()) {
            binding.bindField(obj, field, index, this);
            ++index;
        }
    }

    public <T> void bindObject(@Nullable T obj, @NotNull Field<T> field, int index) {
        if (obj == null) {
            this.bindNull(index);
            return;
        }
        TableBinding<T> binding = field.getTableBinding();
        assert (binding != null);
        binding.bindField(obj, field, index, this);
    }

    public <T> void bindObject(@Nullable T obj, @NotNull Field<T>[] fields) {
        if (obj == null || fields.length == 0) {
            return;
        }
        int index = 1;
        TableBinding<T> binding = fields[0].getTableBinding();
        assert (binding != null);
        for (Field<T> field : fields) {
            binding.bindField(obj, field, index, this);
            ++index;
        }
    }

    public int bindParameterIndex(String parameterName) {
        return PreparedStatement.bindParameterIndex(this.cppObj, parameterName);
    }

    private static native int bindParameterIndex(long var0, String var2);

    public ColumnType getColumnType(int index) {
        return ColumnType.valueOf(PreparedStatement.getColumnType(this.cppObj, index));
    }

    private static native int getColumnType(long var0, int var2);

    public boolean getBool(int index) {
        return PreparedStatement.getInteger(this.cppObj, index) > 0L;
    }

    public byte getByte(int index) {
        return (byte)PreparedStatement.getInteger(this.cppObj, index);
    }

    public short getShort(int index) {
        return (short)PreparedStatement.getInteger(this.cppObj, index);
    }

    public int getInt(int index) {
        return (int)PreparedStatement.getInteger(this.cppObj, index);
    }

    public long getLong(int index) {
        return PreparedStatement.getInteger(this.cppObj, index);
    }

    private static native long getInteger(long var0, int var2);

    public float getFloat(int index) {
        return (float)PreparedStatement.getDouble(this.cppObj, index);
    }

    public double getDouble(int index) {
        return PreparedStatement.getDouble(this.cppObj, index);
    }

    private static native double getDouble(long var0, int var2);

    @NotNull
    public String getText(int index) {
        return PreparedStatement.getText(this.cppObj, index);
    }

    private static native String getText(long var0, int var2);

    @NotNull
    public byte[] getBLOB(int index) {
        return PreparedStatement.getBLOB(this.cppObj, index);
    }

    private static native byte[] getBLOB(long var0, int var2);

    @NotNull
    public Value getValue(int index) {
        switch (PreparedStatement.getColumnType(this.cppObj, index)) {
            case 1: {
                return new Value(PreparedStatement.getInteger(this.cppObj, index));
            }
            case 2: {
                return new Value(PreparedStatement.getDouble(this.cppObj, index));
            }
            case 3: {
                return new Value(PreparedStatement.getText(this.cppObj, index));
            }
            case 4: {
                return new Value(PreparedStatement.getBLOB(this.cppObj, index));
            }
        }
        return new Value();
    }

    @NotNull
    public Value[] getOneRow() {
        int count = this.getColumnCount();
        if (count == 0) {
            return new Value[0];
        }
        Value[] row = new Value[count];
        for (int i = 0; i < count; ++i) {
            row[i] = this.getValue(i);
        }
        return row;
    }

    @NotNull
    public List<Value> getOneColumn() throws WCDBException {
        ArrayList<Value> column = new ArrayList<Value>();
        this.step();
        while (!PreparedStatement.isDone(this.cppObj)) {
            column.add(this.getValue(0));
            this.step();
        }
        return column;
    }

    @NotNull
    public List<Integer> getOneColumnInt() throws WCDBException {
        ArrayList<Integer> column = new ArrayList<Integer>();
        this.step();
        while (!PreparedStatement.isDone(this.cppObj)) {
            column.add((int)this.getLong(0));
            this.step();
        }
        return column;
    }

    @NotNull
    public List<Long> getOneColumnLong() throws WCDBException {
        ArrayList<Long> column = new ArrayList<Long>();
        this.step();
        while (!PreparedStatement.isDone(this.cppObj)) {
            column.add(this.getLong(0));
            this.step();
        }
        return column;
    }

    @NotNull
    public List<Float> getOneColumnFloat() throws WCDBException {
        ArrayList<Float> column = new ArrayList<Float>();
        this.step();
        while (!PreparedStatement.isDone(this.cppObj)) {
            column.add(Float.valueOf((float)this.getDouble(0)));
            this.step();
        }
        return column;
    }

    @NotNull
    public List<Double> getOneColumnDouble() throws WCDBException {
        ArrayList<Double> column = new ArrayList<Double>();
        this.step();
        while (!PreparedStatement.isDone(this.cppObj)) {
            column.add(this.getDouble(0));
            this.step();
        }
        return column;
    }

    @NotNull
    public List<String> getOneColumnString() throws WCDBException {
        ArrayList<String> column = new ArrayList<String>();
        this.step();
        while (!PreparedStatement.isDone(this.cppObj)) {
            column.add(this.getText(0));
            this.step();
        }
        return column;
    }

    @NotNull
    public List<byte[]> getOneColumnBLOB() throws WCDBException {
        ArrayList<byte[]> column = new ArrayList<byte[]>();
        this.step();
        while (!PreparedStatement.isDone(this.cppObj)) {
            column.add(this.getBLOB(0));
            this.step();
        }
        return column;
    }

    @NotNull
    public List<Value[]> getMultiRows() throws WCDBException {
        ArrayList<Value[]> rows = new ArrayList<Value[]>();
        this.step();
        while (!PreparedStatement.isDone(this.cppObj)) {
            rows.add(this.getOneRow());
            this.step();
        }
        return rows;
    }

    @NotNull
    public <T> T getOneObject(@NotNull Field<T>[] fields) {
        return this.getOneObject(fields, Field.getBindClass(fields));
    }

    @NotNull
    public <T, R extends T> R getOneObject(@NotNull Field<T>[] fields, @NotNull Class<R> cls) {
        assert (fields.length > 0);
        try {
            return fields[0].getTableBinding().extractObject(fields, this, cls);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public <T> List<T> getAllObjects(@NotNull Field<T>[] fields) throws WCDBException {
        return this.getAllObjects(fields, Field.getBindClass(fields));
    }

    @NotNull
    public <T, R extends T> List<R> getAllObjects(@NotNull Field<T>[] fields, @NotNull Class<R> cls) throws WCDBException {
        assert (fields.length > 0);
        TableBinding<T> tb = fields[0].getTableBinding();
        ArrayList<R> objs = new ArrayList<R>();
        this.step();
        try {
            while (!PreparedStatement.isDone(this.cppObj)) {
                objs.add(tb.extractObject(fields, this, cls));
                this.step();
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        return objs;
    }

    public int getColumnCount() {
        if (this.columnCount == -1) {
            this.columnCount = PreparedStatement.getColumnCount(this.cppObj);
        }
        return this.columnCount;
    }

    private static native int getColumnCount(long var0);

    @NotNull
    public String getColumnName(int index) {
        return PreparedStatement.getColumnName(this.cppObj, index);
    }

    private static native String getColumnName(long var0, int var2);

    @NotNull
    public String getOriginalColumnName(int index) {
        return PreparedStatement.getOriginalColumnName(this.cppObj, index);
    }

    private static native String getOriginalColumnName(long var0, int var2);

    @NotNull
    public String getColumnTableName(int index) {
        return PreparedStatement.getColumnTableName(this.cppObj, index);
    }

    private static native String getColumnTableName(long var0, int var2);

    public boolean isReadOnly() {
        return PreparedStatement.isReadOnly(this.cppObj);
    }

    private static native boolean isReadOnly(long var0);
}

