/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wcdb.core;

import com.tencent.wcdb.base.Value;
import com.tencent.wcdb.base.WCDBException;
import com.tencent.wcdb.core.Database;
import com.tencent.wcdb.core.Handle;
import com.tencent.wcdb.core.PreparedStatement;
import com.tencent.wcdb.core.Transaction;
import com.tencent.wcdb.winq.Column;
import com.tencent.wcdb.winq.ConflictAction;
import com.tencent.wcdb.winq.Expression;
import com.tencent.wcdb.winq.OrderingTerm;
import com.tencent.wcdb.winq.ResultColumnConvertible;
import com.tencent.wcdb.winq.Statement;
import com.tencent.wcdb.winq.StatementDelete;
import com.tencent.wcdb.winq.StatementInsert;
import com.tencent.wcdb.winq.StatementSelect;
import com.tencent.wcdb.winq.StatementUpdate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableOperation {
    String tableName = null;
    Database database = null;

    @NotNull
    public String getTableName() {
        return this.tableName;
    }

    @NotNull
    public Database getDatabase() {
        return this.database;
    }

    public void insertRow(@NotNull Value[] row, @Nullable Column[] columns) throws WCDBException {
        this.insertRows(Collections.singleton(row), columns);
    }

    public void insertRows(@NotNull Collection<Value[]> rows, @Nullable Column[] columns) throws WCDBException {
        this.insertRows(rows, columns, ConflictAction.None);
    }

    public void insertOrReplaceRow(@NotNull Value[] row, @Nullable Column[] columns) throws WCDBException {
        this.insertOrReplaceRows(Collections.singleton(row), columns);
    }

    public void insertOrReplaceRows(@NotNull Collection<Value[]> rows, @Nullable Column[] columns) throws WCDBException {
        this.insertRows(rows, columns, ConflictAction.Replace);
    }

    public void insertOrIgnoreRow(@NotNull Value[] row, @Nullable Column[] columns) throws WCDBException {
        this.insertOrIgnoreRows(Collections.singleton(row), columns);
    }

    public void insertOrIgnoreRows(@NotNull Collection<Value[]> rows, @Nullable Column[] columns) throws WCDBException {
        this.insertRows(rows, columns, ConflictAction.Ignore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertRows(final Collection<Value[]> rows, Column[] columns, ConflictAction action) throws WCDBException {
        final StatementInsert insert = new StatementInsert().insertInto(this.tableName).columns(columns).valuesWithBindParameters(columns.length);
        if (action == ConflictAction.Replace) {
            insert.orReplace();
        } else if (action == ConflictAction.Ignore) {
            insert.orIgnore();
        }
        Handle handle = this.database.getHandle(true);
        try {
            if (rows.size() > 1) {
                handle.runTransaction(new Transaction(){

                    @Override
                    public boolean insideTransaction(@NotNull Handle handle) throws WCDBException {
                        TableOperation.this.insertRows((Collection<Value[]>)rows, insert, handle);
                        return true;
                    }
                });
            } else {
                this.insertRows(rows, insert, handle);
            }
        }
        finally {
            handle.invalidate();
        }
    }

    private void insertRows(Collection<Value[]> rows, StatementInsert insert, Handle handle) throws WCDBException {
        PreparedStatement preparedStatement = handle.preparedWithMainStatement(insert);
        for (Value[] row : rows) {
            preparedStatement.reset();
            preparedStatement.bindRow(row);
            preparedStatement.step();
        }
        preparedStatement.finalizeStatement();
    }

    public void updateValue(int value, @NotNull Column column) throws WCDBException {
        this.updateRow(new Value[]{new Value(value)}, new Column[]{column});
    }

    public void updateValue(int value, @NotNull Column column, @Nullable Expression condition) throws WCDBException {
        this.updateRow(new Value[]{new Value(value)}, new Column[]{column}, condition);
    }

    public void updateValue(int value, @NotNull Column column, @Nullable Expression condition, @Nullable OrderingTerm order, int limit) throws WCDBException {
        this.updateRow(new Value[]{new Value(value)}, new Column[]{column}, condition, order, limit);
    }

    public void updateValue(int value, @NotNull Column column, @Nullable Expression condition, @Nullable OrderingTerm order, int limit, int offset) throws WCDBException {
        this.updateRow(new Value[]{new Value(value)}, new Column[]{column}, condition, order, limit, offset);
    }

    public void updateValue(int value, @NotNull Column column, @Nullable OrderingTerm order, int limit) throws WCDBException {
        this.updateRow(new Value[]{new Value(value)}, new Column[]{column}, order, limit);
    }

    public void updateValue(int value, @NotNull Column column, @Nullable OrderingTerm order, int limit, int offset) throws WCDBException {
        this.updateRow(new Value[]{new Value(value)}, new Column[]{column}, order, limit, offset);
    }

    public void updateValue(long value, @NotNull Column column) throws WCDBException {
        this.updateRow(new Value[]{new Value(value)}, new Column[]{column});
    }

    public void updateValue(long value, @NotNull Column column, @Nullable Expression condition) throws WCDBException {
        this.updateRow(new Value[]{new Value(value)}, new Column[]{column}, condition);
    }

    public void updateValue(long value, @NotNull Column column, @Nullable Expression condition, @Nullable OrderingTerm order, int limit) throws WCDBException {
        this.updateRow(new Value[]{new Value(value)}, new Column[]{column}, condition, order, limit);
    }

    public void updateValue(long value, @NotNull Column column, @Nullable Expression condition, @Nullable OrderingTerm order, int limit, int offset) throws WCDBException {
        this.updateRow(new Value[]{new Value(value)}, new Column[]{column}, condition, order, limit, offset);
    }

    public void updateValue(long value, @NotNull Column column, @Nullable OrderingTerm order, int limit) throws WCDBException {
        this.updateRow(new Value[]{new Value(value)}, new Column[]{column}, order, limit);
    }

    public void updateValue(long value, @NotNull Column column, @Nullable OrderingTerm order, int limit, int offset) throws WCDBException {
        this.updateRow(new Value[]{new Value(value)}, new Column[]{column}, order, limit, offset);
    }

    public void updateValue(float value, @NotNull Column column) throws WCDBException {
        this.updateRow(new Value[]{new Value(value)}, new Column[]{column});
    }

    public void updateValue(float value, @NotNull Column column, @Nullable Expression condition) throws WCDBException {
        this.updateRow(new Value[]{new Value(value)}, new Column[]{column}, condition);
    }

    public void updateValue(float value, @NotNull Column column, @Nullable Expression condition, @Nullable OrderingTerm order, int limit) throws WCDBException {
        this.updateRow(new Value[]{new Value(value)}, new Column[]{column}, condition, order, limit);
    }

    public void updateValue(float value, @NotNull Column column, @Nullable Expression condition, @Nullable OrderingTerm order, int limit, int offset) throws WCDBException {
        this.updateRow(new Value[]{new Value(value)}, new Column[]{column}, condition, order, limit, offset);
    }

    public void updateValue(float value, @NotNull Column column, @Nullable OrderingTerm order, int limit) throws WCDBException {
        this.updateRow(new Value[]{new Value(value)}, new Column[]{column}, order, limit);
    }

    public void updateValue(float value, @NotNull Column column, @Nullable OrderingTerm order, int limit, int offset) throws WCDBException {
        this.updateRow(new Value[]{new Value(value)}, new Column[]{column}, order, limit, offset);
    }

    public void updateValue(double value, @NotNull Column column) throws WCDBException {
        this.updateRow(new Value[]{new Value(value)}, new Column[]{column});
    }

    public void updateValue(double value, @NotNull Column column, @Nullable Expression condition) throws WCDBException {
        this.updateRow(new Value[]{new Value(value)}, new Column[]{column}, condition);
    }

    public void updateValue(double value, @NotNull Column column, @Nullable Expression condition, @Nullable OrderingTerm order, int limit) throws WCDBException {
        this.updateRow(new Value[]{new Value(value)}, new Column[]{column}, condition, order, limit);
    }

    public void updateValue(double value, @NotNull Column column, @Nullable Expression condition, @Nullable OrderingTerm order, int limit, int offset) throws WCDBException {
        this.updateRow(new Value[]{new Value(value)}, new Column[]{column}, condition, order, limit, offset);
    }

    public void updateValue(double value, @NotNull Column column, @Nullable OrderingTerm order, int limit) throws WCDBException {
        this.updateRow(new Value[]{new Value(value)}, new Column[]{column}, order, limit);
    }

    public void updateValue(double value, @NotNull Column column, @Nullable OrderingTerm order, int limit, int offset) throws WCDBException {
        this.updateRow(new Value[]{new Value(value)}, new Column[]{column}, order, limit, offset);
    }

    public void updateValue(@Nullable String value, @NotNull Column column) throws WCDBException {
        this.updateRow(new Value[]{new Value(value)}, new Column[]{column});
    }

    public void updateValue(@Nullable String value, @NotNull Column column, @Nullable Expression condition) throws WCDBException {
        this.updateRow(new Value[]{new Value(value)}, new Column[]{column}, condition);
    }

    public void updateValue(@Nullable String value, @NotNull Column column, @Nullable Expression condition, @Nullable OrderingTerm order, int limit) throws WCDBException {
        this.updateRow(new Value[]{new Value(value)}, new Column[]{column}, condition, order, limit);
    }

    public void updateValue(@Nullable String value, @NotNull Column column, @Nullable Expression condition, @Nullable OrderingTerm order, int limit, int offset) throws WCDBException {
        this.updateRow(new Value[]{new Value(value)}, new Column[]{column}, condition, order, limit, offset);
    }

    public void updateValue(@Nullable String value, @NotNull Column column, @Nullable OrderingTerm order, int limit) throws WCDBException {
        this.updateRow(new Value[]{new Value(value)}, new Column[]{column}, order, limit);
    }

    public void updateValue(@Nullable String value, @NotNull Column column, @Nullable OrderingTerm order, int limit, int offset) throws WCDBException {
        this.updateRow(new Value[]{new Value(value)}, new Column[]{column}, order, limit, offset);
    }

    public void updateValue(@Nullable byte[] value, @NotNull Column column) throws WCDBException {
        this.updateRow(new Value[]{new Value(value)}, new Column[]{column});
    }

    public void updateValue(@Nullable byte[] value, @NotNull Column column, @Nullable Expression condition) throws WCDBException {
        this.updateRow(new Value[]{new Value(value)}, new Column[]{column}, condition);
    }

    public void updateValue(@Nullable byte[] value, @NotNull Column column, @Nullable Expression condition, @Nullable OrderingTerm order, int limit) throws WCDBException {
        this.updateRow(new Value[]{new Value(value)}, new Column[]{column}, condition, order, limit);
    }

    public void updateValue(@Nullable byte[] value, @NotNull Column column, @Nullable Expression condition, @Nullable OrderingTerm order, int limit, int offset) throws WCDBException {
        this.updateRow(new Value[]{new Value(value)}, new Column[]{column}, condition, order, limit, offset);
    }

    public void updateValue(@Nullable byte[] value, @NotNull Column column, @Nullable OrderingTerm order, int limit) throws WCDBException {
        this.updateRow(new Value[]{new Value(value)}, new Column[]{column}, order, limit);
    }

    public void updateValue(@Nullable byte[] value, @NotNull Column column, @Nullable OrderingTerm order, int limit, int offset) throws WCDBException {
        this.updateRow(new Value[]{new Value(value)}, new Column[]{column}, order, limit, offset);
    }

    public void updateValue(@Nullable Value value, @NotNull Column column) throws WCDBException {
        this.updateRow(new Value[]{value}, new Column[]{column});
    }

    public void updateValue(@Nullable Value value, @NotNull Column column, @Nullable Expression condition) throws WCDBException {
        this.updateRow(new Value[]{value}, new Column[]{column}, condition);
    }

    public void updateValue(@Nullable Value value, @NotNull Column column, @Nullable Expression condition, @Nullable OrderingTerm order, int limit) throws WCDBException {
        this.updateRow(new Value[]{value}, new Column[]{column}, condition, order, limit);
    }

    public void updateValue(@Nullable Value value, @NotNull Column column, @Nullable Expression condition, @Nullable OrderingTerm order, int limit, int offset) throws WCDBException {
        this.updateRow(new Value[]{value}, new Column[]{column}, condition, order, limit, offset);
    }

    public void updateValue(@Nullable Value value, @NotNull Column column, @Nullable OrderingTerm order, int limit) throws WCDBException {
        this.updateRow(new Value[]{value}, new Column[]{column}, order, limit);
    }

    public void updateValue(@Nullable Value value, @NotNull Column column, @Nullable OrderingTerm order, int limit, int offset) throws WCDBException {
        this.updateRow(new Value[]{value}, new Column[]{column}, order, limit, offset);
    }

    public void updateRow(@NotNull Value[] row, @NotNull Column[] columns) throws WCDBException {
        StatementUpdate update = new StatementUpdate().update(this.tableName).setColumnsToBindParameters(columns);
        this.updateRow(row, update);
    }

    public void updateRow(@NotNull Value[] row, @NotNull Column[] columns, @Nullable Expression condition) throws WCDBException {
        StatementUpdate update = new StatementUpdate().update(this.tableName).setColumnsToBindParameters(columns).where(condition);
        this.updateRow(row, update);
    }

    public void updateRow(@NotNull Value[] row, @NotNull Column[] columns, @Nullable Expression condition, @Nullable OrderingTerm order, int limit) throws WCDBException {
        StatementUpdate update = new StatementUpdate().update(this.tableName).setColumnsToBindParameters(columns).where(condition).orderBy(order).limit(limit);
        this.updateRow(row, update);
    }

    public void updateRow(@NotNull Value[] row, @NotNull Column[] columns, @Nullable Expression condition, @Nullable OrderingTerm order, int limit, int offset) throws WCDBException {
        StatementUpdate update = new StatementUpdate().update(this.tableName).setColumnsToBindParameters(columns).where(condition).orderBy(order).limit(limit).offset(offset);
        this.updateRow(row, update);
    }

    public void updateRow(@NotNull Value[] row, @NotNull Column[] columns, @Nullable OrderingTerm order, int limit) throws WCDBException {
        StatementUpdate update = new StatementUpdate().update(this.tableName).setColumnsToBindParameters(columns).orderBy(order).limit(limit);
        this.updateRow(row, update);
    }

    public void updateRow(@NotNull Value[] row, @NotNull Column[] columns, @Nullable OrderingTerm order, int limit, int offset) throws WCDBException {
        StatementUpdate update = new StatementUpdate().update(this.tableName).setColumnsToBindParameters(columns).orderBy(order).limit(limit).offset(offset);
        this.updateRow(row, update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRow(@NotNull Value[] row, StatementUpdate update) throws WCDBException {
        Handle handle = this.database.getHandle(true);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = handle.preparedWithMainStatement(update);
            preparedStatement.bindRow(row);
            preparedStatement.step();
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.finalizeStatement();
            }
            handle.invalidate();
        }
    }

    public void deleteValue() throws WCDBException {
        StatementDelete delete = new StatementDelete().deleteFrom(this.tableName);
        this.deleteValue(delete);
    }

    public void deleteValue(@Nullable Expression condition) throws WCDBException {
        StatementDelete delete = new StatementDelete().deleteFrom(this.tableName).where(condition);
        this.deleteValue(delete);
    }

    public void deleteValue(@Nullable Expression condition, @Nullable OrderingTerm orderingTerm, int limit) throws WCDBException {
        StatementDelete delete = new StatementDelete().deleteFrom(this.tableName).where(condition).orderBy(orderingTerm).limit(limit);
        this.deleteValue(delete);
    }

    public void deleteValue(@Nullable Expression condition, @Nullable OrderingTerm orderingTerm, int limit, int offset) throws WCDBException {
        StatementDelete delete = new StatementDelete().deleteFrom(this.tableName).where(condition).orderBy(orderingTerm).limit(limit).offset(offset);
        this.deleteValue(delete);
    }

    public void deleteValue(@Nullable OrderingTerm orderingTerm, int limit) throws WCDBException {
        StatementDelete delete = new StatementDelete().deleteFrom(this.tableName).orderBy(orderingTerm).limit(limit);
        this.deleteValue(delete);
    }

    public void deleteValue(@Nullable OrderingTerm orderingTerm, int limit, int offset) throws WCDBException {
        StatementDelete delete = new StatementDelete().deleteFrom(this.tableName).orderBy(orderingTerm).limit(limit).offset(offset);
        this.deleteValue(delete);
    }

    private void deleteValue(StatementDelete delete) throws WCDBException {
        Handle handle = this.database.getHandle(true);
        try {
            handle.execute(delete);
        }
        finally {
            handle.invalidate();
        }
    }

    @Nullable
    public Value getValue(@NotNull ResultColumnConvertible column) throws WCDBException {
        return this.getValueFromStatement(new StatementSelect().select(column).from(this.tableName));
    }

    @Nullable
    public Value getValue(@NotNull ResultColumnConvertible column, @Nullable Expression condition) throws WCDBException {
        return this.getValueFromStatement(new StatementSelect().select(column).from(this.tableName).where(condition));
    }

    @Nullable
    public Value getValue(@NotNull ResultColumnConvertible column, @Nullable Expression condition, @Nullable OrderingTerm order) throws WCDBException {
        return this.getValueFromStatement(new StatementSelect().select(column).from(this.tableName).where(condition).orderBy(order));
    }

    @Nullable
    public Value getValue(@NotNull ResultColumnConvertible column, @Nullable Expression condition, @Nullable OrderingTerm order, int offset) throws WCDBException {
        return this.getValueFromStatement(new StatementSelect().select(column).from(this.tableName).where(condition).orderBy(order).limit(1L).offset(offset));
    }

    @Nullable
    public Value getValue(@NotNull ResultColumnConvertible column, @Nullable OrderingTerm order) throws WCDBException {
        return this.getValueFromStatement(new StatementSelect().select(column).from(this.tableName).orderBy(order));
    }

    @Nullable
    public Value getValue(@NotNull ResultColumnConvertible column, @Nullable OrderingTerm order, int offset) throws WCDBException {
        return this.getValueFromStatement(new StatementSelect().select(column).from(this.tableName).orderBy(order).limit(1L).offset(offset));
    }

    @NotNull
    public List<Value> getOneColumn(@NotNull ResultColumnConvertible column) throws WCDBException {
        return this.getOneColumnFromStatement(new StatementSelect().select(column).from(this.tableName));
    }

    @NotNull
    public List<Value> getOneColumn(@NotNull ResultColumnConvertible column, @Nullable Expression condition) throws WCDBException {
        return this.getOneColumnFromStatement(new StatementSelect().select(column).from(this.tableName).where(condition));
    }

    @NotNull
    public List<Value> getOneColumn(@NotNull ResultColumnConvertible column, @Nullable Expression condition, @Nullable OrderingTerm order) throws WCDBException {
        return this.getOneColumnFromStatement(new StatementSelect().select(column).from(this.tableName).where(condition).orderBy(order));
    }

    @NotNull
    public List<Value> getOneColumn(@NotNull ResultColumnConvertible column, @Nullable Expression condition, @Nullable OrderingTerm order, int limit) throws WCDBException {
        return this.getOneColumnFromStatement(new StatementSelect().select(column).from(this.tableName).where(condition).orderBy(order).limit(limit));
    }

    @NotNull
    public List<Value> getOneColumn(@NotNull ResultColumnConvertible column, @Nullable Expression condition, @Nullable OrderingTerm order, int limit, int offset) throws WCDBException {
        return this.getOneColumnFromStatement(new StatementSelect().select(column).from(this.tableName).where(condition).orderBy(order).limit(limit).offset(offset));
    }

    @NotNull
    public List<Value> getOneColumn(@NotNull ResultColumnConvertible column, @Nullable OrderingTerm order) throws WCDBException {
        return this.getOneColumnFromStatement(new StatementSelect().select(column).from(this.tableName).orderBy(order));
    }

    @NotNull
    public List<Value> getOneColumn(@NotNull ResultColumnConvertible column, @Nullable OrderingTerm order, int limit) throws WCDBException {
        return this.getOneColumnFromStatement(new StatementSelect().select(column).from(this.tableName).orderBy(order).limit(limit));
    }

    @NotNull
    public List<Value> getOneColumn(@NotNull ResultColumnConvertible column, @Nullable OrderingTerm order, int limit, int offset) throws WCDBException {
        return this.getOneColumnFromStatement(new StatementSelect().select(column).from(this.tableName).orderBy(order).limit(limit).offset(offset));
    }

    @Nullable
    public Value[] getOneRow(@NotNull ResultColumnConvertible[] columns) throws WCDBException {
        return this.getOneRowFromStatement(new StatementSelect().select(columns).from(this.tableName));
    }

    @Nullable
    public Value[] getOneRow(@NotNull ResultColumnConvertible[] columns, @Nullable Expression condition) throws WCDBException {
        return this.getOneRowFromStatement(new StatementSelect().select(columns).from(this.tableName).where(condition));
    }

    @Nullable
    public Value[] getOneRow(@NotNull ResultColumnConvertible[] columns, @Nullable Expression condition, @Nullable OrderingTerm orderingTerm) throws WCDBException {
        return this.getOneRowFromStatement(new StatementSelect().select(columns).from(this.tableName).where(condition).orderBy(orderingTerm));
    }

    @Nullable
    public Value[] getOneRow(@NotNull ResultColumnConvertible[] columns, @Nullable Expression condition, @Nullable OrderingTerm orderingTerm, int offset) throws WCDBException {
        return this.getOneRowFromStatement(new StatementSelect().select(columns).from(this.tableName).where(condition).orderBy(orderingTerm).limit(1L).offset(offset));
    }

    @Nullable
    public Value[] getOneRow(@NotNull ResultColumnConvertible[] columns, @Nullable OrderingTerm orderingTerm) throws WCDBException {
        return this.getOneRowFromStatement(new StatementSelect().select(columns).from(this.tableName).orderBy(orderingTerm));
    }

    @Nullable
    public Value[] getOneRow(@NotNull ResultColumnConvertible[] columns, @Nullable OrderingTerm orderingTerm, int offset) throws WCDBException {
        return this.getOneRowFromStatement(new StatementSelect().select(columns).from(this.tableName).orderBy(orderingTerm).limit(1L).offset(offset));
    }

    @NotNull
    public List<Integer> getOneColumnInt(@NotNull ResultColumnConvertible column) throws WCDBException {
        return this.getOneColumnIntFromStatement(new StatementSelect().select(column).from(this.tableName));
    }

    @NotNull
    public List<Integer> getOneColumnInt(@NotNull ResultColumnConvertible column, @Nullable Expression condition) throws WCDBException {
        return this.getOneColumnIntFromStatement(new StatementSelect().select(column).from(this.tableName).where(condition));
    }

    @NotNull
    public List<Integer> getOneColumnInt(@NotNull ResultColumnConvertible column, @Nullable Expression condition, @Nullable OrderingTerm order) throws WCDBException {
        return this.getOneColumnIntFromStatement(new StatementSelect().select(column).from(this.tableName).where(condition).orderBy(order));
    }

    @NotNull
    public List<Integer> getOneColumnInt(@NotNull ResultColumnConvertible column, @Nullable Expression condition, @Nullable OrderingTerm order, int limit) throws WCDBException {
        return this.getOneColumnIntFromStatement(new StatementSelect().select(column).from(this.tableName).where(condition).orderBy(order).limit(limit));
    }

    @NotNull
    public List<Integer> getOneColumnInt(@NotNull ResultColumnConvertible column, @Nullable Expression condition, @Nullable OrderingTerm order, int limit, int offset) throws WCDBException {
        return this.getOneColumnIntFromStatement(new StatementSelect().select(column).from(this.tableName).where(condition).orderBy(order).limit(limit).offset(offset));
    }

    @NotNull
    public List<Integer> getOneColumnInt(@NotNull ResultColumnConvertible column, @Nullable OrderingTerm order) throws WCDBException {
        return this.getOneColumnIntFromStatement(new StatementSelect().select(column).from(this.tableName).orderBy(order));
    }

    @NotNull
    public List<Integer> getOneColumnInt(@NotNull ResultColumnConvertible column, @Nullable OrderingTerm order, int limit) throws WCDBException {
        return this.getOneColumnIntFromStatement(new StatementSelect().select(column).from(this.tableName).orderBy(order).limit(limit));
    }

    @NotNull
    public List<Integer> getOneColumnInt(@NotNull ResultColumnConvertible column, @Nullable OrderingTerm order, int limit, int offset) throws WCDBException {
        return this.getOneColumnIntFromStatement(new StatementSelect().select(column).from(this.tableName).orderBy(order).limit(limit).offset(offset));
    }

    @NotNull
    public List<Long> getOneColumnLong(@NotNull ResultColumnConvertible column) throws WCDBException {
        return this.getOneColumnLongFromStatement(new StatementSelect().select(column).from(this.tableName));
    }

    @NotNull
    public List<Long> getOneColumnLong(@NotNull ResultColumnConvertible column, @Nullable Expression condition) throws WCDBException {
        return this.getOneColumnLongFromStatement(new StatementSelect().select(column).from(this.tableName).where(condition));
    }

    @NotNull
    public List<Long> getOneColumnLong(@NotNull ResultColumnConvertible column, @Nullable Expression condition, @Nullable OrderingTerm order) throws WCDBException {
        return this.getOneColumnLongFromStatement(new StatementSelect().select(column).from(this.tableName).where(condition).orderBy(order));
    }

    @NotNull
    public List<Long> getOneColumnLong(@NotNull ResultColumnConvertible column, @Nullable Expression condition, @Nullable OrderingTerm order, int limit) throws WCDBException {
        return this.getOneColumnLongFromStatement(new StatementSelect().select(column).from(this.tableName).where(condition).orderBy(order).limit(limit));
    }

    @NotNull
    public List<Long> getOneColumnLong(@NotNull ResultColumnConvertible column, @Nullable Expression condition, @Nullable OrderingTerm order, int limit, int offset) throws WCDBException {
        return this.getOneColumnLongFromStatement(new StatementSelect().select(column).from(this.tableName).where(condition).orderBy(order).limit(limit).offset(offset));
    }

    @NotNull
    public List<Long> getOneColumnLong(@NotNull ResultColumnConvertible column, @Nullable OrderingTerm order) throws WCDBException {
        return this.getOneColumnLongFromStatement(new StatementSelect().select(column).from(this.tableName).orderBy(order));
    }

    @NotNull
    public List<Long> getOneColumnLong(@NotNull ResultColumnConvertible column, @Nullable OrderingTerm order, int limit) throws WCDBException {
        return this.getOneColumnLongFromStatement(new StatementSelect().select(column).from(this.tableName).orderBy(order).limit(limit));
    }

    @NotNull
    public List<Long> getOneColumnLong(@NotNull ResultColumnConvertible column, @Nullable OrderingTerm order, int limit, int offset) throws WCDBException {
        return this.getOneColumnLongFromStatement(new StatementSelect().select(column).from(this.tableName).orderBy(order).limit(limit).offset(offset));
    }

    @NotNull
    public List<Float> getOneColumnFloat(@NotNull ResultColumnConvertible column) throws WCDBException {
        return this.getOneColumnFloatFromStatement(new StatementSelect().select(column).from(this.tableName));
    }

    @NotNull
    public List<Float> getOneColumnFloat(@NotNull ResultColumnConvertible column, @Nullable Expression condition) throws WCDBException {
        return this.getOneColumnFloatFromStatement(new StatementSelect().select(column).from(this.tableName).where(condition));
    }

    @NotNull
    public List<Float> getOneColumnFloat(@NotNull ResultColumnConvertible column, @Nullable Expression condition, @Nullable OrderingTerm order) throws WCDBException {
        return this.getOneColumnFloatFromStatement(new StatementSelect().select(column).from(this.tableName).where(condition).orderBy(order));
    }

    @NotNull
    public List<Float> getOneColumnFloat(@NotNull ResultColumnConvertible column, @Nullable Expression condition, @Nullable OrderingTerm order, int limit) throws WCDBException {
        return this.getOneColumnFloatFromStatement(new StatementSelect().select(column).from(this.tableName).where(condition).orderBy(order).limit(limit));
    }

    @NotNull
    public List<Float> getOneColumnFloat(@NotNull ResultColumnConvertible column, @Nullable Expression condition, @Nullable OrderingTerm order, int limit, int offset) throws WCDBException {
        return this.getOneColumnFloatFromStatement(new StatementSelect().select(column).from(this.tableName).where(condition).orderBy(order).limit(limit).offset(offset));
    }

    @NotNull
    public List<Float> getOneColumnFloat(@NotNull ResultColumnConvertible column, @Nullable OrderingTerm order) throws WCDBException {
        return this.getOneColumnFloatFromStatement(new StatementSelect().select(column).from(this.tableName).orderBy(order));
    }

    @NotNull
    public List<Float> getOneColumnFloat(@NotNull ResultColumnConvertible column, @Nullable OrderingTerm order, int limit) throws WCDBException {
        return this.getOneColumnFloatFromStatement(new StatementSelect().select(column).from(this.tableName).orderBy(order).limit(limit));
    }

    @NotNull
    public List<Float> getOneColumnFloat(@NotNull ResultColumnConvertible column, @Nullable OrderingTerm order, int limit, int offset) throws WCDBException {
        return this.getOneColumnFloatFromStatement(new StatementSelect().select(column).from(this.tableName).orderBy(order).limit(limit).offset(offset));
    }

    @NotNull
    public List<Double> getOneColumnDouble(@NotNull ResultColumnConvertible column) throws WCDBException {
        return this.getOneColumnDoubleFromStatement(new StatementSelect().select(column).from(this.tableName));
    }

    @NotNull
    public List<Double> getOneColumnDouble(@NotNull ResultColumnConvertible column, @Nullable Expression condition) throws WCDBException {
        return this.getOneColumnDoubleFromStatement(new StatementSelect().select(column).from(this.tableName).where(condition));
    }

    @NotNull
    public List<Double> getOneColumnDouble(@NotNull ResultColumnConvertible column, @Nullable Expression condition, @Nullable OrderingTerm order) throws WCDBException {
        return this.getOneColumnDoubleFromStatement(new StatementSelect().select(column).from(this.tableName).where(condition).orderBy(order));
    }

    @NotNull
    public List<Double> getOneColumnDouble(@NotNull ResultColumnConvertible column, @Nullable Expression condition, @Nullable OrderingTerm order, int limit) throws WCDBException {
        return this.getOneColumnDoubleFromStatement(new StatementSelect().select(column).from(this.tableName).where(condition).orderBy(order).limit(limit));
    }

    @NotNull
    public List<Double> getOneColumnDouble(@NotNull ResultColumnConvertible column, @Nullable Expression condition, @Nullable OrderingTerm order, int limit, int offset) throws WCDBException {
        return this.getOneColumnDoubleFromStatement(new StatementSelect().select(column).from(this.tableName).where(condition).orderBy(order).limit(limit).offset(offset));
    }

    @NotNull
    public List<Double> getOneColumnDouble(@NotNull ResultColumnConvertible column, @Nullable OrderingTerm order) throws WCDBException {
        return this.getOneColumnDoubleFromStatement(new StatementSelect().select(column).from(this.tableName).orderBy(order));
    }

    @NotNull
    public List<Double> getOneColumnDouble(@NotNull ResultColumnConvertible column, @Nullable OrderingTerm order, int limit) throws WCDBException {
        return this.getOneColumnDoubleFromStatement(new StatementSelect().select(column).from(this.tableName).orderBy(order).limit(limit));
    }

    @NotNull
    public List<Double> getOneColumnDouble(@NotNull ResultColumnConvertible column, @Nullable OrderingTerm order, int limit, int offset) throws WCDBException {
        return this.getOneColumnDoubleFromStatement(new StatementSelect().select(column).from(this.tableName).orderBy(order).limit(limit).offset(offset));
    }

    @NotNull
    public List<String> getOneColumnString(@NotNull ResultColumnConvertible column) throws WCDBException {
        return this.getOneColumnStringFromStatement(new StatementSelect().select(column).from(this.tableName));
    }

    @NotNull
    public List<String> getOneColumnString(@NotNull ResultColumnConvertible column, @Nullable Expression condition) throws WCDBException {
        return this.getOneColumnStringFromStatement(new StatementSelect().select(column).from(this.tableName).where(condition));
    }

    @NotNull
    public List<String> getOneColumnString(@NotNull ResultColumnConvertible column, @Nullable Expression condition, @Nullable OrderingTerm order) throws WCDBException {
        return this.getOneColumnStringFromStatement(new StatementSelect().select(column).from(this.tableName).where(condition).orderBy(order));
    }

    @NotNull
    public List<String> getOneColumnString(@NotNull ResultColumnConvertible column, @Nullable Expression condition, @Nullable OrderingTerm order, int limit) throws WCDBException {
        return this.getOneColumnStringFromStatement(new StatementSelect().select(column).from(this.tableName).where(condition).orderBy(order).limit(limit));
    }

    @NotNull
    public List<String> getOneColumnString(@NotNull ResultColumnConvertible column, @Nullable Expression condition, @Nullable OrderingTerm order, int limit, int offset) throws WCDBException {
        return this.getOneColumnStringFromStatement(new StatementSelect().select(column).from(this.tableName).where(condition).orderBy(order).limit(limit).offset(offset));
    }

    @NotNull
    public List<String> getOneColumnString(@NotNull ResultColumnConvertible column, @Nullable OrderingTerm order) throws WCDBException {
        return this.getOneColumnStringFromStatement(new StatementSelect().select(column).from(this.tableName).orderBy(order));
    }

    @NotNull
    public List<String> getOneColumnString(@NotNull ResultColumnConvertible column, @Nullable OrderingTerm order, int limit) throws WCDBException {
        return this.getOneColumnStringFromStatement(new StatementSelect().select(column).from(this.tableName).orderBy(order).limit(limit));
    }

    @NotNull
    public List<String> getOneColumnString(@NotNull ResultColumnConvertible column, @Nullable OrderingTerm order, int limit, int offset) throws WCDBException {
        return this.getOneColumnStringFromStatement(new StatementSelect().select(column).from(this.tableName).orderBy(order).limit(limit).offset(offset));
    }

    @NotNull
    public List<byte[]> getOneColumnBLOB(@NotNull ResultColumnConvertible column) throws WCDBException {
        return this.getOneColumnBLOBFromStatement(new StatementSelect().select(column).from(this.tableName));
    }

    @NotNull
    public List<byte[]> getOneColumnBLOB(@NotNull ResultColumnConvertible column, @Nullable Expression condition) throws WCDBException {
        return this.getOneColumnBLOBFromStatement(new StatementSelect().select(column).from(this.tableName).where(condition));
    }

    @NotNull
    public List<byte[]> getOneColumnBLOB(@NotNull ResultColumnConvertible column, @Nullable Expression condition, @Nullable OrderingTerm order) throws WCDBException {
        return this.getOneColumnBLOBFromStatement(new StatementSelect().select(column).from(this.tableName).where(condition).orderBy(order));
    }

    @NotNull
    public List<byte[]> getOneColumnBLOB(@NotNull ResultColumnConvertible column, @Nullable Expression condition, @Nullable OrderingTerm order, int limit) throws WCDBException {
        return this.getOneColumnBLOBFromStatement(new StatementSelect().select(column).from(this.tableName).where(condition).orderBy(order).limit(limit));
    }

    @NotNull
    public List<byte[]> getOneColumnBLOB(@NotNull ResultColumnConvertible column, @Nullable Expression condition, @Nullable OrderingTerm order, int limit, int offset) throws WCDBException {
        return this.getOneColumnBLOBFromStatement(new StatementSelect().select(column).from(this.tableName).where(condition).orderBy(order).limit(limit).offset(offset));
    }

    @NotNull
    public List<byte[]> getOneColumnBLOB(@NotNull ResultColumnConvertible column, @Nullable OrderingTerm order) throws WCDBException {
        return this.getOneColumnBLOBFromStatement(new StatementSelect().select(column).from(this.tableName).orderBy(order));
    }

    @NotNull
    public List<byte[]> getOneColumnBLOB(@NotNull ResultColumnConvertible column, @Nullable OrderingTerm order, int limit) throws WCDBException {
        return this.getOneColumnBLOBFromStatement(new StatementSelect().select(column).from(this.tableName).orderBy(order).limit(limit));
    }

    @NotNull
    public List<byte[]> getOneColumnBLOB(@NotNull ResultColumnConvertible column, @Nullable OrderingTerm order, int limit, int offset) throws WCDBException {
        return this.getOneColumnBLOBFromStatement(new StatementSelect().select(column).from(this.tableName).orderBy(order).limit(limit).offset(offset));
    }

    @NotNull
    public List<Value[]> getAllRows(@NotNull ResultColumnConvertible[] columns) throws WCDBException {
        return this.getAllRowsFromStatement(new StatementSelect().select(columns).from(this.tableName));
    }

    @NotNull
    public List<Value[]> getAllRows(@NotNull ResultColumnConvertible[] columns, @Nullable Expression condition) throws WCDBException {
        return this.getAllRowsFromStatement(new StatementSelect().select(columns).from(this.tableName).where(condition));
    }

    @NotNull
    public List<Value[]> getAllRows(@NotNull ResultColumnConvertible[] columns, @Nullable Expression condition, @Nullable OrderingTerm order) throws WCDBException {
        return this.getAllRowsFromStatement(new StatementSelect().select(columns).from(this.tableName).where(condition).orderBy(order));
    }

    @NotNull
    public List<Value[]> getAllRows(@NotNull ResultColumnConvertible[] columns, @Nullable Expression condition, @Nullable OrderingTerm order, int limit) throws WCDBException {
        return this.getAllRowsFromStatement(new StatementSelect().select(columns).from(this.tableName).where(condition).orderBy(order).limit(limit));
    }

    @NotNull
    public List<Value[]> getAllRows(@NotNull ResultColumnConvertible[] columns, @Nullable Expression condition, @Nullable OrderingTerm order, int limit, int offset) throws WCDBException {
        return this.getAllRowsFromStatement(new StatementSelect().select(columns).from(this.tableName).where(condition).orderBy(order).limit(limit).offset(offset));
    }

    @NotNull
    public List<Value[]> getAllRows(@NotNull ResultColumnConvertible[] columns, @Nullable OrderingTerm order) throws WCDBException {
        return this.getAllRowsFromStatement(new StatementSelect().select(columns).from(this.tableName).orderBy(order));
    }

    @NotNull
    public List<Value[]> getAllRows(@NotNull ResultColumnConvertible[] columns, @Nullable OrderingTerm order, int limit) throws WCDBException {
        return this.getAllRowsFromStatement(new StatementSelect().select(columns).from(this.tableName).orderBy(order).limit(limit));
    }

    @NotNull
    public List<Value[]> getAllRows(@NotNull ResultColumnConvertible[] columns, @Nullable OrderingTerm order, int limit, int offset) throws WCDBException {
        return this.getAllRowsFromStatement(new StatementSelect().select(columns).from(this.tableName).orderBy(order).limit(limit).offset(offset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Value getValueFromStatement(@NotNull Statement statement) throws WCDBException {
        Handle handle = this.database.getHandle(false);
        Value ret = null;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = handle.preparedWithMainStatement(statement);
            preparedStatement.step();
            if (!preparedStatement.isDone()) {
                ret = preparedStatement.getValue(0);
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.finalizeStatement();
            }
            handle.invalidate();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Value[] getOneRowFromStatement(@NotNull Statement statement) throws WCDBException {
        Handle handle = this.database.getHandle(false);
        Value[] ret = null;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = handle.preparedWithMainStatement(statement);
            preparedStatement.step();
            if (!preparedStatement.isDone()) {
                ret = preparedStatement.getOneRow();
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.finalizeStatement();
            }
            handle.invalidate();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<Value> getOneColumnFromStatement(@NotNull Statement statement) throws WCDBException {
        List<Value> ret;
        Handle handle = this.database.getHandle(false);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = handle.preparedWithMainStatement(statement);
            ret = preparedStatement.getOneColumn();
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.finalizeStatement();
            }
            handle.invalidate();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<Integer> getOneColumnIntFromStatement(@NotNull Statement statement) throws WCDBException {
        List<Integer> ret;
        Handle handle = this.database.getHandle(false);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = handle.preparedWithMainStatement(statement);
            ret = preparedStatement.getOneColumnInt();
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.finalizeStatement();
            }
            handle.invalidate();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<Long> getOneColumnLongFromStatement(@NotNull Statement statement) throws WCDBException {
        List<Long> ret;
        Handle handle = this.database.getHandle(false);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = handle.preparedWithMainStatement(statement);
            ret = preparedStatement.getOneColumnLong();
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.finalizeStatement();
            }
            handle.invalidate();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<Float> getOneColumnFloatFromStatement(@NotNull Statement statement) throws WCDBException {
        List<Float> ret;
        Handle handle = this.database.getHandle(false);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = handle.preparedWithMainStatement(statement);
            ret = preparedStatement.getOneColumnFloat();
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.finalizeStatement();
            }
            handle.invalidate();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<Double> getOneColumnDoubleFromStatement(@NotNull Statement statement) throws WCDBException {
        List<Double> ret;
        Handle handle = this.database.getHandle(false);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = handle.preparedWithMainStatement(statement);
            ret = preparedStatement.getOneColumnDouble();
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.finalizeStatement();
            }
            handle.invalidate();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<String> getOneColumnStringFromStatement(@NotNull Statement statement) throws WCDBException {
        List<String> ret;
        Handle handle = this.database.getHandle(false);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = handle.preparedWithMainStatement(statement);
            ret = preparedStatement.getOneColumnString();
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.finalizeStatement();
            }
            handle.invalidate();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<byte[]> getOneColumnBLOBFromStatement(@NotNull Statement statement) throws WCDBException {
        List<byte[]> ret;
        Handle handle = this.database.getHandle(false);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = handle.preparedWithMainStatement(statement);
            ret = preparedStatement.getOneColumnBLOB();
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.finalizeStatement();
            }
            handle.invalidate();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<Value[]> getAllRowsFromStatement(@NotNull Statement statement) throws WCDBException {
        List<Value[]> ret;
        Handle handle = this.database.getHandle(false);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = handle.preparedWithMainStatement(statement);
            ret = preparedStatement.getMultiRows();
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.finalizeStatement();
            }
            handle.invalidate();
        }
        return ret;
    }
}

