/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wcdb.base;

import com.tencent.wcdb.winq.ColumnType;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class Value {
    private final Object value;

    public Value() {
        this.value = null;
    }

    public Value(boolean value) {
        this.value = (long)(value ? 1 : 0);
    }

    public Value(byte value) {
        this.value = (long)value;
    }

    public Value(int value) {
        this.value = (long)value;
    }

    public Value(long value) {
        this.value = value;
    }

    public Value(float value) {
        this.value = (double)value;
    }

    public Value(double value) {
        this.value = value;
    }

    public Value(@Nullable String value) {
        this.value = value;
    }

    public Value(@Nullable byte[] value) {
        this.value = value;
    }

    public Value(@Nullable Object value) {
        if (value == null) {
            this.value = null;
            return;
        }
        Class<?> cls = value.getClass();
        this.value = cls == Long.class || cls == Double.class || cls == String.class || cls == byte[].class ? value : (cls == Integer.class || cls == Short.class || cls == Byte.class ? Long.valueOf(((Number)value).longValue()) : (cls == Float.class ? Double.valueOf(((Number)value).doubleValue()) : value.toString()));
    }

    public Value(@Nullable Value other) {
        this(other == null ? null : other.value);
    }

    public ColumnType getType() {
        if (this.value == null) {
            return ColumnType.Null;
        }
        Class<?> cls = this.value.getClass();
        if (cls == Long.class) {
            return ColumnType.Integer;
        }
        if (cls == String.class) {
            return ColumnType.Text;
        }
        if (cls == byte[].class) {
            return ColumnType.BLOB;
        }
        if (cls == Double.class) {
            return ColumnType.Float;
        }
        throw new AssertionError();
    }

    public boolean getBool() {
        return this.getLong() != 0L;
    }

    public byte getByte() {
        return (byte)this.getLong();
    }

    public short getShort() {
        return (short)this.getLong();
    }

    public int getInt() {
        return (int)this.getLong();
    }

    public long getLong() {
        if (this.value instanceof Long) {
            return (Long)this.value;
        }
        if (this.value instanceof Double) {
            return (Long)this.value;
        }
        if (this.value instanceof String) {
            try {
                return Long.parseLong((String)this.value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    public float getFloat() {
        return (float)this.getDouble();
    }

    public double getDouble() {
        if (this.value instanceof Double) {
            return (Double)this.value;
        }
        if (this.value instanceof Long) {
            return (Double)this.value;
        }
        if (this.value instanceof String) {
            try {
                return Double.parseDouble((String)this.value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0;
    }

    @Nullable
    public String getText() {
        if (this.value instanceof String) {
            return (String)this.value;
        }
        if (this.value instanceof byte[]) {
            return new String((byte[])this.value);
        }
        return this.value == null ? null : this.value.toString();
    }

    @Nullable
    public byte[] getBLOB() {
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof byte[]) {
            return (byte[])this.value;
        }
        return this.value.toString().getBytes();
    }

    public boolean equals(Object obj) {
        if (obj == this || obj == this.value) {
            return true;
        }
        if (obj instanceof Value) {
            Value v2 = (Value)obj;
            switch (this.getType()) {
                case Null: {
                    return v2.getLong() == 0L;
                }
                case Integer: {
                    return ((Long)this.value).longValue() == v2.getLong();
                }
                case Float: {
                    return ((Double)this.value).doubleValue() == v2.getDouble();
                }
                case Text: {
                    return this.value.equals(v2.getText());
                }
                case BLOB: {
                    return Arrays.equals((byte[])this.value, v2.getBLOB());
                }
            }
            assert (false);
        }
        return Objects.deepEquals(obj, this.value);
    }

    public int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }
}

