/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wcdb.chaincall;

import com.tencent.wcdb.base.Value;
import com.tencent.wcdb.base.WCDBException;
import com.tencent.wcdb.chaincall.ChainCall;
import com.tencent.wcdb.core.Handle;
import com.tencent.wcdb.core.PreparedStatement;
import com.tencent.wcdb.orm.Field;
import com.tencent.wcdb.orm.TableBinding;
import com.tencent.wcdb.winq.Expression;
import com.tencent.wcdb.winq.ExpressionConvertible;
import com.tencent.wcdb.winq.OrderingTerm;
import com.tencent.wcdb.winq.StatementUpdate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Update<T>
extends ChainCall<StatementUpdate> {
    private Field<T>[] fields = null;
    private T object = null;
    private Value[] row = null;

    public Update(@NotNull Handle handle, boolean needChanges, boolean autoInvalidateHandle) {
        super(handle, needChanges, autoInvalidateHandle);
        this.statement = new StatementUpdate();
    }

    @NotNull
    public Update<T> table(@NotNull String table) {
        ((StatementUpdate)this.statement).update(table);
        return this;
    }

    @SafeVarargs
    @NotNull
    public final Update<T> set(Field<T> ... fields) {
        this.fields = fields;
        ((StatementUpdate)this.statement).setColumnsToBindParameters(fields);
        return this;
    }

    @NotNull
    public Update<T> toObject(@Nullable T object) {
        this.object = object;
        return this;
    }

    @NotNull
    public Update<T> toValue(@Nullable Value value) {
        return this.toRow(value);
    }

    @NotNull
    public Update<T> toValue(byte value) {
        return this.toRow(new Value(value));
    }

    @NotNull
    public Update<T> toValue(short value) {
        return this.toRow(new Value(value));
    }

    @NotNull
    public Update<T> toValue(int value) {
        return this.toRow(new Value(value));
    }

    @NotNull
    public Update<T> toValue(long value) {
        return this.toRow(new Value(value));
    }

    @NotNull
    public Update<T> toValue(@Nullable String value) {
        return this.toRow(new Value(value));
    }

    @NotNull
    public Update<T> toValue(@Nullable byte[] value) {
        return this.toRow(new Value(value));
    }

    @NotNull
    public Update<T> toValue(float value) {
        return this.toRow(new Value(value));
    }

    @NotNull
    public Update<T> toValue(double value) {
        return this.toRow(new Value(value));
    }

    @NotNull
    public Update<T> toRow(Value ... row) {
        this.row = row;
        return this;
    }

    @NotNull
    public Update<T> where(@Nullable Expression condition) {
        ((StatementUpdate)this.statement).where(condition);
        return this;
    }

    @NotNull
    public Update<T> orderBy(@Nullable OrderingTerm order) {
        ((StatementUpdate)this.statement).orderBy(order);
        return this;
    }

    @NotNull
    public Update<T> orderBy(OrderingTerm ... orders) {
        ((StatementUpdate)this.statement).orderBy(orders);
        return this;
    }

    @NotNull
    public Update<T> limit(short count) {
        ((StatementUpdate)this.statement).limit(count);
        return this;
    }

    @NotNull
    public Update<T> limit(int count) {
        ((StatementUpdate)this.statement).limit(count);
        return this;
    }

    @NotNull
    public Update<T> limit(long count) {
        ((StatementUpdate)this.statement).limit(count);
        return this;
    }

    @NotNull
    public Update<T> limit(@Nullable ExpressionConvertible count) {
        ((StatementUpdate)this.statement).limit(count);
        return this;
    }

    @NotNull
    public Update<T> offset(short offset) {
        ((StatementUpdate)this.statement).offset(offset);
        return this;
    }

    @NotNull
    public Update<T> offset(int offset) {
        ((StatementUpdate)this.statement).offset(offset);
        return this;
    }

    @NotNull
    public Update<T> offset(long offset) {
        ((StatementUpdate)this.statement).offset(offset);
        return this;
    }

    @NotNull
    public Update<T> offset(@Nullable ExpressionConvertible offset) {
        ((StatementUpdate)this.statement).offset(offset);
        return this;
    }

    @NotNull
    public Update<T> execute() throws WCDBException {
        TableBinding<T> binding = Field.getBinding(this.fields);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.handle.preparedWithMainStatement(this.statement);
            if (this.object != null) {
                preparedStatement.bindObject(this.object, this.fields);
            } else if (this.row != null) {
                preparedStatement.bindRow(this.row);
            }
            preparedStatement.step();
            this.updateChanges();
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.finalizeStatement();
            }
            this.invalidateHandle();
        }
        return this;
    }
}

